<div class="page-header">
  <div class="page-header-content header-elements-lg-inline">
    <div class="page-title d-flex">
      <h4><i class="icon-display mr-2 icon-2x"></i> <span class="font-weight-semibold">Canlı TV Kanalı Düzenle</span></h4>
    </div>
  </div>
</div>
<div class="content">
  <div class="row">
    <div class="col-lg-6">
      <?php if($this->session->flashdata('success')): ?>
        <div class="alert alert-success"><?php echo $this->session->flashdata('success'); ?></div>
      <?php endif; ?>
      
      <?php if($this->session->flashdata('error')): ?>
        <div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
      <?php endif; ?>
      
      <?php if(validation_errors()): ?>
        <div class="alert alert-danger"><?php echo validation_errors(); ?></div>
      <?php endif; ?>

      <div class="card">
        <div class="card-header">
          <h5 class="card-title">Kanal Bilgileri</h5>
        </div>
        <div class="card-body">
          <form class="wc-form" method="post" action="<?php echo base_url('panel/livetv/edit/'.$channel['id']); ?>" enctype="multipart/form-data">
            <div class="row mb-3">
              <div class="col-md-2">
                <div class="mr-lg-3 mb-5 mb-lg-0">
                  <?php if(!empty($channel['image'])): ?>
                    <a href="#" class="profile-thumb">
                      <img src="<?php echo base_url("uploads/livetv/original/". $channel['image']); ?>" class="border-white" width="48" height="48" alt="">
                    </a>
                  <?php endif; ?>
                </div>
              </div>
              <div class="col-md-10">
                <div class="form-group">
                  <label>Kanal Resmi:</label>
                  <label class="custom-file">
                    <input type="file" name="file" class="custom-file-input">
                    <span class="custom-file-label">Resim seç</span>
                  </label>
                  <span class="form-text text-muted">Kabul edilen formatlar: gif, png, jpg. Maksimum dosya boyutu 2Mb</span>
                </div>
              </div>
            </div>
           
            <div class="form-group">
              <label>Kanal Adı:</label>
              <input type="text" name="name" id="name" value="<?php echo set_value('name', $channel['name']); ?>" required class="form-control" placeholder="Kanal Adı">
            </div>
            
            <div class="form-group">
              <label>SEO URL:</label>
              <input type="text" name="slug" id="slug" value="<?php echo set_value('slug', $channel['slug']); ?>" required class="form-control" placeholder="SEO URL">
              <span class="form-text text-muted">Sadece küçük harfler, rakamlar ve tire (-) kullanabilirsiniz.</span>
            </div>
            
            <div class="form-group">
              <label>Açıklama:</label>
              <textarea class="form-control" name="description" rows="5"><?php echo set_value('description', $channel['description']); ?></textarea>
            </div>
            
            <div class="form-group">
              <div class="form-check form-check-inline form-check-switchery">
                <label class="form-check-label">
                  <input type="checkbox" id="status" name="status" value="1" class="form-input-switchery" <?php echo ($channel['status'] == 1) ? 'checked' : ''; ?> data-fouc>
                  Pasif / Aktif
                </label>
              </div>
            </div>
            
            <div class="text-right">
              <a href="<?php echo base_url('panel/livetv'); ?>" class="btn btn-light">İptal</a>
              <button type="submit" class="btn btn-primary">Güncelle <i class="icon-paperplane ml-2"></i></button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
$(document).ready(function() {
  // Kanal adına göre otomatik slug oluşturma
  $('#name').on('keyup', function() {
    var name = $(this).val();
    var slug = name.toLowerCase()
                  .replace(/[^\w ]+/g, '')
                  .replace(/ +/g, '-');
    $('#slug').val(slug);
  });
  
  // Switchery nesnelerini başlat
  var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
  elems.forEach(function(html) {
    var switchery = new Switchery(html, { color: '#4CAF50' });
  });
});
</script> 