<div class="page-header">
  <div class="page-header-content header-elements-lg-inline">
    <div class="page-title d-flex">
      <h4><i class="icon-feed mr-2 icon-2x"></i> <span class="font-weight-semibold"><?php echo $channel['name']; ?> - Kaynak Düzenle</span></h4>
    </div>
  </div>
</div>
<div class="content">
  <div class="row">
    <div class="col-lg-6">
      <?php if($this->session->flashdata('success')): ?>
        <div class="alert alert-success"><?php echo $this->session->flashdata('success'); ?></div>
      <?php endif; ?>
      
      <?php if($this->session->flashdata('error')): ?>
        <div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
      <?php endif; ?>
      
      <?php if(validation_errors()): ?>
        <div class="alert alert-danger"><?php echo validation_errors(); ?></div>
      <?php endif; ?>

      <div class="card">
        <div class="card-header">
          <h5 class="card-title"><?php echo $source['name']; ?> Kaynağını Düzenle</h5>
        </div>
        <div class="card-body">
          <form class="wc-form" method="post" action="<?php echo base_url('panel/livetv/edit_source/'.$source['id']); ?>">
            <div class="form-group">
              <label>Kaynak Adı:</label>
              <input type="text" name="source_name" id="source_name" value="<?php echo set_value('source_name', $source['name']); ?>" required class="form-control" placeholder="Kaynak Adı">
              <span class="form-text text-muted">Örn: HD, SD, Alternatif, vs.</span>
            </div>
            
            <div class="form-group">
              <label>Kaynak Tipi:</label>
              <select name="source_type" id="source_type" class="form-control select" required>
                <option value="">-- Kaynak Tipi Seçin --</option>
                <option value="hls" <?php echo set_select('source_type', 'hls', ($source['type'] == 'hls')); ?>>HLS (m3u8)</option>
                <option value="embed" <?php echo set_select('source_type', 'embed', ($source['type'] == 'embed')); ?>>Embed (iframe)</option>
              </select>
            </div>
            
            <div class="form-group">
              <label>Kaynak URL / Embed Kodu:</label>
              <textarea class="form-control" name="source_url" id="source_url" rows="5" required><?php echo set_value('source_url', $source['url']); ?></textarea>
              <span class="form-text text-muted url-help">
                <?php if($source['type'] == 'hls'): ?>
                  HLS için .m3u8 uzantılı URL girin.
                <?php elseif($source['type'] == 'embed'): ?>
                  Embed için iframe kodunu girin.
                <?php else: ?>
                  Kaynak tipine uygun URL veya kodu girin.
                <?php endif; ?>
              </span>
            </div>
            
            <div class="form-group">
              <label>Öncelik:</label>
              <input type="number" name="priority" id="priority" value="<?php echo set_value('priority', $source['priority']); ?>" class="form-control" placeholder="Öncelik">
              <span class="form-text text-muted">Düşük sayılar daha önce görüntülenir. Varsayılan: 1</span>
            </div>
            
            <div class="form-group">
              <div class="form-check form-check-inline form-check-switchery">
                <label class="form-check-label">
                  <input type="checkbox" id="status" name="status" value="1" class="form-input-switchery" <?php echo ($source['status'] == 1) ? 'checked' : ''; ?> data-fouc>
                  Pasif / Aktif
                </label>
              </div>
            </div>
            
            <div class="text-right">
              <a href="<?php echo base_url('panel/livetv/sources/'.$channel['id']); ?>" class="btn btn-light">İptal</a>
              <button type="submit" class="btn btn-primary">Güncelle <i class="icon-paperplane ml-2"></i></button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
$(document).ready(function() {
  // Kaynak tipi seçimine göre açıklama metni değiştir
  $('#source_type').on('change', function() {
    var type = $(this).val();
    var url_help = '';
    
    if (type === 'hls') {
      url_help = 'HLS için .m3u8 uzantılı URL girin.';
      $('#source_url').attr('placeholder', 'https://example.com/stream.m3u8');
    } else if (type === 'embed') {
      url_help = 'Embed için iframe kodunu girin.';
      $('#source_url').attr('placeholder', '<iframe src="https://example.com/embed/..." width="100%" height="100%" frameborder="0" allowfullscreen></iframe>');
    }
    
    $('.url-help').text(url_help);
  });
  
  // Switchery nesnelerini başlat
  var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
  elems.forEach(function(html) {
    var switchery = new Switchery(html, { color: '#4CAF50' });
  });
  
  // Select2 başlat
  $('.select').select2();
});
</script> 