<div class="page-header">
  <div class="page-header-content header-elements-lg-inline">
    <div class="page-title d-flex">
      <h4><i class="icon-feed mr-2 icon-2x"></i> <span class="font-weight-semibold"><?php echo $channel['name']; ?> - Kaynaklar</span></h4>
      <a href="#" class="header-elements-toggle text-body d-lg-none"><i class="icon-more"></i></a>
    </div>
    <div class="header-elements d-none py-0 mb-3 mb-lg-0">
      <div class="breadcrumb">
        <a href="<?php echo base_url('panel/livetv/add_source/'.$channel['id']); ?>" class="btn btn-success">
          <i class="icon-plus-circle2 mr-2"></i> Yeni Kaynak Ekle
        </a>
      </div>
    </div>
  </div>
</div>

<div class="content">
  <?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success alert-styled-left alert-dismissible">
      <button type="button" class="close" data-dismiss="alert"><span>×</span></button>
      <?php echo $this->session->flashdata('success'); ?>
    </div>
  <?php endif; ?>
  
  <?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger alert-styled-left alert-dismissible">
      <button type="button" class="close" data-dismiss="alert"><span>×</span></button>
      <?php echo $this->session->flashdata('error'); ?>
    </div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-striped">
          <thead>
            <tr>
              <th width="60">ID</th>
              <th>Kaynak Adı</th>
              <th>Kaynak Tipi</th>
              <th width="80">Öncelik</th>
              <th width="100">Durum</th>
              <th width="150" class="text-center">İşlemler</th>
            </tr>
          </thead>
          <tbody>
            <?php if(!empty($sources)): ?>
              <?php foreach($sources as $source): ?>
                <tr>
                  <td><?php echo $source['id']; ?></td>
                  <td><?php echo $source['name']; ?></td>
                  <td>
                    <?php if($source['type'] == 'hls'): ?>
                      <span class="badge badge-primary">HLS</span>
                    <?php elseif($source['type'] == 'embed'): ?>
                      <span class="badge badge-info">Embed</span>
                    <?php else: ?>
                      <span class="badge badge-secondary"><?php echo $source['type']; ?></span>
                    <?php endif; ?>
                  </td>
                  <td><?php echo $source['priority']; ?></td>
                  <td>
                    <?php if($source['status'] == 1): ?>
                      <span class="badge badge-success">Aktif</span>
                    <?php else: ?>
                      <span class="badge badge-danger">Pasif</span>
                    <?php endif; ?>
                  </td>
                  <td class="text-center">
                    <div class="list-icons">
                      <a href="<?php echo base_url('panel/livetv/edit_source/'.$source['id']); ?>" class="btn btn-primary btn-sm">
                        <i class="icon-pencil"></i> Düzenle
                      </a>
                      <a href="<?php echo base_url('panel/livetv/delete_source/'.$source['id']); ?>" class="btn btn-danger btn-sm" onclick="return confirm('Bu kaynağı silmek istediğinizden emin misiniz?');">
                        <i class="icon-trash"></i> Sil
                      </a>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="6" class="text-center">Bu kanal için henüz hiç kaynak eklenmemiş.</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer">
      <a href="<?php echo base_url('panel/livetv'); ?>" class="btn btn-light">Kanallara Dön</a>
    </div>
  </div>
</div> 