<div class="page-header">
  <div class="page-header-content header-elements-lg-inline">
    <div class="page-title d-flex">
      <h4><i class="icon-add-to-list mr-2 icon-2x"></i> <span class="font-weight-semibold">Grup Düzenle</span></h4>
    </div>
  </div>
</div>
<div class="content">
  <div class="row">
    <div class="col-lg-6">
      <?= $message ?>
      <?= $error ?>
      <div class="card">
        <div class="card-header">
          <h5 class="card-title">Video Grup Bilgileri</h5>
        </div>
        <div class="card-body">
          <form class="wc-form" method="post" action="" enctype="multipart/form-data">
            <div class="row mb-3">
                <div class="col-md-2">
                  <div class="mr-lg-3 mb-5 mb-lg-0">
                      <a href="#" class="profile-thumb">
                        <img src="<?= base_url("uploads/video/group/original/$get->vg_icon")?>"  class="border-white " width="50" height="50" alt="">
                      </a>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label>Video Grup Görsel:</label>
                    <label class="custom-file">
                      <input type="file" name="file" class="custom-file-input">
                      <span class="custom-file-label">Görsel seç</span>
                    </label>
                    <span class="form-text text-muted">Kabul edilen formatlar: gif, png, jpg. Maksimum dosya boyutu 2Mb</span>
                  </div>
                </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Adı :</label>
                  <input type="text" name="name" required="" value="<?= $get->vg_name?>" class="form-control" placeholder="Servis Adı">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Slug :</label>
                  <input type="text" name="alias" class="form-control" value="<?= $get->vg_slug?>" placeholder="Servis Slug">
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Sıra No :</label>
                  <input type="text" name="sort" value="<?= $get->vg_sort?>" class="form-control" placeholder="Sıra No">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Video Grup Kategorisi :</label>
                  <select class="form-control select-search" name="type" data-placeholder="Video Grup Kategorisi">
                    <option></option>
                    <?php 
                    if(!empty($type)){
                      foreach($type as $row){
                    ?>
                    <option value="<?= $row->vt_id?>" <?= $get->vt_id == $row->vt_id ? 'selected': null ?>><?= $row->vt_name?></option>
                    <?php } } ?>
                  </select>
                </div>
              </div>
            </div>
            <div class="form-group">
               <div class="form-check form-check-inline form-check-switchery">
                  <label class="form-check-label">
                     <input type="checkbox" id="active" name="active" class="form-input-switchery" <?= $get->vg_active ? 'checked' : null ?> data-fouc>
                     Pasif / Aktif
                  </label>
               </div>
            </div>

            <div class="text-right">
              <button type="submit" class="btn btn-primary">Düzenle <i class="icon-paperplane ml-2"></i></button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <?php
      if($this->translator){
        $social = !empty($translator) ? json_decode($translator->social) : [];

    ?>
    <div class="col-lg-6">
    
      <div class="card">
        <div class="card-header">
          <h5 class="card-title">Çeviri Grup Bilgileri</h5>
        </div>
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-2">
                  <div class="mr-lg-3 mb-5 mb-lg-0">
                      <a href="#" class="profile-thumb">
                        <img src="<?= !empty($translator) ? base_url("uploads/translator/original/$translator->image") : ''?>"  class="border-white " width="50" height="50" alt="">
                      </a>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label>Çeviri Görsel:</label>
                    <label class="custom-file">
                      <input type="file" name="" id="translator-image" class="custom-file-input">
                      <span class="custom-file-label">Görsel seç</span>
                    </label>
                    <span class="form-text text-muted">Kabul edilen formatlar: gif, png, jpg. Maksimum dosya boyutu 2Mb</span>
                  </div>
                </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Üyeler :</label>
                  <input type="text" name="" id="translator-users" required="" value="<?= $translator->users ?? ""?>" class="form-control" placeholder="Üyeler">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Hakkında :</label>
                  <input type="hidden" id="vg_id" value="<?= $get->vg_id?>" name="">
                  <textarea class="form-control" id="translator-desc"><?= $translator->description ?? ""?></textarea>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Website</label>
                  <input type="text" name="" value="<?= $social->website ?? "" ?>" class="translator-social-website form-control" placeholder="Website">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Twitter</label>
                  <input type="text" name="" value="<?= $social->twitter ?? "" ?>" class="translator-social-twitter form-control" placeholder="Twitter">
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Facebook</label>
                  <input type="text" name="" value="<?= $social->facebook ?? "" ?>" class="translator-social-facebook form-control" placeholder="Facebook">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Discord</label>
                  <input type="text" name="" value="<?= $social->discord ?? "" ?>" class="translator-social-discord form-control" placeholder="Discord">
                </div>
              </div>
            </div>

           
            <div class="text-right">
              <button type="submit" class="btn btn-primary translator-update">Kaydet <i class="icon-paperplane ml-2"></i></button>
            </div>
        </div>
      </div>
    </div>
  <?php } ?>
  </div>
</div>
