<?php
	$this->load->view(FRONT_THEME_FILE."/components/page_header");
   $weekly = $this->my_model->getTrendWeekly();
   $categoryList = $this->category_m->getCategoryList();
     $logo = pathinfo("uploads/logo/original/{$this->settings->logo}");
     if($this->stablePage){
       $pages = $this->pages_m->getList();
    }

?>

<section class="wrapper mx-auto">
   <header class="header flex items-center w-full fixed lg:relative">
      <div class="mobile-menu-icon flex lg:hidden">
         <button class="focus:outline-none mobile-menu-trigger absolute" aria-label="Mobile Menü Trigger">
           <span class="block relative"></span>
         </button>
      </div>
      <div class="mobile-menu fixed">
         <ul>
           <li class="mobile-menu-active">
             <a <?= navigo()?> href="/" class="block relative">Anasayfa</a>
           </li>
           <li class="just-mobile">
             <a href="javascript:void(0);" class="block relative">Türler</a>
          
             <ul class="sub-menu">
               <?php
                  if(!empty($categoryList)){
                     foreach($categoryList as $category){
                        $hash = $this->my_model->slugHash('category',["id" => $category->id,"name" => $category->title_tr]);

               ?>
               <li><a <?= navigo()?> href="<?= base_url("film/tur/$category->alias_tr")?>" class="block relative"><?= $category->title_tr?></a></li>
               <?php } } ?>
             </ul>
           </li>
           <?php
             if($this->hot40){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("hot-40")?>" class="block relative">Hot 40</a>
           </li>
           <?php } ?>
           <?php
             if($this->channel){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("kanallar")?>" class="block relative">Dizi Kanalları</a>
           </li>
           <?php } ?>
           <?php
             if($this->liveTv){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("canli-tv")?>" class="block relative">Canlı TV</a>
           </li>
           <?php } ?>
           <?php
             if($this->tier){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("tiers")?>" class="block relative">Kademeler</a>
           </li>
           <?php } ?>
           <?php
             if($this->flow){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("tiers")?>" class="block relative">Akış</a>
           </li>
           <?php } ?>
           <?php
             if($this->badges){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("tiers")?>" class="block relative">Rozetler</a>
           </li>
           <?php } ?>
           <?php
             if($this->collect){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("seri-filmler")?>" class="block relative">Seri Filmler</a>
           </li>
           <?php } ?>
           <?php
             if($this->blog){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("bloglar")?>" class="block relative">Bloglar</a>
           </li>
           <?php } ?>
            <?php
             if($this->topRate){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("imdbtop250")?>" class="block relative">IMDb Top 250</a>
           </li>
           <?php } ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("kesfet")?>" class="block relative">Gözat</a>
           </li>
         
           
           <li>
             <a <?= navigo()?> href="<?= base_url("trendler")?>" class="block relative">En İyiler</a>
           </li>
           <?php
             if($this->cast){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("oyuncular")?>" class="block relative">Oyuncular</a>
           </li>
           <?php } ?>
           <li>
             <a <?= navigo()?> href="<?= base_url("filmler")?>" class="block relative">Yeni Filmler</a>
           </li>
           <li>
             <a <?= navigo()?> href="<?= base_url("dizi-izle")?>" class="block relative">Yabancı Diziler</a>
           </li>
           <li>
             <a <?= navigo()?> href="<?= base_url("tartismalar")?>" class="block relative">Tartışmalar</a>
           </li>
           <?php
             if($this->collections){
           ?>
           <li>
             <a <?= navigo()?> href="<?= base_url('koleksiyonlar')?>" class="block relative">Koleksiyonlar</a>
           </li>
         <?php } ?>
         </ul>
      </div>
      <div class="logo flex items-center flex-shrink-0 relative">
         <a class="flex items-center justify-center" <?= navigo()?> href="/">
            <?php
                  if(!empty($logo["extension"]) && $logo["extension"] == 'svg'){
                    echo file_get_contents("uploads/logo/original/{$this->settings->logo}");
                  }else {
                ?>
                <img src="<?= base_url("uploads/logo/original/{$this->settings->logo}")?>">
              <?php } ?>
         </a>
         <span class="block absolute">100%</span>
      </div>
      <div class="mobile-search-area leftbar-search absolute">
         <input type="text" placeholder="Arama yap...">
         <div class="leftbar-search-icon absolute">
           <button class="focus:outline-none flex items-center justify-center">
             <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>
           </button>
         </div>
      </div>
      
      <div class="header-action w-full flex items-center">
         <div class="header-menu hidden lg:block">
           <ul class="flex">
               <li>
                 <a <?= navigo()?> href="/" class="block">
                   <svg><path d="M13 18h3V8L8.696 2.033 2 8v10h3v-5l1-1h6l1 1v5zm-1 2l-1-1v-5H7v5l-1 1H1l-1-1V7.826c0-.249.106-.485.291-.65L8.117.219a.873.873 0 0 1 1.157 0l7.825 6.957c.186.165.901.575.901.824v11l-1 1h-5z"></path></svg>
                 </a>
               </li>
               <li>
                 <a <?= navigo()?> href="<?= base_url("kesfet")?>" class="block">Gözat</a>
               </li>
               <?php
                if($this->trend ){
               ?>
               <li>
                 <a <?= navigo()?> href="<?= base_url("trendler")?>" class="block">En İyiler</a>
               </li>
              <?php } ?>
               <?php
                if($this->cast){
               ?>
               <li>
                 <a <?= navigo()?> href="<?= base_url("oyuncular")?>" class="block">Oyuncular</a>
               </li>
              <?php } ?>
             
               <li>
                 <a <?= navigo()?> href="<?= base_url("filmler")?>" class="block">🎬 Filmler</a>
               </li>
               <li>
                 <a <?= navigo()?> href="<?= base_url("dizi-izle")?>" class="block new-tv-shows relative">🍿 Diziler</a>
               </li>
               <li>
                 <a <?= navigo()?> href="<?= base_url("tartismalar")?>" class="block">🔥 Tartışmalar</a>
               </li>
               <li>
                 <a <?= navigo()?> href="<?= base_url("canli-tv")?>" class="block">📺 Canlı Maç İzle</a>
               </li>
               <li>
                 <a <?= navigo()?> href="<?= base_url("iletisim")?>" class="block">✉️ İletişim</a>
               </li>
               <?php
                if($this->collections){
               ?>
               <li>
                 <a <?= navigo()?> href="<?= base_url("koleksiyonlar")?>" class="block">Koleksiyonlar</a>
               </li>
              <?php } ?>
            </ul>
         </div>
         <div class="user flex justify-end flex-1 items-center">
            <div class="mobile-search flex lg:hidden">
               <button class="focus:outline-none">
               <svg id="icon-search"><path d="M13.4 14c-.2 0-.3-.1-.4-.2l-3.4-3.4c-.2-.2-.2-.6 0-.9s.6-.2.9 0l3.4 3.4c.2.2.2.6 0 .9-.2.1-.4.2-.5.2zM6.1 12.2c-3.4 0-6.1-2.8-6.1-6.1s2.7-6.1 6.1-6.1 6.1 2.7 6.1 6.1-2.8 6.1-6.1 6.1zm0-11c-2.7 0-4.9 2.2-4.9 4.9s2.2 4.9 4.9 4.9 4.9-2.2 4.9-4.9-2.2-4.9-4.9-4.9z"></path></svg>
               </button>
            </div>

            <?php
               if(LOGIN){
            ?>
            <ul class="flex items-center">
               <li class="notification-button relative  ui upward dropdown item">
                  <a href="javascript:void(0);" class="block">
                     <svg class="valign-middle" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M18 16l1.28 1.29c.63.63.18 1.71-.71 1.71h-13.17c-.89 0-1.33-1.08-.7-1.71l1.3-1.29v-5c0-3.08 1.63-5.64 4.5-6.32v-.68c0-.83.66-1.5 1.49-1.5s1.51.67 1.51 1.5v.68c2.86.68 4.5 3.25 4.5 6.32v5zm-6.01 6c-1.11 0-2-.9-2-2h4c0 1.1-.9 2-2 2zm-5.22-17.27c-1.39 1.27-2.35 3-2.65 4.94-.08.48-.5.83-.98.83-.62 0-1.09-.55-1-1.16.38-2.38 1.56-4.5 3.27-6.06.39-.37 1.01-.36 1.39.02.4.4.39 1.05-.03 1.43zm11.83-1.45c1.7 1.57 2.87 3.68 3.25 6.05.1.61-.38 1.16-.99 1.16-.49 0-.91-.35-.98-.83-.3-1.94-1.27-3.67-2.65-4.94-.41-.38-.43-1.02-.03-1.42.38-.38 1-.39 1.4-.02z" fill="#fff"></path></svg>
                     <span class="inline-block absolute notification-badge"><?= $this->session->userdata("notif_count")?></span>
                  </a>
                  <div class="menu transition" tabindex="-1" >
                    <?php 
                       if(!empty($this->session->userdata("notif_list"))){
                           foreach($this->session->userdata("notif_list") as $notification){
                              if($notification->icon){
                                 if(strpos($notification->icon, '.svg') !== FALSE){
                                    $icon = file_get_contents("uploads/notification/original/$notification->icon");
                                 }else {
                                    $icon = '<img class="lazy" data-src="'.base_url("uploads/notification/original/$notification->icon").'" />';
                                 }
                              }else {
                                 $icon = "";
                              }
                              if(!empty($notification->from_user)){
                                 $from_avatar = $notification->from_user->u_avatar;
                                 $from_name = $notification->from_user->u_name;
                                 $from_username =  base_url("profil/".$notification->from_user->u_username);
                              }else {
                                 $from_avatar   = "system.jpg";
                                 $from_name     = $this->settings->title;
                                 $from_username = "javascript:;";
                              }
                        ?>
                     <div class="item">
                        <div class="flex items-start notification-box">
                           <img class="flex-shrink-0" src="<?= base_url("uploads/users/$from_avatar") ?>" alt="<?= $from_name?>">
                           <div class="notification-drop-box">
                              <span class="block">
                                <?= $notification->parse ?>
                              </span>
                              <p><?= zaman($notification->created_at)?></p>
                           </div>
                        </div>
                     </div>
                     <div class="divider"></div>

                     <?php } } ?>
                  </div>
               </li>
               <li class="user-button relative ui upward dropdown item">
                  <a href="javascript:void(0);" class="block">
                     <div class="header-user-profile flex items-center">
                        <img class="lazy" data-src="<?= base_url("uploads/users/".$this->session->userdata("user_avatar"))?>" alt="<?= $this->user->u_name?>">
                        <div class="header-user-profile-right">
                           <div class="header-user-name truncate relative">
                              @<?= $this->user->u_name?>
                              <span class="header-user-level absolute"><?= $this->session->userdata("levelInfo")->level?></span>
                           </div>
                           <div class="header-user-exp">
                              <div class="header-user-progress">
                                 <div class="header-user-progress-bar" style="width:<?= $this->session->userdata("levelInfo")->rate?>%"></div>
                              </div>
                           </div>
                        </div>
                        <div class="hader-user-drop-icon">
                           <button class="focus:outline-none">
                              <svg id="icon-arrow-down"><path d="M5 5a.593.593 0 0 1-.387-.143L0 .903.774 0 5 3.622 9.226 0 10 .903 5.387 4.857A.593.593 0 0 1 5 5"></path></svg>
                           </button>
                        </div>
                     </div>
                  </a>
                  <div class="menu transition" tabindex="-1" >
                     <div class="item"><a <?= navigo()?> href="<?= base_url("profil/".$this->user->u_username)?>"  class="block">Profilim</a></div>
                     <div class="divider"></div>
                     <?php
                      if($this->request){
                     ?>
                     <div class="item"><a <?= navigo()?> href="<?= base_url("istek")?>" class="block">İstek Yap</a></div>
                   <?php } ?>
                     <div class="item"><a <?= navigo()?> href="<?= base_url("profil/bilgilerim")?>" class="block">Hesap Ayarlarım</a></div>
                     <div class="item"><a <?= navigo()?> href="<?= base_url("iletisim")?>" class="block">İletişim</a></div>
                     <div class="item"><a  href="<?= base_url("cikis-yap")?>" class="block">Çıkış Yap</a></div>
                  </div>
               </li>
            </ul>
            <?php }else { ?>
               <div class="user-rl flex">
                  <a class="text-white hidden md:block" <?= $this->modal ? 'data-register' : null?> href="<?= $this->modal ? 'javascript:void(0);' : base_url('kayit-ol')?>">Kayıt ol</a>
                  <a class="user-login-btn block" <?= $this->modal ? 'data-login' : null ?> href="<?= $this->modal ? 'javascript:void(0);' : base_url('giris-yap')?>">Giriş yap</a>

               </div>

            <?php } ?>
         </div>
      </div>
   </header>
   <div class="search block md:hidden">
      <div class="main-search relative flex-1">
         <input class="w-full rounded-full focus:outline-none tvSearch" type="text" name="search" autocomplete="off" placeholder="Dizi veya film ara..">
         <div class="main-search-icon absolute">
            <button class="flex focus:outline-none">
               <svg id="search" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search">
                  <circle cx="11" cy="11" r="8"></circle>
                  <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
               </svg>
            </button>
         </div>
         <div class="leftbar-search-result absolute z-50">
            <div class="leftbar-search-result-head flex items-center justify-between">
               <span class="block">En İyi Sonuçlar</span>
            </div>
            <div class="leftbar-search-result-in"></div>
         </div>
      </div>
   </div>
   <div class="wrapper-inner flex">
      <aside class="leftbar flex-shrink-0 hidden lg:block">
         <div class="leftbar-box">
           <div class="leftbar-search relative">
             <input type="text" placeholder="Arama yap...">
             <div class="leftbar-search-icon absolute">
               <button class="focus:outline-none flex items-center justify-center">
                 <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>
               </button>
             </div>
             <div class="leftbar-search-result absolute z-50">
               <div class="leftbar-search-result-head flex items-center justify-between">
                 <span class="block">En İyi Sonuçlar</span>
                 <?php
                  if($this->request){
                 ?>
                   <div class="add-ms">
                     <a <?= navigo()?> href="<?= base_url("istek")?>" class="flex items-center">
                       <div class="add-ms-icon flex items-center justify-center">
                         <svg id="icon-plus"><path d="M5 7v5h2v-5h5v-2h-5v-5h-2v5h-5v2h5z"></path></svg>
                       </div>
                       Film & Dizi İstek
                     </a>
                   </div>
                  <?php } ?>
                 </div>
                 <div class="leftbar-search-result-in">
                   
                 </div>
             </div>
           </div>
         </div>
         <div class="leftbar-box ">
            <ul class="hot-rate-menu mb-2">
               <?php
                if($this->collect){
               ?>
                 <li class="top-rate">
                   <a <?= navigo()?> href="<?= base_url("seri-filmler")?>" class="flex items-center">
                     <svg aria-hidden="true" width="24" height="24" role="img" fill="#fbc607" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">                        <g class="fa-group">                            <path class="fa-secondary" fill="#fbc607" d="M12.41 236.31L70.51 210l161.63 73.27a57.64 57.64 0 0 0 47.72 0L441.5 210l58.09 26.33c16.55 7.5 16.55 32.5 0 40L266.64 381.9a25.68 25.68 0 0 1-21.29 0L12.41 276.31c-16.55-7.5-16.55-32.5 0-40z" opacity="0.4"></path>                            <path class="fa-primary" fill="#fbc607" d="M12.41 148l232.94 105.7a25.61 25.61 0 0 0 21.29 0L499.58 148c16.55-7.51 16.55-32.52 0-40L266.65 2.32a25.61 25.61 0 0 0-21.29 0L12.41 108c-16.55 7.5-16.55 32.52 0 40zm487.18 216.11l-57.87-26.23-161.86 73.37a57.64 57.64 0 0 1-47.72 0L70.29 337.88l-57.88 26.23c-16.55 7.5-16.55 32.5 0 40L245.35 509.7a25.68 25.68 0 0 0 21.29 0l233-105.59c16.5-7.5 16.5-32.5-.05-40z">                            </path>                        </g>                    </svg>
                       <span class="ml-3">Seri Filmler</span>
                   </a>
                 </li>
             <?php } ?>
               <?php
                     if($this->blog){
                  ?>
               <li class="top-rate">
                  <a  class="flex  no-underline" <?= navigo()?> href="<?= base_url("bloglar")?>">
                     <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" style="color:#fbc607" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="16" y1="13" x2="8" y2="13"></line><line x1="16" y1="17" x2="8" y2="17"></line><polyline points="10 9 9 9 8 9"></polyline></svg>
                     <span class="ml-3">Bloglar</span>            
                  </a>
               </li>
             <?php } ?> 
               <?php
                if($this->tier){
               ?>
               <li class="top-rate">
                 <a <?= navigo()?> href="<?= base_url("tiers")?>" class="flex items-center">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M22 10.75C22.41 10.75 22.75 10.41 22.75 10V9C22.75 4.59 21.41 3.25 17 3.25H10.75V5.5C10.75 5.91 10.41 6.25 10 6.25C9.59 6.25 9.25 5.91 9.25 5.5V3.25H7C2.59 3.25 1.25 4.59 1.25 9V9.5C1.25 9.91 1.59 10.25 2 10.25C2.96 10.25 3.75 11.04 3.75 12C3.75 12.96 2.96 13.75 2 13.75C1.59 13.75 1.25 14.09 1.25 14.5V15C1.25 19.41 2.59 20.75 7 20.75H9.25V18.5C9.25 18.09 9.59 17.75 10 17.75C10.41 17.75 10.75 18.09 10.75 18.5V20.75H17C21.41 20.75 22.75 19.41 22.75 15C22.75 14.59 22.41 14.25 22 14.25C21.04 14.25 20.25 13.46 20.25 12.5C20.25 11.54 21.04 10.75 22 10.75ZM10.75 14.17C10.75 14.58 10.41 14.92 10 14.92C9.59 14.92 9.25 14.58 9.25 14.17V9.83C9.25 9.42 9.59 9.08 10 9.08C10.41 9.08 10.75 9.42 10.75 9.83V14.17Z" fill="#fbc607"/>
                      </svg>

                     <span class="ml-3">Kademeler</span>
                 </a>
               </li>
             <?php } ?>
               <?php
                if($this->flow){
               ?>
               <li class="top-rate">
                 <a <?= navigo()?> href="<?= base_url("akis")?>" class="flex items-center">
                    <svg viewBox="0 0 24 24" stroke="#fbc607" width="24" height="24"  stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path></svg>

                     <span class="ml-3">Akış</span>
                 </a>
               </li>
             <?php } ?>
               <?php
                if($this->badges){
               ?>
               <li class="top-rate">
                 <a <?= navigo()?> href="<?= base_url("rozetler")?>" class="flex items-center">
                      <svg viewBox="0 0 20 20" fill="#fbc607" width="24" height="24" ><path d="M10,8c2.757,0,5,2.243,5,5s-2.243,5-5,5s-5-2.243-5-5S7.243,8,10,8 M10,6c-3.866,0-7,3.134-7,7s3.134,7,7,7c3.865,0,7-3.134,7-7S13.865,6,10,6L10,6z"></path><path d="M3.906,6.391L2.651,2h3.84l0.701,2.453c0.627-0.206,1.283-0.347,1.963-0.41L8,0H0l2.36,8.26C2.79,7.568,3.31,6.941,3.906,6.391z"></path><path d="M12.808,4.453L13.509,2h3.84l-1.255,4.391C16.689,6.94,17.21,7.568,17.64,8.26L20,0h-8l-1.155,4.043C11.524,4.106,12.181,4.247,12.808,4.453z"></path></svg>
                     <span class="ml-3">Rozetler</span>
                 </a>
               </li>
             <?php } ?>
                <?php
                  if($this->hot40){
                ?>
               <li class="top-rate">
                 <a <?= navigo()?> href="<?= base_url("hot-40")?>" class="flex items-center">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                     <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM15.53 13.23L10.35 16.82C9.59 17.35 9.15 17.04 9.37 16.15L10.32 12.31L8.67 11.9C7.92 11.72 7.83 11.2 8.46 10.76L13.64 7.17C14.4 6.64 14.84 6.95 14.62 7.84L13.67 11.68L15.32 12.09C16.07 12.28 16.16 12.79 15.53 13.23Z" fill="#fbc607"/>
                     </svg>
                     <span class="ml-3">Hot 40</span>
                 </a>
               </li>
              <?php } ?>
              <?php
                if($this->topRate){
               ?>
               <li class="top-rate">
                 <a <?= navigo()?> href="<?= base_url("imdbtop250")?>" class="flex items-center">
                   <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                     <path d="M17.9105 10.7209H14.8205V3.52087C14.8205 1.84087 13.9105 1.50087 12.8005 2.76087L12.0005 3.67087L5.2305 11.3709C4.3005 12.4209 4.6905 13.2809 6.0905 13.2809H9.1805V20.4809C9.1805 22.1609 10.0905 22.5009 11.2005 21.2409L12.0005 20.3309L18.7705 12.6309C19.7005 11.5809 19.3105 10.7209 17.9105 10.7209Z" fill="#fbc607"/>
                     </svg>
                     <span class="ml-3">IMDb Top 250</span>
                 </a>
               </li>
              <?php } ?>
                <?php
                  if($this->channel){
                ?>
               <li class="top-rate">
                 <a <?= navigo()?> href="<?= base_url("kanallar")?>" class="flex items-center">
                     <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" color="#fbc607" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><rect x="2" y="7" width="20" height="15" rx="2" ry="2"></rect><polyline points="17 2 12 7 7 2"></polyline></svg>
                     <span class="ml-3">Dizi Kanalları</span>
                 </a>
               </li>
              <?php } ?>
                <?php
                  if($this->liveTv){
                ?>
               <li class="top-rate">
                 <a <?= navigo()?> href="<?= base_url("canli-tv")?>" class="flex items-center">
                     <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" color="#fbc607" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><rect x="2" y="7" width="20" height="15" rx="2" ry="2"></rect><polyline points="17 2 12 7 7 2"></polyline></svg>
                     <span class="ml-3">Canlı TV</span>
                 </a>
               </li>
              <?php } ?>
            </ul>
           <h5>Popüler Film Türleri</h5>
           <ul>
               <?php
                  if(!empty($categoryList)){
                     foreach($categoryList as $category){
                        $hash = $this->my_model->slugHash('category',["id" => $category->id,"name" => $category->title_tr]);

               ?>
              <li class="active">
                <a <?= navigo()?> href="<?= base_url("film/tur/$category->alias_tr")?>" class="flex items-center">
                  <img class="lazy" src="<?= base_url("uploads/category/original/$category->image")?>" alt="<?= $category->title_tr?>">
                  <?= $category->title_tr?> Filmleri
                </a>
              </li>
               <?php } } ?>
            </ul>
            <?php
                  if($this->stablePage){

            ?>
            <h5>Özel Sayfalar</h5>
           <ul>
               <?php
                     foreach($pages as $page){
               ?>
               <li>
                  <a class="flex items-center no-underline" <?= navigo()?> href="<?= base_url($page->slug)?>">
                     <?php
                        $pageIcon = pathinfo("uploads/pages/original/{$page->icon}");
                        if(!empty($pageIcon["extension"]) && $pageIcon["extension"] == 'svg'){
                          echo file_get_contents("uploads/pages/original/{$page->icon}");
                        }else {
                      ?>
                      <img src="<?= base_url("uploads/pages/original/{$page->icon}")?>">
                    <?php } ?>
                     <?= $page->title?>
                  </a>
               </li>
               <?php } ?>
            </ul>
               <?php } ?>
         </div>
        <div class="leftbar-box">
          <h5>Yıllara Göre Filmler</h5>
          <ul class="flex flex-wrap leftbar-for-years">
           <?php
               $dateEncodeOne = $this->my_model->slugHash('encrypt','{"year":{"from":1960,"to":2013}}');

              for($i = date("Y");$i >= 2014;$i--){
               $dateEncode = $this->my_model->slugHash('encrypt','{"year":{"from":'.$i.'}}');
           ?>
              <li class="w-1/3">
                <a class="block" <?= navigo()?> href="<?= base_url("kesfet/$dateEncode")?>" title="<?= $i?> filmleri"><?= $i?></a>
              </li>
           <?php } ?>
              <li class="w-2/3">
                 <a class="block" <?= navigo()?> href="<?= base_url("kesfet/$dateEncodeOne")?>" title="1970+2013 filmleri">2013 Öncesi</a>
              </li>
          </ul>
        </div>
        <div class="leftbar-box">
          <h5>Haftanın En İyileri</h5>
          <ul class="leftbar-best-movies">
            <?php
              if(!empty($weekly)){
                $count = 0;
                foreach($weekly as $row){
                  $count +=1;
                   if(!empty($row->season_count)){
                      $link = base_url("dizi/$row->alias");
                      $image = base_url("uploads/series/cover/original/$row->cover");
                    }else {
                      $link = base_url("film/$row->alias");
                      $image = base_url("uploads/movies/cover/original/$row->cover");
                    }
            ?>
            <li>
                <div class="relative">
                  <img class="lazy" data-src="<?= $image?>">
                  <a class="flex items-center absolute" <?= navigo()?> href="<?= $link?>">
                    <div class="leftbar-best-movies-text flex-1">
                      <h4><?= $row->name?></h4>
                      <small class="block">+<?= $row->total?> puan</small>
                    </div>
                    <span class="flex items-center justify-center"><?= $count?></span>
                  </a>
                </div>
              </li>
            <?php } } ?>
          </ul>
        </div>
      </aside>
      <main class="content">
        <?php
          if(!empty($this->ads->header)){
            echo $this->ads->header;
          }
          
         if(!empty($this->ads->header_adsense) && $this->method != 'index' && $this->class != 'Movie'&& $this->method != 'Episode' && $this->class != 'Series'){
            echo $this->ads->header_adsense;
         }
        ?>
        <div class="content-inner <?= $this->uri->segment(1) == 'tiers' ? 'doc-dark' : ''?>">
            <?php 
               $this->load->view($subview);
            ?>
        </div>
      </main>
   </div>
   <div class="go-top fixed z-50">
      <a href="javascript:void(0);" class="flex items-center justify-center">
         <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1">
            <line x1="12" y1="19" x2="12" y2="5"></line>
            <polyline points="5 12 12 5 19 12"></polyline>
         </svg>
      </a>
   </div>
   <div class="modal trailer-modal">
      <div class="modal-overlay fixed">
         <div class="modal-content mx-auto relative">
            <div class="modal-close flex absolute">
               <button class="flex items-center focus:outline-none">
                  <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                     <line x1="18" y1="6" x2="6" y2="18"></line>
                     <line x1="6" y1="6" x2="18" y2="18"></line>
                  </svg>
                  Kapat          
               </button>
            </div>
            <div class="trailer-movie">
              <div id="trailer-link"><a href="">Şimdi İzle</a></div>
              <iframe src="" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen=""></iframe>
            </div>
         </div>
      </div>
   </div>
   <footer class="footer">
      <div class="footer-top flex flex-wrap ">
         <div class="footer-top-left w-1/4">
            <div class="footer-logo">
               <a  class="flex items-center" <?= navigo()?> href="/">
                <?php
                  if(!empty($logo["extension"]) && $logo["extension"] == 'svg'){
                    echo file_get_contents("uploads/logo/original/{$this->settings->logo}");
                  }else {
                ?>
                <img src="<?= base_url("uploads/logo/original/{$this->settings->logo}")?>">
              <?php } ?>
               </a>
            </div>
         </div>
         <?php 
      $social = json_decode($this->settings->social_media);
     ?>

         <div class="footer-top-right  flex md:justify-end w-full md:w-3/4">
            <ul class="flex">
               <li>
                  <a class="flex no-underline" target="_blank" <?= navigo()?> href="<?= $social->facebook ?? ""?>">
                     <div class="social flex items-center">
                        <div class="social-icon flex items-center justify-center rounded-full">
                           <svg id="facebook" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-facebook">
                              <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path>
                           </svg>
                        </div>
                        <div class="social-text flex-shrink-0">
                           <span class="block">Facebook</span>
                           <p>Beğen</p>
                        </div>
                     </div>
                  </a>
               </li>
               <li>
                  <a class="flex no-underline" target="_blank" <?= navigo()?> href="<?= $social->twitter ?? ""?>">
                     <div class="social flex items-center">
                        <div class="social-icon flex items-center justify-center rounded-full">
                           <svg id="twitter" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-twitter">
                              <path d="M23 3a10.9 10.9 0 0 1-3.14 1.53 4.48 4.48 0 0 0-7.86 3v1A10.66 10.66 0 0 1 3 4s-4 9 5 13a11.64 11.64 0 0 1-7 2c9 5 20 0 20-11.5a4.5 4.5 0 0 0-.08-.83A7.72 7.72 0 0 0 23 3z"></path>
                           </svg>
                        </div>
                        <div class="social-text flex-shrink-0">
                           <span class="block">Twitter</span>
                           <p>Takip et</p>
                        </div>
                     </div>
                  </a>
               </li>
               <li>
                  <a class="flex no-underline" target="_blank" <?= navigo()?> href="<?= $social->instagram ?? ""?>">
                     <div class="social flex items-center">
                        <div class="social-icon flex items-center justify-center rounded-full">
                           <svg id="instagram" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-instagram">
                              <rect x="2" y="2" width="20" height="20" rx="5" ry="5"></rect>
                              <path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"></path>
                              <line x1="17.5" y1="6.5" x2="17.5" y2="6.5"></line>
                           </svg>
                        </div>
                        <div class="social-text flex-shrink-0">
                           <span class="block">Instagram</span>
                           <p>Takip et</p>
                        </div>
                     </div>
                  </a>
               </li>
            </ul>
         </div>
      </div>
      <div class="footer-middle">
         <div class="flex flex-wrap">
            <?php 
               $footer = json_decode($this->settings->footer_json);
               if(!empty($footer)){
                 foreach($footer as $item){
             ?>
            <div class="w-full lg:w-1/5">
               <h6><?= $item->title?></h6>
               <div class="flex">
                  <?php 
                   if(!empty($item->subs)){
                 ?>
                  <ul class="w-1/2">
                     <?php 
                     $count = 0;
                        foreach($item->subs as $name => $link){
                           $count += 1;
                      ?>
                        <li><a class="flex no-underline" <?= navigo()?> href="<?= $link?>"><?=$name?></a></li>
                     <?php 
                           echo $count % 5 == 0 ? '</ul><ul class="w-1/2">' : '';
                        } ?>
                  </ul>
                  <?php } ?>
               </div>
            </div>
            <?php } } ?>
         </div>
      </div>
      <div class="footer-bottom">
         <p><?= $this->settings->footer?></p>
      </div>
   </footer>
</section>

        
<?php $this->load->view(FRONT_THEME_FILE."/components/page_footer"); ?>
