<!DOCTYPE html>
<html lang="tr">
  <head>
      <meta charset="utf-8">
      <title><?= $this->title?></title>
      <meta name="description" content="<?= $this->desc?>">
        <?php
        if(!empty($this->noindex)){
      ?>
        <meta name="robots" content="noindex">
        <meta name="robots" content="nofollow">
      <?php } ?>
      <meta name="theme-color" media="(prefers-color-scheme: light)" content="#121621">
      <meta name="theme-color" media="(prefers-color-scheme: dark)" content="#4ff461">
      <meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
      <meta property="og:url"         content="<?= $this->meta->og_url ?? base_url(uri_string())?>" />
      <meta property="og:type"        content="website" />
      <meta property="og:title"       content="<?= $this->meta->og_title ?? $this->title?>" />
      <meta property="og:description" content="<?= $this->meta->og_desc ?? $this->desc?>" />
      <meta property="og:image"       content="<?= $this->meta->og_image ?? base_url("assets/images/site-cover.jpg")?>" />
      
      
      <meta name="twitter:card" content="summary_large_image" />
      <meta name="twitter:site" content="@" />
      <meta name="twitter:creator" content="@" />
      <meta name="twitter:title" content="<?= $this->meta->og_title ?? $this->title?>" />
      <meta name="twitter:description" content="<?= $this->meta->og_desc ?? $this->desc?>" />
      <meta name="twitter:image" content="<?= $this->meta->og_image ?? base_url("assets/images/site-cover.jpg")?>" />

      <link rel="stylesheet" href="<?= base_url("assets/v3/css/popup.css")?>">
      <link rel="stylesheet" href="<?= base_url("assets/v3/css/dropdown.min.css")?>">
      <link rel="stylesheet" href="<?= base_url("assets/v3/css/main.css")?>">
      <link rel="stylesheet" href="<?= base_url("assets/v3/css/other.css")?>">
      <link rel="stylesheet" href="<?= base_url("assets/v3/css/news.css")?>">
      <link rel="stylesheet" href="<?= base_url("assets/v3/css/widgets.css")?>">
      <link rel="canonical" href="<?= base_url(uri_string(),null,true)?>">
      <link rel="icon" href="<?= base_url("uploads/favicon/original/favicon.webp")?>" type="image/x-icon">
      
      <?= $this->settings->analytic?>
      <?php 
        if($this->method == 'Landing'){
      ?>
      <link rel="stylesheet" href="<?= base_url("assets/landing/css/design.css")?>">
      <link rel="stylesheet" href="https://cdn.linearicons.com/free/1.0.0/icon-font.min.css" />
      <?php  } ?>
      <?php

         if(!empty($this->schema)){ ?>
         <script type="application/ld+json">
            <?= $this->schema?>
         </script>
       <?php } ?>
  <?php
      if(!empty($this->ads->full_page)){
        echo $this->ads->full_page;
      }
    ?>
   </head>
   <body class="">
