<div class="page-head">
   <h1>Rozetler</h1>
   <p>Görevlerinizi tamamladıkça kazanacağınız rozetlerin hepsi burada. Bu sayfa görev adamlarının sayfası!</p>
</div>
<section class="badges area">
    <div class="area-title">
        <h2>Tüm Rozetler</h2>
    </div>
    <ul class="flex flex-wrap">
      <?php 
      if(!empty($badges)){
         foreach($badges as $row){
            if(!empty($row->condition)){
               $percent = get_percentage($row->condition->from,$row->condition->to);
               if($row->condition->range){
                  if($row->condition->to == $row->condition->from){
                     $progressText = "Açıldı";
                     $percent = "100";
                  }else if($row->condition->to > 0){
                     $progressText = "{$row->condition->to}/{$row->condition->from} Kaldı";
                  }else {
                     $progressText = "{$row->condition->to}/{$row->condition->from} Hemen Başla";
                  }
               }else {
                  if($row->condition->unlock){
                     $percent = "100";
                     $progressText = "Açıldı";
                  }else {
                     $progressText = "Kilitli";
                  }
               }
            }else {
               $percent = "0";
               $progressText = "Kilitli";
            }
      ?>
      <li class="w-full sm:w-1/2 md:w-1/3 xl:w-1/4 relative">
            <div class="badges-box flex flex-col h-full">
               <div class="badges-box-cover ">
                  <img class="w-1/2 mx-auto lazy" data-src="<?= base_url("uploads/badges/original/$row->image")?>" alt="<?= $row->title?>">
                  <div class="badges-box-exp absolute">
                     <span class="flex items-center">
                        <svg viewBox="0 0 8 8" preserveAspectRatio="xMinYMin meet">
                           <path d="M8,5H5v3H3V5H0V3h3V0h2v3h3V5z"></path>
                        </svg>
                        <?= $row->experiance?> Exp
                     </span>
                  </div>
               </div>
               <div class="badges-box-content flex flex-col h-full">
                  <div class="badges-box-icon absolute"><img class="lazy" data-src="<?= base_url("uploads/badges/original/$row->image")?>" alt="<?= $row->title?>"></div>
                  <div class="badges-box-text text-center">
                     <span class="block"><?= $row->title?></span>
                     <p><?= $row->desc?></p>
                  </div>
                  <div class="badges-box-progress">
                     <div class="progress">
                        <div class="progress-area relative">
                           <div class="progress-bar absolute" style="width: <?= $percent?>%"></div>
                        </div>
                        <div class="progress-text "><span class="block"><?= $progressText?></span></div>
                     </div>
                  </div>
                  <div class="badges-box-completed-user flex items-center">
                     <?php 
                        if(!empty($row->friends)){
                     ?>
                     <ul class="flex">
                        <?php 
                           foreach($row->friends as $friend){
                        ?>
                        <li>
                           <a href="<?= base_url("profil/$friend->u_username")?>"><img class="lazy" title="<?= $friend->u_name?>" data-src="<?= base_url("uploads/users/$friend->u_avatar")?>" alt="<?= $friend->u_name?>"></a>
                        </li>
                        <?php } ?>
                     </ul>
                     <div class="badges-box-completed-user-text">
                        <?php 
                           if($friend->total > 3){
                        ?>
                        <span class="block">+<?=$friend->total?> arkadaşın</span>
                        <?php }else { ?>
                        <span class="block"><?= $friend->total?> arkadaşın</span>
                        <?php } ?>
                        <p>Bu rozeti kazandı</p>
                     </div>
                  <?php }else {  ?>
                     <div class="badges-box-empty-user-text ">
                        <p>Arkadaşların arasında ilk sen kazan</p>
                     </div>
                  <?php } ?>
                  </div>
               </div>
            </div>
      </li>
      <?php } } ?>
     
    </ul>
    <div class="pagination flex justify-center">
    <?= $page?>
    </div>
</section>
