<div class="page flex justify-between flex-col lg:flex-row">
   <div class="page-title w-full lg:w-1/2">
      <h1>Keşfet</h1>
      <p>Yeni film ve dizileri burada bulabilirsin.</p>
   </div>
   <div class="page-right w-full lg:w-1/2 flex items-start justify-start lg:justify-end">
      <div class="select flex md:items-center flex-col md:flex-row">
         <div class="select-title"><span class="block">Sırala:</span></div>
         <div class="select-area relative">
            <div class="ui secondary dropdown top left pointing selection" tabindex="0">
               <i class="dropdown icon"></i>
               <div class="text"><?= $sort ?></div>
               <div class="menu transition hidden" tabindex="-1">
                  <a class="item" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("sort","imdb_top")) ?>">IMDb Puanına Göre En Yüksek</a>
                  <a class="item" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("sort","imdb_bottom")) ?>">IMDb Puanına Göre En Düşük</a>
                  <a class="item" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("sort","year_top")) ?>">Yıla Göre En Yüksek</a>
                  <a class="item" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("sort","year_bottom")) ?>">Yıla Göre En Düşük</a>
                  <a class="item" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("sort","date_top")) ?>">İlk Eklenene Göre</a>
                  <a class="item active selected" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("sort","date_bottom")) ?>">Son Eklenene Göre</a>
               </div>
            </div>
            <div class="select-icon pointer-events-none absolute flex">
               <svg>
                  <use xlink:href="images/icons/down.svg#down"></use>
               </svg>
            </div>
         </div>
      </div>
   </div>
</div>

<div class="filter">
   <ul class="flex flex-wrap">
       <li class="w-full lg:w-1/4">
         <div class="ui selection dropdown">
            <i class="dropdown icon"></i>
            <?php
                if(!empty($uriHash->type)){
            ?>
            <div class="default text tags">
               <?php
                  if( $uriHash->type == 'movies'){
               ?>
                  <a class="ui label" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("delete","type")) ?>">Filmler <span class="mofycon-delete"></span></a>
               <?php }else if ( $uriHash->type == 'series') { ?>
                  <a class="ui label" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("delete","type")) ?>">Diziler <span class="mofycon-delete"></span></a>
               <?php } ?>
            </div>
            <?php }else { ?>
            <div class="default text">Filmler</div>
            <?php } ?>
            <div class="menu">
               <?php
                  $seriesTypeHash = $this->my_model->slugHash('type',"series");
                  $moviesTypeHash = $this->my_model->slugHash('type',"movies");
               ?>
               <a class="item" data-value="Filmler" <?= navigo()?> href="<?= base_url("kesfet/$moviesTypeHash")?>">Filmler</a>
               <a class="item" data-value="Diziler" <?= navigo()?> href="<?= base_url("kesfet/$seriesTypeHash")?>">Diziler</a>
            </div>
         </div>
      </li>
      <li class="w-full lg:w-1/4">
         <div class="ui selection dropdown">
            <input type="hidden" name="s_year">
            <i class="dropdown icon"></i>
            <?php
               if(!empty($uriHash->year)){
            ?>
            <div class="default text tags">
               <a class="ui label" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("delete","year")) ?>">
                  <?= $uriHash->year->from ?? 2000 ?> <?= !empty($uriHash->year->to) ? "- {$uriHash->year->to}" : "" ?>  <span class="mofycon-delete"></span></a>
            </div>
            <?php }else { ?>
               <div class="default text">Yıllar</div>
            <?php } ?>
            <div class="menu">
            <?php
               $dateEncodeOne = $this->my_model->slugHash('multi','{"year":{"from":2015,"to":'.date("Y").'}}');
               $dateEncodeSecond = $this->my_model->slugHash('multi','{"year":{"from":2000,"to":2015}}');
               $dateEncodeThird = $this->my_model->slugHash('multi','{"year":{"from":1970,"to":2000}}');
                  for($y = date("Y");$y >= 2016;$y--){
                     $encode = $this->my_model->slugHash('multi','{"year":{"from":'.$y.'}}');
               ?>
                 <a <?= navigo()?> href="<?= base_url("kesfet/$encode")?>" class="item" data-value="<?= $y?>"><?= $y?> <?= !empty($uriHash->type) && $uriHash->type == 'series' ? 'Dizileri' : 'Filmleri' ?></a>
              <?php } ?>
              <a <?= navigo()?> href="<?= base_url("kesfet/$dateEncodeOne")?>" class="item" data-value="2015+2020">2015 - <?= date("Y")?> Arası</a>
              <a <?= navigo()?> href="<?= base_url("kesfet/$dateEncodeSecond")?>" class="item" data-value="2000+2015">2000 - 2015 Arası</a>
              <a <?= navigo()?> href="<?= base_url("kesfet/$dateEncodeThird")?>" class="item" data-value="1960+2000">2000 Öncesi</a>
            </div>
         </div>
      </li>
      <li class="w-full lg:w-1/4">
         <div class="ui selection dropdown">
            <i class="dropdown icon"></i>
            <?php
               if(!empty($uriHash->category)){
            ?>
            <div class="default text tags">
            <?php
               foreach($uriHash->category as $selected){ ?>
                  <a class="ui label" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("delete","category")) ?>"><?= $selected->name ?> <span class="mofycon-delete"></span></a>
               <?php } ?>
            </div>
            <?php }else { ?>
            <div class="default text">Türler</div>
            <?php } ?>
            <div class="menu">
             <?php
                  if(!empty($category)){
                     foreach($category as $category){
                        $selectedId = !empty($uriHash->category) ? array_column($uriHash->category, "id") : [];
                        if(in_array($category->id, $selectedId)){
                           $active = 'explore-filter-active';
                        }else {
                           $active = "";
                        }
                        $hash = $this->my_model->slugHash('category',["id" => $category->id,"name" => $category->title_tr]);
                        $link = base_url("kesfet/$hash");
               ?>
               <a class="item" data-value="<?= $category->title_tr?>"<?= navigo()?>  href="<?= $link?>"><?= $category->title_tr?></a>
               <?php } } ?>
            </div>
         </div>
      </li>
   
      <li class="w-full lg:w-1/4">
         <div class="ui selection dropdown">
            <i class="dropdown icon"></i>
                <?php
                  if(!empty($uriHash->imdb)){
               ?>
               <div class="default text tags">
                  <a class="ui label" <?= navigo()?> href="<?= base_url("kesfet/".$this->my_model->slugHash("delete","imdb")) ?>"> <?= $uriHash->imdb->from ?> ve üzeri <span class="mofycon-delete"></span></a>
               </div>
            <?php }else { ?>
            <div class="default text">IMDb Puanı</div>
            <?php } ?>
            <div class="menu">
               <?php
                  for($i = 9;$i >= 6;$i--){
                  $imdbEncodeOne = $this->my_model->slugHash('multi','{"imdb":{"from":'.$i.'}}');
               ?>
               <a class="item" data-value="<?= $i?>" <?= navigo()?> href="<?= base_url("kesfet/$imdbEncodeOne")?>"><?= $i?> ve üzeri</a>
               <?php } ?>
            </div>
         </div>
      </li>
   </ul>
</div>
<div class="movies-list">
   <?php 
      if(!empty($uriHash) && @$uriHash->type == 'movies'){
         $this->load->view(FRONT_THEME_FILE."template/Discover/movies");
      }else {
         $this->load->view(FRONT_THEME_FILE."template/Discover/series");
      }
   ?>

</div>
  <?php
   if(!empty($pagination)){
  ?>
   <div class="pagination">
    <?= $pagination?>
   </div>
<?php } ?>
