   <?php
      if($items){
   ?>
   <ul class="flex flex-wrap row">
      <?php
         foreach($items as $item){
            if(!empty($item->season_count)){
               $link = base_url("dizi/$item->alias");
            }else {
               $link = base_url("film/$item->alias");
            }
      ?>
      <li class="w-full">
         <div class="filter-result-box">
            <div class="filter-result-box-top flex items-start">
               <div class="filter-result-box-image flex-shrink-0">
                  <a  class="block" <?= navigo()?> href="<?= $link?>">
                     <img class="lazy" data-src="<?= base_url("uploads/series/original/$item->image")?>" alt="<?= $item->name?>">
                  </a>
               </div>
               <div class="filter-result-box-subject w-full">
                  <div class="filter-result-box-subject-top flex-col md:flex-row flex items-start">
                     <div class="filter-result-box-subject-top-left">
                        <a  class="block no-underline" <?= navigo()?> href="<?= $link?>">
                           <h2 class="truncate"><?=$item->name?></h2>
                        </a>
                        <p><?= categoryParse($item->category)?></p>
                        <span class="flex items-center">
                           <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 46.354 46.354" style="enable-background:new 0 0 46.354 46.354;" xml:space="preserve">
                              <g>
                                 <path d="M21.57,2.049c0.303-0.612,0.927-1,1.609-1c0.682,0,1.307,0.388,1.609,1l5.771,11.695c0.261,0.529,0.767,0.896,1.352,0.981    L44.817,16.6c0.677,0.098,1.237,0.572,1.448,1.221c0.211,0.649,0.035,1.363-0.454,1.839l-9.338,9.104    c-0.423,0.412-0.616,1.006-0.517,1.588l2.204,12.855c0.114,0.674-0.161,1.354-0.715,1.756c-0.553,0.4-1.284,0.453-1.89,0.137    l-11.544-6.07c-0.522-0.275-1.147-0.275-1.67,0l-11.544,6.069c-0.604,0.317-1.337,0.265-1.89-0.136    c-0.553-0.401-0.829-1.082-0.714-1.756l2.204-12.855c0.1-0.582-0.094-1.176-0.517-1.588L0.542,19.66    c-0.489-0.477-0.665-1.19-0.454-1.839c0.211-0.649,0.772-1.123,1.449-1.221l12.908-1.875c0.584-0.085,1.09-0.452,1.351-0.982    L21.57,2.049z"></path>
                              </g>
                           </svg>
                           <?= number_format($item->imdb_rate,1)?>                       
                        </span>
                     </div>
                     <div class="filter-result-box-subject-top-right">
                        <button class="focus:outline-none set-follow" data-type="1" data-data="<?= $item->id?>"><?= $item->follow ? 'Takip ediliyor' : "Takip et"?></button>
                     </div>
                  </div>
                  <div class="filter-result-box-subject-middle article hidden md:block" data-more="Daha fazla göster"data-less="Daha az göster">
                     <p><?= $item->overview?></p>
                  </div>
               </div>
            </div>
            <div class="filter-result-box-middle article block md:hidden">
               <p><?= $item->overview?></p>
            </div>
            <div class="filter-result-box-bottom">
               <ul class="flex">
                  <li class="w-auto sm:w-1/5 flex-shrink-0">
                     <span class="block">Yapım yılı</span>
                     <p><?= $item->year?></p>
                  </li>
                  <li class="w-auto sm:w-1/5 flex-shrink-0">
                     <span class="block">Süre</span>
                     <p><?= $item->time?> dk</p>
                  </li>
                  <li class="w-auto sm:w-1/5 flex-shrink-0">
                     <span class="block">Sezon</span>
                     <p><?= $item->season_count?></p>
                  </li>
                  <li class="w-auto sm:w-1/5 flex-shrink-0">
                     <span class="block">Bölüm</span>
                     <p><?= $item->episode_count?></p>
                  </li>
                  <li class="w-auto sm:w-1/5 flex-shrink-0">
                     <span class="block">Takipçiler</span>
                     <p><?= $item->followerCount?></p>
                  </li>
               </ul>
            </div>
         </div>
      </li>
      <?php } ?>
   </ul>
   <?php } else {
      echo alert2('danger','Listelenecek içerik bulunamadı.');
   } ?>
