<div class="page flex justify-between flex-col md:flex-row">
   <div class="page-title md:w-1/2">
      <h1><?= $category->name?> Konuları</h1>
      <p>Tüm diziler, filmler ve sitemiz hakkındaki düşüncelerini belirtip, sorularını sorabileceğin tartışma forumları</p>
   </div>
   <div class="page-right md:w-1/2 flex items-start md:justify-end">
      <div class="page-right-button"><a class="block" <?= navigo()?> href="<?= base_url("tartisma/ekle")?>">Yeni Konu Aç</a></div>
   </div>
</div>
<div class="discussion">
   <div class="discussion-nav">
      <ul class="flex">
         <li><a class="block discussion-nav-active" <?= navigo()?> href="<?= base_url("tartismalar/$category->alias")?>">Popüler Tartışmalar</a></li>
      </ul>
   </div>
   <div class="discussion-list">
      <div class="discussion-list-title">
         <h2>En Popüler <?= $category->name?> Konuları</h2>
      </div>
      <ul>
         <?php
            if(!empty($topics)){
               foreach($topics as $row){
         ?>
         <li class="flex items-center">
            <div class="discussion-vote">
               <button class="vote-up focus:outline-none " onclick="addFeel(1,1,this,4)">
                  <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 386.257 386.257" style="enable-background:new 0 0 386.257 386.257;" xml:space="preserve">
                     <polygon points="193.129,96.879 0,289.379 386.257,289.379 "></polygon>
                  </svg>
               </button>
               <span class="block text-center">0</span>
               <button class="vote-down focus:outline-none " onclick="addFeel(1,2,this,4)">
                  <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 386.257 386.257" style="enable-background:new 0 0 386.257 386.257;" xml:space="preserve">
                     <polygon points="0,96.879 193.129,289.379 386.257,96.879 "></polygon>
                  </svg>
               </button>
            </div>
            <div class="discussion-image flex-shrink-0">
               <a class="block" <?= navigo()?> href="<?= base_url("tartismalar/$category->alias/$row->alias")?>">
                  <img class="lazy" data-src="<?= base_url("assets/images/discuss-issue.png")?>" alt="<?= $row->name?>">
               </a>
            </div>
            <div class="discussion-subject">
               <h3 class="truncate"><a class="block" <?= navigo()?> href="<?= base_url("tartismalar/$category->alias/$row->alias")?>"><?= $row->name?></a></h3>
               <p class="truncate"><?= kisalt($row->desc,299)?></p>
               <p>0 yorum · <?= zaman($row->created_at)?> <a class="inline-block" <?= navigo()?> href="<?= base_url("profil/$row->u_username")?>"><strong><?= $row->u_name?></strong></a> tarafından eklendi.</p>
            </div>
            <div class="discussion-favorite flex">
               <button class="focus:outline-none " onclick="addFavorite(1,1,this)">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true" data-reactid="1161">
                     <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                  </svg>
               </button>
            </div>
         </li>
         <?php } } ?>
      </ul>
   </div>
</div>

