<div class="flow">
   <div class="page-title w-full mb-5 lg:w-1/2">
      <h1>Akış</h1>
      <p>Bugün neler olduğuna bak ve sen de bir şeyler paylaş!</p>
   </div>
   <div class="flow-content flex flex-col xl:flex-row">
      <div class="flow-left w-full xl:w-2/3">
         <?php
         if(!$hash){
            if(LOGIN){
         ?>
         <div class="flow-write flow-content">
            <div class="flow-write-header">
               <ul class="flex" data-tab="write">
                  <li class="tab-active w-1/2" data-type="post">
                     <a class="flex items-center justify-center" href="javascript:void(0);">
                        <svg viewBox="0 0 20 20">
                           <path d="M16,1H4C1.791,1,0,2.791,0,5v4v2v4c0,2.209,1.791,4,4,4h12c2.209,0,4-1.791,4-4v-4V9V5C20,2.791,18.209,1,16,1z M18,15c0,1.103-0.897,2-2,2H4c-1.103,0-2-0.897-2-2v-4h16V15z M18,9H2V5c0-1.103,0.897-2,2-2h12c1.103,0,2,0.897,2,2V9z"></path>
                           <rect x="13" y="13" width="2" height="2"></rect>
                           <rect x="9" y="13" width="2" height="2"></rect>
                           <rect x="5" y="5" width="10" height="2"></rect>
                           <rect x="5" y="13" width="2" height="2"></rect>
                        </svg>
                        Durum
                     </a>
                  </li>
                  <li class="relative w-1/2" data-type="poll">
                     <a class="flex items-center justify-center" href="javascript:void(0);">
                        <svg viewBox="0 0 20 20">
                           <path d="M12,14H2C0.896,14,0,14.896,0,16v2C0,19.104,0.896,20,2,20h10c1.105,0,2-0.896,2-2v-2C14,14.896,13.105,14,12,14z M12,18H2v-2h10V18z M18,7H2C0.896,7,0,7.896,0,9v2C0,12.104,0.896,13,2,13h16c1.104,0,2-0.896,2-2V9C20,7.896,19.104,7,18,7z M18,11H2V9h16V11z M2,6h4C7.105,6,8,5.104,8,4V2C8,0.896,7.105,0,6,0H2C0.896,0,0,0.896,0,2v2C0,5.104,0.896,6,2,6z M2,2h4v2H2V2z"></path>
                        </svg>
                        Anket
                     </a>
                  </li>
               </ul>
            </div>
            <div class="flow-write-content" id="write">
               <div class="flow-write-content tab-content tab-active">
                  <div class="form-group">
                     <div class="form-element"><textarea data-autoresize id="discussion_write" name="discussion_write" placeholder="Merhaba <?= $this->user->u_name?>, yazını buraya yazabilirsin..."><?= $shared ?? ""?></textarea></div>
                  </div>
                  <div class="image-upload-preview hidden" data-preview-area>
                     <ul class="flex flex-wrap result-images"></ul>
                  </div>
               </div>
               <div class="flow-write-content tab-content">
                  <div class="poll-create">
                     <div class="poll-create-box">
                        <span class="block">Soru veya Başlık</span>
                        <ul>
                           <li>
                              <div class="form-group">
                                 <div class="form-element relative"><input type="text" id="questOrTitle" name="questOrTitle" autocomplete="off" required><label class="block absolute" for="questOrTitle">Bir soru veya başlık yaz...</label></div>
                              </div>
                           </li>
                        </ul>
                     </div>
                     <div class="poll-create-box">
                        <span class="block">Cevaplar</span>
                        <div class="form-group">
                           <div class="form-element relative">
                              <input type="text" class="newPollItem" name="newPollItem[]" autocomplete="off" required><label class="block absolute" for="newPollItem">Cevap 1</label>
                              <div class="poll-create-box-delete absolute">
                                 <button class="focus:outline-none" tabindex="-1">
                                    <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                       <line x1="18" y1="6" x2="6" y2="18"></line>
                                       <line x1="6" y1="6" x2="18" y2="18"></line>
                                    </svg>
                                 </button>
                              </div>
                           </div>
                           <div class="form-element relative">
                              <input type="text" class="newPollItem" name="newPollItem[]" autocomplete="off" required><label class="block absolute" for="newPollItem2">Cevap 2</label>
                              <div class="poll-create-box-delete absolute">
                                 <button class="focus:outline-none" tabindex="-1">
                                    <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                       <line x1="18" y1="6" x2="6" y2="18"></line>
                                       <line x1="6" y1="6" x2="18" y2="18"></line>
                                    </svg>
                                 </button>
                              </div>
                           </div>
                           <div class="form-element relative">
                              <input type="text" class="newPollItem" name="newPollItem[]" autocomplete="off" required><label class="block absolute" for="newPollItem3">Cevap 3</label>
                              <div class="poll-create-box-delete absolute">
                                 <button class="focus:outline-none" tabindex="-1">
                                    <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                       <line x1="18" y1="6" x2="6" y2="18"></line>
                                       <line x1="6" y1="6" x2="18" y2="18"></line>
                                    </svg>
                                 </button>
                              </div>
                           </div>
                        </div>
                        <div class="form-group">
                           <div class="form-element relative"><button class="w-full add-new-answer focus:outline-none">+ Yeni Cevap Ekle</button></div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="flow-write-footer flex items-center justify-between">
               <div class="flow-write-footer-left">
                  <ul class="flex">
                     <li>
                        <div class="image-upload-button">
                           <label class="block">
                              <input type="file" id="wc-input" multiple accept=".png, .jpg, .jpeg" data-upload-area="" data-type="flow">
                              <span class="block">
                                 <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                                    <circle cx="8.5" cy="8.5" r="1.5"></circle>
                                    <polyline points="21 15 16 10 5 21"></polyline>
                                 </svg>
                              </span>
                           </label>
                        </div>
                     </li>
                  </ul>
               </div>
               <div class="form-group flex">
                  <div class="form-element"><button class="button-second focus:outline-none set-post" data-id="" type="submit">Paylaş</button></div>
               </div>
            </div>
         </div>
         <?php }else {
            echo alert('danger','Paylaşım yapmak için lütfen giriş yapınız.');
         } ?>
      <?php } ?>
         <div class="flow-nav">
            <ul class="flex">
               <li class="active"><a class="block" href="javascript:void(0);">Tümü</a></li>
            </ul>
         </div>
         <div class="flow-posts">
            <ul>
               <?php 
                  if(!empty($posts)){
                     foreach($posts as $posts){
                        if($posts->action){
                           $parse_action = explode("|", $posts->action);
                           list($post_action_id,$action_id,$action_title,$action_image) = $parse_action;
                        }
                        if($posts->poll_values){
                           $text = "anket";
                        }else {
                           $text = "gönderi";
                        }
               ?>
               <li id="post-<?= $posts->flow_post_id?>">
                  <div class="post">
                     <div class="post-header flex items-center justify-between">
                        <div class="user-medium flex items-center">
                           <div class="user-medium-image flex-shrink-0"><a class="block" href="<?= base_url("profil/$posts->u_username")?>"><img class="lazy" data-src="<?= base_url("uploads/users/$posts->u_avatar")?>" alt="<?= $posts->u_name?>"></a></div>
                           <div class="user-medium-text">
                              <span class="block"><a class="inline-block" href="<?= base_url("profil/$posts->u_username")?>"><?= $posts->u_name?></a> bir <strong><?=$text?> </strong>paylaştı</span>
                              <p><?= zaman($posts->created_at)?></p>
                           </div>
                        </div>
                        <?php 
                           if($posts->user_id == $this->user_id || ADMIN){
                        ?>
                        <div class="options-drop relative">
                           <button class="flex focus:outline-none">
                              <svg viewBox="0 0 22 6">
                                 <path d="M19,6c-1.657,0-3-1.344-3-3c0-1.656,1.343-3,3-3s3,1.344,3,3C22,4.656,20.657,6,19,6z M19,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C20,2.447,19.552,2,19,2z M11,6C9.343,6,8,4.656,8,3c0-1.656,1.343-3,3-3s3,1.344,3,3C14,4.656,12.657,6,11,6z M11,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C12,2.447,11.552,2,11,2z M3,6C1.343,6,0,4.656,0,3c0-1.656,1.343-3,3-3c1.656,0,3,1.344,3,3C6,4.656,4.656,6,3,6z M3,2C2.447,2,2,2.447,2,3c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C4,2.447,3.552,2,3,2z"></path>
                              </svg>
                           </button>
                           <div class="options-drop-content absolute">
                              <ul>
                                 <?php 
                                    if(!$posts->poll_values){
                                 ?> 
                                 <!-- <li><a class="block" href="javascript:void(0);" data-flow-edit="<?= $posts->flow_post_id?>">Gönderiyi Düzenle</a></li> -->
                                 <?php } ?>
                                 <li><a class="block second" href="javascript:void(0);" data-type="flow" data-delete-post="<?= $posts->flow_post_id?>">Gönderiyi Sil</a></li>
                              </ul>
                           </div>
                        </div>
                        <?php } ?>
                     </div>
                     <div class="post-content">
                        <p id="post<?= $posts->flow_post_id?>"><?= nl2br($posts->post)?></p>
                        <?php
                           if($posts->poll){
                              echo $this->load->view(FRONT_THEME_FILE."template/Flow/poll-box",$posts,true);
                           }
                        ?>
                        <?php 
                           if(!empty($posts->post_images)){
                              $total_count = count($posts->post_images) - 4;
                        ?> 
                        <div class="post-content-images">
                           <ul class="flex flex-wrap">
                              <?php 
                              $count = 0;
                                 foreach($posts->post_images as $images){
                                    $count += 1;
                                    if(count($posts->post_images) == 1){
                                       $class = "w-full";
                                    }else if($count == 2 || $count == 1){
                                       $class = "w-1/2";
                                    }else {
                                       $class = "w-1/3";
                                    }
                              ?>
                              <li class="relative <?= $class ?> <?= $count > 4 && $count != 5 ? 'hidden' : null ?>">
                                 <a class="block" href="<?= base_url("uploads/flow/post/original/$images->image")?>" data-fancybox="gallery-<?= $posts->flow_post_id?>">
                                    <img class="lazy" data-src="<?= base_url("uploads/flow/post/original/$images->image")?>" alt="">
                                    <?php 
                                       if($count > 4){
                                    ?>
                                    <div class="post-content-images-on absolute flex items-center justify-center"><span class="block">+<?= $total_count?></span></div>
                                 <?php } ?>
                                 </a>
                              </li>
                              <?php } ?>
                           </ul>
                        </div>
                        <?php } ?>
                     </div>
                     <div class="post-action flex items-center justify-between">
                        <div class="reactions flex items-center">
                          
                           <ul class="sm:flex">
                              <?php 
                                 if(!empty($posts->action_list)){
                                    foreach($posts->action_list as $action){
                              ?>
                              <li class="relative flex-shrink-0" data-total="<?= $action->total_action?>" data-action-id="<?=$action->action_id?>" >
                                 <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                 <?php 
                                    if(!empty($action->users)){
                                 ?>
                                 <div class="tooltip absolute">
                                    <small class="flex items-center"><img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>"><?= $action->title?></small>
                                    <ul>
                                      <?php 
                                          foreach($action->users as $user){
                                      ?> 
                                       <li><?= $user->u_name?></li>
                                       <?php } ?>
                                       <?php 
                                          if(count($action->users) > 6){
                                       ?>
                                       <li><strong><?= $action->total_action?> kişi daha..</strong></li>
                                       <?php } ?>
                                    </ul>
                                 </div>
                                 <?php } ?>
                              </li>
                              <?php } } ?>
                           </ul>
                           <span class="block"><?= $posts->action_count?></span>
                        </div>
                        <ul class="flex">
                           <li><button class="focus:outline-none"><?= $posts->comment_count?> Yorum</button></li>
                        </ul>
                     </div>
                     <div class="post-footer">
                        <ul class="flex justify-around">
                           <li class="relative actions-content">
                              <?php 
                                 if($posts->action){
                              ?>
                              <button class="flex items-center focus:outline-none active delete-action" data-id="<?= $post_action_id?>" data-act="<?=$action_id?>" data-type="flow">
                                 <img class="lazy" width="22" height="22" data-src="<?= base_url("uploads/reaction/original/{$action_image}")?>" alt="<?= $action_title?>">
                                 <span class="hidden sm:block"><?= $action_title?></span>
                              </button>
                              <?php }else { ?>
                                 <button class="flex items-center <?= LOGIN ? 'set-action' : null ?>  focus:outline-none" <?= login_check()?> data-type="flow" data-id="<?=$posts->flow_post_id?>" data-action="1">
                                    <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                       <path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28a2 2 0 0 0 2-1.7l1.38-9a2 2 0 0 0-2-2.3zM7 22H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h3"></path>
                                    </svg>
                                    <span class="hidden sm:block">Beğen</span>
                                 </button>
                              <?php } ?>
                          
                           </li>
                           <li>
                              <button class="flex items-center focus:outline-none" data-goto-comment="">
                                 <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                                 </svg>
                                 <span class="hidden sm:block">Yorum</span>
                              </button>
                           </li>
                           <li>
                              <button class="flex items-center focus:outline-none flow-share" data-target=".share-modal">
                                 <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="18" cy="5" r="3"></circle>
                                    <circle cx="6" cy="12" r="3"></circle>
                                    <circle cx="18" cy="19" r="3"></circle>
                                    <line x1="8.59" y1="13.51" x2="15.42" y2="17.49"></line>
                                    <line x1="15.41" y1="6.51" x2="8.59" y2="10.49"></line>
                                 </svg>
                                 <span class="hidden sm:block">Paylaş</span>
                              </button>
                           </li>
                        </ul>
                     </div>

                     <div class="post-comment">
                        <?php 
                           if(!empty($posts->comment)){
                        ?>
                        <ul>
                           <?php 
                              foreach($posts->comment as $comment){
                                 if($comment->action){
                                    $parse_action = explode("|", $comment->action);
                                    list($post_action_id,$action_id,$action_title,$action_image) = $parse_action;
                                 }
                           ?>
                           <li>
                              <div class="post-comment-box flex items-start">
                                 <div class="user-medium-image flex-shrink-0"><a class="block" href="<?= base_url("profil/$comment->u_username")?>"><img class="lazy" data-src="<?= base_url("uploads/users//$comment->u_avatar")?>" alt="<?= $comment->u_name?>"></a></div>
                                 <div class="user-medium-text">
                                    <span class="flex">
                                       <a class="block" href="<?= base_url("profil/$comment->u_username")?>"><?= $comment->u_name?></a>
                                    </span>
                                    <p id="post<?= $comment->flow_post_id?>"><?= $comment->post?></p>
                                    <div class="post-comment-box-action">
                                       <ul class="flex items-center">
                                          <li>
                                             <div class="reactions flex items-center">
                                                <?php
                                                   if(!empty($comment->action_list)){
                                                ?>
                                                <ul class="flex">
                                                   <?php 
                                                   $total_action = 0;
                                                      foreach($comment->action_list as $action){
                                                         $total_action += $action->total_action;
                                                   ?>
                                                   <li class="relative flex-shrink-0" data-total="<?= $action->total_action?>" data-action-id="<?=$action->action_id?>">
                                                      <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                                      <?php 
                                                         if(!empty($action->users)){
                                                      ?>
                                                      <div class="tooltip absolute">
                                                         <small class="flex items-center">
                                                            <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                                            <?= $action->title?>
                                                         </small>
                                                         <ul>
                                                            <?php
                                                               foreach($action->users as $user){
                                                            ?>
                                                            <li><?= $user->u_name?></li>
                                                            <?php } ?>
                                                            <?php 
                                                               if(count($action->users) > 6){
                                                            ?>
                                                            <li><strong><?= $action->total_action?> kişi daha..</strong></li>
                                                            <?php } ?>
                                                         </ul>
                                                      </div>
                                                      <?php } ?>
                                                   </li>
                                                      <?php } ?>
                                                </ul>
                                                <span class="block"><?= $total_action?></span>
                                                <?php }else { ?>
                                                   <ul class="flex"></ul>
                                                   <span class="block">0</span>
                                                <?php } ?>
                                             </div>
                                          </li>
                                          <li class="relative">
                                             <?php 
                                                if(!empty($comment->action)){
                                             ?>
                                              <button class="flex items-center active delete-action focus:outline-none" data-delete-action="<?= $post_action_id?>" data-type="flow" data-action="<?=$action_id?>" data-act="<?= $action_id?>" data-post="1" data-id="<?= $comment->flow_post_id?>">  <img class="lazy" width="22" height="22" data-src="<?= base_url("uploads/reaction/original/$action_image")?>" alt="<?= $action_title?>">
                                                <span class="sm:block"><?= $action_title?></span>
                                              </button>
                                             <?php } else { ?>
                                                <button class="flex items-center <?= LOGIN ? 'set-action' : null ?> focus:outline-none" <?= login_check()?> data-post="1" data-type="flow" data-id="<?= $comment->flow_post_id ?>" data-action="1"> 
                                                <span class="sm:block">Beğen</span></button>
                                             <?php } ?>
                                          </li>
                                          <li><button class="flex reply-button focus:outline-none" <?= login_check()?> data-group="" data-id="<?= $comment->flow_post_id ?>">Cevapla</button></li>
                                          <li><span class="block"><?= zaman($comment->created_at) ?></span></li>
                                          <?php 
                                             if(LOGIN  || $this->user_id == $comment->user_id || ADMIN){
                                          ?>
                                          <li>
                                             <div class="options-drop relative">
                                                <button class="flex focus:outline-none">
                                                   <svg viewBox="0 0 22 6">
                                                      <path d="M19,6c-1.657,0-3-1.344-3-3c0-1.656,1.343-3,3-3s3,1.344,3,3C22,4.656,20.657,6,19,6z M19,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C20,2.447,19.552,2,19,2z M11,6C9.343,6,8,4.656,8,3c0-1.656,1.343-3,3-3s3,1.344,3,3C14,4.656,12.657,6,11,6z M11,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C12,2.447,11.552,2,11,2z M3,6C1.343,6,0,4.656,0,3c0-1.656,1.343-3,3-3c1.656,0,3,1.344,3,3C6,4.656,4.656,6,3,6z M3,2C2.447,2,2,2.447,2,3c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C4,2.447,3.552,2,3,2z"></path>
                                                   </svg>
                                                </button>
                                                  
                                                   <div class="options-drop-content absolute">
                                                      <ul>
                                                         <li><a class="block second" href="javascript:void(0);" data-type="flow" data-delete-post="<?= $comment->flow_post_id?>">Yorumu Sil</a></li>
                                                      </ul>
                                                   </div>
                                             </div>
                                          </li>
                                          <?php } ?>
                                       </ul>
                                    </div>
                                 </div>
                              </div>
                              <?php 
                                 if(LOGIN){
                              ?>
                              <div class="comments-write comments-reply flex items-center">
                                 <div class="user-medium flex items-center">
                                    <div class="user-medium-image flex-shrink-0"><a class="block" href="<?= base_url("profil/{$this->user->u_username}")?>"><img class="lazy" data-src="<?= base_url("uploads/users/{$this->user->u_avatar}")?>" alt="<?= $this->user->u_name ?>"></a></div>
                                 </div>
                                 <div class="form-group w-full relative flex items-center" method="post" name="">
                                    <div class="form-element w-full relative"><input type="text" class="replyComment" name="replyComment" autocomplete="off" required><label class="block absolute" for="replyComment">Cevabın</label></div>
                                    <button class="absolute focus:outline-none reply-comment" >Paylaş</button>
                                 </div>
                              </div>
                              <?php } ?>
                              <?php 
                                 if(!empty($comment->comment)){
                                    foreach($comment->comment as $comments){
                                       if($comments->action){
                                          $parse_action = explode("|", $comments->action);
                                          list($post_action_id,$action_id,$action_title,$action_image) = $parse_action;
                                       }
                              ?>
                              <div class="post-comment-box post-comment-reply-box flex items-start">
                                 <div class="user-medium-image flex-shrink-0"><a class="block" href="<?= base_url("profil/{$comments->u_username}")?>"><img class="lazy" data-src="<?= base_url("uploads/users/{$comments->u_avatar}")?>" alt="<?= $comments->u_name?>"></a></div>
                                 <div class="user-medium-text">
                                    <span class="flex">
                                       <a class="block" href="<?= base_url("profil/$comments->u_username")?>"><?= $comments->u_name?></a>
                                    </span>
                                    <p id="post<?= $comments->flow_post_id?>"><?= $comments->post?></p>
                                    <div class="post-comment-box-action">
                                       <ul class="flex items-center">
                                          <li>
                                             <div class="reactions flex items-center">
                                                <?php
                                                   if(!empty($comments->action_list)){
                                                ?>
                                                <ul class="flex">
                                                   <?php 
                                                   $action_count = 0;
                                                      foreach($comments->action_list as $action){
                                                         $action_count += $action->total_action;
                                                   ?>
                                                   <li class="relative flex-shrink-0" data-total="<?= $action->total_action?>" data-action-id="<?=$action->action_id?>">
                                                      <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                                      <?php 
                                                         if(!empty($action->users)){
                                                      ?>
                                                      <div class="tooltip absolute">
                                                         <small class="flex items-center">
                                                            <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                                            <?= $action->title?>
                                                         </small>
                                                         <ul>
                                                            <?php
                                                               foreach($action->users as $user){
                                                            ?>
                                                            <li><?= $user->u_name?></li>
                                                            <?php } ?>
                                                            <?php 
                                                               if(count($action->users) > 6){
                                                            ?>
                                                            <li><strong><?= $action->total_action?> kişi daha..</strong></li>
                                                            <?php } ?>
                                                         </ul>
                                                      </div>
                                                      <?php } ?>
                                                   </li>
                                                      <?php } ?>
                                                </ul>
                                                <span class="block"><?= $action_count?></span>
                                                <?php }else { ?>
                                                   <ul class="flex"></ul>
                                                   <span class="block">0</span>
                                                <?php } ?>
                                             </div>
                                          </li>
                                          <li class="relative">
                                             <?php 
                                                if(!empty($comments->action)){
                                             ?>
                                              <button class="flex items-center active delete-action focus:outline-none" data-id="<?= $post_action_id?>" data-type="flow" data-act="<?= $action_id?>" data-action-id="<?= $action_id?>" data-post="1">  <img class="lazy" width="22" height="22" data-src="<?= base_url("uploads/reaction/original/$action_image")?>" alt="<?= $action_title?>">
                                                <span class="sm:block"><?= $action_title?></span>
                                              </button>
                                             <?php } else { ?>
                                              <button class="flex items-center <?= LOGIN ? 'reaction-button' : null ?> focus:outline-none" <?= login_check()?>> <span class="sm:block">Beğen</span></button>
                                             <?php } ?>
                                             <div class="reactions-drop absolute">
                                                <ul class="flex">
                                                   <?php 
                                                      if(!empty($actions)){
                                                         foreach($actions as $action){
                                                   ?>
                                                   <li>
                                                      <button class="flex items-center relative focus:outline-none set-action" data-post="1" data-type="flow" data-id="<?= $comments->flow_post_id ?>" data-action="<?= $action->action_id?>">
                                                         <img src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                                         <div class="tooltip absolute"><small class="flex items-center"><?= $action->title?></small></div>
                                                      </button>
                                                   </li>
                                                   <?php } } ?>
                                                </ul>
                                             </div>
                                          </li>
                                          <li><span class="block"><?= zaman($comments->created_at)?></span></li>
                                          <?php 
                                             if(LOGIN  || $this->user_id == $comments->user_id || ADMIN){
                                          ?>
                                          <li>
                                             <div class="options-drop relative">
                                                <button class="flex focus:outline-none">
                                                   <svg viewBox="0 0 22 6">
                                                      <path d="M19,6c-1.657,0-3-1.344-3-3c0-1.656,1.343-3,3-3s3,1.344,3,3C22,4.656,20.657,6,19,6z M19,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C20,2.447,19.552,2,19,2z M11,6C9.343,6,8,4.656,8,3c0-1.656,1.343-3,3-3s3,1.344,3,3C14,4.656,12.657,6,11,6z M11,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C12,2.447,11.552,2,11,2z M3,6C1.343,6,0,4.656,0,3c0-1.656,1.343-3,3-3c1.656,0,3,1.344,3,3C6,4.656,4.656,6,3,6z M3,2C2.447,2,2,2.447,2,3c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C4,2.447,3.552,2,3,2z"></path>
                                                   </svg>
                                                </button>
                                                
                                                <div class="options-drop-content absolute">
                                                   <ul>
                                                      <li><a class="block second" href="javascript:void(0);" data-type="flow" data-delete-post="<?= $comments->flow_post_id?>">Yorumu Sil</a></li>
                                                   </ul>
                                                </div>
                                             </div>
                                          </li>
                                                <?php } ?>

                                       </ul>
                                    </div>
                                 </div>
                              </div>
                              <?php } } ?>
                           </li>
                           <?php } ?>
                        </ul>
                        <?php }else {?>
                           <ul></ul>
                        <?php } ?>
                        <?php 
                           if($posts->comment_count > $this->groupPostComment && !$hash){
                        ?>
                        <div class="post-comment-more"><button class="text-center focus:outline-none get-comment-load" data-group_id="" data-page="1" data-post_id="<?= $posts->flow_post_id?>">Daha Fazla Yorum Göster <strong><data><?= $posts->comment_count - 5?></data>+</strong></button></div>
                        <?php } ?>
                        <?php 
                           if(LOGIN){
                        ?>
                        <div class="post-comment-write flex items-center comments-write ">
                           <div class="user-medium flex items-center">
                              <div class="user-medium-image flex-shrink-0 flex-shrink-0"><a class="block" href="<?= base_url("profil/{$this->user->u_username}")?>"><img class="lazy" data-src="<?= base_url("uploads/users/{$this->user->u_avatar}")?>" alt="<?= $this->user->u_name?>"></a></div>
                           </div>
                           <div class="form-group w-full relative flex items-center" method="post" name="">
                              <div class="form-element w-full relative"><input type="text" class="addComment" name="addComment" autocomplete="off" required><label class="block absolute" for="addComment">Yorumun</label>
                              </div>
                              <button class="absolute focus:outline-none reply-post-comment"  data-group="" data-id="<?= $posts->flow_post_id ?>">Paylaş</button>
                           </div>
                        </div>
                        <?php } ?>
                     </div>
                  </div>
               </li>
               <?php } }else {
                  echo '<li>'.alert('danger','Listelenecek gönderi bulunamadı.').'</li>';
               } ?>
            </ul>
            <?php 
               if($flowCount > $this->flowPostLimit && !$hash ){
            ?>
           
             <div class="see-more">
               <button class="relative focus:outline-none see-more-flow" data-page="1" >
                  Daha Fazla Göster
               </button>
            </div>
            <?php } ?>
         </div>
      </div>
      <div class="flow-right w-full xl:w-1/3">
         <div class="widget-box">
            <div class="widget-box-head flex items-center justify-between">
               <span class="block">Öne Çıkan Üyeler</span>
            </div>
            <div class="widget-box-content">
               <div class="widget-box-nav">
                  <ul class="flex" data-tab="member">
                     <li class="tab-active"><a class="block" href="javascript:void(0);">Yeni</a></li>
                     <li><a class="block" href="javascript:void(0);">Popüler</a></li>
                     <li><a class="block" href="javascript:void(0);">Aktif</a></li>
                  </ul>
               </div>
               <div class="widget-box-tabs" id="member">
                  <div class="widget-box-tab tab-content tab-active">
                     <div class="widget-box-list">
                        <ul>
                           <?php
                              if(!empty($users->new)){
                                 foreach($users->new as $new){
                           ?>
                           <li>
                              <div class="requests-box flex items-center justify-between">
                                 <div class="user-medium flex items-center">
                                    <div class="user-medium-image"><a class="block" href="<?= base_url("profil/$new->u_username")?>"><img class="lazy" data-src="<?= base_url("uploads/users/$new->u_avatar")?>" alt="<?= $new->u_name?>"></a></div>
                                    <div class="user-medium-text">
                                       <span class="block"><a class="block" href="<?= base_url("profil/$new->u_username")?>"><?= $new->u_name?></a></span>
                                       <?= !empty($new->mutual) ? "<p>$new->mutual ortak arkadaş</p>" : '<p>Ortak arkadaş yok</p>'?>
                                    </div>
                                 </div>
                            
                              </div>
                           </li>
                           <?php } } ?>
                        </ul>
                     </div>
                  </div>
                  <div class="widget-box-tab tab-content">
                     <div class="widget-box-list">
                        <ul>
                           <?php
                              if(!empty($users->popular)){
                                 foreach($users->popular as $new){
                           ?>
                           <li>
                              <div class="requests-box flex items-center justify-between">
                                 <div class="user-medium flex items-center">
                                    <div class="user-medium-image"><a class="block" href="<?= base_url("profil/$new->u_username")?>"><img class="lazy" data-src="<?= base_url("uploads/users/$new->u_avatar")?>" alt="<?= $new->u_name?>"></a></div>
                                    <div class="user-medium-text">
                                       <span class="block"><a class="block" href="<?= base_url("profil/$new->u_username")?>"><?= $new->u_name?></a></span>
                                       <?= !empty($new->mutual) ? "<p>$new->mutual ortak arkadaş</p>" : '<p>Ortak arkadaş yok</p>'?>
                                    </div>
                                 </div>
                                 
                              </div>
                           </li>
                           <?php } } ?>
                        </ul>
                     </div>
                  </div>
                  <div class="widget-box-tab tab-content">
                     <div class="widget-box-list">
                        <ul>
                           <?php
                              if(!empty($users->active)){
                                 foreach($users->active as $new){
                           ?>
                           <li>
                              <div class="requests-box flex items-center justify-between">
                                 <div class="user-medium flex items-center">
                                    <div class="user-medium-image"><a class="block" href="<?= base_url("profil/$new->u_username")?>"><img class="lazy" data-src="<?= base_url("uploads/users/$new->u_avatar")?>" alt="<?= $new->u_name?>"></a></div>
                                    <div class="user-medium-text">
                                       <span class="block"><a class="block" href="<?= base_url("profil/$new->u_username")?>"><?= $new->u_name?></a></span>
                                       <?= !empty($new->mutual) ? "<p>$new->mutual ortak arkadaş</p>" : '<p>Ortak arkadaş yok</p>'?>
                                    </div>
                                 </div>
                              
                              </div>
                           </li>
                           <?php } } ?>
                        </ul>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php 
            if(!empty($groups)){
         ?>
         <div class="widget-box">
            <div class="widget-box-head flex items-center justify-between">
               <span class="block">Öne Çıkan Gruplar</span>
            </div>
            <div class="widget-box-content">
               <div class="widget-box-nav">
                  <ul class="flex" data-tab="group">
                     <li class="tab-active"><a class="block" href="javascript:void(0);">Yeni</a></li>
                  </ul>
               </div>
               <div class="widget-box-tabs" id="group">
                  <div class="widget-box-tab tab-content tab-active">
                     <div class="widget-box-list">
                        
                        <ul>
                           <?php
                              foreach($groups as $group){
                           ?>
                           <li>
                              <div class="requests-box flex items-center justify-between">
                                 <div class="user-medium flex items-center">
                                    <div class="user-medium-image"><a class="block" href="<?= base_url("grup/$group->alias")?>"><img class="lazy" data-src="<?= base_url("uploads/group/original/$group->poster")?>" alt="<?= $group->title?>"></a></div>
                                    <div class="user-medium-text">
                                       <span class="block"><a class="block" href="<?= base_url("grup/$group->alias")?>"><?= $group->title?></a></span>
                                       <p><?= $group->user_count?> Üye</p>
                                    </div>
                                 </div>
                                 <?php 
                                    if(LOGIN){
                                 ?>
                                 <div class="requests-box-actions">
                                    <ul class="flex">
                                       <li>
                                          <?php 
                                             if(!$group->check_in){
                                          ?>
                                          <button class="button-third accept-friend flex items-center justify-center focus:outline-none set-group-request" data-id="<?= $group->group_id?>">
                                             <?php 
                                                   if(!$group->check_in_request){
                                                ?>
                                                <svg viewBox="0 0 20 20">
                                                   <path d="M10,9.999c2.762,0,5-2.238,5-5s-2.238-5-5-5s-5,2.238-5,5S7.238,9.999,10,9.999z M10,1.999c1.654,0,3,1.346,3,3s-1.346,3-3,3s-3-1.346-3-3S8.346,1.999,10,1.999z M20,3.949v-2c-2.236,0-4.05,1.813-4.05,4.05c0,2.236,1.813,4.05,4.05,4.05v-2c-1.13,0-2.05-0.92-2.05-2.05C17.95,4.869,18.87,3.949,20,3.949z M4.05,5.999C4.05,3.762,2,1.949,0,1.949v2c1,0,2.05,0.919,2.05,2.05c0,1.13-1.05,2.05-2.05,2.05v2C2,10.049,4.05,8.235,4.05,5.999zM11,13.999H9v2H7v2h2v2h2v-2h2v-2h-2V13.999z M7,11.999c-3.313,0-6,2.687-6,6v2h2v-2c0-2.205,1.794-4,4-4V11.999z M13,11.999v2c2.206,0,4,1.795,4,4v2h2v-2C19,14.686,16.313,11.999,13,11.999z"></path>
                                                </svg>
                                                <?php }else { ?>
                                                   <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                                     <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />  
                                                   </svg> 
                                                <?php } ?>
                                          </button>
                                          <?php }else { ?>
                                             <button class="button-third accept-friend flex items-center justify-center focus:outline-none" onclick="window.location.href='<?= base_url("grup/$group->alias")?>'">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                                  <path fill-rule="evenodd" d="M6.672 1.911a1 1 0 10-1.932.518l.259.966a1 1 0 001.932-.518l-.26-.966zM2.429 4.74a1 1 0 10-.517 1.932l.966.259a1 1 0 00.517-1.932l-.966-.26zm8.814-.569a1 1 0 00-1.415-1.414l-.707.707a1 1 0 101.415 1.415l.707-.708zm-7.071 7.072l.707-.707A1 1 0 003.465 9.12l-.708.707a1 1 0 001.415 1.415zm3.2-5.171a1 1 0 00-1.3 1.3l4 10a1 1 0 001.823.075l1.38-2.759 3.018 3.02a1 1 0 001.414-1.415l-3.019-3.02 2.76-1.379a1 1 0 00-.076-1.822l-10-4z" clip-rule="evenodd" />
                                                </svg>
                                             </button>
                                          <?php } ?>
                                       </li>
                                    </ul>
                                 </div>
                              <?php } ?>
                              </div>
                           </li>
                           <?php } ?>
                        </ul>
                     
                     </div>
                  </div>
               </div>
            </div>
         </div>
      <?php } ?>
      </div>
   </div>
</div>
<div class="modal modal-small share-modal fixed flex flex-col items-center justify-center" data-modal="">
   <div class="modal-body relative overflow-y-auto">
      <div class="modal-header flex items-center justify-between sticky z-50">
         <span class="block">Paylaş</span>
         <button class="flex items-center justify-center focus:outline-none" data-close="">
            <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
               <line x1="18" y1="6" x2="6" y2="18"></line>
               <line x1="6" y1="6" x2="18" y2="18"></line>
            </svg>
         </button>
      </div>
      <div class="modal-content">
         <div class="social-share">
            <ul class="flex flex-wrap">
               <li class="w-1/2 sm:w-1/3">
                  <a class="flex flex-col items-center facebook-share" 
                  href="https://www.facebook.com/sharer/sharer.php?u=&t=" 
                  onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600');return false;"
                  target="_blank" title="Facebook'da Paylaş"
                  >
                     <span class="flex items-center justify-center facebook">
                        <svg viewBox="0 0 18 18">
                           <path d="M16.313,18h-4.504v-6.192h3.087V8.671h-3.087V7.135V6.831V6.814l0,0c0.01-0.328,0.277-0.591,0.607-0.591h0.067h1.113h1.62V3.086h-2.733l0,0l-0.009,0.018h-0.092c-2.051,0-3.712,1.661-3.712,3.711v0.911v0.945H6.191v3.137h2.479V18H1.687C0.755,18,0,17.242,0,16.313V1.686C0,0.754,0.755,0,1.687,0h14.626C17.244,0,18,0.754,18,1.686v14.627C18,17.242,17.244,18,16.313,18z"></path>
                        </svg>
                     </span>
                     Facebook
                  </a>
               </li>
               <li class="w-1/2 sm:w-1/3">
                  <a class="flex flex-col items-center twitter-share" 
                  href="https://twitter.com/intent/tweet?url=&text=&hashtags=filmizle,diziizle" 
                  onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600');return false;"
                  target="_blank" title="Twitter'da Paylaş"
                  >
                     <span class="flex items-center justify-center twitter">
                        <svg viewBox="0 0 18 18">
                           <path d="M18,3.617c-0.675,0.322-1.351,0.43-2.139,0.537c0.788-0.43,1.351-1.076,1.576-1.937c-0.675,0.43-1.463,0.646-2.362,0.861C14.399,2.431,13.388,2,12.375,2c-1.912,0-3.601,1.617-3.601,3.554c0,0.323,0,0.538,0.113,0.754C5.851,6.2,3.038,4.8,1.238,2.646C0.9,3.185,0.788,3.724,0.788,4.478c0,1.184,0.675,2.261,1.688,2.907c-0.563,0-1.125-0.216-1.688-0.431l0,0c0,1.723,1.237,3.122,2.925,3.446c-0.338,0.107-0.675,0.107-1.013,0.107c-0.225,0-0.45,0-0.675-0.107c0.45,1.399,1.8,2.476,3.487,2.476C4.274,13.846,2.7,14.384,0.9,14.384c-0.338,0-0.563,0-0.9,0C1.688,15.354,3.601,16,5.625,16c6.75,0,10.462-5.385,10.462-10.015c0-0.108,0-0.323,0-0.431C16.875,5.016,17.549,4.371,18,3.617z"></path>
                        </svg>
                     </span>
                     Twitter
                  </a>
               </li>
               <li class="w-1/2 sm:w-1/3">
                  <a class="flex flex-col items-center whatsapp-share"
                  data-action="share/whatsapp/share"
                  href="https://web.whatsapp.com/send?text=" 
                  target="_blank" title="WhatsApp'da Paylaş"
                  >
                     <span class="flex items-center justify-center whatsapp">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                           <path d="M260.062 32C138.605 32 40.134 129.701 40.134 250.232c0 41.23 11.532 79.79 31.559 112.687L32 480l121.764-38.682c31.508 17.285 67.745 27.146 106.298 27.146C381.535 468.464 480 370.749 480 250.232 480 129.701 381.535 32 260.062 32zm109.362 301.11c-5.174 12.827-28.574 24.533-38.899 25.072-10.314.547-10.608 7.994-66.84-16.434-56.225-24.434-90.052-83.844-92.719-87.67-2.669-3.812-21.78-31.047-20.749-58.455 1.038-27.413 16.047-40.346 21.404-45.725 5.351-5.387 11.486-6.352 15.232-6.413 4.428-.072 7.296-.132 10.573-.011 3.274.124 8.192-.685 12.45 10.639 4.256 11.323 14.443 39.153 15.746 41.989 1.302 2.839 2.108 6.126.102 9.771-2.012 3.653-3.042 5.935-5.961 9.083-2.935 3.148-6.174 7.042-8.792 9.449-2.92 2.665-5.97 5.572-2.9 11.269 3.068 5.693 13.653 24.356 29.779 39.736 20.725 19.771 38.598 26.329 44.098 29.317 5.515 3.004 8.806 2.67 12.226-.929 3.404-3.599 14.639-15.746 18.596-21.169 3.955-5.438 7.661-4.373 12.742-2.329 5.078 2.052 32.157 16.556 37.673 19.551 5.51 2.989 9.193 4.529 10.51 6.9 1.317 2.38.901 13.531-4.271 26.359z"></path>
                        </svg>
                     </span>
                     WhatsApp
                  </a>
               </li>
            </ul>
            <div class="form-group">
               <div class="form-element relative">
                  <input class="linkToCopy" type="text" value="<?= base_url(uri_string())?>" id="pageUrl" name="pageUrl" autocomplete="off" required=""><label class="block absolute" for="pageUrl">Sayfa Bağlantısı</label>
                  <div class="form-element-end-icon absolute">
                     <button class="flex copyButton focus:outline-none">
                        <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                           <rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect>
                           <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path>
                        </svg>
                     </button>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>

