<?php 
   $interval = time() - strtotime($poll_values->end_date);
   if($interval >= 86400){
      $info = "Anket sonuçlandı.";
   }else {
      $time = 24 - (round($interval/3600));
      $info = "Bu anket $time saat sonra sonuçlanacak.";
   }
?>
<div class="poll-box">
   <div class="poll-header">
      <span class="block"><?= $poll_values->title ?></span>
      <p><?= $info?></p>
   </div>
   <div class="poll-content">
      <div class="poll-vote">
         <ul>
            <?php 
               foreach($poll_values->values as $value){
            ?>
            <li>
               <div class="checkbox">
                  <label class="flex items-center">
                     <input type="radio" <?= $poll_values->check_vote == $value->flow_post_poll_id ? 'checked' : null ?> <?= $poll_values->check_vote ? 'disabled' : null ?> name="answer-<?= $value->flow_poll_id?>" value="<?= $value->flow_post_poll_id?>">
                     <span class="checkbox-icon block relative"></span>
                     <span class="checkbox-text block"><?= $value->answer?></span>
                  </label>
               </div>
            </li>
            <?php } ?>
          
         </ul>
      </div>
      <?php 
         if(!empty($poll_values->vote_result)){
      ?>
      <div class="poll-result hidden">
         <ul>
            <?php
               foreach($poll_values->vote_result as $vote){
                  $percent = 0;
                  if($vote->vote_count && $vote->total){
                     $percent = yuzde($vote->total,$vote->vote_count);
                  }
            ?>
            <li>
               <div class="progress">
                  <div class="progress-top flex items-center justify-between"><span class="block"><?= $vote->answer?></span><span class="block">%<?=$percent?></span></div>
                  <div class="progress-area relative">
                     <div class="progress-bar absolute" style="width:<?= $percent?>%"></div>
                  </div>
                 
                  <div class="progress-bottom">
                     <div class="your-friends flex items-center">
                        <?php 
                           if(!empty($vote->users)){
                        ?>
                        <ul class="flex">
                           <?php 
                              foreach($vote->users as $user){
                           ?>
                           <li><a class="block" href="<?= base_url("profil/$user->u_username")?>"> <img src="<?= base_url("uploads/users/$user->u_avatar")?>" alt="<?= $user->u_name?>"></a></li>
                           <?php } ?>
                        </ul>
                        <?php } ?>

                        <button class="focus:outline-none"><?= $vote->vote_count?> Oy</button>
                     </div>
                  </div>
               </div>
            </li>
            <?php } ?>
         </ul>
      </div>
         <?php } ?>
   </div>
   <?php 
      if(LOGIN){
   ?>
   <div class="poll-footer">
      <div class="form-group flex flex-wrap">
         <?php 
            if(!empty($poll_values->check_vote)){
         ?>
         <div class="form-element relative w-full sm:w-auto"><button class="button-third w-full focus:outline-none" type="submit">Sonuçları Görüntüle</button></div>
         <?php } else { ?>
            <div class="form-element relative w-full sm:w-auto">
               <button class="button-second w-full focus:outline-none set-vote" data-poll-id="<?= $poll_values->flow_poll_id?>" data-post-id="<?= $flow_post_id?>" data-id="">Oy Ver</button>
            </div>
         <?php } ?>

      </div>
   </div>
   <?php } ?>
</div>
