<div class="group-profile" data-group-admin="<?= $column?>">
   <div class="group-profile-top">
      <div class="group-profile-cover relative"><img class="lazy" data-src="<?= base_url("uploads/group/cover/original/$group->cover")?>" alt="<?= $group->title?>"></div>
      <div class="group-profile-info flex relative flex-col xl:flex-row xl:justify-between items-center">
         <div class="group-profile-info-left flex items-center">
            <div class="group-profile-avatar absolute"><img class="lazy" data-src="<?= base_url("uploads/group/original/$group->poster") ?>" alt="<?= $group->title?>"></div>
            <div class="group-profile-name text-center xl:text-left">
               <h1><?= $group->title?></h1>
               <p><?= $group->info ?></p>
            </div>
         </div>
         <div class="group-profile-info-right flex items-center flex-col xl:flex-row">
            <ul class="flex items-center">
               <li>
                  <div class="group-profile-visibility">
                     <span class="flex items-center flex-col sm:flex-row">
                        <?php 
                           if($group->privacy){
                        ?>
                        <svg viewBox="0 0 20 20"><path d="M11,11H9c-0.553,0-1,0.447-1,1s0.447,1,1,1v1c0,0.553,0.447,1,1,1s1-0.447,1-1v-1c0.553,0,1-0.447,1-1S11.553,11,11,11z"></path><path d="M16,6.142V6c0-3.313-2.687-6-6-6S4,2.687,4,6v0.142C2.278,6.588,1,8.139,1,10v6c0,2.209,1.791,4,4,4h10c2.209,0,4-1.791,4-4v-6C19,8.139,17.722,6.588,16,6.142z M10,2c2.206,0,4,1.794,4,4H6C6,3.794,7.794,2,10,2z M17,16c0,1.103-0.897,2-2,2H5c-1.103,0-2-0.897-2-2v-6c0-1.103,0.897-2,2-2h10c1.103,0,2,0.897,2,2V16z"></path></svg>
                        Gizli Grup
                     <?php }else { ?>
                        <svg viewBox="0 0 20 20">
                           <path d="M20,10c0-5.522-4.478-10-10-10C4.477,0,0,4.478,0,10c0,5.523,4.477,10,10,10                          c1.566,0,3.043-0.37,4.362-1.013l0.01,0.018c0.051-0.028,0.086-0.059,0.135-0.087C17.763,17.27,20,13.9,20,10z M16.155,15.108c-0.648-1.745-2.802-3.14-4.653-3.408c-0.751-0.109-0.829-0.433-0.858-0.555C10.497,10.532,11,9.499,11.679,9.021c1.482-1.044,4.529-0.504,6.252-0.025C17.972,9.325,18,9.659,18,10C18,11.942,17.307,13.723,16.155,15.108z M14.715,3.547c-0.012,0-0.022,0.003-0.034,0.003c-1.374,0-2.609-0.561-3.518-1.456C12.479,2.286,13.688,2.796,14.715,3.547z M2,10                          c0-2.277,0.956-4.328,2.483-5.785c1.26,0.272,2.644,0.845,2.87,1.36C7.373,5.62,7.425,5.74,7.222,6.051c-0.295,0.451-0.603,0.88-0.896,1.29c-1.389,1.937-2.963,4.131-0.647,6.169c0.537,0.472,0.805,1.243,0.624,1.793c-0.184,0.557-0.815,0.773-1.402,0.86C3.128,14.695,2,12.479,2,10z M7.065,17.437c0.671-0.479,0.993-1.077,1.135-1.507c0.432-1.308-0.063-2.92-1.201-3.922c-0.814-0.716-0.672-1.24,0.951-3.502c0.31-0.432,0.633-0.883,0.944-1.359c0.66-1.009,0.521-1.85,0.289-2.377c-0.428-0.972-1.522-1.606-2.57-2.01C7.251,2.46,7.934,2.244,8.65,2.122c1.236,2.047,3.469,3.428,6.03,3.428c0.618,0,1.206-0.106,1.776-0.259c0.339,0.463,0.631,0.961,0.865,1.492c-1.979-0.428-4.906-0.729-6.795,0.603c-1.195,0.84-2.204,2.651-1.828,4.224c0.268,1.122,1.185,1.876,2.516,2.068c1.409,0.205,2.963,1.352,3.137,2.314c0.028,0.156,0.1,0.618-0.781,1.158C12.495,17.689,11.285,18,10,18C8.963,18,7.975,17.796,7.065,17.437z"></path>
                        </svg>
                        Açık Grup
                     <?php } ?>
                     </span>
                  </div>
               </li>
               <li class="relative text-center">
                  <span class="block"><?= $group->user_count?></span>
                  <p>Üye</p>
               </li>
               <li class="relative text-center">
                  <span class="block"><?= $group->post_count?></span>
                  <p>Gönderi</p>
               </li>
            </ul>
            <div class="group-profile-info-right-buttons">
               <div class="form-group flex">
                  <div class="form-element">
                  <?php
                     if($president){

                     }else {
                  ?>
                  <?php 
                     if(!$inside){
                  ?>
                     <?php 
                        if(!$checkRequest){
                     ?>
                     <button class="button-second flex items-center justify-center focus:outline-none set-group-request" data-id="<?= $group->group_id?>">
                        <svg viewBox="0 0 20 20">
                           <path d="M10,9.999c2.762,0,5-2.238,5-5s-2.238-5-5-5s-5,2.238-5,5S7.238,9.999,10,9.999z M10,1.999c1.654,0,3,1.346,3,3s-1.346,3-3,3s-3-1.346-3-3S8.346,1.999,10,1.999z M20,3.949v-2c-2.236,0-4.05,1.813-4.05,4.05c0,2.236,1.813,4.05,4.05,4.05v-2c-1.13,0-2.05-0.92-2.05-2.05C17.95,4.869,18.87,3.949,20,3.949z M4.05,5.999C4.05,3.762,2,1.949,0,1.949v2c1,0,2.05,0.919,2.05,2.05c0,1.13-1.05,2.05-2.05,2.05v2C2,10.049,4.05,8.235,4.05,5.999zM11,13.999H9v2H7v2h2v2h2v-2h2v-2h-2V13.999z M7,11.999c-3.313,0-6,2.687-6,6v2h2v-2c0-2.205,1.794-4,4-4V11.999z M13,11.999v2c2.206,0,4,1.795,4,4v2h2v-2C19,14.686,16.313,11.999,13,11.999z"></path>
                        </svg>
                     </button>
                     <?php }else { ?>
                        <button class="button-second flex items-center justify-center focus:outline-none set-group-request" data-id="<?= $group->group_id?>">
                       <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"></path>  
                              </svg>
                        </button>
                     <?php } ?>
                  <?php } else { ?>
                     <button class="button-second flex items-center justify-center focus:outline-none leave-group" data-id="<?= $group->group_id?>">
                       <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="8.5" cy="7" r="4"></circle><line x1="23" y1="11" x2="17" y2="11"></line></svg>
                     </button>
                  <?php } ?>
                  <?php } ?>
                  </div>
                    <?php 
                     if($president){
                    ?>
                  <div class="form-element">
                     <button class="button-third flex items-center justify-center focus:outline-none" data-target=".group-edit-modal">
                        <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                           <circle cx="12" cy="12" r="1"></circle>
                           <circle cx="19" cy="12" r="1"></circle>
                           <circle cx="5" cy="12" r="1"></circle>
                        </svg>
                     </button>
                  </div>
                  <?php } ?>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="group-profile-nav relative">
      <div class="group-profile-nav-slide navigation-slide swiper">
         <ul class="swiper-wrapper">
            <li class="swiper-slide relative <?= !$navigator ? 'active' : null ?>">
               <a class="flex flex-col items-center" <?= navigo()?> href="<?= base_url("grup/$group->alias")?>">
                  <svg viewBox="0 0 20 20">
                     <path d="M16,0H4C1.791,0,0,1.791,0,4v12c0,2.209,1.791,4,4,4h12c2.209,0,4-1.791,4-4V4C20,1.791,18.209,0,16,0zM18,16c0,1.103-0.897,2-2,2H4c-1.103,0-2-0.897-2-2V4c0-1.103,0.897-2,2-2h12c1.103,0,2,0.897,2,2V16z"></path>
                     <polygon points="18,5 2,5 2,7 5,7 5,20 7,20 7,7 13,7 13,20 15,20 15,7 18,7"></polygon>
                  </svg>
                  <span class="block absolute">Akış</span>
               </a>
            </li>
            <li class="swiper-slide relative <?=  $navigator == 'hakkinda'  ? 'active' : null ?>">
               <a class="flex flex-col items-center" <?= navigo()?> href="<?= base_url("grup/$group->alias/hakkinda")?>">
                  <svg viewBox="0 0 20 20">
                     <path d="M9,15h2V9H9V15z M9,7h2V5H9V7z M16-0.001H4c-2.209,0-4,1.791-4,4v12c0,2.209,1.791,4,4,4h12c2.209,0,4-1.791,4-4v-12C20,1.79,18.209-0.001,16-0.001z M18,15.999C18,17.102,17.103,18,16,18H4c-1.103,0-2-0.898-2-2.001v-12c0-1.103,0.897-2,2-2h12c1.103,0,2,0.897,2,2V15.999z"></path>
                  </svg>
                  <span class="block absolute">Hakkında</span>
               </a>
            </li>
            <li class="swiper-slide relative <?= $navigator == 'uyeler' ? 'active' : null ?>">
               <a class="flex flex-col items-center" <?= navigo()?> href="<?= base_url("grup/$group->alias/uyeler")?>">
                  <svg viewBox="0 0 20 20">
                     <path d="M10,10c2.762,0,5-2.238,5-5c0-2.762-2.238-5-5-5S5,2.238,5,5C5,7.761,7.238,10,10,10z M10,2c1.654,0,3,1.346,3,3s-1.346,3-3,3S7,6.654,7,5S8.346,2,10,2z M13,12H7c-3.313,0-6,2.686-6,6v2h2v-2c0-2.205,1.794-4,4-4h6c2.206,0,4,1.795,4,4v2h2v-2C19,14.686,16.313,12,13,12z"></path>
                  </svg>
                  <span class="block absolute">Üyeler</span>
               </a>
            </li>
            <?php 
               if($president){
            ?>
            <li class="swiper-slide relative <?= $navigator == 'istekler' ? 'active' : null ?>">
               <a class="flex flex-col items-center" <?= navigo()?> href="<?= base_url("grup/$group->alias/istekler")?>">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                    <path d="M13 6a3 3 0 11-6 0 3 3 0 016 0zM18 8a2 2 0 11-4 0 2 2 0 014 0zM14 15a4 4 0 00-8 0v3h8v-3zM6 8a2 2 0 11-4 0 2 2 0 014 0zM16 18v-3a5.972 5.972 0 00-.75-2.906A3.005 3.005 0 0119 15v3h-3zM4.75 12.094A5.973 5.973 0 004 15v3H1v-3a3 3 0 013.75-2.906z" />
                  </svg>
                  <span class="block absolute">İstekler</span>
               </a>
            </li>
            <?php } ?>
         </ul>
         <div class="square-arrows">
            <button class="group-profile-nav-prev left absolute flex items-center justify-center focus:outline-none">
               <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="3" fill="none" stroke-linecap="round" stroke-linejoin="round">
                  <polyline points="15 18 9 12 15 6"></polyline>
               </svg>
            </button>
            <button class="group-profile-nav-next right absolute flex items-center justify-center focus:outline-none">
               <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="3" fill="none" stroke-linecap="round" stroke-linejoin="round">
                  <polyline points="9 18 15 12 9 6"></polyline>
               </svg>
            </button>
         </div>
      </div>
   </div>
   
   <?= $content ?>
  
</div>
<?php 
   if($group->user_id == $this->user_id){
?>
<div class="organized-modal group-edit-modal fixed flex flex-col items-center md:justify-center z-50" data-modal>
   <div class="organized-modal-body md:flex relative">
      <div class="organized-modal-close absolute z-20" data-close>
         <button class="flex items-center justify-center focus:outline-none">
            <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
               <line x1="18" y1="6" x2="6" y2="18"></line>
               <line x1="6" y1="6" x2="18" y2="18"></line>
            </svg>
         </button>
      </div>
      <div class="organized-modal-sidebar w-full md:w-1/3">
         <div class="organized-modal-sidebar-profile">
            <div class="organized-modal-sidebar-profile-cover"><img src="<?= base_url("uploads/group/cover/original/$group->cover")?>" alt="<?= $group->title?>"></div>
            <div class="organized-modal-sidebar-profile-content flex flex-col items-center">
               <img class="lazy" data-src="<?= base_url("uploads/group/original/$group->poster")?>" alt=""><span class="block"><?= $group->title?></span>
               <p>Grup Yöneticisi</p>
            </div>
         </div>
         <div class="organized-modal-sidebar-menu">
            <ul data-tab="group-management">
               <li class="tab-active"><a class="block" href="javascript:void(0);">Bilgiler</a></li>
               <li><a class="block" href="javascript:void(0);">Resimler</a></li>
               <li><a class="block" href="javascript:void(0);">Sosyal Bağlantılar</a></li>
               <li><a class="block" href="javascript:void(0);">Üyeler</a></li>
               <li><a class="block" href="javascript:void(0);">Ayarlar</a></li>
            </ul>
            <button class="focus:outline-none remove-group" data-group="<?= $group->group_id?>"><a class="block" href="javascript:void(0);">Grubu Sil</a></button>
         </div>
         <div class="organized-modal-sidebar-buttons absolute md:static w-full md:w-auto">
            <div class="form-group">
               <div class="form-element relative"><button class="button-second focus:outline-none update-group" type="submit" data-id="<?= $group->group_id?>">Değişiklikleri Kaydet</button></div>
               <div class="form-element relative"><button data-close class="button-third focus:outline-none" type="reset">İptal Et</button></div>
            </div>
         </div>
      </div>
      <div class="organized-modal-content w-full md:w-2/3" id="group-management">
         <div class="organized-modal-content-box tab-content tab-active">
            <div class="organized-modal-content-head sticky z-10"><span class="block">Grup Bilgileri</span></div>
            <div class="organized-modal-content-in">
               <form class="form-group" method="post" name="">
                  <div class="form-element relative"><input type="text" value="<?= $group->title?>" class="groupName" name="groupName" autocomplete="off" required><label class="block absolute" for="groupName">Adı</label></div>
                  <div class="form-element relative"><input type="text" value="<?= $group->info?>" class="groupTagline" name="groupTagline" autocomplete="off" required><label class="block absolute" for="groupTagline">Slogan</label></div>
                  <div class="form-element relative"><textarea class="groupDesc" name="groupDesc" data-autoresize autocomplete="off" required><?= $group->description?></textarea><label class="block absolute" for="groupDesc">Açıklama</label></div>
               </form>
            </div>
         </div>
         <div class="organized-modal-content-box tab-content">
            <div class="organized-modal-content-head sticky z-10"><span class="block">Grup Resimleri</span></div>
            <div class="organized-modal-content-in">
               <div class="upload-area">
                  <div class="upload-cover">
                     <label class="block relative">
                        <input type="file" class="coverUpload" data-upload-area accept=".png, .jpg, .jpeg">
                        <div class="upload-cover-preview" data-preview-area><img class="lazy" data-src="<?= base_url("uploads/group/cover/original/$group->cover")?>" alt="<?=$group->title?>"></div>
                        <div class="upload-icon absolute">
                           <button class="flex items-center justify-center focus:outline-none">
                              <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                 <path d="M17 3a2.828 2.828 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5L17 3z"></path>
                              </svg>
                           </button>
                        </div>
                     </label>
                  </div>
                  <div class="upload-content flex flex-col items-center">
                     <div class="upload-avatar relative">
                        <label class="block relative">
                           <input type="file" class="avatarUpload" data-upload-area accept=".png, .jpg, .jpeg">
                           <div class="upload-avatar-preview" data-preview-area><img class="lazy" data-src="<?= base_url("uploads/group/original/$group->poster")?>" alt=""></div>
                           <div class="upload-icon absolute">
                              <button class="flex items-center justify-center focus:outline-none">
                                 <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M17 3a2.828 2.828 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5L17 3z"></path>
                                 </svg>
                              </button>
                           </div>
                        </label>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="organized-modal-content-box tab-content">
            <div class="organized-modal-content-head sticky z-10"><span class="block">Grup Sosyal Bağlantıları</span></div>
            <div class="organized-modal-content-in">
               <form class="form-group flex flex-wrap" method="post" name="">
                  <div class="form-element relative w-full">
                     <div class="form-element-icon social-icon facebook absolute">
                        <span class="flex items-center justify-center">
                           <svg viewBox="0 0 18 18">
                              <path d="M16.313,18h-4.504v-6.192h3.087V8.671h-3.087V7.135V6.831V6.814l0,0c0.01-0.328,0.277-0.591,0.607-0.591h0.067h1.113h1.62V3.086h-2.733l0,0l-0.009,0.018h-0.092c-2.051,0-3.712,1.661-3.712,3.711v0.911v0.945H6.191v3.137h2.479V18H1.687C0.755,18,0,17.242,0,16.313V1.686C0,0.754,0.755,0,1.687,0h14.626C17.244,0,18,0.754,18,1.686v14.627C18,17.242,17.244,18,16.313,18z"></path>
                           </svg>
                        </span>
                     </div>
                     <input type="text" class="fbUsername" name="fbUsername" value="<?= $social->facebook?>" autocomplete="off" required><label class="block absolute" for="fbUsername">Facebook Kullanıcı Adı</label>
                  </div>
                  <div class="form-element relative w-full">
                     <div class="form-element-icon social-icon twitter absolute">
                        <span class="flex items-center justify-center">
                           <svg viewBox="0 0 18 18">
                              <path d="M18,3.617c-0.675,0.322-1.351,0.43-2.139,0.537c0.788-0.43,1.351-1.076,1.576-1.937c-0.675,0.43-1.463,0.646-2.362,0.861C14.399,2.431,13.388,2,12.375,2c-1.912,0-3.601,1.617-3.601,3.554c0,0.323,0,0.538,0.113,0.754C5.851,6.2,3.038,4.8,1.238,2.646C0.9,3.185,0.788,3.724,0.788,4.478c0,1.184,0.675,2.261,1.688,2.907c-0.563,0-1.125-0.216-1.688-0.431l0,0c0,1.723,1.237,3.122,2.925,3.446c-0.338,0.107-0.675,0.107-1.013,0.107c-0.225,0-0.45,0-0.675-0.107c0.45,1.399,1.8,2.476,3.487,2.476C4.274,13.846,2.7,14.384,0.9,14.384c-0.338,0-0.563,0-0.9,0C1.688,15.354,3.601,16,5.625,16c6.75,0,10.462-5.385,10.462-10.015c0-0.108,0-0.323,0-0.431C16.875,5.016,17.549,4.371,18,3.617z"></path>
                           </svg>
                        </span>
                     </div>
                     <input type="text" class="twUsername" name="twUsername" value="<?= $social->twitter?>" autocomplete="off" required><label class="block absolute" for="twUsername">Twitter Kullanıcı Adı</label>
                  </div>
                  <div class="form-element relative w-full">
                     <div class="form-element-icon social-icon instagram absolute">
                        <span class="flex items-center justify-center">
                           <svg viewBox="0 0 100 100">
                              <path d="M72.402,0H27.595C12.379,0,0,12.381,0,27.597v44.809C0,87.619,12.379,100,27.595,100h44.807C87.621,100,100,87.619,100,72.406V27.597C100,12.381,87.621,0,72.402,0z M88.691,71.078c0,9.711-7.902,17.613-17.615,17.613H28.923c-9.712,0-17.613-7.902-17.613-17.613V28.926c0-9.715,7.901-17.618,17.613-17.618h42.153c9.713,0,17.615,7.903,17.615,17.618V71.078z M50.001,26.779c-12.804,0-23.22,10.426-23.22,23.22c0,12.804,10.416,23.22,23.22,23.22c12.801,0,23.217-10.416,23.217-23.22C73.219,37.205,62.803,26.779,50.001,26.779z M50.001,63.689c-7.548,0-13.688-6.139-13.688-13.691c0-7.545,6.14-13.684,13.688-13.684c7.545,0,13.686,6.139,13.686,13.684C63.688,57.551,57.547,63.689,50.001,63.689z M75.658,17.864c-1.711,0-4.383,0.724-5.711,2.056c-1.332,1.328-2.098,3.178-2.098,5.065c0,1.882,0.766,3.727,2.098,5.063c1.326,1.325,3.172,2.098,5.051,2.098c1.885,0,3.723-0.772,5.055-2.098c1.332-1.336,2.094-3.184,2.094-5.063c0-1.888-0.762-3.737-2.094-5.065C78.729,18.587,77.373,17.864,75.658,17.864z"></path>
                           </svg>
                        </span>
                     </div>
                     <input type="text" class="igUsername" name="igUsername" value="<?= $social->instagram?>" autocomplete="off" required><label class="block absolute" for="igUsername">Instagram Kullanıcı Adı</label>
                  </div>
                  <div class="form-element relative w-full">
                     <div class="form-element-icon social-icon twitch absolute">
                        <span class="flex items-center justify-center">
                           <svg viewBox="0 0 100 100">
                              <path d="M6.179,0L0,17.964V87.81h24.714V100h15.789L52.86,87.81h18.993L100,60.527V0H6.179z M90.39,57.645L74.828,72.504H49.885L37.299,84.703V72.504H15.561V9.094H90.39V57.645z M49.885,27.051h-9.382v27.27h9.382V27.051z M74.828,27.051h-9.382v27.27h9.382V27.051z"></path>
                           </svg>
                        </span>
                     </div>
                     <input type="text" class="thUsername" name="thUsername" value="<?= $social->twitch?>" autocomplete="off" required><label class="block absolute" for="thUsername">Twitch Kullanıcı Adı</label>
                  </div>
                  <div class="form-element relative w-full">
                     <div class="form-element-icon social-icon youtube absolute">
                        <span class="flex items-center justify-center">
                           <svg viewBox="0 0 100 100">
                              <path d="M97.911,24.557c-1.149-4.549-4.538-8.13-8.842-9.347C81.271,13,49.999,13,49.999,13s-31.271,0-39.07,2.21c-4.302,1.216-7.69,4.798-8.84,9.347C0,32.8,0,50.001,0,50.001s0,17.2,2.089,25.443c1.15,4.549,4.538,8.132,8.84,9.348C18.729,87,49.999,87,49.999,87s31.271,0,39.07-2.208c4.304-1.216,7.692-4.799,8.842-9.348C100,67.201,100,50.001,100,50.001S100,32.8,97.911,24.557z M39.999,65.858V34.144L65.98,50.001L39.999,65.858z"></path>
                           </svg>
                        </span>
                     </div>
                     <input type="text" class="ytUsername" name="ytUsername" value="<?= $social->youtube?>" autocomplete="off" required><label class="block absolute" for="ytUsername">Youtube Kullanıcı Adı</label>
                  </div>
                  <div class="form-element relative w-full">
                     <div class="form-element-icon social-icon discord absolute">
                        <span class="flex items-center justify-center">
                           <svg viewBox="0 0 100 100">
                              <path d="M87.671,23.75C75.993,15.223,64.855,15,63.707,15c-0.061,0-0.093,0-0.093,0l-1.2,1.332c14.556,4.332,21.32,10.582,21.32,10.582c-8.906-4.749-17.639-7.083-25.771-8c-2.7-0.291-5.353-0.422-7.926-0.422c-3.287,0-6.437,0.216-9.371,0.591c-0.512,0-0.941,0.084-1.456,0.165c-2.994,0.252-10.273,1.334-19.434,5.249c-3.167,1.417-5.052,2.417-5.052,2.417s7.107-6.583,22.518-10.915L36.387,15c0,0-0.032,0-0.098,0c-1.144,0-12.283,0.223-23.96,8.75C12.329,23.75,0,45.498,0,72.333c0,0,7.19,12.081,26.114,12.667c0,0,3.166-3.752,5.734-6.919c-10.873-3.168-14.981-9.831-14.981-9.831s0.854,0.582,2.397,1.414l0.343,0.25l0.769,0.419c2.14,1.163,4.282,2.084,6.251,2.833c3.511,1.334,7.706,2.663,12.584,3.585c3.51,0.633,7.349,1.047,11.451,1.047c3.408,0,6.999-0.284,10.728-0.964c4.021-0.67,8.129-1.836,12.415-3.585c2.991-1.083,6.333-2.665,9.845-4.916c0,0-4.287,6.831-15.5,9.915C70.717,81.414,73.805,85,73.805,85C92.722,84.414,100,72.333,100,72.333C100,45.498,87.671,23.75,87.671,23.75z M34.869,66.745c-5.046,0-9.136-4.056-9.136-9.059c0-5.002,4.09-9.059,9.136-9.059c5.045,0,9.137,4.057,9.137,9.059C44.006,62.689,39.914,66.745,34.869,66.745z M67.758,66.745c-5.045,0-9.135-4.056-9.135-9.059c0-5.002,4.09-9.059,9.135-9.059c5.046,0,9.137,4.057,9.137,9.059C76.895,62.689,72.804,66.745,67.758,66.745z"></path>
                           </svg>
                        </span>
                     </div>
                     <input type="text" class="dcUsername" name="dcUsername" <?= $social->discord?> autocomplete="off" required><label class="block absolute" for="dcUsername">Discord Davet Bağlantısı</label>
                  </div>
               </form>
            </div>
         </div>
         <div class="organized-modal-content-box tab-content">
            <div class="organized-modal-content-head sticky z-10"><span class="block">Grup Üyeleri <strong><?= $group->user_count?></strong></span></div>
            <div class="organized-modal-content-in">
               <div class="organized-modal-content-search">
                  <div class="form-group">
                     <div class="form-element relative"><input type="text" id="username" name="username" autocomplete="off" required><label class="block absolute" for="username">Kullanıcı Adı</label></div>
                  </div>
               </div>
               <ul class="landscape group-user-list">
                  <?php 
                     if(!empty($users)){
                        foreach($users as $user){
                  ?>
                  <li>
                     <div class="user-box flex items-center">
                        <div class="user-box-content flex items-center justify-between w-full relative">
                           <div class="user-box-desc flex items-center">
                              <div class="user-box-avatar"><a class="block" href="javascript:void(0);"><img class="lazy" data-src="<?= base_url("uploads/users/$user->u_avatar")?>" alt="<?= $user->u_name?>"></a></div>
                              <div class="user-box-name">
                                 <span class="block"><a class="block" <?= navigo()?> href="<?= base_url("profil/$user->u_username")?>"><?= $user->u_name?></a></span>
                                 <p>@<?= $user->u_username?></p>
                              </div>
                           </div>
                           <div class="user-box-footer">
                              <ul class="flex">
                                 <?php 
                                    if(!$user->check_friend && $user->u_id != $this->user_id){
                                 ?>
                                 <li class="user-item">
                                    <?php
                                       if($user->check_friend_request){
                                    ?>
                                    <button class="flex items-center justify-center focus:outline-none delete-request-friend" data-id="<?= $user->u_id?>">
                                       <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                         <path d="M11 6a3 3 0 11-6 0 3 3 0 016 0zM14 17a6 6 0 00-12 0h12zM13 8a1 1 0 100 2h4a1 1 0 100-2h-4z" />
                                       </svg>
                                    </button>
                                    <?php } else { ?>
                                    <button class="flex items-center justify-center focus:outline-none set-friend" data-id="<?= $user->u_id?>">
                                       <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                          <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                          <circle cx="8.5" cy="7" r="4"></circle>
                                          <line x1="20" y1="8" x2="20" y2="14"></line>
                                          <line x1="23" y1="11" x2="17" y2="11"></line>
                                       </svg>
                                    </button>
                                    <?php } ?>
                                 </li>
                                    <?php } ?>
                               
                                 <?php 
                                    if($user->u_id != $group->user_id){
                                 ?>
                                 <li>
                                    <button class="flex items-center justify-center focus:outline-none delete-in-group" data-group="<?= $group->group_id?>" data-id="<?= $user->u_id?>">
                                       <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                          <path d="M21 4H8l-7 8 7 8h13a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"></path>
                                          <line x1="18" y1="9" x2="12" y2="15"></line>
                                          <line x1="12" y1="9" x2="18" y2="15"></line>
                                       </svg>
                                    </button>
                                 </li>
                                 <?php } ?>
                              </ul>
                           </div>
                        </div>
                     </div>
                  </li>
                  <?php  } } ?>
                 
               </ul>
               <ul class="hidden landscape user-search-list"></ul>
            </div>
         </div>
         <div class="organized-modal-content-box tab-content">
            <div class="organized-modal-content-head sticky z-10"><span class="block">Grup Ayaları</span></div>
            <div class="organized-modal-content-in">
               <form class="organized-modal-content-privacy" method="post">
                  <ul>
                     <li>
                        <div class="general-settings-box flex items-center justify-between">
                           <div class="general-settings-box-text">
                              <span class="block">Paylaşım</span>
                              <p>Sadece grup yöneticileri paylaşım yapabilir</p>
                           </div>
                           <div class="general-settings-box-action">
                              <div class="switch"><label class="block"><input type="checkbox" class="private" value="1" <?= $group->private ? 'checked' : null?>><span class="block switch-button relative"><span class="block switch-button-icon absolute"></span></span></label></div>
                           </div>
                        </div>
                     </li>
                     <li>
                        <div class="general-settings-box flex items-center justify-between">
                           <div class="general-settings-box-text">
                              <span class="block">Gizlilik</span>
                              <p>Sadece üye olanlar grubu görebilir</p>
                           </div>
                           <div class="general-settings-box-action">
                              <div class="switch"><label class="block"><input type="checkbox" class="privacy" value="1" <?= $group->privacy ? 'checked' : null?>><span class="block switch-button relative"><span class="block switch-button-icon absolute"></span></span></label></div>
                           </div>
                        </div>
                     </li>
                  </ul>
               </form>
            </div>
         </div>
      </div>
   </div>
</div>
<?php } ?>
