<style>
    :root {
      --dark-100: #181a25;
      --dark-200: #181a27;
      --dark-300: #111216;
      --teal: #f6c500;
      --gray-400: #94a3b8;
      --white: #ffffff;
    }

    .container {
      max-width: 1400px;
      margin: 0 auto;
      padding: 0 2rem;
    }

    .header-content {
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 1rem 0;
    }

    .logo {
      display: flex;
      align-items: center;
      gap: 0.5rem;
      color: var(--white);
      text-decoration: none;
      font-weight: 700;
      font-size: 1.25rem;
    }

    .logo svg {
      color: var(--teal);
    }

    .nav-links {
      display: none;
    }

    @media (min-width: 768px) {
      .nav-links {
        display: flex;
        gap: 0.25rem;
      }
    }

    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      border-radius: 0.375rem;
      font-weight: 500;
      font-size: 0.875rem;
      padding: 0.5rem 1rem;
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .btn-primary {
      background-color: var(--teal);
      color: var(--dark-300);
      border: none;
    }

    .btn-primary:hover {
      background-color: rgba(66, 227, 208, 0.9);
    }

    .btn-ghost {
      background-color: transparent;
      color: var(--gray-400);
      border: none;
    }

    .btn-ghost:hover {
      color: var(--teal);
      background-color: var(--dark-200);
    }

    .btn-outline {
      background-color: var(--dark-200);
      color: var(--white);
      border: 1px solid var(--dark-100);
    }

    .btn-outline:hover {
      background-color: var(--dark-100);
      color: var(--teal);
    }

    .btn svg {
      width: 1rem;
      height: 1rem;
      margin-right: 0.5rem;
    }

    .main-content {
      padding: 2rem 0;
    }

    .page-title {
      font-size: 1.875rem;
      font-weight: 700;
      margin-bottom: 1.5rem;
      color: var(--white);
    }

    .search-bar {
      display: flex;
      flex-direction: column;
      gap: 1rem;
      margin-bottom: 2rem;
    }

    @media (min-width: 640px) {
      .search-bar {
        flex-direction: row;
      }
    }

    .search-input-wrapper {
      position: relative;
      flex: 1;
    }

    .search-input {
      width: 100%;
      padding: 0.625rem 0.75rem 0.625rem 2.5rem;
      background-color: var(--dark-200);
      border: 1px solid var(--dark-100);
      border-radius: 0.375rem;
      color: var(--white);
      font-size: 0.875rem;
      transition: all 0.3s ease;
    }

    .search-input:focus {
      outline: none;
      border-color: var(--teal);
      box-shadow: 0 0 0 2px rgba(66, 227, 208, 0.2);
    }

    .search-icon {
      position: absolute;
      left: 0.75rem;
      top: 50%;
      transform: translateY(-50%);
      color: var(--gray-400);
      width: 1rem;
      height: 1rem;
    }

    .filter-buttons {
      display: flex;
      gap: 0.5rem;
    }

    .tabs {
      margin-bottom: 2rem;
    }

    .tabs-list {
      margin-bottom: 20px;
      display: flex;
      background-color: var(--dark-200);
      border: 1px solid var(--dark-100);
      border-radius: 0.375rem;
      padding: 0.25rem;
      overflow-x: auto;
      outline: none;
    }
    .tabs-list button {
      outline: none;
    }

    .tab {
      padding: 0.5rem 1rem;
      font-size: 0.875rem;
      font-weight: 500;
      color: var(--gray-400);
      background: transparent;
      border: none;
      border-radius: 0.25rem;
      cursor: pointer;
      position: relative;
      white-space: nowrap;
    }

    .tab.active {
      color: var(--teal);
      background-color: var(--dark-100);
    }

    .tab-highlight::after {
      content: "";
      position: absolute;
      bottom: -1px;
      left: 0;
      width: 100%;
      height: 2px;
      background-color: var(--teal);
      transform: scaleX(0);
      transition: transform 0.3s ease;
    }

    .tab.active .tab-highlight::after {
      transform: scaleX(1);
    }

    .tab-content {
      display: none;
      margin-top: 1.5rem;
    }

    .tab-content.active {
      display: block;
    }

    .channel-grid {
      display: grid;
      grid-template-columns: repeat(1, 1fr);
      gap: 1.5rem;
    }

    @media (min-width: 640px) {
      .channel-grid {
        grid-template-columns: repeat(2, 1fr);
      }
    }

    @media (min-width: 1024px) {
      .channel-grid {
        grid-template-columns: repeat(3, 1fr);
      }
    }

    @media (min-width: 1280px) {
      .channel-grid {
        grid-template-columns: repeat(4, 1fr);
      }
    }

    .channel-card {
      background-color: var(--dark-100);
      border: 1px solid var(--dark-200);
      border-radius: 0.5rem;
      overflow: hidden;
      height: 100%;
      transition: all 0.3s ease;
      text-decoration: none;
      display: block;
    }

    .channel-card:hover {
      transform: translateY(-4px);
      border-color: var(--teal);
      box-shadow: 0 10px 25px -5px rgba(66, 227, 208, 0.15);
    }

    .channel-thumbnail {
      position: relative;
      aspect-ratio: 16 / 9;
      background-color: var(--dark-200);
    }

    .channel-thumbnail img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      opacity: 0.9;
      transition: opacity 0.3s ease;
    }

    .channel-card:hover .channel-thumbnail img {
      opacity: 1;
    }

    .thumbnail-overlay {
      position: absolute;
      inset: 0;
      background: linear-gradient(to top, rgba(17, 18, 22, 0.8), transparent);
    }

    .live-badge {
      position: absolute;
      top: 0.5rem;
      right: 0.5rem;
      z-index: 10;
      background-color: var(--teal);
      color: var(--dark-300);
      font-size: 0.75rem;
      font-weight: 500;
      padding: 0.25rem 0.5rem;
      border-radius: 0.25rem;
      overflow: hidden;
    }

    .live-badge::before {
      content: "";
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: linear-gradient(90deg, #4de5d3d1 0%, rgba(66, 227, 208, 0.3) 50%, rgba(66, 227, 208, 0) 100%)
      transform: translateX(-100%);
      animation: shimmer 2s infinite;
    }

    @keyframes shimmer {
      100% {
        transform: translateX(100%);
      }
    }

    .channel-content {
      padding: 1rem;
      position: relative;
    }

    .channel-header {
      display: flex;
      align-items: flex-start;
      justify-content: space-between;
    }

    .channel-info h3 {
      font-weight: 600;
      font-size: 0.875rem;
      color: var(--white);
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }

    .channel-info p {
      font-size: 0.75rem;
      color: var(--gray-400);
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }

    .channel-logo {
      background-color: var(--dark-200);
      padding: 0.25rem;
      border-radius: 9999px;
    }

    .channel-logo img {
      width: 2rem;
      height: 2rem;
      object-fit: contain;
      border-radius: 9999px;
    }

    .channel-now-playing {
      margin-top: 0.75rem;
      padding-top: 0.75rem;
      border-top: 1px solid var(--dark-200);
    }

    .now-playing-label {
      display: flex;
      align-items: center;
      font-size: 0.75rem;
      color: var(--gray-400);
      margin-bottom: 0.25rem;
    }

    .now-playing-label svg {
      width: 0.75rem;
      height: 0.75rem;
      margin-right: 0.25rem;
    }

    .now-playing-title {
      font-size: 0.875rem;
      color: var(--white);
      display: -webkit-box;
      -webkit-line-clamp: 2;
      -webkit-box-orient: vertical;
      overflow: hidden;
    }

    /* Detail page styles */
    .back-link {
      display: inline-flex;
      align-items: center;
      font-size: 0.875rem;
      font-weight: 500;
      color: var(--gray-400);
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .back-link:hover {
      color: var(--teal);
    }

    .back-link svg {
      width: 1rem;
      height: 1rem;
      margin-right: 0.5rem;
    }

    .detail-container {
      display: grid;
      grid-template-columns: 1fr;
      gap: 2rem;
    }

    @media (min-width: 1024px) {
      .detail-container {
        grid-template-columns: 2fr 1fr;
      }
    }

    .video-container {
      position: relative;
      aspect-ratio: 16 / 9;
      background-color: var(--dark-200);
      border-radius: 0.5rem;
      overflow: hidden;
      margin-bottom: 1.5rem;
    }

    .video-container img {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }

    .video-overlay {
      position: absolute;
      inset: 0;
      background: linear-gradient(to top, rgba(17, 18, 22, 0.9), transparent);
      opacity: 0;
      transition: opacity 0.3s ease;
      display: flex;
      align-items: flex-end;
      justify-content: center;
      padding-bottom: 2rem;
    }

    .video-container:hover .video-overlay {
      opacity: 1;
    }

    .video-actions {
      display: flex;
      gap: 1rem;
    }

    .channel-header-detail {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-bottom: 1.5rem;
    }

    .channel-info-detail {
      display: flex;
      align-items: center;
    }

    .channel-logo-detail {
      background-color: var(--dark-200);
      padding: 0.5rem;
      border-radius: 9999px;
      margin-right: 1rem;
    }

    .channel-logo-detail img {
      width: 3rem;
      height: 3rem;
      border-radius: 9999px;
    }

    .detail-tabs {
      margin-bottom: 2rem;
    }

    .tab-panel {
      display: none;
    }

    .tab-panel.active {
      display: block;
    }

    .about-section {
      margin-bottom: 1rem;
    }

    .about-title {
      font-size: 1.25rem;
      font-weight: 600;
      margin-bottom: 0.5rem;
      color: var(--white);
    }

    .about-description {
      color: var(--gray-400);
      line-height: 1.6;
    }

    .separator {
      height: 1px;
      background-color: var(--dark-200);
      margin: 1rem 0;
    }

    .now-playing-card {
      background-color: var(--dark-100);
      border: 1px solid var(--dark-200);
      padding: 1rem;
      border-radius: 0.5rem;
      transition: border-color 0.3s ease;
    }

    .now-playing-card:hover {
      border-color: rgba(66, 227, 208, 0.3);
    }

    .now-playing-header {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-bottom: 0.5rem;
    }

    .now-playing-title-detail {
      font-weight: 500;
      color: var(--white);
    }

    .now-playing-time {
      display: flex;
      align-items: center;
      font-size: 0.875rem;
      color: var(--gray-400);
    }

    .now-playing-time svg {
      width: 1rem;
      height: 1rem;
      margin-right: 0.25rem;
      color: var(--teal);
    }

    .now-playing-description {
      font-size: 0.875rem;
      color: var(--gray-400);
      line-height: 1.6;
    }

    .schedule-list {
      display: flex;
      flex-direction: column;
      gap: 1rem;
    }

    .article-list {
      display: flex;
      flex-direction: column;
      gap: 1rem;
    }

    .article-card {
      border: 1px solid var(--dark-200);
      background-color: var(--dark-100);
      padding: 1rem;
      border-radius: 0.5rem;
      transition: border-color 0.3s ease;
    }

    .article-card:hover {
      border-color: rgba(66, 227, 208, 0.3);
    }

    .article-title {
      font-weight: 500;
      margin-bottom: 0.5rem;
      color: var(--white);
      transition: color 0.3s ease;
    }

    .article-card:hover .article-title {
      color: var(--teal);
    }

    .article-meta {
      display: flex;
      align-items: center;
      font-size: 0.875rem;
      color: var(--gray-400);
    }

    .article-meta svg {
      width: 1rem;
      height: 1rem;
      margin-right: 0.25rem;
      color: var(--teal);
    }

    .article-date {
      margin-right: 0.75rem;
    }

    .article-category {
      display: inline-block;
      border: 1px solid var(--dark-200);
      padding: 0.125rem 0.5rem;
      border-radius: 0.25rem;
      font-size: 0.75rem;
      color: var(--teal);
    }

    .sidebar-section {
      background-color: var(--dark-100);
      border: 1px solid var(--dark-200);
      padding: 1rem;
      border-radius: 0.5rem;
      margin-bottom: 1.5rem;
    }

    .sidebar-title {
      font-size: 1.125rem;
      font-weight: 600;
      margin-bottom: 1rem;
      color: var(--white);
    }

    .popular-channels {
      display: flex;
      flex-direction: column;
      gap: 1rem;
    }

    .popular-channel-item {
      display: flex;
      align-items: center;
      gap: 0.75rem;
      position: relative;
    }

    .popular-channel-logo {
      background-color: var(--dark-200);
      padding: 0.25rem;
      border-radius: 9999px;
    }

    .popular-channel-logo img {
      width: 2.5rem;
      height: 2.5rem;
      border-radius: 9999px;
    }

    .popular-channel-info {
      flex: 1;
      min-width: 0;
    }

    .popular-channel-name {
      font-weight: 500;
      font-size: 0.875rem;
      color: var(--white);
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      transition: color 0.3s ease;
    }

    .popular-channel-item:hover .popular-channel-name {
      color: var(--teal);
    }

    .popular-channel-category {
      font-size: 0.75rem;
      color: var(--gray-400);
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }

    .popular-channel-status {
      font-size: 0.75rem;
    }

    .recommended-shows {
      display: flex;
      flex-direction: column;
      gap: 1rem;
    }

    .recommended-show-item {
      display: flex;
      gap: 0.75rem;
    }

    .recommended-show-thumbnail {
      position: relative;
      overflow: hidden;
      border-radius: 0.25rem;
    }

    .recommended-show-thumbnail img {
      width: 5rem;
      height: 3.5rem;
      object-fit: cover;
      transition: transform 0.3s ease;
    }

    .recommended-show-item:hover .recommended-show-thumbnail img {
      transform: scale(1.1);
    }

    .recommended-show-info h3 {
      font-weight: 500;
      font-size: 0.875rem;
      color: var(--white);
      transition: color 0.3s ease;
    }

    .recommended-show-item:hover .recommended-show-info h3 {
      color: var(--teal);
    }

    .recommended-show-channel {
      font-size: 0.75rem;
      color: var(--gray-400);
    }

    .rating {
      display: flex;
      align-items: center;
      margin-top: 0.25rem;
    }

    .star {
      width: 0.75rem;
      height: 0.75rem;
      color: var(--teal);
      fill: var(--teal);
    }

    .star-empty {
      width: 0.75rem;
      height: 0.75rem;
      color: var(--gray-400);
    }

    .rating-value {
      font-size: 0.75rem;
      color: var(--gray-400);
      margin-left: 0.25rem;
    }


        /* Video source switcher styles */
    .video-source-switcher {
      position: absolute;
      top: 0.5rem;
      left: 0.5rem;
      z-index: 20;
      background-color: rgba(20, 22, 29, 0.8);
      backdrop-filter: blur(4px);
      border: 1px solid var(--dark-100);
      border-radius: 0.375rem;
      padding: 0.5rem;
      display: flex;
      flex-direction: column;
      gap: 0.5rem;
      min-width: 180px;
      transition: all 0.3s ease;
    }

    .source-switcher-header {
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding-bottom: 0.5rem;
      border-bottom: 1px solid var(--dark-100);
    }

    .source-switcher-title {
      font-size: 0.75rem;
      font-weight: 600;
      color: var(--white);
      display: flex;
      align-items: center;
    }

    .source-switcher-title svg {
      width: 0.875rem;
      height: 0.875rem;
      margin-right: 0.375rem;
      color: var(--teal);
    }

    .source-list {
      display: flex;
      flex-direction: column;
      gap: 0.25rem;
    }

    .source-item {
      display: flex;
      align-items: center;
      padding: 0.375rem 0.5rem;
      border-radius: 0.25rem;
      font-size: 0.75rem;
      color: var(--gray-400);
      cursor: pointer;
      transition: all 0.2s ease;
    }

    .source-item:hover {
      background-color: var(--dark-200);
      color: var(--white);
    }

    .source-item.active {
      background-color: var(--dark-100);
      color: var(--teal);
    }

    .source-item svg {
      width: 0.75rem;
      height: 0.75rem;
      margin-right: 0.5rem;
    }

    .source-quality {
      margin-left: auto;
      font-size: 0.625rem;
      padding: 0.125rem 0.25rem;
      background-color: var(--dark-300);
      border-radius: 0.125rem;
    }

    .source-item.active .source-quality {
      background-color: rgba(66, 227, 208, 0.2);
      color: var(--teal);
    }

    .toggle-source-switcher {
      position: absolute;
      top: 0.5rem;
      left: 0.5rem;
      z-index: 15;
      background-color: rgba(20, 22, 29, 0.8);
      backdrop-filter: blur(4px);
      border: 1px solid var(--dark-100);
      border-radius: 0.375rem;
      padding: 0.375rem;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      transition: all 0.2s ease;
    }

    .toggle-source-switcher:hover {
      background-color: var(--dark-100);
    }

    .toggle-source-switcher svg {
      width: 1rem;
      height: 1rem;
      color: var(--teal);
    }

    .video-source-switcher {
      display: none;
    }

    .video-source-switcher.open {
      display: flex;
    }

    #video-container iframe {
      width: 100%;
      height: 100%;
    }

</style>
    <!-- Detail Page -->
    <div id="detail-page">
      <div class="header-content">
          <a href="<?php echo base_url("canli-tv"); ?>" class="back-link" id="back-to-home">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
              <line x1="19" y1="12" x2="5" y2="12"></line>
              <polyline points="12 19 5 12 12 5"></polyline>
            </svg>
            Kanal listesine geri dön
          </a>
      </div>

      <main class="main-content">
        
          <div class="detail-container">
            <div class="main-content-detail">
              <div class="video-container">
                <div class="live-badge">CANLI</div>
                  <!-- Video Source Switcher Toggle Button -->
                  <div class="toggle-source-switcher" id="toggle-source-switcher">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                      <path d="M12 2v4M12 18v4M4.93 4.93l2.83 2.83M16.24 16.24l2.83 2.83M2 12h4M18 12h4M4.93 19.07l2.83-2.83M16.24 7.76l2.83-2.83"></path>
                    </svg>
                  </div>
                  
                <!-- Video Source Switcher Panel -->
                <div class="video-source-switcher" id="video-source-switcher">
                  <div class="source-switcher-header">
                    <div class="source-switcher-title">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"></path>
                        <polyline points="14 2 14 8 20 8"></polyline>
                      </svg>
                      Kaynaklar
                    </div>
                  </div>
                  <?php 
                    $link = "";
                    if( !empty($sources[0]['url']) && $sources[0]['type'] == 'hls'){
                      $query = array("type" => "live","name" => trim($sources[0]['name']));
                      $link = base_url("stream/".base64url_encode( $sources[0]['url'] )."?".http_build_query($query));
                    }
                  ?>
                  <div class="source-list">
                    <div class="source-item active" data-source="main" data-source-url="<?=  $link  ?>">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"></circle>
                        <circle cx="12" cy="12" r="4"></circle>
                      </svg>
                      Ana Kaynak
                      <span class="source-quality">HD</span>
                    </div>
                    <?php 
                    if(!empty($sources)){
                      foreach($sources as $row){
                        if($row['type'] == 'hls'){
                            $query = array("type" => "live","name" => trim($row['name']));
                            $link = base_url("stream/".base64url_encode( $row['url'] )."?".http_build_query($query));
                        }else {
                          $link = $row['url'];
                        }
                    ?>
                    <div class="source-item" data-source="alternate" data-source-url="<?= $link  ?>">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"></circle>
                      </svg>
                      <?= $row['name']?>
                      <span class="source-quality">HD</span>
                    </div>
                  <?php } } ?>
              
                  </div>
                </div>
                <div id="video-container" class="video-container w-full">
                  <?php 
                      if($sources[0]['type'] == 'hls'){
                          $query = array("type" => "live","name" => trim($sources[0]['name']));
                          $link = base_url("stream/".base64url_encode($sources[0]['url'])."?".http_build_query($query));
                      }else {
                          $link = $sources[0]['url'];
                      }
                  ?>
                   <iframe id="tv-frame" src="<?= $link?>" width="100%" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" height="100%" frameborder="0"></iframe>
                </div>
              </div>

              <div class="channel-header-detail">
                <div class="channel-info-detail">
                  <div class="channel-logo-detail">
                    <img src="<?php echo base_url("uploads/livetv/original/". $channel['image']); ?>" alt="<?php echo $channel['name']; ?> logo">
                  </div>
                  <div>
                    <h1 class="page-title" style="margin-bottom: 0.25rem;"><?php echo $channel['name']; ?></h1>
                  </div>
                </div>
              </div>

              <div class="detail-tabs">
                <div class="tabs-list">
                  <button class="tab active" data-detail-tab="about">
                    Hakkında
                    <span class="tab-highlight"></span>
                  </button>
                </div>

                <div class="tab-panel active" data-detail-panel="about">
                  <div class="about-section">
                    <h2 class="about-title"><?= $channel['name']?> Hakkında</h2>
                    <p class="about-description"><?= nl2br($channel['description'])?></p>
                  </div>
                  <div class="separator"></div>
             
                </div>

              </div>
            </div>

            <div class="sidebar">
              <div class="sidebar-section">
                <h2 class="sidebar-title">Diğer Kanallar</h2>
                <div class="popular-channels">
                  <?php if($channels){ ?>
                    <?php foreach($channels as $channel){ ?>
                    <a href="<?php echo base_url("canli-tv/". $channel['slug']); ?>" class="popular-channel-item">
                      <div class="popular-channel-logo">
                      <img src="<?php echo base_url("uploads/livetv/original/". $channel['image']); ?>" alt="Channel 1 logo">
                    </div>
                    <div class="popular-channel-info">
                      <h3 class="popular-channel-name"><?php echo $channel['name']; ?></h3>
                      </div>
                      <div class="live-badge popular-channel-status">CANLI</div>
                    </a>
                    <?php } ?>
                  <?php } ?>
                </div>
              </div>

            </div>
          </div>
        
      </main>
    </div>



    <script>
    // Channel data
    const channels = [
      {
        id: "1",
        name: "News 24",
        category: "News",
        isLive: true,
        thumbnail: "https://placehold.co/320x180/14161d/14161d",
        logo: "https://placehold.co/40x40/14161d/14161d",
        currentShow: "Breaking News: World Events Coverage"
      },
      {
        id: "2",
        name: "Sports Central",
        category: "Sports",
        isLive: true,
        thumbnail: "https://placehold.co/320x180/14161d/14161d",
        logo: "https://placehold.co/40x40/14161d/14161d",
        currentShow: "Premier League: Manchester United vs. Liverpool"
      },
      {
        id: "3",
        name: "Movie Channel",
        category: "Entertainment",
        isLive: false,
        thumbnail: "https://placehold.co/320x180/14161d/14161d",
        logo: "https://placehold.co/40x40/14161d/14161d",
        currentShow: "The Avengers (2012)"
      },
      {
        id: "4",
        name: "Documentary World",
        category: "Education",
        isLive: true,
        thumbnail: "https://placehold.co/320x180/14161d/14161d",
        logo: "https://placehold.co/40x40/14161d/14161d",
        currentShow: "Exploring the Deep Ocean"
      },
      {
        id: "5",
        name: "Kids Zone",
        category: "Children",
        isLive: true,
        thumbnail: "https://placehold.co/320x180/14161d/14161d",
        logo: "https://placehold.co/40x40/14161d/14161d",
        currentShow: "SpongeBob SquarePants"
      },
      {
        id: "6",
        name: "Music TV",
        category: "Entertainment",
        isLive: true,
        thumbnail: "https://placehold.co/320x180/14161d/14161d",
        logo: "https://placehold.co/40x40/14161d/14161d",
        currentShow: "Top 40 Countdown"
      },
      {
        id: "7",
        name: "Cooking Channel",
        category: "Lifestyle",
        isLive: false,
        thumbnail: "https://placehold.co/320x180/14161d/14161d",
        logo: "https://placehold.co/40x40/14161d/14161d",
        currentShow: "Master Chef: Season Finale"
      },
      {
        id: "8",
        name: "Science Network",
        category: "Education",
        isLive: true,
        thumbnail: "https://placehold.co/320x180/14161d/14161d",
        logo: "https://placehold.co/40x40/14161d/14161d",
        currentShow: "The Universe Explained"
      }
    ];

    // Function to create channel card
    function createChannelCard(channel) {
      return `
        <a href="#" class="channel-card" data-channel-id="${channel.id}">
          <div class="channel-thumbnail">
            ${channel.isLive ? '<div class="live-badge">LIVE</div>' : ''}
            <img src="${channel.thumbnail}" alt="${channel.name}">
            <div class="thumbnail-overlay"></div>
          </div>
          <div class="channel-content">
            <div class="channel-header">
              <div class="channel-info">
                <h3>${channel.name}</h3>
                <p>${channel.category}</p>
              </div>
              <div class="channel-logo">
                <img src="${channel.logo}" alt="${channel.name} logo">
              </div>
            </div>
            <div class="channel-now-playing">
              <div class="now-playing-label">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                  <circle cx="12" cy="12" r="10"></circle>
                  <polyline points="12 6 12 12 16 14"></polyline>
                </svg>
                Now Playing:
              </div>
              <p class="now-playing-title">${channel.currentShow}</p>
            </div>
          </div>
        </a>
      `;
    }

    // Populate channels
    function populateChannels() {
      const allChannelsContainer = document.getElementById('all-channels');
      const newsChannelsContainer = document.getElementById('news-channels');
      const sportsChannelsContainer = document.getElementById('sports-channels');
      const entertainmentChannelsContainer = document.getElementById('entertainment-channels');
      const kidsChannelsContainer = document.getElementById('kids-channels');

      allChannelsContainer.innerHTML = '';
      newsChannelsContainer.innerHTML = '';
      sportsChannelsContainer.innerHTML = '';
      entertainmentChannelsContainer.innerHTML = '';
      kidsChannelsContainer.innerHTML = '';

      channels.forEach(channel => {
        // Add to all channels
        allChannelsContainer.innerHTML += createChannelCard(channel);

        // Add to category-specific containers
        if (channel.category === 'News') {
          newsChannelsContainer.innerHTML += createChannelCard(channel);
        } else if (channel.category === 'Sports') {
          sportsChannelsContainer.innerHTML += createChannelCard(channel);
        } else if (channel.category === 'Entertainment') {
          entertainmentChannelsContainer.innerHTML += createChannelCard(channel);
        } else if (channel.category === 'Children') {
          kidsChannelsContainer.innerHTML += createChannelCard(channel);
        }
      });

      // Add event listeners to channel cards
      document.querySelectorAll('.channel-card').forEach(card => {
        card.addEventListener('click', function(e) {
          e.preventDefault();
          const channelId = this.getAttribute('data-channel-id');
          showChannelDetail(channelId);
        });
      });
    }

    // Tab functionality
    function setupTabs() {
      const tabs = document.querySelectorAll('.tab');
      tabs.forEach(tab => {
        tab.addEventListener('click', function() {
          const tabId = this.getAttribute('data-tab');
          
          // Remove active class from all tabs and contents
          document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
          document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
          
          // Add active class to selected tab and content
          this.classList.add('active');
          document.querySelector(`.tab-content[data-content="${tabId}"]`).classList.add('active');
        });
      });

      // Detail page tabs
      const detailTabs = document.querySelectorAll('[data-detail-tab]');
      detailTabs.forEach(tab => {
        tab.addEventListener('click', function() {
          const tabId = this.getAttribute('data-detail-tab');
          
          // Remove active class from all tabs and panels
          document.querySelectorAll('[data-detail-tab]').forEach(t => t.classList.remove('active'));
          document.querySelectorAll('[data-detail-panel]').forEach(p => p.classList.remove('active'));
          
          // Add active class to selected tab and panel
          this.classList.add('active');
          document.querySelector(`[data-detail-panel="${tabId}"]`).classList.add('active');
        });
      });
    }

    // Show channel detail page
    function showChannelDetail(channelId) {
      document.getElementById('home-page').style.display = 'none';
      document.getElementById('detail-page').style.display = 'block';
      
      // In a real app, you would fetch the channel details based on the ID
      // For now, we're just showing the hardcoded detail page
    }

    // Initialize
    document.addEventListener('DOMContentLoaded', function() {
      setupTabs();
    });

       // Video source switcher functionality
    document.getElementById('toggle-source-switcher').addEventListener('click', function() {
      const sourceSwitcher = document.getElementById('video-source-switcher');
      sourceSwitcher.classList.toggle('open');
    });

    // Source selection
    document.querySelectorAll('.source-item').forEach(item => {
      item.addEventListener('click', function() {
        // Remove active class from all sources
        document.querySelectorAll('.source-item').forEach(s => s.classList.remove('active'));
        
        // Add active class to selected source
        this.classList.add('active');
        
        // In a real app, you would switch the video source here
        const sourceId = this.getAttribute('data-source-url');
        
        $("#tv-frame").attr('src',sourceId)
        
        const sourceSwitcher = document.getElementById('video-source-switcher');
        sourceSwitcher.classList.toggle('open');
      });
    });
  </script>
</body>
</html>
