<div class="quests">
   <div class="page-head">
      <h1>Görevler</h1>
      <p>Aşağıda bulunan görevleri tamamlayabilecek görev adamlarına ihtiyacımız var. O kişi sen misin ? </p>
   </div>
   <div class="area featured-quests">
      <div class="area-title">
         <h2 class="block">Öne Çıkan Görevler</h2>
      </div>
      <ul class="flex flex-wrap">
         <?php 
            if(!empty($result)){
               $count   = 0;
               $img     = "openq";
               foreach($result as $row){
                  $count += 1;
                  if(!empty($row->condition)){
                     $percent = get_percentage($row->condition->from,$row->condition->to);
                     if($row->condition->range){
                        if($row->condition->to == $row->condition->from){
                           $progressText = "Tamamlandı";
                           $img = "completedq";
                           $percent = "100";
                        }else if($row->condition->to > 0){
                           $progressText = "{$row->condition->to}/{$row->condition->from} Kaldı";
                           $img  = "openq";
                        }else {
                           $img  = "openq";
                           $progressText = "{$row->condition->to}/{$row->condition->from} Hemen Başla";
                        }
                     }else {
                        if($row->condition->unlock){
                           $percent = "100";
                           $progressText = "Tamamlandı";
                           $img = "completedq";
                        }else {
                           $progressText = "Kilitli";
                        }
                     }
                  }else {
                     $percent  = 0;
                     $progressText = "Kilitli";
                  }
         ?>
         <li class="w-full sm:w-1/2 md:w-1/3 xl:w-1/4">
            <div class="quests-box flex flex-col h-full">
               <div class="quests-box-cover relative">
                  <img src="<?= base_url("assets/images/quest/cover/0$count.png")?>" alt="">
                  <div class="quests-box-exp absolute">
                     <span class="flex items-center">
                        <svg viewBox="0 0 8 8" preserveAspectRatio="xMinYMin meet">
                           <path d="M8,5H5v3H3V5H0V3h3V0h2v3h3V5z"></path>
                        </svg>
                        <?= $row->experiance?> Exp
                     </span>
                  </div>
               </div>
               <div class="quests-box-content relative flex flex-col h-full">
                  <div class="quests-box-icon"><img src="assets/images/quest/<?= $img?>.png" alt=""></div>
                  <div class="quests-box-text">
                     <span class="block"><?= $row->title?></span>
                     <p><?= $row->desc?></p>
                  </div>
                  <div class="quests-box-progress">
                     <div class="progress">
                        <div class="progress-area relative">
                           <div class="progress-bar absolute" style="width: <?= $percent?>%"></div>
                        </div>
                        <div class="progress-text "><span class="block"><?= $progressText?></span></div>
                     </div>
                  </div>
                  <div class="quests-box-completed-user flex items-center">
                       <?php 
                        if(!empty($row->friends)){
                     ?>
                     <ul class="flex">
                        <?php 
                           foreach($row->friends as $friend){
                        ?>
                        <li>
                           <a href="<?= base_url("profil/$friend->u_username")?>"><img class="lazy" title="<?= $friend->u_name?>" data-src="<?= base_url("uploads/users/$friend->u_avatar")?>" alt="<?= $friend->u_name?>"></a>
                        </li>
                        <?php } ?>
                     </ul>
                     <div class="badges-box-completed-user-text">
                        <?php 
                           if($friend->total > 3){
                        ?>
                        <span class="block">+<?=$friend->total?> arkadaşın</span>
                        <?php }else { ?>
                        <span class="block"><?= $friend->total?> arkadaşın</span>
                        <?php } ?>
                        <p>Bu rozeti kazandı</p>
                     </div>
                  <?php }else {  ?>
                     <div class="badges-box-empty-user-text ">
                        <p>Arkadaşların arasında ilk sen kazan</p>
                     </div>
                  <?php } ?>
                  </div>
               </div>
            </div>
         </li>
         <?php } } ?>
      </ul>
   </div>
   <div class="area all-quests">
      <div class="area-title">
         <h2 class="block">Tüm Görevlere Gözat</h2>
      </div>
      <div class="quests-list table w-full">
         <div class="quests-list-header hidden sm:table-header-group">
            <div class="quests-list-header-box table-cell"><span class="block">Görev</span></div>
            <div class="quests-list-header-box table-cell"><span class="block">Açıklama</span></div>
            <div class="quests-list-header-box table-cell"><span class="block">Deneyim</span></div>
            <div class="quests-list-header-box table-cell"><span class="block">İlerleme</span></div>
         </div>
         <div class="quests-list-body table-row-group">
            <?php 
               if(!empty($result)){
                  $count = 0;
                  foreach($result as $row){
                     $count += 1;
                     if(!empty($row->condition)){
                        $percent = get_percentage($row->condition->from,$row->condition->to);
                        if($row->condition->range){
                           if($row->condition->to == $row->condition->from){
                              $progressText = "Açıldı";
                              $percent = "100";
                           }else if($row->condition->to > 0){
                              $progressText = "{$row->condition->to}/{$row->condition->from} Kaldı";
                           }else {
                              $progressText = "{$row->condition->to}/{$row->condition->from} Hemen Başla";
                           }
                        }else {
                           if($row->condition->unlock){
                              $percent = "100";
                              $progressText = "Açıldı";
                           }else {
                              $progressText = "Kilitli";
                           }
                        }
                     }else {
                              $progressText = "Tamamlanmadı";
                              $percent = 0;

                     }
            ?>
            <div class="quests-list-body-row flex flex-wrap items-center sm:table-row">
               <div class="quests-list-body-box w-full sm:w-auto sm:table-cell sm:align-middle">
                  <div class="quests-name flex items-center"><img src="assets/images/quest/openq.png" alt="<?= $row->title?>"><span class="block truncate"><?= $row->title?></span></div>
               </div>
               <div class="quests-list-body-box sm:table-cell sm:align-middle">
                  <p><?= $row->desc?></p>
               </div>
               <div class="quests-list-body-box w-full sm:w-auto sm:table-cell sm:align-middle">
                  <span class="flex items-center whitespace-nowrap">
                     <svg viewBox="0 0 8 8" preserveAspectRatio="xMinYMin meet">
                        <path d="M8,5H5v3H3V5H0V3h3V0h2v3h3V5z"></path>
                     </svg>
                     <?= $row->experiance?> Exp
                  </span>
               </div>
               <div class="quests-list-body-box w-full sm:w-auto sm:table-cell sm:align-middle">
                  <div class="progress flex items-center">
                     <div class="progress-area relative hidden md:block">
                           <div class="progress-bar absolute" style="width: <?= $percent?>%"></div>
                     </div>
                     <div class="progress-text"><span class="block whitespace-nowrap"><?= $progressText?></span></div>
                  </div>
               
               </div>
            </div>
            <?php } } ?>
            
         </div>
      </div>
   </div>
</div>

