<div class="page flex justify-between flex-col lg:flex-row">
   <div class="page-title w-full lg:w-3/2">
      <h1>Yeni Diziler</h1>
      <p>Son çıkan en yeni dizileri türkçe dublaj ve türkçe altyazılı dil seçenekleriyle Full HD (1080p) kalitelerinde dizi izle</p>
   </div>
   <div class="page-right w-full lg:w-1/2 flex items-start justify-start lg:justify-end">
      <div class="select flex md:items-center flex-col md:flex-row">
         <div class="select-title"><span class="block">Sırala:</span></div>
         <div class="select-area relative">
            <div class="ui secondary dropdown top left pointing selection" tabindex="0">
               <i class="dropdown icon"></i>
               <div class="text"><?= $sort ?></div>
               <div class="menu transition hidden" tabindex="-1">
                  <a class="item <?= $selectedSort == 'imdb_top' ? ' active selected' : null ?>"  <?= navigo()?> href="<?= base_url("diziler/?sort=imdb_top") ?>">IMDb Puanına Göre En Yüksek</a>
                  <a class="item <?= $selectedSort == 'imdb_bottom' ? ' active selected' : null ?>"  <?= navigo()?> href="<?= base_url("diziler/?sort=imdb_bottom") ?>">IMDb Puanına Göre En Düşük</a>
                  <a class="item <?= $selectedSort == 'year_top' ? ' active selected' : null ?>"  <?= navigo()?> href="<?= base_url("diziler/?sort=year_top") ?>">Yıla Göre En Yüksek</a>
                  <a class="item <?= $selectedSort == 'year_bottom' ? ' active selected' : null ?>"  <?= navigo()?> href="<?= base_url("diziler/?sort=year_bottom") ?>">Yıla Göre En Düşük</a>
                  <a class="item <?= $selectedSort == 'date_top' ? ' active selected' : null ?>"  <?= navigo()?> href="<?= base_url("diziler/?sort=date_top") ?>">İlk Eklenene Göre</a>
                  <a class="item <?= $selectedSort == 'date_bottom' ? ' active selected' : null ?>"  <?= navigo()?> href="<?= base_url("diziler/?sort=date_bottom") ?>">Son Eklenene Göre</a>
               </div>
            </div>
            <div class="select-icon pointer-events-none absolute flex">
               <svg>
                  <use xlink:href="images/icons/down.svg#down"></use>
               </svg>
            </div>
         </div>
      </div>
   </div>
</div>


<div class="movies-list">
     <?php
      if($series){
   ?>
   <ul class="flex flex-wrap row">
      <?php
         foreach($series as $item){
            $link = base_url("dizi/$item->alias");

      ?>
        <li class="w-1/2 md:w-1/5">
            <div class="poster-long">
              <div class="poster-long-image relative">
                <?php
                    if(!empty($item->video_groups)){
                 ?>
                 <div class="movies-alternate flex justify-end">
                    <?php
                       foreach($item->video_groups as $video){
                             if(strpos($video->vg_icon, ".svg") === FALSE){
                               $icon = '<img class="lazy" data-src="'.base_url("uploads/video/group/original/$video->vg_icon").'">';
                            }else {
                                $icon = file_exists("uploads/video/group/original/$video->vg_icon") ? file_get_contents("uploads/video/group/original/$video->vg_icon") : "";
                            }
                    ?>
                    <span class="inline-block relative"  data-tooltip="<?= $video->vg_name?>" data-inverted="">
                     <?= $icon?>
                    </span>
                    <?php } ?>
                 </div>
                <?php } ?>
                <a class="block no-underline" <?= navigo()?> href="<?= $link?>">
                  <img class="lazy" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAJCAQAAACRI2S5AAAAEElEQVR42mNkIAAYRxWAAQAG9gAKqv6+AwAAAABJRU5ErkJggg==" data-src="<?= base_url("uploads/series/original/$item->image")?>" alt="<?= $item->name?>">
                  <div class="poster-long-on absolute flex items-center justify-between">
                    <span class="rating flex items-center">
                   <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 46.354 46.354" style="enable-background:new 0 0 46.354 46.354;" xml:space="preserve">
                      <g>
                        <path d="M21.57,2.049c0.303-0.612,0.927-1,1.609-1c0.682,0,1.307,0.388,1.609,1l5.771,11.695c0.261,0.529,0.767,0.896,1.352,0.981    L44.817,16.6c0.677,0.098,1.237,0.572,1.448,1.221c0.211,0.649,0.035,1.363-0.454,1.839l-9.338,9.104    c-0.423,0.412-0.616,1.006-0.517,1.588l2.204,12.855c0.114,0.674-0.161,1.354-0.715,1.756c-0.553,0.4-1.284,0.453-1.89,0.137    l-11.544-6.07c-0.522-0.275-1.147-0.275-1.67,0l-11.544,6.069c-0.604,0.317-1.337,0.265-1.89-0.136    c-0.553-0.401-0.829-1.082-0.714-1.756l2.204-12.855c0.1-0.582-0.094-1.176-0.517-1.588L0.542,19.66    c-0.489-0.477-0.665-1.19-0.454-1.839c0.211-0.649,0.772-1.123,1.449-1.221l12.908-1.875c0.584-0.085,1.09-0.452,1.351-0.982    L21.57,2.049z"></path>
                      </g>
                    </svg>
                    <?= number_format($item->imdb_rate,1)?></span>
                    <span class="year block"><?= $item->year?></span>
                  </div>
                </a>
              </div>
              <div class="poster-long-subject">
                <a class="block no-underline" <?= navigo()?> href="<?= $link?>">
                  <h2 class="truncate"><?= $item->name?> </h2>
                </a>
                <p class="truncate" title="<?= categoryParse($item->category)?>"><?= categoryParse($item->category)?></p>
              </div>
            </div>
          </li>
      <?php } ?>
   </ul>
     <?php } else {
      echo alert2('danger','Listelenecek içerik bulunamadı.');
   } ?>

</div>
  <?php
   if(!empty($pagination)){
  ?>
   <div class="pagination">
    <?= $pagination?>
   </div>
<?php } ?>
