<?php 
   $activeSeason = $season ? $season : 1;
   switch ($series->s_status) {
      case '1':
         $status = 'Sezon finali';
      break;
      case '2':
         $status = 'Final';
      break;
      case '3':
         $status = 'Ertelendi';
      break;
      case '4':
         $status = 'İptal edildi';
      break;
      default:
         $status = 'Devam ediyor';
      break;
   }
?>
<div class="page flex items-center justify-between flex-col md:flex-row">
   <div class="page-title w-full relative z-10">
      <span class="inline-block series-status finish"><?= $status?></span>
      <h1><?=$series->name?><span class="inline-block"> (<?= $series->year?>) <?= $activeSeason ? "- $activeSeason. Sezon" : ""?></span></h1>
      <p><?= $series->s_original_name?></p>
   </div>
   <div class="page-right w-full md:w-1/2 flex items-start md:justify-end relative z-30">
      <div class="page-right-button flex">
         <?php
            if($this->collections && LOGIN){
         ?>
         <button class="ui secondary scrolling button dropdown top right pointing" data-addcollections="<?= $series->id?>" tabindex="0">
            <span>Koleksiyonuma Ekle</span>
            <div class="menu" tabindex="-1">
               <?php
                  if(!empty($collections)){
                    foreach($collections as $col){
                  ?>
               <a href="javascript:;" class="item cl_add_item" data-clid="<?= $col->collection_id?>" data-list='[{"id":"<?= $series->id?>","type":"series","name":"<?= $series->name?>"}]'><?= $col->name?></a>
               <?php } } ?>
               <div class="divider"></div>
               <a <?= navigo()?> href="<?= base_url("koleksiyonlar")?>" class="item" >Koleksiyonlarım</a>
            </div>
         </button>
         <?php } ?>
        
         <button class="focus:outline-none set-follow" data-type="1" data-data="<?= $series->id?>"><?= $series->follow ? 'Takip ediliyor' : "Takip et"?></button>
      </div>
   </div>
</div>
<div class="series-profile relative z-10">
   <div class="tab">
      <ul class="flex">
         <li class="tab-active"><a class="block" <?= navigo()?> href="<?= base_url("dizi/$series->alias")?>">GENEL BAKIŞ</a></li>
         <li><a class="block" <?= navigo()?> href="<?= base_url("tartismalar")?>">TARTIŞMA KONULARI</a></li>
      </ul>
   </div>
   <div class="series-profile-content">
      <div class="series-profile-top flex items-start">
         <div class="series-profile-image md:block hidden"><a class="block" <?= navigo()?> href="<?= base_url("dizi/$series->alias")?>">
            <img src="<?=base_url("uploads/series/original/$series->image")?>" alt="<?= $series->name?>"></a>
         </div>
         <div class="series-profile-infos w-full">
           
            <div class="series-profile-summary article mb-5" data-more="Devamını oku" data-less="Gizle">
               <h2>GENEL BAKIŞ</h2>
               <p><?= $series->overview?></p>
               <small class="flex items-center flex-wrap">Bu dizi özeti &nbsp; <a class="flex items-center" <?= navigo()?> href="<?= base_url("profil/{$series->user->u_username}")?>"><img class="lazy" data-src="<?= base_url("uploads/users/{$series->user->u_avatar}")?>"> @<?= $series->user->u_username?></a> &nbsp; tarafından oluşturuldu</small>
            </div>
            <div class="series-profile-type tv-show-profile-type">
               <span class="block">Türü: <?= categoryParseLinkSeries($series->category)?></span>
            </div>
            <?php
               if($this->channel && !empty($channel_name)){
            ?>
            <div class="series-profile-channel flex">
               <a <?= navigo()?> href="<?=base_url("kanal/$channel_alias")?>" class="block mr-5">
                 <img src="https://image.tmdb.org/t/p/h50/<?= $channel_image?>" alt="<?= $channel_name?>">
               </a>
            </div>
            <?php } ?>
            <div class="series-profile-info">
               <div class="filter-result-box-bottom">
                  <ul class="flex">
                     <li class="w-auto sm:w-1/5 flex-shrink-0">
                        <span class="block">Ülke</span>
                        <p><?= $series->country?></p>
                     </li>
                     <li class="w-auto sm:w-1/5 flex-shrink-0">
                        <span class="block">Süre</span>
                        <p><?=$series->time?> dk</p>
                     </li>
                     <li class="w-auto sm:w-1/5 flex-shrink-0">
                        <span class="block">Takipçiler</span>
                        <p><?= $series->followerCount?></p>
                     </li>
                     <li class="w-auto sm:w-1/5 flex-shrink-0">
                        <span class="block">IMDB Puanı</span>
                        <p><span class="color-imdb"><?= $series->imdb_rate?></span> (3232 oy)</p>
                     </li>
                     <li class="w-auto sm:w-1/5 flex-shrink-0">
                        <span class="block">Yapım yılı</span>
                        <p><?= $series->year?></p>
                     </li>
                  </ul>
               </div>
            </div>
            <div class="series-profile-episode-buttons flex flex-col sm:flex-row">
               <a class="flex items-center w-full" <?= navigo()?> href="<?= $series->no_season ? base_url("dizi/$firstEpisode->e_link"): base_url("dizi/$series->alias/sezon-1/bolum-1")?>">
                  <div class="series-profile-episode-buttons-icon">
                     <svg>
                        <path d="M3.3 20c0 9.2 7.5 16.7 16.7 16.7s16.7-7.5 16.7-16.7-7.5-16.7-16.7-16.7-16.7 7.5-16.7 16.7zm-3.3 0c0-11 9-20 20-20s20 9 20 20-9 20-20 20-20-9-20-20zm16.2 8.1c-.5-.3-.9-.9-.9-1.5v-13.3c0-.6.3-1.2.9-1.5.5-.3 1.2-.3 1.7.1l10 6.7c.5.3.7.8.7 1.4s-.3 1.1-.7 1.4l-10 6.7c-.3.2-.6.3-.9.3-.3-.1-.5-.1-.8-.3z"></path>
                     </svg>
                  </div>
                  <div class="series-profile-episode-buttons-text">
                     <span class="block">Dizinin İlk Bölümünü İzle</span>
                     <p>1. Sezon 1. Bölüm</p>
                  </div>
               </a>
               <a class="flex items-center justify-end w-full" <?= navigo()?> href="<?= $series->no_season ? base_url("dizi/$endEpisode->e_link"): base_url("dizi/$series->alias/sezon-$endEpisode->season_number/bolum-$endEpisode->e_num")?>">
                  <div class="series-profile-episode-buttons-text">
                     <span class="block">Dizinin Son Bölümünü İzle</span>
                     <p><?= $endEpisode->season_number?>. Sezon <?= $endEpisode->e_num?>. Bölüm</p>
                  </div>
                  <div class="series-profile-episode-buttons-icon">
                     <svg>
                        <path d="M3.3 20c0 9.2 7.5 16.7 16.7 16.7s16.7-7.5 16.7-16.7-7.5-16.7-16.7-16.7-16.7 7.5-16.7 16.7zm-3.3 0c0-11 9-20 20-20s20 9 20 20-9 20-20 20-20-9-20-20zm16.2 8.1c-.5-.3-.9-.9-.9-1.5v-13.3c0-.6.3-1.2.9-1.5.5-.3 1.2-.3 1.7.1l10 6.7c.5.3.7.8.7 1.4s-.3 1.1-.7 1.4l-10 6.7c-.3.2-.6.3-.9.3-.3-.1-.5-.1-.8-.3z"></path>
                     </svg>
                  </div>
               </a>
            </div>
         
            <?php
               $fragman = false;
               $count = 0;
               if(!empty($series->fragman)){
                  $list = explode(",",$series->fragman);
                 foreach($list as $row){
                  $count += 1;

               ?>
            <div class="series-profile-trailer flex seriesFragmans"  data-target=".trailer-modal" data-yt="<?= $row?>">
               <div class="series-profile-trailer-image"><img class="lazy-wc" data-src="https://img.youtube.com/vi/<?= $row?>/0.jpg" alt="<?= $row?>"></div>
               <div class="series-profile-trailer-text relative flex-auto">
                  <span class="block">Fragman</span><small class="block">OFFICIAL TRAILER</small>
                  <p><?= $series->name?> fragmanı izle</p>
                  <div class="series-profile-trailer-year absolute"></div>
               </div>
            </div>
            <?php 
               if($count >= 2){
                  break;
               }
               } } ?>
         </div>
      </div>
      <div class="series-profile-bottom">
         <div class="row flex flex-col lg:flex-row">
            <div class="col w-full lg:w-1/3">
               <div class="series-profile-cast">
                  <h4>Öne Çıkan Oyuncular</h4>
                  <ul class="flex sm:block">
                     <?php
                        $castList = false;
                        if(!empty($series->cast_list)){
                          $count = 0;
                          foreach($series->cast_list as $cast){
                              if($this->cast){
                                $link = base_url("oyuncu/$cast->alias");
                              }else {
                                $link = "javascript:;";
                              }
                              if(!$this->frontSettings->tmdbImage){
                                 $image =  base_url("uploads/cast/original/$cast->image");
                              }else {
                                 $image =  "https://image.tmdb.org/t/p/w185$cast->image";
                              }
                        ?>
                     <li class="w-auto sm:w-full flex-shrink-0">
                        <a class="flex items-center flex-col sm:flex-row" <?= $this->cast ? navigo() : ''?> href="<?= $link ?>">
                           <img class="lazy" data-src="<?= $image?>" alt="<?= $cast->name?>">
                           <div class="series-profile-cast-info text-center sm:text-left">
                              <h5 class="truncate"><?= $cast->name?></h5>
                              <p class="truncate"><?= $cast->character_name?></p>
                           </div>
                        </a>
                     </li>
                     <?php } } ?>
                  </ul>
               </div>
            </div>
            <div class="col w-full lg:w-2/3">
               <div class="series-profile-episodes">
                  <div class="series-profile-episodes-top flex sm:items-center justify-between flex-col sm:flex-row">
                     <h4><span><?= $series->name?> <data>1</data>. Sezon</span></h4>
                     <div class="checkbox">
                        <label class="flex items-center">
                        <input type="checkbox" class="hidden allseries" data-all="1" data-tvseries="<?= $series->id?>" value="1"/>
                        <span class="flex items-center justify-center checkbox-icon"></span>
                        <span class="checkbox-text">Tümünü İzlendi İşaretle</span>
                        </label>
                     </div>
                  </div>
                  <div class="series-profile-episodes-box flex flex-col md:flex-row">
                     <div class="series-profile-episodes-nav relative">
                        <ul class="flex md:block">
                           <?php
                              $count = 0;
                                 if(!empty($series->season)){
                                    foreach($series->season as $season){
                                       $count += 1;
                                       if($count == 1 && !$activeSeason){
                                          $activeTab = 'class="series-tab-nav-active"';
                                       }else if($activeSeason && $activeSeason == $season->s_num){
                                          $activeTab = 'class="series-tab-nav-active"';
                                       }else {
                                          $activeTab = "";
                                       }
                                       // if($count == 1 && !$seasonUri){
                                       //   $activeTab = 'class="series-tab-nav-active"';
                                       // }else if($i->s_num == str_replace('sezon-','',$seasonUri)){
                                       //   $activeTab = 'class="series-tab-nav-active"';
                                       // }else {
                                       //   $activeTab = "";
                                       // }
                              ?>
                           <li <?= $activeTab ?> data-watched="<?= $season->watched ? 1 : 0?>" data-num="<?=$season->s_num?>" data-season="sea-<?=$season->s_num?>">
                              <a class="flex items-center h-full" onclick="return false"  href="<?= base_url("dizi/$series->alias/sezon-$season->s_num")?>">
                                 Sezon&nbsp;
                                 <data itemprop="name"><?=$season->s_num?></data>
                              </a>
                           </li>
                           <?php } } ?>
                        </ul>
                     </div>
                     <div class="series-profile-episodes-areas flex-auto">
                        <?php
                        $count = 0;
                           if(!empty($series->season)){
                              foreach($series->season as $season){
                                 $count += 1;
                                 $seasonNumber = $season->s_num;
                                 $episodeList = array_filter($series->episodes,function($item) use($seasonNumber){
                                    if($item->season == $seasonNumber){
                                       return $item;
                                    }
                                 });

                                 if($count == 1 && !$activeSeason){
                                    $activeTab = 'series-tab-content-active';
                                 }else if($activeSeason && $activeSeason == $season->s_num){
                                    $activeTab = 'series-tab-content-active';
                                 }else {
                                    $activeTab = "";
                                 }

                           ?>
                        <div class="series-profile-episodes-area <?= $activeTab?>" id="sea-<?=$season->s_num?>">
                           <div class="series-profile-episode-list">
                              <ul>
                                 <?php
                                    if($episodeList){
                                       foreach($episodeList as $row){
                                          // if($series->no_season){
                                          //   $link = base_url($row->e_link);
                                          // }else{
                                          // }
                                          $link = $series->no_season ? base_url("dizi/$row->e_link"): base_url("dizi/$series->alias/sezon-{$season->s_num}/bolum-{$row->e_num}");

                                          $date = explode("-",$row->e_date);
                                          if($season->watched){
                                             $checkWatch = "checked";
                                          }else {
                                             $checkWatch = $row->watched ? 'checked' : null;
                                          }
                                    ?>
                                 <li class="flex items-center justify-between">
                                    <div class="series-profile-episode-list-left flex items-center">
                                       <div class="checkbox">
                                          <label class="flex items-center">

                                          <input type="checkbox" data-season="<?= $row->season_number?>" data-series="<?= $series->id?>" data-addwatch="<?= $row->e_id?>" class="hidden episodeWc_<?= $season->s_num?>" <?= $checkWatch ?> value="<?= $row->e_id?>">
                                          <span class="flex items-center justify-center checkbox-icon"></span>
                                          </label>
                                       </div>
                                       <a class="truncate" <?= navigo()?> href="<?=$link?>">Bölüm <data><?=$row->e_num?></data></a>
                                       <h6 class="truncate">
                                          <a class="block truncate <?= strtotime($row->e_air_date) > time() ? 'not-published' : '';?>" <?= navigo()?> href="<?=$link?>"><?=$row->e_name;?></a>
                                       </h6>
                                    </div>
                                    <span class="block <?= strtotime($row->e_air_date) > time() ? 'not-published-text' : '';?>"><?= dates2($row->e_air_date,false)?></span>
                                 </li>
                                 <?php } } ?>
                              </ul>
                           </div>
                        </div>
                        <?php } } ?>
                     </div>
                  </div>
               </div>
               <div class="comment">
                  <div class="comment-head">
                     <h4>Yorumlar ( <?= $series->comment_count?> )</h4>
                  </div>
                  <div class="comment-reviews">
                     <?php
                        if(LOGIN){
                     ?>
                     <div class="comment-review-form">
                        <form action="" method="">
                           <textarea placeholder="Yorumunuz" spellcheck="false" data-autoresize="1"  data-id="<?= $series->id?>"  data-type="1" id="commentData"></textarea>
                           <div id="commentData-container"></div>
                           <span class="textarea-length">500 karakter daha yazabilirsiniz</span>
                           <div class="comment-review-form-bottom flex sm:items-center items-start sm:justify-between flex-col sm:flex-row">
                             <div class="checkbox">
                               <label class="flex items-center">
                                 <input class="hidden" type="checkbox" id="commentSpoiler" value="1"><span class="flex items-center justify-center checkbox-icon"></span><span class="checkbox-text">Yorumunuz spoiler içeriyor mu ?</span>
                               </label>
                             </div>
                             <button onclick="addComment(this)" class="focus:outline-none">Yorum Ekle</button>
                           </div>
                        </form>
                    </div>
                     <?php } else { 
                        echo alert2('danger','Yorum yapabilmek için lütfen giriş yap.');
                     } ?>
                     <div class="comment-review-list">
                        <?php
                           if(!empty($series->comments)){
                              foreach($series->comments as $comment){
                        ?>
                        <div class="comment-review-box flex relative <?= $comment->spoiler ? 'comment-spoiler' : null?>" id="comment-<?= $comment->comment_id?>">
                           <img class="flex-shrink-0 lazy" data-src="<?= base_url("uploads/users/$comment->u_avatar")?>" alt="<?= $comment->u_username?>">
                           <div class="comment-review-box-subject flex-1 relative">
                              <div class="comment-review-box-top <?= $comment->u_type == 3 ? 'admin' : '' ?> relative flex items-center">
                                 <h6 class="truncate"><a class="block" <?= navigo()?> href="<?= base_url("profil/$comment->u_username")?>"><?= $comment->u_name?></a></h6>
                                 <time><?= zaman($comment->created_at)?></time>
                                 <?php
                                    if($comment->user_id == $this->user_id || ADMIN){
                                 ?>
                                 <div class="comment-action flex absolute">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                       <polyline points="6 9 12 15 18 9"></polyline>
                                    </svg>
                                    <div class="comment-action-options absolute">
                                       <ul>
                                          <li><a class="block" data-type="comment" data-delete="<?= $comment->comment_id?>" href="javascript:void(0);">Yorumu Sil</a></li>
                                       </ul>
                                    </div>
                                 </div>
                                 <?php } ?>
                              </div>
                              <div class="comment-review-box-content">
                                 <p><?= $comment->comment?></p>
                              </div>
                              <div class="comment-review-box-bottom">
                                 <div class="comment-review-box-actions flex items-center">
                                    <button class="flex items-center focus:outline-none fnc_addFeel <?= !empty($comment->action) && $comment->action == 1 ? 'comment-action-active' : null ?>"  data-type="comment" data-action="1" data-id="<?= $comment->comment_id?>">
                                       <svg>
                                          <path d="M7.301 4.875h3.488c.65 0 1.298.244 1.704.813.406.406.568 1.056.487 1.706l-.65 3.737C12.169 12.187 11.277 13 10.223 13H3V6.5L5.192.406c0-.244.243-.406.487-.406C6.652 0 7.3.406 7.3 1.625v3.25zM0 6h2v7H0V6z"></path>
                                       </svg>
                                       <span class="inline-block"><?= $comment->like_action_count?></span>
                                    </button>
                                    <button class="flex items-center focus:outline-none fnc_addFeel <?= !empty($comment->action) && $comment->action == 3 ? 'comment-action-active' : null ?>" data-type="comment" data-action="3" data-id="<?= $comment->comment_id?>">
                                       <svg>
                                          <path d="M5.699 8.125H2.21c-.65 0-1.298-.244-1.704-.813C.101 6.907-.061 6.256.02 5.607L.67 1.87C.831.813 1.723 0 2.777 0H10v6.5l-2.192 6.094c0 .244-.243.406-.487.406-.973 0-1.622-.406-1.622-1.625v-3.25zM13 7h-2V0h2v7z"></path>
                                       </svg>
                                       <span class="inline-block"><?= $comment->dislike_action_count?></span>
                                    </button>
                                    <a class="inline-block reply-comment" href="javascript:void(0);">Cevapla ( <?= $comment->sub_count?> )</a>
                                 </div>
                              </div>
                             
                              <!-- Reply List -->
                              <div class="comment-review-box-reply-list">
                                 <div class="comment-review-box-reply-form">
                                    <form class="flex" action="" method="">
                                       <input placeholder="Cevapla" spellcheck="false" data-id="<?= $series->id?>" data-comment="<?= $comment->comment_id?>" class="comment-reply-input">
                                       <button class="focus:outline-none commentReply">Cevapla</button>
                                    </form>
                                 </div>
                                 <?php
                                    if(!empty($comment->sub_comments)){
                                 ?>
                                 <ul class="reply-list-wrapper">
                                     <?php 
                                          foreach($comment->sub_comments as $sub_comment){
                                    ?>
                                    <li id="comment-<?= $sub_comment->comment_id?>">
                                       <div class="comment-review-box flex">
                                          <img class="flex-shrink-0 lazy" data-src="<?= base_url("uploads/users/$sub_comment->u_avatar")?>" alt="<?= $sub_comment->u_username?>">
                                          <div class="comment-review-box-subject flex-1">
                                             <div class="comment-review-box-top <?= $sub_comment->u_type == 3 ? 'admin' : '' ?> flex items-center relative">
                                                <h6 class="truncate"><a class="block" <?= navigo()?> href="<?= base_url("profil/$sub_comment->u_username")?>"><?= $sub_comment->u_name?></a></h6>
                                                <time><?= zaman($sub_comment->created_at)?></time>
                                                <div class="comment-action flex absolute">
                                                   <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                      <polyline points="6 9 12 15 18 9"></polyline>
                                                   </svg>
                                                   <div class="comment-action-options absolute">
                                                      <ul>
                                                         <li><a class="block" data-type="comment" data-delete="<?= $sub_comment->comment_id?>" href="javascript:void(0);">Yorumu Sil</a></li>
                                                      </ul>
                                                   </div>
                                                </div>
                                             </div>
                                             <div class="comment-review-box-content">
                                                <p><?= $sub_comment->comment?></p>
                                             </div>
                                             <div class="comment-review-box-bottom">
                                                <div class="comment-review-box-actions flex items-center">
                                                   <button class="flex items-center focus:outline-none fnc_addFeel <?= !empty($sub_comment->action) && $sub_comment->action == 1 ? 'comment-action-active' : null ?>" data-type="comment" data-action="1" data-id="<?= $sub_comment->comment_id?>">
                                                      <svg>
                                                         <path d="M7.301 4.875h3.488c.65 0 1.298.244 1.704.813.406.406.568 1.056.487 1.706l-.65 3.737C12.169 12.187 11.277 13 10.223 13H3V6.5L5.192.406c0-.244.243-.406.487-.406C6.652 0 7.3.406 7.3 1.625v3.25zM0 6h2v7H0V6z"></path>
                                                      </svg>
                                                      <span class="inline-block"><?= $sub_comment->like_action_count?></span>
                                                   </button>
                                                   <button class="flex items-center focus:outline-none fnc_addFeel <?= !empty($sub_comment->action) && $sub_comment->action == 3 ? 'comment-action-active' : null ?>" data-type="comment" data-action="3" data-id="<?= $sub_comment->comment_id?>">
                                                      <svg>
                                                         <path d="M5.699 8.125H2.21c-.65 0-1.298-.244-1.704-.813C.101 6.907-.061 6.256.02 5.607L.67 1.87C.831.813 1.723 0 2.777 0H10v6.5l-2.192 6.094c0 .244-.243.406-.487.406-.973 0-1.622-.406-1.622-1.625v-3.25zM13 7h-2V0h2v7z"></path>
                                                      </svg>
                                                      <span class="inline-block"><?= $sub_comment->dislike_action_count?></span>
                                                   </button>
                                                </div>
                                             </div>
                                          </div>
                                       </div>
                                    </li>
                                 <?php } ?>
                                 </ul>
                                 <?php } ?>

                              </div>
                      
                           </div>
                           <?php
                              if($comment->spoiler){
                           ?>
                           <div class="comment-spoiler-content flex items-center justify-center absolute">
                             <button class="focus:outline-none">Bu yorum bölüm hakkında spoiler içerir. Okumak isterseniz tıklayın</button>
                           </div>
                           <?php } ?>
                        </div>
                        <?php } } ?>
                     </div>
                  </div>
                  <?php
                     if($series->comment_count > $this->seriesProfileComment) {
                  ?>
                  <button class="load-more-series w-full flex items-center justify-center focus:outline-none" data-type="1" data-load-comment="<?=$series->id?>" data-page="2"><svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg> Daha Fazla Göster</button>
                   <?php } ?>
                 
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
