<div class="page flex justify-between other-title">
    <div class="page-title">
      <h1>Hot 40</h1>
      <p>Sitemizde bulunan en çok izlenen dizi ve filmleri aylık, haftalık ve günlük olarak takip edebilirsin.</p>
    </div>
  </div>
  <div class="page-tab-reverse">
    <ul class="flex overflow-auto lg:overflow-hidden">
      <li <?= !$status ? 'class="page-tab-reverse-active"' : null ?>>
        <a <?= navigo()?> href="<?= base_url("hot-40")?>"  class="block whitespace-no-wrap">Tüm Zamanlar</a>
      </li>
      <li <?= $status == 'daily' ? 'class="page-tab-reverse-active"' : null ?>>
        <a <?= navigo()?> href="<?= base_url("hot-40?status=daily")?>"  class="block whitespace-no-wrap">Günlük Hot 40</a>
      </li>
      <li <?= $status == 'weekly' ? 'class="page-tab-reverse-active"' : null ?>>
        <a <?= navigo()?> href="<?= base_url("hot-40?status=weekly")?>"  class="block whitespace-no-wrap">Haftalık Hot 40</a>
      </li>
      <li <?= $status == 'montly' ? 'class="page-tab-reverse-active"' : null ?>>
        <a <?= navigo()?> href="<?= base_url("hot-40?status=montly")?>"  class="block whitespace-no-wrap">Aylık Hot 40</a>
      </li>
    </ul>
  </div>
  <div class="hot40">
    <?php
      if(!empty($result)){
    ?>
    <ul class="flex flex-wrap">
      <?php
        foreach($result as $row){
              if(!empty($row->category == 'series')){
                 $trendType = 'Dizi';
                 $link = base_url("dizi/$row->alias");
                 $image = base_url("uploads/series/cover/original/$row->cover");
               }else if(!empty($row->category == 'animes')){
                 $trendType = 'Anime';
                 $link = base_url("anime/$row->alias");
                 $image = base_url("uploads/animes/cover/original/$row->cover");
               }else {
                 $trendType = 'Film';
                 $link = base_url("film/$row->alias");
                 $image = base_url("uploads/movies/cover/original/$row->cover");
               }
      ?>
      <li class="md:w-1/2 w-full">
          <a class="block relative" <?= navigo()?> href="<?= $link?>" >
            <img src="<?= $image?>" alt="<?= $row->name?>" />
            <div class="hot40-on absolute flex items-center justify-between">
              <div class="hot40-on-left"><span class="flex items-center"><?= $row->name?></span>
                <p><?= categoryParse($row->category)?></p>
                <div class="imdb-points">
                  <span class="flex items-center">
                    <svg>
                      <path d="M12.3 4.1l-3.5-.5-1.6-3.2c-.2-.5-1.2-.5-1.4 0l-1.6 3.2-3.5.5c-.7.1-.9.9-.5 1.4l2.6 2.5-.6 3.5c-.1.7.6 1.2 1.2.9l3.1-1.6 3.1 1.6c.6.3 1.3-.2 1.2-.9l-.6-3.5 2.5-2.5c.5-.5.3-1.3-.4-1.4z"></path>
                    </svg><?= number_format($row->imdb_rate,1)?>               </span>
                </div>
              </div>
              <div class="hot40-on-right">
                <div class="trend-point relative flex items-center justify-center"><span class="block"><?= $row->total?><sup>%</sup></span>
                  <div class="trend-point-circle absolute">
                    <svg class="control" data-percent="<?= $row->total?>" viewBox="0 0 120 120">
                      <circle class="progress__meter" cx="60" cy="60" r="54" stroke-width="10"></circle>
                      <circle class="progress__value" cx="60" cy="60" r="54" stroke-width="10"></circle>
                    </svg>
                  </div>
                </div>
              </div>
            </div>
          </a>
        </li>
      <?php } ?>
    </ul>
    <?php }else {
      echo alert2('danger','Ateşli liste hazırlanıyor. Lütfen daha sonra tekrar gel.');
    } ?>

  </div>
</div>
