<div class="page flex justify-between other-title">
   <div class="page-title">
      <h1>IMDb Top 250 Filmleri</h1>
      <p>IMDb de bulunan Top 250 filmlerinin hepsini sitemizden full hd 1080p görüntü kalitesindee Türkçe Dublaj ve Türkçe Altyazı seçenekleri ile izleyebilirsiniz.</p>
   </div>
</div>
<div class="top-rated-area">
   <div class="top-rated-list overflow-x-auto">
      <ul class="table w-full">
         <li class="table-row">
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap text-center">
               <span class="block">Rank</span>
            </div>
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap">
               <span class="block">Film</span>
            </div>
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap text-center">
               <span class="block">İzleme Seçeneği</span>
            </div>
        
            <div class="top-rated-box table-cell align-middle  text-center">
               <span class="block">Tür</span>
            </div>
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap text-center">
               <span class="block">IMDb Puanı</span>
            </div>
        
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap">
               <span class="block"></span>
            </div>
         </li>
         <?php
            if(!empty($result)){
               $page = $this->uri->segment(2) ? $this->uri->segment(2) : 1;
               $count =$page * 20 - 20;
               foreach($result as $row){
                  $count +=1;
         ?>
         <li class="table-row">
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap text-center top-rated-rank">
               <p><?= $count?></p>
            </div>
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap">
               <div class="top-rated-poster flex items-center">
                  <div class="top-rated-poster-image flex-shrink-0">
                     <a href="<?= base_url("film/$row->alias")?>" class="block">
                     <img class="lazy" data-src="<?= base_url("uploads/movies/original/$row->image")?>" alt="<?= $row->name?>">
                     </a>
                  </div>
                  <div class="top-rated-poster-text">
                     <span class="flex" title="<?= $row->name?>">
                        <a href="<?= base_url("film/$row->alias")?>" class="inline-block truncate" title="<?= $row->name?>"><?= kisalt($row->name,20)?>  (<?= $row->year?>)</a>
                     </span>
                     <p title=""><?= kisalt($row->original_name,30)?></p>
                  </div>
               </div>
            </div>
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap text-center">
               <div class="top-rated-watch-options">
                  <ul class="flex items-center justify-center">
                     <?php
                        if(!empty($row->groups)){
                           list($title,$slug,$icon) = explode("|", $row->groups);
                     ?>
                     <li>
                        <a href="<?= base_url("film/$row->alias")?>/<?= $slug?>" class="block" data-tooltip="<?= $title?>" data-inverted="">
                           <img class="lazy" data-src="<?= base_url("uploads/video/group/original/$icon")?>">
                        </a>
                     </li>
                     <?php } ?>
                     
                  </ul>
               </div>
            </div>
         
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap text-center">
               <p class="truncate"><?= categoryParse($row->category,false,1)?></p>
            </div>
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap text-center">
               <div class="top-rated-imdb">
                  <span class="flex items-center justify-center">
                     <svg>
                        <path d="M12.3 4.1l-3.5-.5-1.6-3.2c-.2-.5-1.2-.5-1.4 0l-1.6 3.2-3.5.5c-.7.1-.9.9-.5 1.4l2.6 2.5-.6 3.5c-.1.7.6 1.2 1.2.9l3.1-1.6 3.1 1.6c.6.3 1.3-.2 1.2-.9l-.6-3.5 2.5-2.5c.5-.5.3-1.3-.4-1.4z"></path>
                     </svg>
                     <?= $row->imdb_rate?>
                  </span>
               </div>
            </div>
           
            <div class="top-rated-box table-cell align-middle whitespace-no-wrap text-center">
               <button class="focus:outline-none set-follow" data-type="2" data-data="<?= $row->id?>"><?= $row->follow ? 'Takip ediliyor' : "Takip et"?></button>
            </div>
         </li>
         <?php } } ?>
      </ul>
   </div>
   <div class="pagination"><?= $pagination?></div>
</div>
