<div class="page flex justify-between flex-col md:flex-row aspage">
 <div class="page-title md:w-1/2">
   <h1 class="flex">Hesap ayarlarım</h1>
   <p>Burada profil fotoğrafını yükleyebilir, kişisel bilgilerini düzenleyebilir, istersen de şifreni değiştirebilirsin.</p>
 </div>
 <div class="page-right md:w-1/2 flex items-start md:justify-end">
   <div class="page-right-button flex">
     <a  class="focus:outline-none" href="<?= base_url("profil/{$this->user->u_username}")?>">Profile Dön</a>
   </div>
 </div>
</div>
<div class="settings tab">
 <div class="settings-nav">
   <ul class="flex">
     <li class="settings-nav-active" data-tab="tab-1"><a class="block" href="javascript:void(0);">Kişisel Bilgiler</a></li>
     <li data-tab="tab-2"><a class="block" href="javascript:void(0);">Şifre Değiştir</a></li>
     <li data-tab="tab-3"><a class="block" href="javascript:void(0);">Sosyal Medya</a></li>
   </ul>
 </div>
 <div class="settings-contents">
   <div class="settings-content settings-content-active" id="tab-1">
     <div class="row flex items-start flex-col lg:flex-row">
       <div class="col w-full lg:w-1/3">
         <div class="settings-profile-photo"><span class="block">Profil Fotoğrafı</span>
           <div class="settings-profile-photo-change relative">
             <label class="flex flex-col items-center">
               <?php
                    if($user->u_id == $this->user_id){
                  ?>
                  <form action="" method="post" enctype="multipart/form-data" accept-charset="utf-8">
                   <input type="file" name="avatar" id="profilePhoto">
                  </form>
                  <?php } ?>
               <img src="<?= base_url("uploads/users/$user->u_avatar")?>" alt="<?=$user->u_name?>">
               <span class="block">Fotoğraf yükle</span>
             </label>
             <p class="text-center">Fotoğrafını JPG, GIF veya PNG olarak yükleyebilirsin.</p>
           </div>
         </div>
       </div>
       <div class="col w-full lg:w-2/3">
         <div class="settings-profile-infos"><span class="block">Kişisel Bilgiler</span>
           <div class="settings-profile-infos-form">
             <form action="" onsubmit="return false" method="POST">
               <div class="input-group">
                 <div class="input-element">
                   <label class="block" for="name">Adı</label>
                   <input type="text" id="name" value="<?=$user->u_name?>">
                 </div>
                 <div class="input-element">
                   <label class="block" for="username">Kullanıcı adı</label>
                   <input type="text" id="username" disabled placeholder="<?=$user->u_username?>">
                   <p>Profil adresin: <?= base_url(lang("profile")."/$user->u_username")?> (Kullanıcı adı değiştirilemez)</p>
                 </div>
                 <div class="input-element">
                   <label class="block" for="emailAddress">E-posta adresi</label>
                   <input type="email" id="email" value="<?=$user->u_email?>">
                 </div>
                  <div class="input-element">
                     <label class="block" for="place">Yer &amp; Mekan</label>
                     <input type="text" id="location" maxlength="30" value="<?= $user->country?>">
                  </div>
                 <div class="input-element">
                   <label class="block" for="about">Hakkında</label>
                   <textarea data-autoresize id="bio" maxlength="30"><?= $user->u_bio?></textarea>
                 </div>
                 <div class="input-element">
                   <button id="save-btn" class="focus:outline-none">Bilgileri Güncelle</button>
                 </div>
               </div>
             </form>
           </div>
         </div>
       </div>
     </div>
   </div>
   <div class="settings-content" id="tab-2">
     <div class="row flex items-start flex-col lg:flex-row">
       <div class="col w-full lg:w-1/3">
         <div class="settings-profile-infos"><span class="block">ŞİFRE AYARLARIM</span>
           <p>Şifren en az 4 karakterden oluşmalıdır</p>
         </div>
       </div>
       <div class="col w-full lg:w-2/3">
         <div class="settings-profile-infos"><span class="block">ŞİFRENİ DEĞİŞTİR</span>
           <div class="settings-profile-infos-form">
            <div class="form-result"></div>
              <form action="" class="password-form" onsubmit="return false" method="POST">
               <div class="input-group">
                 <div class="input-element">
                   <label class="block" for="availablePassword">Mevcut Şifren</label>
                   <input type="password" name="currentPassword" id="old-ps" placeholder="Mevcut Şifren">
                 </div>
                 <div class="input-element">
                   <label class="block" for="newPassword">Yeni Şifren</label>
                   <input type="password" name="newPassword" id="new-ps" placeholder="">
                 </div>
                 <div class="input-element">
                   <label class="block" for="newPasswordAgain">Yeni Şifren ( Tekrar )</label>
                   <input type="password" name="newPasswordAgain" id="newPasswordAgain">
                 </div>
                 <div class="input-element">
                   <button id="ps-btn" class="focus:outline-none">Şifreyi Güncelle</button>
                 </div>
               </div>
             </form>
           </div>
         </div>
       </div>
     </div>
   </div>
   <div class="settings-content" id="tab-3">
     <div class="row flex items-start flex-col lg:flex-row">
       <div class="col w-full lg:w-1/3">
         <div class="settings-profile-infos"><span class="block">BİLGİ</span>
           <p>Sosyal medya hesapların varsa, burada kullanıcı adını girerek diğer kullanıcıların seni bulmalarını sağlayabilirsin.</p>
         </div>
       </div>
       <div class="col w-full lg:w-2/3">
         <div class="settings-profile-infos"><span class="block"></span>
           <div class="settings-profile-infos-form">
             <form action="" onsubmit="return false" method="POST">
               <div class="input-group">
                 <div class="input-element">
                   <label class="block" for="facebook">Facebook</label>
                   <input type="text" id="facebook" value="<?= $user->u_facebook?>" placeholder="">
                 </div>
                 <div class="input-element">
                   <label class="block" for="twitter">Twitter</label>
                   <input type="text" id="twitter" value="<?= $user->u_instagram?>" placeholder="">
                 </div>
                 <div class="input-element">
                   <label class="block" for="instagram">Instagram </label>
                   <input type="text" id="instagram" value="<?= $user->u_twitter?>"  placeholder="">
                 </div>
                 <div class="input-element">
                   <button class="focus:outline-none" data-social="1">Bilgilerini Güncelle</button>
                 </div>
               </div>
             </form>
           </div>
         </div>
       </div>
     </div>
   </div>
 </div>
</div>
