<div class="user-profile-content-in flex items-start flex-col xl:flex-row">
   <div class="user-profile-content-left w-full xl:w-2/3 flow-posts">
      <ul>
        <?php 
         if(!empty($posts)){
            foreach($posts as $posts){
               if($posts->action){
                  $parse_action = explode("|", $posts->action);
                  list($post_action_id,$action_id,$action_title,$action_image) = $parse_action;
               }
               if($posts->poll_values){
                  $text = "anket";
               }else {
                  $text = "gönderi";
               }
      ?>
      <li id="post-<?= $posts->flow_post_id?>">
         <div class="post">
            <div class="post-header flex items-center justify-between">
               <div class="user-medium flex items-center">
                  <div class="user-medium-image flex-shrink-0"><a class="block" href="<?= base_url("profil/$posts->u_username")?>"><img class="lazy" data-src="<?= base_url("uploads/users/$posts->u_avatar")?>" alt="<?= $posts->u_name?>"></a></div>
                  <div class="user-medium-text">
                     <span class="block"><a class="inline-block" href="<?= base_url("profil/$posts->u_username")?>"><?= $posts->u_name?></a> bir <strong><?=$text?> </strong>paylaştı</span>
                     <p><?= zaman($posts->created_at)?></p>
                  </div>
               </div>
               <?php 
                  if($posts->user_id == $this->user_id || ADMIN){
               ?>
               <div class="options-drop relative">
                  <button class="flex focus:outline-none">
                     <svg viewBox="0 0 22 6">
                        <path d="M19,6c-1.657,0-3-1.344-3-3c0-1.656,1.343-3,3-3s3,1.344,3,3C22,4.656,20.657,6,19,6z M19,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C20,2.447,19.552,2,19,2z M11,6C9.343,6,8,4.656,8,3c0-1.656,1.343-3,3-3s3,1.344,3,3C14,4.656,12.657,6,11,6z M11,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C12,2.447,11.552,2,11,2z M3,6C1.343,6,0,4.656,0,3c0-1.656,1.343-3,3-3c1.656,0,3,1.344,3,3C6,4.656,4.656,6,3,6z M3,2C2.447,2,2,2.447,2,3c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C4,2.447,3.552,2,3,2z"></path>
                     </svg>
                  </button>
                  <div class="options-drop-content absolute">
                     <ul>
                        <?php 
                           if(!$posts->poll_values){
                        ?> 
                        <li><a class="block" href="javascript:void(0);" data-flow-edit="<?= $posts->flow_post_id?>">Gönderiyi Düzenle</a></li>
                        <?php } ?>
                        <li><a class="block second" href="javascript:void(0);" data-type="flow" data-delete-post="<?= $posts->flow_post_id?>">Gönderiyi Sil</a></li>
                     </ul>
                  </div>
               </div>
               <?php } ?>
            </div>
            <div class="post-content">
               <p id="post<?= $posts->flow_post_id?>"><?= $posts->post?></p>
               <?php
                  if($posts->poll){
                     echo $this->load->view(FRONT_THEME_FILE."template/Flow/poll-box",$posts,true);
                  }
               ?>
               <?php 
                  if(!empty($posts->post_images)){
                     $total_count = count($posts->post_images) - 4;
               ?> 
               <div class="post-content-images">
                  <ul class="flex flex-wrap">
                     <?php 
                     $count = 0;
                        foreach($posts->post_images as $images){
                           $count += 1;
                           if(count($posts->post_images) == 1){
                              $class = "w-full";
                           }else if($count == 2 || $count == 1){
                              $class = "w-1/2";
                           }else {
                              $class = "w-1/3";
                           }
                     ?>
                     <li class="relative <?= $class ?> <?= $count > 4 && $count != 5 ? 'hidden' : null ?>">
                        <a class="block" href="<?= base_url("uploads/flow/post/original/$images->image")?>" data-fancybox="gallery">
                           <img class="lazy" data-src="<?= base_url("uploads/flow/post/original/$images->image")?>" alt="">
                           <?php 
                              if($count > 4){
                           ?>
                           <div class="post-content-images-on absolute flex items-center justify-center"><span class="block">+<?= $total_count?></span></div>
                        <?php } ?>
                        </a>
                     </li>
                     <?php } ?>
                  </ul>
               </div>
               <?php } ?>
            </div>
            <div class="post-action flex items-center justify-between">
               <div class="reactions flex items-center">
                  <ul class="mobile-reactions block sm:hidden">
                     <li class="relative flex-shrink-0">
                        <?php 
                           if(!empty($posts->action_list)){
                        ?>
                        <img class="lazy" data-src="/assets/images/reaction/like.png" alt="">
                        <div class="tooltip absolute">
                           <ul>
                              <?php 
                                 foreach($posts->action_list as $action){
                              ?>
                              <li class="flex items-center">
                                 <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                 <span class="block"><?= $action->total_action?></span>
                              </li>
                              <?php } ?>
                           </ul>
                        </div>
                        <?php } ?>
                     </li>
                  </ul>
                  <ul class="hidden sm:flex">
                     <?php 
                        if(!empty($posts->action_list)){
                           foreach($posts->action_list as $action){
                     ?>
                     <li class="relative flex-shrink-0">
                        <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                        <?php 
                           if(!empty($action->users)){
                        ?>
                        <div class="tooltip absolute">
                           <small class="flex items-center"><img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>"><?= $action->title?></small>
                           <ul>
                             <?php 
                                 foreach($action->users as $users){
                             ?> 
                              <li><?= $users->u_name?></li>
                              <?php } ?>
                              <?php 
                                 if(count($action->users) > 6){
                              ?>
                              <li><strong><?= $action->total_action?> kişi daha..</strong></li>
                              <?php } ?>
                           </ul>
                        </div>
                        <?php } ?>
                     </li>
                     <?php } } ?>
                  </ul>
                  <span class="block"><?= $posts->action_count?></span>
               </div>
               <ul class="flex">
                  <li><button class="focus:outline-none"><?= $posts->comment_count?> Yorum</button></li>
               </ul>
            </div>
            <div class="post-footer">
               <ul class="flex justify-around">
                  <li class="relative actions-content">
                     <?php 
                        if($posts->action){
                     ?>
                     <button class="flex items-center focus:outline-none active delete-action" data-id="<?= $post_action_id?>" data-type="flow">
                        <img class="lazy" width="22" height="22" data-src="<?= base_url("uploads/reaction/original/{$action_image}")?>" alt="<?= $action_title?>">
                        <span class="hidden sm:block"><?= $action_title?></span>
                     </button>
                     <?php }else { ?>
                        <button class="flex items-center <?= LOGIN ? 'reaction-button' : null ?> focus:outline-none" <?= login_check()?>>
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28a2 2 0 0 0 2-1.7l1.38-9a2 2 0 0 0-2-2.3zM7 22H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h3"></path>
                           </svg>
                           <span class="hidden sm:block">Beğen</span>
                        </button>
                     <?php } ?>
                     <div class="reactions-drop absolute">
                        <ul class="flex">
                            <?php 
                              if(!empty($actions)){
                                 foreach($actions as $action){
                           ?>
                           <li>
                              <button class="relative focus:outline-none set-action" data-type="flow" data-id="<?= $posts->flow_post_id ?>" data-action="<?= $action->action_id?>">
                                 <img src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                 <div class="tooltip absolute"><small class="flex items-center"><?= $action->title?></small></div>
                              </button>
                           </li>
                           <?php } } ?>
                           
                        </ul>
                     </div>
                  </li>
                  <li>
                     <button class="flex items-center focus:outline-none">
                        <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                           <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                        </svg>
                        <span class="hidden sm:block">Yorum</span>
                     </button>
                  </li>
                  <li>
                     <button class="flex items-center focus:outline-none flow-share" data-target=".share-modal">
                        <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                           <circle cx="18" cy="5" r="3"></circle>
                           <circle cx="6" cy="12" r="3"></circle>
                           <circle cx="18" cy="19" r="3"></circle>
                           <line x1="8.59" y1="13.51" x2="15.42" y2="17.49"></line>
                           <line x1="15.41" y1="6.51" x2="8.59" y2="10.49"></line>
                        </svg>
                        <span class="hidden sm:block">Paylaş</span>
                     </button>
                  </li>
               </ul>
            </div>

            <div class="post-comment">
               <?php 
                  if(!empty($posts->comment)){
               ?>
               <ul>
                  <?php 
                     foreach($posts->comment as $comment){
                        if($comment->action){
                           $parse_action = explode("|", $comment->action);
                           list($post_action_id,$action_id,$action_title,$action_image) = $parse_action;
                        }
                  ?>
                  <li>
                     <div class="post-comment-box flex items-start">
                        <div class="user-medium-image flex-shrink-0"><a class="block" href="<?= base_url("profil/$comment->u_username")?>"><img class="lazy" data-src="<?= base_url("uploads/users//$comment->u_avatar")?>" alt="<?= $comment->u_name?>"></a></div>
                        <div class="user-medium-text">
                           <span class="flex">
                              <a class="block" href="<?= base_url("profil/$comment->u_username")?>"><?= $comment->u_name?></a>
                           </span>
                           <p id="post<?= $comment->post?>"><?= $comment->post?></p>
                           <div class="post-comment-box-action">
                              <ul class="flex items-center">
                                 <li>
                                    <div class="reactions flex items-center">
                                       <?php
                                          if(!empty($comment->action_list)){
                                       ?>
                                       <ul class="flex">
                                          <?php 
                                             foreach($comment->action_list as $action){
                                          ?>
                                          <li class="relative flex-shrink-0">
                                             <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                             <?php 
                                                if(!empty($action->users)){
                                             ?>
                                             <div class="tooltip absolute">
                                                <small class="flex items-center">
                                                   <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                                   <?= $action->title?>
                                                </small>
                                                <ul>
                                                   <?php
                                                      foreach($action->users as $users){
                                                   ?>
                                                   <li><?= $users->u_name?></li>
                                                   <?php } ?>
                                                   <?php 
                                                      if(count($action->users) > 6){
                                                   ?>
                                                   <li><strong><?= $action->total_action?> kişi daha..</strong></li>
                                                   <?php } ?>
                                                </ul>
                                             </div>
                                             <?php }  } ?>
                                          </li>
                                       </ul>
                                       <span class="block"><?= $action->total_action?></span>
                                       <?php } ?>
                                    </div>
                                 </li>
                                 <li class="relative">
                                    <?php 
                                       if(!empty($comment->action)){
                                    ?>
                                     <button class="flex items-center active delete-action focus:outline-none" data-id="<?= $post_action_id?>" data-type="flow">  <img class="lazy" width="22" height="22" data-src="<?= base_url("uploads/reaction/original/$action_image")?>" alt="<?= $action_title?>">
                                       <span class="sm:block"><?= $action_title?></span>
                                     </button>
                                    <?php }else { ?>
                                     <button class="flex items-center <?= LOGIN ? 'reaction-button' : null ?> focus:outline-none" <?= login_check()?>> <span class="sm:block">Beğen</span></button>
                                    <?php } ?>
                                    <div class="reactions-drop absolute">
                                       <ul class="flex">
                                          <?php 
                                             if(!empty($actions)){
                                                foreach($actions as $action){
                                          ?>
                                          <li>
                                             <button class="flex items-center relative focus:outline-none set-action" data-post="1" data-type="flow" data-id="<?= $comment->flow_post_id ?>" data-action="<?= $action->action_id?>">
                                                <img src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                                <div class="tooltip absolute"><small class="flex items-center"><?= $action->title?></small></div>
                                             </button>
                                          </li>
                                          <?php } } ?>
                                       </ul>
                                    </div>
                                 </li>
                                 <li><button class="flex reply-button focus:outline-none" <?= login_check()?> data-group="" data-id="<?= $comment->flow_post_id ?>">Cevapla</button></li>
                                 <li><span class="block"><?= zaman($comment->created_at) ?></span></li>
                                 <?php 
                                    if(LOGIN  || $this->user_id == $comment->user_id){
                                 ?>
                                 <li>
                                    <div class="options-drop relative">
                                       <button class="flex focus:outline-none">
                                          <svg viewBox="0 0 22 6">
                                             <path d="M19,6c-1.657,0-3-1.344-3-3c0-1.656,1.343-3,3-3s3,1.344,3,3C22,4.656,20.657,6,19,6z M19,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C20,2.447,19.552,2,19,2z M11,6C9.343,6,8,4.656,8,3c0-1.656,1.343-3,3-3s3,1.344,3,3C14,4.656,12.657,6,11,6z M11,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C12,2.447,11.552,2,11,2z M3,6C1.343,6,0,4.656,0,3c0-1.656,1.343-3,3-3c1.656,0,3,1.344,3,3C6,4.656,4.656,6,3,6z M3,2C2.447,2,2,2.447,2,3c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C4,2.447,3.552,2,3,2z"></path>
                                          </svg>
                                       </button>
                                         
                                          <div class="options-drop-content absolute">
                                             <ul>
                                                <li><a class="block second" href="javascript:void(0);" data-type="flow" data-delete-post="<?= $comment->flow_post_id?>">Yorumu Sil</a></li>
                                             </ul>
                                          </div>
                                    </div>
                                 </li>
                                 <?php } ?>
                              </ul>
                           </div>
                        </div>
                     </div>
                     <?php 
                        if(LOGIN){
                     ?>
                     <div class="comments-write comments-reply flex items-center">
                        <div class="user-medium flex items-center">
                           <div class="user-medium-image flex-shrink-0"><a class="block" href="<?= base_url("profil/{$this->user->u_username}")?>"><img class="lazy" data-src="<?= base_url("uploads/users/{$this->user->u_avatar}")?>" alt="<?= $this->user->u_name ?>"></a></div>
                        </div>
                        <div class="form-group w-full relative flex items-center" method="post" name="">
                           <div class="form-element w-full relative"><input type="text" class="replyComment" name="replyComment" autocomplete="off" required><label class="block absolute" for="replyComment">Cevabın</label></div>
                           <button class="absolute focus:outline-none reply-comment" disabled>Paylaş</button>
                        </div>
                     </div>
                     <?php } ?>
                     <?php 
                        if(!empty($comment->comment)){
                           foreach($comment->comment as $comments){
                              if($comments->action){
                                 $parse_action = explode("|", $comments->action);
                                 list($post_action_id,$action_id,$action_title,$action_image) = $parse_action;
                              }
                     ?>
                     <div class="post-comment-box post-comment-reply-box flex items-start">
                        <div class="user-medium-image flex-shrink-0"><a class="block" href="<?= base_url("profil/{$comments->u_username}")?>"><img class="lazy" data-src="<?= base_url("uploads/users/{$comments->u_avatar}")?>" alt="<?= $comments->u_name?>"></a></div>
                        <div class="user-medium-text">
                           <span class="flex">
                              <a class="block" href="<?= base_url("profil/$comments->u_username")?>"><?= $comments->u_name?></a>
                           </span>
                           <p id="post<?= $comments->flow_post_id?>"><?= $comments->post?></p>
                           <div class="post-comment-box-action">
                              <ul class="flex items-center">
                                 <li>
                                    <div class="reactions flex items-center">
                                       <?php
                                          if(!empty($comments->action_list)){
                                       ?>
                                       <ul class="flex">
                                          <?php 
                                             foreach($comments->action_list as $action){
                                          ?>
                                          <li class="relative flex-shrink-0">
                                             <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                             <?php 
                                                if(!empty($action->users)){
                                             ?>
                                             <div class="tooltip absolute">
                                                <small class="flex items-center">
                                                   <img class="lazy" data-src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                                   <?= $action->title?>
                                                </small>
                                                <ul>
                                                   <?php
                                                      foreach($action->users as $users){
                                                   ?>
                                                   <li><?= $users->u_name?></li>
                                                   <?php } ?>
                                                   <?php 
                                                      if(count($action->users) > 6){
                                                   ?>
                                                   <li><strong><?= $action->total_action?> kişi daha..</strong></li>
                                                   <?php } ?>
                                                </ul>
                                             </div>
                                             <?php } ?>
                                          </li>
                                       <?php } ?>
                                       </ul>
                                       <span class="block"><?= $action->total_action?></span>
                                       <?php } ?>
                                    </div>
                                 </li>
                                 <li class="relative">
                                    <?php 
                                       if(!empty($comments->action)){
                                    ?>
                                     <button class="flex items-center active delete-action focus:outline-none" data-id="<?= $post_action_id?>" data-type="flow">  <img class="lazy" width="22" height="22" data-src="<?= base_url("uploads/reaction/original/$action_image")?>" alt="<?= $action_title?>">
                                       <span class="sm:block"><?= $action_title?></span>
                                     </button>
                                    <?php } else { ?>
                                     <button class="flex items-center <?= LOGIN ? 'reaction-button' : null ?> focus:outline-none" <?= login_check()?>> <span class="sm:block">Beğen</span></button>
                                    <?php } ?>
                                    <div class="reactions-drop absolute">
                                       <ul class="flex">
                                          <?php 
                                             if(!empty($actions)){
                                                foreach($actions as $action){
                                          ?>
                                          <li>
                                             <button class="flex items-center relative focus:outline-none set-action" data-post="1" data-type="flow" data-id="<?= $comments->flow_post_id ?>" data-action="<?= $action->action_id?>">
                                                <img src="<?= base_url("uploads/reaction/original/$action->image")?>" alt="<?= $action->title?>">
                                                <div class="tooltip absolute"><small class="flex items-center"><?= $action->title?></small></div>
                                             </button>
                                          </li>
                                          <?php } } ?>
                                       </ul>
                                    </div>
                                 </li>
                                 <li><span class="block"><?= zaman($comments->created_at)?></span></li>
                                 <li>
                                    <div class="options-drop relative">
                                       <button class="flex focus:outline-none">
                                          <svg viewBox="0 0 22 6">
                                             <path d="M19,6c-1.657,0-3-1.344-3-3c0-1.656,1.343-3,3-3s3,1.344,3,3C22,4.656,20.657,6,19,6z M19,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C20,2.447,19.552,2,19,2z M11,6C9.343,6,8,4.656,8,3c0-1.656,1.343-3,3-3s3,1.344,3,3C14,4.656,12.657,6,11,6z M11,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C12,2.447,11.552,2,11,2z M3,6C1.343,6,0,4.656,0,3c0-1.656,1.343-3,3-3c1.656,0,3,1.344,3,3C6,4.656,4.656,6,3,6z M3,2C2.447,2,2,2.447,2,3c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C4,2.447,3.552,2,3,2z"></path>
                                          </svg>
                                       </button>
                                       <?php 
                                          if(LOGIN  || $this->user_id == $comments->user_id){
                                       ?>
                                       <div class="options-drop-content absolute">
                                          <ul>
                                             <li><a class="block second" href="javascript:void(0);" data-type="flow" data-delete-post="<?= $comments->flow_post_id?>">Yorumu Sil</a></li>
                                          </ul>
                                       </div>
                                       <?php } ?>
                                    </div>
                                 </li>
                              </ul>
                           </div>
                        </div>
                     </div>
                     <?php } } ?>
                  </li>
                  <?php } ?>
               </ul>
               <?php }else {?>
                  <ul></ul>
               <?php } ?>
               <?php 
                  if($posts->comment_count > $this->groupPostComment){
               ?>
               <div class="post-comment-more"><button class="text-center focus:outline-none get-comment-load" data-group_id="" data-page="1" data-post_id="<?= $posts->flow_post_id?>">Daha Fazla Yorum Göster <strong><data><?= $posts->comment_count - 5?></data>+</strong></button></div>
               <?php } ?>
               <?php 
                  if(LOGIN){
               ?>
               <div class="post-comment-write flex items-center comments-write ">
                  <div class="user-medium flex items-center">
                     <div class="user-medium-image flex-shrink-0 flex-shrink-0"><a class="block" href="<?= base_url("profil/{$this->user->u_username}")?>"><img class="lazy" data-src="<?= base_url("uploads/users/{$this->user->u_avatar}")?>" alt="<?= $this->user->u_name?>"></a></div>
                  </div>
                  <div class="form-group w-full relative flex items-center" method="post" name="">
                     <div class="form-element w-full relative"><input type="text" class="addComment" name="addComment" autocomplete="off" required><label class="block absolute" for="addComment">Yorumun</label>
                     </div>
                     <button class="absolute focus:outline-none reply-post-comment" disabled="" data-group="" data-id="<?= $posts->flow_post_id ?>">Paylaş</button>
                  </div>
               </div>
               <?php } ?>
            </div>
         </div>
      </li>
      <?php } }else {
         echo '<li>'.alert('danger','Listelenecek gönderi bulunamadı.').'</li>';
      } ?>
      </ul>
      <div class="see-more">
         <button class="relative focus:outline-none see-more-flow" data-me="<?= $user->u_id?>" data-page="1">
            Daha Fazla Göster
         </button>
      </div>
      <div class="modal post-edit-modal fixed flex flex-col items-center justify-center z-50" data-modal>
         <div class="modal-body relative overflow-y-auto">
            <div class="modal-header flex items-center justify-between sticky z-50">
               <span class="block">Gönderiyi Düzenle</span>
               <button class="flex items-center justify-center focus:outline-none" data-close>
                  <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                     <line x1="18" y1="6" x2="6" y2="18"></line>
                     <line x1="6" y1="6" x2="18" y2="18"></line>
                  </svg>
               </button>
            </div>
            <div class="modal-content">
               <form class="form-group" method="post" name="">
                  <div class="form-element relative"><textarea id="postEditText" name="postEditText" data-autoresize autocomplete="off" required>Sed rutrum sodales sapien consequat vulputate. Praesent tempus neque ut felis ullamcorper interdum. Suspendisse potenti. Pellentesque mollis elit a purus sodales, nec auctor justo rutrum. In semper ac nisi sed dictum. Nunc eget lobortis augue. Donec porta, justo non consectetur placerat, augue nisl convallis eros, eu efficitur ex arcu ac dui. Nunc non lectus interdum dui molestie vehicula a non mi. Donec eu quam consectetur.</textarea></div>
               </form>
               <div class="image-upload-preview" data-preview-area>
                  <ul class="flex flex-wrap">
                     <li class="relative w-1/2 sm:w-1/4 md:w-1/5">
                        <a class="block" href="javascript:void(0);"><img src="https://images.unsplash.com/photo-1625777719124-9e23c775c3e5?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=634&amp;q=80" alt=""></a>
                        <button class="absolute flex items-center justify-center focus:outline-none" data-preview-delete>
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <line x1="18" y1="6" x2="6" y2="18"></line>
                              <line x1="6" y1="6" x2="18" y2="18"></line>
                           </svg>
                        </button>
                     </li>
                     <li class="relative w-1/2 sm:w-1/4 md:w-1/5">
                        <a class="block" href="javascript:void(0);"><img src="https://images.unsplash.com/photo-1625756297373-817c698b0e70?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=634&amp;q=80" alt=""></a>
                        <button class="absolute flex items-center justify-center focus:outline-none" data-preview-delete>
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <line x1="18" y1="6" x2="6" y2="18"></line>
                              <line x1="6" y1="6" x2="18" y2="18"></line>
                           </svg>
                        </button>
                     </li>
                     <li class="relative w-1/2 sm:w-1/4 md:w-1/5">
                        <a class="block" href="javascript:void(0);"><img src="https://images.unsplash.com/photo-1625770084721-57b90c348d1c?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=1050&amp;q=80" alt=""></a>
                        <button class="absolute flex items-center justify-center focus:outline-none" data-preview-delete>
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <line x1="18" y1="6" x2="6" y2="18"></line>
                              <line x1="6" y1="6" x2="18" y2="18"></line>
                           </svg>
                        </button>
                     </li>
                     <li class="relative w-1/2 sm:w-1/4 md:w-1/5">
                        <a class="block" href="javascript:void(0);"><img src="https://images.unsplash.com/photo-1625624732896-d72166e27636?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=1050&amp;q=80" alt=""></a>
                        <button class="absolute flex items-center justify-center focus:outline-none" data-preview-delete>
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <line x1="18" y1="6" x2="6" y2="18"></line>
                              <line x1="6" y1="6" x2="18" y2="18"></line>
                           </svg>
                        </button>
                     </li>
                     <li class="relative w-1/2 sm:w-1/4 md:w-1/5">
                        <a class="block" href="javascript:void(0);"><img src="https://images.unsplash.com/photo-1625797143914-36d6a5dbabe3?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=634&amp;q=80" alt=""></a>
                        <button class="absolute flex items-center justify-center focus:outline-none" data-preview-delete>
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <line x1="18" y1="6" x2="6" y2="18"></line>
                              <line x1="6" y1="6" x2="18" y2="18"></line>
                           </svg>
                        </button>
                     </li>
                  </ul>
               </div>
               <div class="post-edit-modal-actions flex items-center justify-between">
                  <span class="block">Gönderine Ekle</span>
                  <div class="image-upload-button">
                     <label class="block">
                        <input type="file" multiple accept=".png, .jpg, .jpeg" data-upload-area="">
                        <span class="block">
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                              <circle cx="8.5" cy="8.5" r="1.5"></circle>
                              <polyline points="21 15 16 10 5 21"></polyline>
                           </svg>
                        </span>
                     </label>
                  </div>
               </div>
            </div>
            <div class="modal-footer sticky z-50">
               <div class="form-group">
                  <div class="form-element"><button class="button-second w-full focus:outline-none">+ Değişiklikleri Kaydet</button></div>
               </div>
            </div>
         </div>
      </div>
      <div class="modal post-share-modal fixed flex flex-col items-center justify-center z-50" data-modal>
         <div class="modal-body relative overflow-y-auto">
            <div class="modal-header flex items-center justify-between sticky z-50">
               <span class="block">Gönderiyi Paylaş</span>
               <button class="flex items-center justify-center focus:outline-none" data-close>
                  <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                     <line x1="18" y1="6" x2="6" y2="18"></line>
                     <line x1="6" y1="6" x2="18" y2="18"></line>
                  </svg>
               </button>
            </div>
            <div class="modal-content">
               <form class="form-group" method="post" name="">
                  <div class="form-element relative"><textarea id="postShareText" name="postShareText" data-autoresize autocomplete="off" required placeholder="Bir şeyler yaz.."></textarea></div>
               </form>
               <div class="image-upload-preview" data-preview-area>
                  <ul class="flex flex-wrap"></ul>
               </div>
               <div class="post">
                  <div class="post-header flex items-center justify-between">
                     <div class="user-medium flex items-center">
                        <div class="user-medium-image flex-shrink-0"><a class="block" href="/"><img src="https://randomuser.me/api/portraits/men/1.jpg" alt=""></a></div>
                        <div class="user-medium-text">
                           <span class="block"><a class="inline-block" href="/">Jack Reacher</a> bir <strong>resim </strong>paylaştı</span>
                           <p>1 saat, 36 dakika önce</p>
                        </div>
                     </div>
                  </div>
                  <div class="post-content">
                     <p>Sed rutrum sodales sapien consequat vulputate. Praesent tempus neque ut felis ullamcorper interdum. Suspendisse potenti. Pellentesque mollis elit a purus sodales, nec auctor justo rutrum. In semper ac nisi sed dictum. Nunc eget lobortis augue. Donec porta, justo non consectetur placerat, augue nisl convallis eros, eu efficitur ex arcu ac dui. Nunc non lectus interdum dui molestie vehicula a non mi. Donec eu quam consectetur.</p>
                     <div class="post-content-images">
                        <ul class="flex flex-wrap">
                           <li class="w-1/2"><a class="block" href="https://images.unsplash.com/photo-1625777719124-9e23c775c3e5?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=634&amp;q=80" data-fancybox="gallery"><img src="https://images.unsplash.com/photo-1625777719124-9e23c775c3e5?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=634&amp;q=80" alt=""></a></li>
                           <li class="w-1/2"><a class="block" href="https://images.unsplash.com/photo-1625756297373-817c698b0e70?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=634&amp;q=80" data-fancybox="gallery"><img src="https://images.unsplash.com/photo-1625756297373-817c698b0e70?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=634&amp;q=80" alt=""></a></li>
                           <li class="w-1/3"><a class="block" href="https://images.unsplash.com/photo-1625770084721-57b90c348d1c?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=1050&amp;q=80" data-fancybox="gallery"><img src="https://images.unsplash.com/photo-1625770084721-57b90c348d1c?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=1050&amp;q=80" alt=""></a></li>
                           <li class="w-1/3"><a class="block" href="https://images.unsplash.com/photo-1625624732896-d72166e27636?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=1050&amp;q=80" data-fancybox="gallery"><img src="https://images.unsplash.com/photo-1625624732896-d72166e27636?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=1050&amp;q=80" alt=""></a></li>
                           <li class="relative w-1/3">
                              <a class="block" href="https://images.unsplash.com/photo-1625797143914-36d6a5dbabe3?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=634&amp;q=80" data-fancybox="gallery">
                                 <img src="https://images.unsplash.com/photo-1625797143914-36d6a5dbabe3?ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;ixlib=rb-1.2.1&amp;auto=format&amp;fit=crop&amp;w=634&amp;q=80" alt="">
                                 <div class="post-content-images-on absolute flex items-center justify-center"><span class="block">+10</span></div>
                              </a>
                           </li>
                        </ul>
                     </div>
                  </div>
               </div>
               <div class="post-edit-modal-actions flex items-center justify-between">
                  <span class="block">Gönderine Ekle</span>
                  <div class="image-upload-button">
                     <label class="block">
                        <input type="file" multiple accept=".png, .jpg, .jpeg" data-upload-area>
                        <span class="block">
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                              <circle cx="8.5" cy="8.5" r="1.5"></circle>
                              <polyline points="21 15 16 10 5 21"></polyline>
                           </svg>
                        </span>
                     </label>
                  </div>
               </div>
            </div>
            <div class="modal-footer sticky z-50">
               <div class="form-group">
                  <div class="form-element"><button class="button-second w-full focus:outline-none">Paylaş</button></div>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="user-profile-content-right w-full xl:w-1/3">
      <div class="widget-box">
         <div class="widget-box-head flex items-center justify-between">
            <span class="block">Hakkında</span>
             <?php 
                  if($this->user_id == $user->u_id){
               ?>
            <div class="options-drop relative">
               <button class="flex focus:outline-none">
                  <svg viewBox="0 0 22 6">
                     <path d="M19,6c-1.657,0-3-1.344-3-3c0-1.656,1.343-3,3-3s3,1.344,3,3C22,4.656,20.657,6,19,6z M19,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C20,2.447,19.552,2,19,2z M11,6C9.343,6,8,4.656,8,3c0-1.656,1.343-3,3-3s3,1.344,3,3C14,4.656,12.657,6,11,6z M11,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C12,2.447,11.552,2,11,2z M3,6C1.343,6,0,4.656,0,3c0-1.656,1.343-3,3-3c1.656,0,3,1.344,3,3C6,4.656,4.656,6,3,6z M3,2C2.447,2,2,2.447,2,3c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C4,2.447,3.552,2,3,2z"></path>
                  </svg>
               </button>
              
               <div class="options-drop-content absolute">
                  <ul>
                     <li><a class="block" href="javascript:void(0);">Düzenle</a></li>
                  </ul>
               </div>
            </div>
               <?php } ?>
         </div>
         <div class="widget-box-content">
            <p><?= $user->u_bio?></p>
            <div class="widget-box-content-table-list">
               <ul class="table w-full">
                  <li class="table-row">
                     <div class="table-cell"><span class="block">Katıldı</span></div>
                     <div class="table-cell">
                        <p><?= dates2($user->u_date,false)?></p>
                     </div>
                  </li>
                  <li class="table-row">
                     <div class="table-cell"><span class="block">Şehir</span></div>
                     <div class="table-cell">
                        <p><?= $user->city?></p>
                     </div>
                  </li>
                  <li class="table-row">
                     <div class="table-cell"><span class="block">Ülke</span></div>
                     <div class="table-cell">
                        <p><?= $user->country?></p>
                     </div>
                  </li>
                  <li class="table-row">
                     <div class="table-cell"><span class="block">Yaş</span></div>
                     <div class="table-cell">
                        <p><?= $user->u_birthday ? date_diff(date_create($user->u_birthday),date_create(date("Y-m-d")))->format('%y') : "Belirtilmedi" ?></p>
                     </div>
                  </li>
               </ul>
            </div>
         </div>
      </div>
      <div class="widget-box">
         <div class="widget-box-head flex items-center justify-between">
            <span class="block">Rozetler <strong><?= $badgesCount?></strong></span>
            <div class="options-drop relative">
               <button class="flex focus:outline-none">
                  <svg viewBox="0 0 22 6">
                     <path d="M19,6c-1.657,0-3-1.344-3-3c0-1.656,1.343-3,3-3s3,1.344,3,3C22,4.656,20.657,6,19,6z M19,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C20,2.447,19.552,2,19,2z M11,6C9.343,6,8,4.656,8,3c0-1.656,1.343-3,3-3s3,1.344,3,3C14,4.656,12.657,6,11,6z M11,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C12,2.447,11.552,2,11,2z M3,6C1.343,6,0,4.656,0,3c0-1.656,1.343-3,3-3c1.656,0,3,1.344,3,3C6,4.656,4.656,6,3,6z M3,2C2.447,2,2,2.447,2,3c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C4,2.447,3.552,2,3,2z"></path>
                  </svg>
               </button>
               <div class="options-drop-content absolute">
                  <ul>
                     <li><a class="block" href="javascript:void(0);">Düzenle</a></li>
                  </ul>
               </div>
            </div>
         </div>
         <div class="widget-box-content">
            <div class="widget-box-content-list">
               <ul class="flex flex-wrap">
                  <?php 
                     if(!empty($badges)){
                        foreach($badges as $badge){
                  ?>
                  <li class="relative w-1/6 md:w-auto xl:w-1/6">
                     <img class="lazy" data-src="<?= base_url("uploads/badges/original/$badge->image")?>" alt="<?= $badge->title?>">
                     <div class="tooltip absolute">
                        <p><?= $badge->title?></p>
                     </div>
                  </li>
                  <?php } } ?>
                  
               </ul>
            </div>
         </div>
      </div>
      <div class="widget-box">
         <div class="widget-box-head flex items-center justify-between">
            <span class="block">Arkadaş <strong><?= $friendCount?></strong></span>
         </div>
         <div class="widget-box-content">
            <div class="widget-box-content-friend-list">
               <?php 
                  if(!empty($friends)){
               ?>
               <ul>
                  <?php 
                     foreach($friends as $friend){
                  ?>
                  <li>
                     <div class="requests-box flex items-center justify-between">
                        <div class="user-medium flex items-center">
                           <div class="user-medium-image flex-shrink-0">
                              <a class="block" href="<?= base_url("profil/$friend->u_username")?>"><img src="<?= base_url("uploads/users/$friend->u_avatar")?>" alt="<?= $friend->u_username?>"></a>
                           </div>
                           <div class="user-medium-text w-full">
                              <span class="block"><a class="block truncate" href="<?= base_url("profil/$friend->u_username")?>"><?= $friend->u_name?></a></span>
                              <?= !empty($friend->mutual)  ? "<p>$friend->mutual ortak arkadaş</p>" : '<p>Ortak arkadaşınız yok</p>'?>
                           </div>
                        </div>
                        <div class="requests-box-actions">
                           <ul class="flex">
                              <li>
                                 <?= $friend->button ?? ""?>
                              </li>
                           </ul>
                        </div>
                     </div>
                  </li>
                  <?php } ?>
               </ul>
               <a class="block text-center" href="<?= base_url("profil/$user->u_username/arkadaslar")?>">Tüm Arkadaşları Gör</a>
               <?php } ?>
            </div>
         </div>
      </div>
   </div>
</div>
<div class="modal modal-small share-modal fixed flex flex-col items-center justify-center" data-modal="">
   <div class="modal-body relative overflow-y-auto">
      <div class="modal-header flex items-center justify-between sticky z-50">
         <span class="block">Paylaş</span>
         <button class="flex items-center justify-center focus:outline-none" data-close="">
            <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
               <line x1="18" y1="6" x2="6" y2="18"></line>
               <line x1="6" y1="6" x2="18" y2="18"></line>
            </svg>
         </button>
      </div>
      <div class="modal-content">
         <div class="social-share">
            <ul class="flex flex-wrap">
               <li class="w-1/2 sm:w-1/3">
                  <a class="flex flex-col items-center facebook-share" 
                  href="https://www.facebook.com/sharer/sharer.php?u=&t=" 
                  onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600');return false;"
                  target="_blank" title="Facebook'da Paylaş"
                  >
                     <span class="flex items-center justify-center facebook">
                        <svg viewBox="0 0 18 18">
                           <path d="M16.313,18h-4.504v-6.192h3.087V8.671h-3.087V7.135V6.831V6.814l0,0c0.01-0.328,0.277-0.591,0.607-0.591h0.067h1.113h1.62V3.086h-2.733l0,0l-0.009,0.018h-0.092c-2.051,0-3.712,1.661-3.712,3.711v0.911v0.945H6.191v3.137h2.479V18H1.687C0.755,18,0,17.242,0,16.313V1.686C0,0.754,0.755,0,1.687,0h14.626C17.244,0,18,0.754,18,1.686v14.627C18,17.242,17.244,18,16.313,18z"></path>
                        </svg>
                     </span>
                     Facebook
                  </a>
               </li>
               <li class="w-1/2 sm:w-1/3">
                  <a class="flex flex-col items-center twitter-share" 
                  href="https://twitter.com/intent/tweet?url=&text=&hashtags=filmizle,diziizle" 
                  onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600');return false;"
                  target="_blank" title="Twitter'da Paylaş"
                  >
                     <span class="flex items-center justify-center twitter">
                        <svg viewBox="0 0 18 18">
                           <path d="M18,3.617c-0.675,0.322-1.351,0.43-2.139,0.537c0.788-0.43,1.351-1.076,1.576-1.937c-0.675,0.43-1.463,0.646-2.362,0.861C14.399,2.431,13.388,2,12.375,2c-1.912,0-3.601,1.617-3.601,3.554c0,0.323,0,0.538,0.113,0.754C5.851,6.2,3.038,4.8,1.238,2.646C0.9,3.185,0.788,3.724,0.788,4.478c0,1.184,0.675,2.261,1.688,2.907c-0.563,0-1.125-0.216-1.688-0.431l0,0c0,1.723,1.237,3.122,2.925,3.446c-0.338,0.107-0.675,0.107-1.013,0.107c-0.225,0-0.45,0-0.675-0.107c0.45,1.399,1.8,2.476,3.487,2.476C4.274,13.846,2.7,14.384,0.9,14.384c-0.338,0-0.563,0-0.9,0C1.688,15.354,3.601,16,5.625,16c6.75,0,10.462-5.385,10.462-10.015c0-0.108,0-0.323,0-0.431C16.875,5.016,17.549,4.371,18,3.617z"></path>
                        </svg>
                     </span>
                     Twitter
                  </a>
               </li>
               <li class="w-1/2 sm:w-1/3">
                  <a class="flex flex-col items-center whatsapp-share"
                  data-action="share/whatsapp/share"
                  href="https://web.whatsapp.com/send?text=" 
                  target="_blank" title="WhatsApp'da Paylaş"
                  >
                     <span class="flex items-center justify-center whatsapp">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                           <path d="M260.062 32C138.605 32 40.134 129.701 40.134 250.232c0 41.23 11.532 79.79 31.559 112.687L32 480l121.764-38.682c31.508 17.285 67.745 27.146 106.298 27.146C381.535 468.464 480 370.749 480 250.232 480 129.701 381.535 32 260.062 32zm109.362 301.11c-5.174 12.827-28.574 24.533-38.899 25.072-10.314.547-10.608 7.994-66.84-16.434-56.225-24.434-90.052-83.844-92.719-87.67-2.669-3.812-21.78-31.047-20.749-58.455 1.038-27.413 16.047-40.346 21.404-45.725 5.351-5.387 11.486-6.352 15.232-6.413 4.428-.072 7.296-.132 10.573-.011 3.274.124 8.192-.685 12.45 10.639 4.256 11.323 14.443 39.153 15.746 41.989 1.302 2.839 2.108 6.126.102 9.771-2.012 3.653-3.042 5.935-5.961 9.083-2.935 3.148-6.174 7.042-8.792 9.449-2.92 2.665-5.97 5.572-2.9 11.269 3.068 5.693 13.653 24.356 29.779 39.736 20.725 19.771 38.598 26.329 44.098 29.317 5.515 3.004 8.806 2.67 12.226-.929 3.404-3.599 14.639-15.746 18.596-21.169 3.955-5.438 7.661-4.373 12.742-2.329 5.078 2.052 32.157 16.556 37.673 19.551 5.51 2.989 9.193 4.529 10.51 6.9 1.317 2.38.901 13.531-4.271 26.359z"></path>
                        </svg>
                     </span>
                     WhatsApp
                  </a>
               </li>
            </ul>
            <div class="form-group">
               <div class="form-element relative">
                  <input class="linkToCopy" type="text" value="<?= base_url(uri_string())?>" id="pageUrl" name="pageUrl" autocomplete="off" required=""><label class="block absolute" for="pageUrl">Sayfa Bağlantısı</label>
                  <div class="form-element-end-icon absolute">
                     <button class="flex copyButton focus:outline-none">
                        <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                           <rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect>
                           <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path>
                        </svg>
                     </button>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
