<div class="together-watch-wrapper flex" data-room="<?= $room->id?>">
   <div class="watch-room flex">
      <div class="series-playlist-inner flex">
         <div class="series-playlist-content flex flex-col">
            <div class="playlist-wrapper px-4">
               <div class="series-playlist-header flex items-center justify-between">
                  <div class="series-playlist-header-text">
                     <span class="block font-bold text-white"><?= $room->title?></span>
                     <small class="truncate font-bold">Public Group</small>
                  </div>
                  <?php
                     if($room->user_id == $this->user_id){
                  ?>
                  <div class="series-playlist-header-icon">
                     <div class="countdown-actions relative">
                        <button class="flex focus:outline-none rounded-full">
                           <svg viewBox="0 0 22 6">
                              <path d="M19,6c-1.657,0-3-1.344-3-3c0-1.656,1.343-3,3-3s3,1.344,3,3C22,4.656,20.657,6,19,6z M19,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C20,2.447,19.552,2,19,2z M11,6C9.343,6,8,4.656,8,3c0-1.656,1.343-3,3-3s3,1.344,3,3C14,4.656,12.657,6,11,6z M11,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C12,2.447,11.552,2,11,2z M3,6C1.343,6,0,4.656,0,3c0-1.656,1.343-3,3-3c1.656,0,3,1.344,3,3C6,4.656,4.656,6,3,6z M3,2C2.447,2,2,2.447,2,3c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C4,2.447,3.552,2,3,2z"></path>
                           </svg>
                        </button>
                        <div class="options-drop-content absolute">
                           <ul>
                              <li>
                                 <a class="flex items-center" data-target=".invite-firends-modal" href="javascript:;">
                                     <svg class="mr-5" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 40 40"><circle cx="20" cy="20" r="20" fill="rgb(146, 156, 255, 0.2)"></circle><circle cx="34" cy="6" r="6" fill="#FF3D1F"></circle><path fill="#fff" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="2" d="M15.832 28c1.231.663 2.652 1 4.168 1 4.926 0 9-4.074 9-9s-4.074-9-9-9-9 4.074-9 9c0 1.516.337 2.768 1 4l-1 5 4.832-1z" opacity="0.8"></path><rect width="4" height="4" x="15" y="18" fill="#46495f" rx="2"></rect><rect width="4" height="4" x="21" y="18" fill="#46495f" rx="2"></rect></svg>
                                    Arkadaşların arasından davet et
                                 </a>
                              </li>
                              <li>
                                 <a class="flex items-center" data-target=".invite-firends-link-modal" href="javascript:;">
                                   <svg width="25" height="25" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                       <path d="M16.6495 20.2V20.49C15.1695 21.44 13.3995 22 11.4995 22C9.56953 22 7.76953 21.42 6.26953 20.43V20.2C6.26953 17.87 8.59953 15.97 11.4595 15.97C14.3295 15.97 16.6495 17.87 16.6495 20.2Z" fill="#00c56a"/>
                                       <path opacity="0.4" d="M21 12.5C21 15.85 19.27 18.79 16.65 20.49V20.2C16.65 17.87 14.33 15.97 11.46 15.97C8.6 15.97 6.27 17.87 6.27 20.2V20.43C3.7 18.73 2 15.82 2 12.5C2 7.25 6.25 3 11.5 3C12.81 3 14.06 3.25999 15.2 3.73999C15.07 4.13999 15 4.56 15 5C15 5.75 15.21 6.46 15.58 7.06C15.78 7.4 16.04 7.70997 16.34 7.96997C17.04 8.60997 17.97 9 19 9C19.44 9 19.86 8.92998 20.25 8.78998C20.73 9.92998 21 11.19 21 12.5Z" fill="#00c56a"/>
                                       <path d="M21.97 2.33002C21.25 1.51002 20.18 1 19 1C17.88 1 16.86 1.46002 16.13 2.21002C15.71 2.64002 15.39 3.15999 15.2 3.73999C15.07 4.13999 15 4.56 15 5C15 5.75 15.21 6.46 15.58 7.06C15.78 7.4 16.04 7.70997 16.34 7.96997C17.04 8.60997 17.97 9 19 9C19.44 9 19.86 8.92998 20.25 8.78998C21.17 8.49998 21.94 7.87 22.42 7.06C22.63 6.72 22.79 6.32999 22.88 5.92999C22.96 5.62999 23 5.32 23 5C23 3.98 22.61 3.04002 21.97 2.33002ZM20.49 5.72998H19.75V6.51001C19.75 6.92001 19.41 7.26001 19 7.26001C18.59 7.26001 18.25 6.92001 18.25 6.51001V5.72998H17.51C17.1 5.72998 16.76 5.38998 16.76 4.97998C16.76 4.56998 17.1 4.22998 17.51 4.22998H18.25V3.52002C18.25 3.11002 18.59 2.77002 19 2.77002C19.41 2.77002 19.75 3.11002 19.75 3.52002V4.22998H20.49C20.9 4.22998 21.24 4.56998 21.24 4.97998C21.24 5.38998 20.91 5.72998 20.49 5.72998Z" fill="#00c56a"/>
                                       <path d="M11.4604 14.7299C13.0123 14.7299 14.2704 13.4718 14.2704 11.9199C14.2704 10.3679 13.0123 9.10986 11.4604 9.10986C9.90847 9.10986 8.65039 10.3679 8.65039 11.9199C8.65039 13.4718 9.90847 14.7299 11.4604 14.7299Z" fill="#00c56a"/>
                                       </svg>

                                   Oda bağlantını paylaş
                                 </a>
                              </li>
                              <li>
                                 <a class="flex items-center" data-target=".search-movie-and-series-modal" href="javascript:;">
                                     <svg class="mr-5" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 40 40"><circle cx="20" cy="20" r="20" fill="rgb(255, 186, 229, 0.2)"></circle><circle cx="34" cy="6" r="6" fill="#ff8f7b"></circle><path fill="#fff" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 21.895L20.227 11v7.105H27L20.227 29v-7.105H13z" opacity="0.8"></path></svg>
                                    Dizi veya Film ara
                                 </a>
                              </li>
                           </ul>
                        </div>
                     </div>
                  </div>
                  <?php } ?>
               </div>
               <div class="series-playlist-search mt-5 relative">
                  <div class="main-search-drop fixed md:absolute">
                     <div class="main-search-mobile flex md:hidden">
                        <div class="main-search-mobile-input relative">
                           <input type="text" placeholder="Dizi veya film ara..">
                           <div class="main-search-icon absolute">
                              <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                 <circle cx="11" cy="11" r="8"></circle>
                                 <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                              </svg>
                           </div>
                        </div>
                        <div class="main-search-mobile-close">
                           <button class="flex items-center justify-center focus:outline-none">
                              <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                 <line x1="18" y1="6" x2="6" y2="18"></line>
                                 <line x1="6" y1="6" x2="18" y2="18"></line>
                              </svg>
                           </button>
                        </div>
                     </div>   
                  </div>
               </div>
               <div class="series-chat-panel flex items-center justify-between">
                  <div class="series-chat-total-user">
                     <span class="flex items-center font-bold">
                        <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                           <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                           <circle cx="8.5" cy="7" r="4"></circle>
                           <line x1="20" y1="8" x2="20" y2="14"></line>
                           <line x1="23" y1="11" x2="17" y2="11"></line>
                        </svg>
                        <span id="memberCount">0</span>
                     </span>
                  </div>
                  <div class="series-chat-message-button">
                     <a id="messageButton" class="block relative chat-message-button " href="javascript:void(0);">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                        </svg>
                     </a>
                  </div>
               </div>
            </div>
            <div class="series-playlist-item-content flex relative px-4">
               <div class="playlist">
                  <h3>OYNATILIYOR</h3>
                     
                  <ul>
                     <li>
                        <div class="relative p-1 w-full rounded-lg overflow-hidden  hover:shadow-md rounded-lg">
                           <div class="animate-pulse flex space-x-4">
                             <div class="rounded-sm flex-shrink-0 bg-gray-600 w-10 h-10"></div>
                             <div class="flex w-full justify-between items-center py-1">
                                 <div class="space-y-2 w-full">
                                   <div class="h-1 bg-gray-600 rounded "></div>
                                   <div class="h-1 bg-gray-600 rounded w-5/6"></div>
                                   <div class="h-1 bg-gray-600 rounded w-5/6"></div>
                                 </div>
                                 <div class="rounded-full bg-gray-600 flex-shrink-0 ml-4 w-5 h-5"></div>
                              </div>
                           </div>
                          </div>
                     </li>
                  </ul>
                  <h3>SIRADAKİLER</h3>
                  <ul id="playlist">

                     <li>
                        <div class="relative p-1 w-full rounded-lg overflow-hidden  hover:shadow-md rounded-lg">
                           <div class="animate-pulse flex space-x-4">
                             <div class="rounded-sm flex-shrink-0 bg-gray-600 w-10 h-10"></div>
                             <div class="flex w-full justify-between items-center py-1">
                                 <div class="space-y-2 w-full">
                                   <div class="h-1 bg-gray-600 rounded "></div>
                                   <div class="h-1 bg-gray-600 rounded w-5/6"></div>
                                   <div class="h-1 bg-gray-600 rounded w-5/6"></div>
                                 </div>
                                 <div class="rounded-full bg-gray-600 flex-shrink-0 ml-4 w-5 h-5"></div>
                              </div>
                           </div>
                          </div>
                     </li>
                  </ul>
               </div>
              
               <div class="active-chat-close hidden" id="together-watch-chat">
                  <aside class="chatpanel h-full">
                     <div class="together-watch-chat-box h-full ">
                        <div class="together-watch-chat-box-inner flex h-full flex-col justify-between">
                              <div class="together-watch-chat-box-in relative w-full">
                                 <?php 
                                    /*   <div class="chat-box block mb-3 flex relative w-full flex-col">
                                       <span class="line-border " style="background-color: rgb(153, 246, 255);"></span>
                                       <div class="chat-box-top ">
                                          <a href="">Warez123</a>
                                          <span>• 14:23</span>
                                       </div>
                                       <div class="chat-box-message ">
                                          <p>Merhaba moruk !</p>
                                       </div>
                                    </div>*/
                                 ?>

                              </div>
                              <div class="messages-content-write">
                                 <form class="form-group flex flex-col sm:flex-row" id="message-form" method="post">
                                    <div class="form-element w-full relative">
                                          <input type="text" placeholder="Mesaj yaz..." id="message-box" required="">
                                          <div class="form-element-reset absolute">
                                          <button class="flex focus:outline-none" type="reset">
                                             <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                <line x1="18" y1="6" x2="6" y2="18"></line>
                                                <line x1="6" y1="6" x2="18" y2="18"></line>
                                             </svg>
                                          </button>
                                          </div>
                                          <span id="message-check" style="color:#fff" class="p-5"></span>
                                    </div>
                                    <div class="form-element w-full sm:w-auto">
                                          <button class="button-first send-message flex items-center justify-center focus:outline-none w-full sm:w-auto">
                                          <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                             <line x1="22" y1="2" x2="11" y2="13"></line>
                                             <polygon points="22 2 15 22 11 13 2 9 22 2"></polygon>
                                          </svg>
                                          </button>
                                    </div>
                                 </form>
                              </div>
                        </div>
                     </div>
                  </aside>
               </div>  
            </div>   
         </div>
      </div>
      <div class="player-content w-full relative">
         <div class="w-full h-full hidden" id="player-content">
            <iframe src="<?= $video->data->video ?? ""?>" id="player" scrolling="no" allowfullscreen="true" title="izle"></iframe>
            <div class="player-series-seasons">
               
            </div>
         </div>
         <div class="h-full w-full flex flex-col justify-center" id="friends-content">
            <div class="player-content-bg-overlay bg-overlay w-full absolute top-0">
               <div class="inner" style="background-image: url('https://assets.nflxext.com/ffe/siteui/vlv3/5c235903-02cc-4228-85a2-5fcef1e47627/64b51a11-7322-496c-aab1-411ddf583abd/TR-tr-20211227-popsignuptwoweeks-perspective_alpha_website_small.jpg');"></div>
            </div>
            <div class="player-content-description flex items-center justify-center">
               <div class="player-content-description-box">
                  <h4 class="font-semibold text-white text-3xl">Yalnız başına ne yapıyorsun?</h4>
                  <p class="w-full">Hemen arkadaşlarına davet bağlantısı göndererek dizi/film partisini oluşturabilir, eğlencenin dibine vurabilirsin.</p>
                  <div class="player-content-actions w-full mt-8">
                     <ul>
                        <li>
                           <button class="focus:outline-none w-full flex justify-between hover:shadow-lg shadow-cyan-500/50" data-target=".invite-firends-modal">
                              <div class="player-content-actions-button flex items-center">
                                    <svg class="mr-5" xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="none" viewBox="0 0 40 40"><circle cx="20" cy="20" r="20" fill="rgb(146, 156, 255, 0.2)"></circle><circle cx="34" cy="6" r="6" fill="#FF3D1F"></circle><path fill="#fff" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="2" d="M15.832 28c1.231.663 2.652 1 4.168 1 4.926 0 9-4.074 9-9s-4.074-9-9-9-9 4.074-9 9c0 1.516.337 2.768 1 4l-1 5 4.832-1z" opacity="0.8"></path><rect width="4" height="4" x="15" y="18" fill="#46495f" rx="2"></rect><rect width="4" height="4" x="21" y="18" fill="#46495f" rx="2"></rect></svg>
                                    Arkadaşların arasından davet et
                              </div>
                              <div class="player-content-actions-icon">
                                    <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><polyline points="9 18 15 12 9 6"></polyline></svg>
                              </div>
                           </button>
                        </li>
                        <li class="mt-4">
                           <button class="focus:outline-none w-full flex justify-between hover:shadow-lg shadow-cyan-500/50" data-target=".invite-firends-link-modal">
                              <div class="player-content-actions-button flex items-center">
                                    <svg class="mr-5" xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="none" viewBox="0 0 40 40"><g clip-path="url(#clip0)"><circle cx="20" cy="20" r="20" fill="rgb(176, 255, 199, 0.2)"></circle><circle cx="20" cy="17" r="5" fill="#fff" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="3.6" opacity="0.8"></circle><path fill="#fff" opacity="0.8" d="M20 28c-9 0-12 8-12 8s4 4 12 4 12-4 12-4-3-8-12-8z"></path><circle cx="34" cy="6" r="6" fill="#00C56A"></circle></g><defs><clipPath id="clip0"><path fill="#fff" d="M0 0H40V40H0z"></path></clipPath></defs></svg>
                                   Oda bağlantınızı arkadaşların ile paylaş
                              </div>
                              <div class="player-content-actions-icon">
                                    <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><polyline points="9 18 15 12 9 6"></polyline></svg>
                              </div>
                           </button>
                        </li>
                        <li class="mt-4">
                        <button class="focus:outline-none w-full flex justify-between hover:shadow-lg shadow-cyan-500/50" data-target=".search-movie-and-series-modal">
                           <div class="player-content-actions-button flex items-center">
                                 <svg class="mr-5" xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="none" viewBox="0 0 40 40"><circle cx="20" cy="20" r="20" fill="rgb(255, 186, 229, 0.2)"></circle><circle cx="34" cy="6" r="6" fill="#ff8f7b"></circle><path fill="#fff" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 21.895L20.227 11v7.105H27L20.227 29v-7.105H13z" opacity="0.8"></path></svg>
                                 Dizi veya film ara
                           </div>
                           <div class="player-content-actions-icon">
                                 <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><polyline points="9 18 15 12 9 6"></polyline></svg>
                           </div>
                        </button>
                        </li>
                        
                     </ul>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>

<div class="invite-firends-link-modal modal modal-small fixed flex flex-col items-center justify-center">
   <div class="invite-friends-body modal-body relative overflow-y-auto">
      <div class="invite-friends-modal-content mb-5">
         <span class="block text-3xl text-white">Arkadaşlarını Davet Et</span>
         <p>Grup linkini arkadaşlarınızla paylaşın ve birlikte izlemenin keyfini çıkarın</p>
      </div>
      <div class="invite-friends-content modal-content">
         <div class="form-group">
            <div class="form-element relative">
               <input class="linkToCopy" type="text" value="<?= base_url("room/$room->slug")?>" data-slug="<?= $room->slug?>" id="pageUrl" name="pageUrl" autocomplete="off" required=""><label class="block absolute" for="pageUrl">Parti Linki</label>
               <div class="form-element-end-icon absolute">
                  <button class="flex copyButton focus:outline-none">
                     <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect>
                        <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path>
                     </svg>
                  </button>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<div class="invite-firends-modal modal modal-small fixed flex flex-col items-center justify-center">
   <div class="invite-friends-body modal-body relative overflow-y-auto">
      <div class="invite-friends-modal-content mb-5">
         <span class="block text-3xl text-white">Arkadaşlarını Davet Et</span>
         <p>Grup linkini arkadaşlarınızla paylaşın ve birlikte izlemenin keyfini çıkarın</p>
      </div>
      <div class="invite-friends-content modal-content">
         <div class="form-group">
            <div class="form-element relative">
               <input class="room-friends-user" type="text" value="" name="pageUrl" autocomplete="off" required="">
               <label class="block absolute" for="pageUrl">Arkadaş Ara</label>
               <div class="form-element-end-icon absolute">
                  <button class="flex copyButton focus:outline-none">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M17.5291 7.77C17.4591 7.76 17.3891 7.76 17.3191 7.77C15.7691 7.72 14.5391 6.45 14.5391 4.89C14.5391 3.3 15.8291 2 17.4291 2C19.0191 2 20.3191 3.29 20.3191 4.89C20.3091 6.45 19.0791 7.72 17.5291 7.77Z" fill="#6c7388"/>
                        <path d="M20.7916 14.7004C19.6716 15.4504 18.1016 15.7304 16.6516 15.5404C17.0316 14.7204 17.2316 13.8104 17.2416 12.8504C17.2416 11.8504 17.0216 10.9004 16.6016 10.0704C18.0816 9.8704 19.6516 10.1504 20.7816 10.9004C22.3616 11.9404 22.3616 13.6504 20.7916 14.7004Z" fill="#6c7388"/>
                        <path d="M6.44016 7.77C6.51016 7.76 6.58016 7.76 6.65016 7.77C8.20016 7.72 9.43016 6.45 9.43016 4.89C9.43016 3.29 8.14016 2 6.54016 2C4.95016 2 3.66016 3.29 3.66016 4.89C3.66016 6.45 4.89016 7.72 6.44016 7.77Z" fill="#6c7388"/>
                        <path d="M6.55109 12.8506C6.55109 13.8206 6.76109 14.7406 7.14109 15.5706C5.73109 15.7206 4.26109 15.4206 3.18109 14.7106C1.60109 13.6606 1.60109 11.9506 3.18109 10.9006C4.25109 10.1806 5.76109 9.89059 7.18109 10.0506C6.77109 10.8906 6.55109 11.8406 6.55109 12.8506Z" fill="#6c7388"/>
                        <path d="M12.1208 15.87C12.0408 15.86 11.9508 15.86 11.8608 15.87C10.0208 15.81 8.55078 14.3 8.55078 12.44C8.56078 10.54 10.0908 9 12.0008 9C13.9008 9 15.4408 10.54 15.4408 12.44C15.4308 14.3 13.9708 15.81 12.1208 15.87Z" fill="#6c7388"/>
                        <path d="M8.87078 17.9406C7.36078 18.9506 7.36078 20.6106 8.87078 21.6106C10.5908 22.7606 13.4108 22.7606 15.1308 21.6106C16.6408 20.6006 16.6408 18.9406 15.1308 17.9406C13.4208 16.7906 10.6008 16.7906 8.87078 17.9406Z" fill="#6c7388"/>
                        </svg>
                  </button>
               </div>
            </div>
            <div class="room-modal-content-in organized-modal-content-in">
               <ul class="hidden landscape user-search-list"></ul>
            </div>
         </div>
            
      </div>
   </div>
</div>
<div class="search-movie-and-series-modal modal modal-small fixed flex flex-col items-center justify-center">
   <div class="search-movie-and-series-modal-body modal-body relative">
      <div class="search-movie-and-series-header modal-header">
         <div class="search-movie-and-series-input-box flex items-center relative">
            <input type="text" id="room-search" placeholder="Bir film veya dizi arayın yada link yapıştırın">
            <div class="search-movie-and-series-input-icon absolute">
               <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                  <circle cx="11" cy="11" r="8"></circle>
                  <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
               </svg>
            </div>
         </div>
      </div>
      <div class="room-search-wrap w-full">

      </div>
   </div>
</div>


<script src="https://js.pusher.com/7.1/pusher.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
window.ownerRoom = <?= $room->user_id == $this->user_id ? true : false?>

 Pusher.logToConsole = false;
 var pusher = new Pusher('6d7dc6ebf22fd10a6359', {
   cluster: 'eu',
   channelAuthorization: { 
     endpoint: "/pusher_user_auth"
   }
 });

 var channel = pusher.subscribe('presence-cache-room-<?= $room->slug?>');
 channel.bind('room-message', function(data) {
   get_message(data)
 });
 channel.bind('room-playlist', function(data) {
   get_playlist(data)
 });
 channel.bind('room-setplayer', function(data) {
   set_player(data)
   playerControlOwner()
 });
 channel.bind('room-control', function(data) {
   if(window.ownerRoom == false){
      playerControl(data)
   }
 });
 channel.bind('room-message-check', function(data) {
   if(data.typing == 1){
      $("#message-check").html(data.message);
   }else {
      $("#message-check").html("");
   }
 });
 channel.bind('room-watch-pause', function(data) {
   console.log(data,"pause moruk");
 });
function playerControl(content){
   var iframe = document.getElementById("player") ? document.getElementById("player") : "";
   if(iframe){
      const iWindow = iframe.contentWindow;
      if(content.video && !content.video.unstarted){
         iWindow.jwpl.play();
         console.log('unstard')
      } else if(content.video && content.video.playing == 1 ){
         var seek = parseFloat(content.video.last_played_second);
         var seek_diff =  parseFloat(Math.floor(new Date() / 1000) - content.video.last_played_date);
         seek = seek_diff + seek;
         iWindow.jwpl.seek(seek)

      }else if(content.video && content.video.playing == 0 && content.video.last_paused_second >= 1 ){
         iWindow.jwpl.stop()
      }
      if(content && window.ownerRoom == false){
         // iWindow.jwpl.setControls(false)
      }
      iWindow.jwpl.on("seeked",function(){
      })
   }
}
channel.bind('room-func', function(data) {
   console.log(data)
   get_message(data)
});
function get_message(data){
   var user = channel.members.get(data.id)
   if(user){
      var color = user.info.color;
   }else {
      var color = "background: rgb(64 208 79);";
   }
   var theme = `
      <div class="chat-box block mb-3 flex relative w-full flex-col">
         <span class="line-border " style="${color}"></span>
         <div class="chat-box-top ">
            <a href="">${data.name}</a>
            <span>• ${data.time}</span>
         </div>
         <div class="chat-box-message ">
            <p>${data.message}</p>
         </div>
      </div>
   `;

   $(".together-watch-chat-box-in").append(theme)
 }
function update_member_count(count){
   $("#memberCount").html(count)
 }
function set_player(data){
   $("#player").attr('src',data.video)
}
function get_playlist(data){
   if(data){
      var theme = ""
      
      if(data.video && data.video.data){
         if(data.video.type == 1){
            var pathNow = 'series';
            var nowPath = `${data.video.data.time ?? 0} dk • Sezon ${data.video.data.season} - Bölüm ${data.video.data.episode}`;
         }else {
            var pathNow = 'movies';
            var nowPath = `${data.video.data.time ?? 0} dk`;
         }
         var now = `
         <li>
            <div class="playlist-item flex items-center justify-between">
               <div class="flex items-center">
                  <div class="playing-image mr-2 flex-shrink-0">
                     <img src="/uploads/${pathNow}/original/${data.video.data.image}">
                  </div>
                  <div class="playlist-text">
                     <p>${data.video.data.name}</p>
                     <span>${nowPath}</span>
                  </div>
               </div>
               <div class="playlist-icon">
                  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                     <path d="M19.0717 19.8211C18.8817 19.8211 18.6917 19.7511 18.5417 19.6011C18.2517 19.3111 18.2517 18.8311 18.5417 18.5411C22.1517 14.9311 22.1517 9.06109 18.5417 5.46109C18.2517 5.17109 18.2517 4.69109 18.5417 4.40109C18.8317 4.11109 19.3117 4.11109 19.6017 4.40109C23.7917 8.59109 23.7917 15.4111 19.6017 19.6011C19.4517 19.7511 19.2617 19.8211 19.0717 19.8211Z" fill="#6c7388"></path>
                     <path d="M4.93031 19.8211C4.74031 19.8211 4.55031 19.7511 4.40031 19.6011C0.210312 15.4111 0.210312 8.59109 4.40031 4.40109C4.69031 4.11109 5.17031 4.11109 5.46031 4.40109C5.75031 4.69109 5.75031 5.17109 5.46031 5.46109C1.85031 9.07109 1.85031 14.9411 5.46031 18.5411C5.75031 18.8311 5.75031 19.3111 5.46031 19.6011C5.31031 19.7511 5.12031 19.8211 4.93031 19.8211Z" fill="#6c7388"></path>
                     <path d="M11.9988 22.7119C10.7488 22.7019 9.55878 22.5019 8.44878 22.1119C8.05878 21.9719 7.84878 21.5419 7.98878 21.1519C8.12878 20.7619 8.54878 20.5519 8.94878 20.6919C9.90878 21.0219 10.9288 21.2019 12.0088 21.2019C13.0788 21.2019 14.1088 21.0219 15.0588 20.6919C15.4488 20.5619 15.8788 20.7619 16.0188 21.1519C16.1588 21.5419 15.9488 21.9719 15.5588 22.1119C14.4388 22.5019 13.2488 22.7119 11.9988 22.7119Z" fill="#6c7388"></path>
                     <path d="M15.2988 3.33906C15.2188 3.33906 15.1288 3.32906 15.0488 3.29906C14.0988 2.95906 13.0688 2.78906 11.9988 2.78906C10.9288 2.78906 9.90878 2.96906 8.94878 3.29906C8.54878 3.42906 8.12878 3.22906 7.98878 2.83906C7.84878 2.44906 8.05878 2.01906 8.44878 1.87906C9.56878 1.48906 10.7588 1.28906 11.9988 1.28906C13.2388 1.28906 14.4388 1.48906 15.5488 1.87906C15.9388 2.01906 16.1488 2.44906 16.0088 2.83906C15.8988 3.14906 15.6088 3.33906 15.2988 3.33906Z" fill="#6c7388"></path>
                     <path d="M8.73828 12.0001V10.3301C8.73828 8.25014 10.2083 7.40014 12.0083 8.44014L13.4583 9.28014L14.9083 10.1201C16.7083 11.1601 16.7083 12.8601 14.9083 13.9001L13.4583 14.7401L12.0083 15.5801C10.2083 16.6201 8.73828 15.7701 8.73828 13.6901V12.0001Z" fill="#6c7388"></path>
                     </svg>
               </div>
            </div>
         </li>
      `
         $(".playlist > ul").html(now)
         $("#player-content").removeClass('hidden');
         $("#friends-content").addClass('hidden');
         
        
      }
      $.each(data.playlist,function(a,i){
         var path = ""
         var sub_title = ""
         if(i.type == 1){
            path = 'series';
            sub_title = `Toplam Sezon Sayısı : ${i.data.season_count}`
         }else {
            path = 'movies';
            sub_title = ``
         }
         var cs = ""
         var action = ""
         if(window.ownerRoom){
            cs = "play-item";
            action = `<div class="playlist-icon">
                    <div class="countdown-actions relative">
                        <button class="flex focus:outline-none rounded-full">
                           <svg viewBox="0 0 22 6">
                              <path d="M19,6c-1.657,0-3-1.344-3-3c0-1.656,1.343-3,3-3s3,1.344,3,3C22,4.656,20.657,6,19,6z M19,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C20,2.447,19.552,2,19,2z M11,6C9.343,6,8,4.656,8,3c0-1.656,1.343-3,3-3s3,1.344,3,3C14,4.656,12.657,6,11,6z M11,2c-0.553,0-1,0.447-1,1c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C12,2.447,11.552,2,11,2z M3,6C1.343,6,0,4.656,0,3c0-1.656,1.343-3,3-3c1.656,0,3,1.344,3,3C6,4.656,4.656,6,3,6z M3,2C2.447,2,2,2.447,2,3c0,0.552,0.447,1,1,1c0.552,0,1-0.449,1-1C4,2.447,3.552,2,3,2z"></path>
                           </svg>
                        </button>
                        <div class="options-drop-content absolute">
                           <ul>
                              <li>
                                 <a class="flex items-center text-tooltip-tft" data-remove-playlist="${i.id}" data-title="İçerik yayınlandığında haberiniz olur." href="javascript:;">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                       <path d="M21.0697 5.23C19.4597 5.07 17.8497 4.95 16.2297 4.86V4.85L16.0097 3.55C15.8597 2.63 15.6397 1.25 13.2997 1.25H10.6797C8.34967 1.25 8.12967 2.57 7.96967 3.54L7.75967 4.82C6.82967 4.88 5.89967 4.94 4.96967 5.03L2.92967 5.23C2.50967 5.27 2.20967 5.64 2.24967 6.05C2.28967 6.46 2.64967 6.76 3.06967 6.72L5.10967 6.52C10.3497 6 15.6297 6.2 20.9297 6.73C20.9597 6.73 20.9797 6.73 21.0097 6.73C21.3897 6.73 21.7197 6.44 21.7597 6.05C21.7897 5.64 21.4897 5.27 21.0697 5.23Z" fill="#fff"/>
                                       <path opacity="0.3991" d="M19.2297 8.14C18.9897 7.89 18.6597 7.75 18.3197 7.75H5.67975C5.33975 7.75 4.99975 7.89 4.76975 8.14C4.53975 8.39 4.40975 8.73 4.42975 9.08L5.04975 19.34C5.15975 20.86 5.29975 22.76 8.78975 22.76H15.2097C18.6997 22.76 18.8398 20.87 18.9497 19.34L19.5697 9.09C19.5897 8.73 19.4597 8.39 19.2297 8.14Z" fill="#fff"/>
                                       <path fill-rule="evenodd" clip-rule="evenodd" d="M9.58008 17C9.58008 16.5858 9.91586 16.25 10.3301 16.25H13.6601C14.0743 16.25 14.4101 16.5858 14.4101 17C14.4101 17.4142 14.0743 17.75 13.6601 17.75H10.3301C9.91586 17.75 9.58008 17.4142 9.58008 17Z" fill="#fff"/>
                                       <path fill-rule="evenodd" clip-rule="evenodd" d="M8.75 13C8.75 12.5858 9.08579 12.25 9.5 12.25H14.5C14.9142 12.25 15.25 12.5858 15.25 13C15.25 13.4142 14.9142 13.75 14.5 13.75H9.5C9.08579 13.75 8.75 13.4142 8.75 13Z" fill="#fff"/>
                                       </svg>

                                    Listeden sil
                             
                                 </a>
                              </li>
                           </ul>
                        </div>
                     </div>
                  </div>`
         }
         theme += `
            <li class="">
               <div class="playlist-item flex items-center justify-between">
                  <div class="${cs} flex items-center" data-type="${i.type}" data-id="${i.data.id}">
                     <div class="playing-image mr-2 flex-shrink-0">
                        <img src="/uploads/${path}/original/${i.data.image}">
                     </div>
                     <div class="playlist-text">
                        <p>${i.data.name}</p>
                        <span>${sub_title}</span>
                     </div>
                  </div>
                  ${action}
               </div>
            </li>
         `;
      });
      $("#playlist").html(theme)
   }
}
function join_member(member){
   var time = new Date().toLocaleString("tr-TR", {timeStyle:"short"})
   var theme = `
   <div class="activity join mb-3">
      <div class="activity-inner flex items-center">
         <div class="activity-icon">
            <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" height="16" width="16" stroke="currentColor" stroke-width="3" stroke-linejoin="round" stroke-linecap="round"><path stroke="currentColor" d="M6.757 17.243l9.9-9.9m0 0H8.172m8.485 0v8.485"></path></svg>
         </div>
         <div class="activity-text flex items-center">
            <p class="truncate mr-1">${member.info.name}</p>
            <span>giriş yaptı</span>
         </div>
         <div class="activity-date">
            <span class="activity-time "><span class="mx-1">•</span>${time}</span>
         </div>
      </div>
   </div>
   `;
   $(".together-watch-chat-box-in").append(theme)
 }
function remove_member(member){
   var time = new Date().toLocaleString("tr-TR", {timeStyle:"short"})
   var theme = `
   <div class="activity join mb-3">
      <div class="activity-inner flex items-center">
         <div class="activity-icon">
           <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" height="16" width="16" stroke="currentColor" stroke-width="3" stroke-linejoin="round" stroke-linecap="round"><path stroke="currentColor" d="M17.243 6.757l-9.9 9.9m0 0h8.485m-8.485 0V8.172"></path></svg>
         </div>
         <div class="activity-text flex items-center">
            <p class="truncate mr-1">${member.info.name}</p>
            <span>çıkış yaptı</span>
         </div>
         <div class="activity-date">
            <span class="activity-time "><span class="mx-1">•</span>${time}</span>
         </div>
      </div>
   </div>
   `;
   $(".together-watch-chat-box-in").append(theme)
}
channel.bind("pusher:cache_miss", () => {
   console.log("ilk alım cacahe")
});
 channel.bind("pusher:subscribe", (data,war) => {
   console.log("1",data,war)
});
channel.bind("pusher:member_removed", (member) => {
   update_member_count(channel.members.count);
   remove_member(member)
});
channel.bind("pusher_internal:member_removed", (member) => {
   update_member_count(channel.members.count);
   remove_member(member)
});
 channel.bind("pusher:member_added", (member) => {
   update_member_count(channel.members.count);
   join_member(member);
 });
 channel.bind("pusher_internal:member_added", (member) => {
   update_member_count(channel.members.count);
   join_member(member);
 });
 channel.bind("pusher:subscription_succeeded", (members) => {
   // For example
   update_member_count(members.count);
   members.each((member) => {
     // For example
     // add_member(member.id, member.info);
   });
 });

channel.members.each(function (member) {
   var userId = member.id;
   var userInfo = member.info;
   console.log(userId,userInfo)
 });
$(document).on("click",".send-message",function(){
   var message = $("#message-box").val();
   if(message){
      var t = $(this);
      var html = t.html();
      t.html(loader2);
      t.prop('disabled',true);
      $("#message-box").prop("disabled",true)
      $.ajax({
       type: "POST",
       url: origin + "/room/set/message",
       dataType: "json",
       data: {message,room: '<?= $room->id?>'},
          success: function(result) {
           if(result.success) {
            $("#message-box").val("");
           } else {
           }
          },
          complete: function() {
               t.html(html);
               t.prop('disabled',false);
               $("#message-box").prop("disabled",false)

          }
      });
   }
 });
 /*$(document).on("input","#message-box",function(){
   var t = $(this).val();
   if(t.length >= 1 && t.length < 2){
      $.ajax ({
       type: "POST",
       url: origin + "/room/set/message/check",
       dataType: "json",
       data: {room: '<?= $room->id?>',typing:1},
          success: function(result) {
           if(result.success) {
           
           } else {
           }
          },
          complete: function() {
          }
      });
   }else if(!t.length){
      $.ajax ({
       type: "POST",
       url: origin + "/room/set/message/check",
       dataType: "json",
       data: {room: '<?= $room->id?>',typing:0},
          success: function(result) {
           if(result.success) {
           
           } else {
           }
          },
          complete: function() {
          }
      });
   }
 })*/

function playerControlOwner(){
   if(window.ownerRoom){
      setTimeout(function(){
         var iframe = document.getElementById("player") ? document.getElementById("player") : "";
         window.iWindow = iframe.contentWindow;
         if(window.iWindow.jwpl && window.ownerRoom == false){
            // window.iWindow.jwpl.setControls(false)
         }
         if(window.iWindow.jwpl){
            window.iWindow.jwpl.on("pause",function(a){
               if(a.pauseReason == "interaction"){
                  var position = window.iWindow.jwpl.getPosition();
                  $.ajax ({
                     type: "POST",
                     url: origin + "/room/set/control",
                     dataType: "json",
                     data: {room: "<?= $room->id ?>",play:0,position},
                      success: function(result) {
                     
                      },
                      complete: function() {
                      }
                  });
               }
            });
            window.iWindow.jwpl.on("play",function(a,s){
               if(a.playReason == "interaction"){
                  var position = window.iWindow.jwpl.getPosition();
                  $.ajax ({
                     type: "POST",
                     url: origin + "/room/set/control",
                     dataType: "json",
                     data: {room: "<?= $room->id ?>",play:1,position},
                      success: function(result) {
                     
                      },
                      complete: function() {
                      }
                  });
               }
               
            })
         }
      },1000)
   }
}
$(document).ready(function(){
   playerControlOwner()
   $(document).on("click",".hide-season-list",function(){
      $(".player-series-seasons").html("")
   })
   $.ajax({
      url:'/room/info/<?= $room->slug?>',
      type:'POST',
      datType:'json',
      data: {
         ping:1
      }
   })
})
</script>
