<!DOCTYPE html>
<head>
  <title>Pusher Test</title>
  <script src="https://js.pusher.com/7.1/pusher.min.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>

    // Enable pusher logging - don't include this in production
    Pusher.logToConsole = true;

    var pusher = new Pusher('6d7dc6ebf22fd10a6359', {
      cluster: 'eu',
      channelAuthorization: { 
        endpoint: "/pusher_user_auth"
      }
    });

    var channel = pusher.subscribe('presence-cache-test-kanal');
    channel.bind('test-func', function(data) {
      $("body").append('<p>'+data.message+'</p>')
    });
    function update_member_count(count){
      $("#user_count").html(count)
    }
    channel.bind("pusher:cache_miss", () => {
      console.log("ilk alım")
  });
    channel.bind("pusher:member_added", (member) => {
      // For example
     console.log('sekme actık')
    });
    channel.bind("pusher:subscription_succeeded", (members) => {
      // For example
      console.log(members,"sakso")
      update_member_count(members.count);
      members.each((member) => {
        // For example
        // add_member(member.id, member.info);
      });
    });

    channel.members.each(function (member) {
      var userId = member.id;
      var userInfo = member.info;
      console.log(userId,userInfo)
    });
  </script>
</head>
<body>
  <h1>Pusher Test</h1>
  <p id="">Kişi: <span id="user_count"></span></p>
  <p>
    Try publishing an event to channel <code>my-channel</code>
    with event name <code>my-event</code>.
  </p>
</body>
