<div class="together-watch-wrapper flex w-full h-full" data-room="<?= $room->id?>">
   <div class="series-playlist-inner flex flex-col">
      <div class="playlist-wrapper h-1/5 px-4">
         <div class="series-playlist-header flex items-center justify-between">
            <div class="series-playlist-header-text">
               <span class="block font-bold text-white"><?= $room->title?></span>
               <small class="truncate font-bold">Public Group</small>
            </div>
            <div class="series-playlist-header-icon">
               <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><polyline points="6 9 12 15 18 9"></polyline></svg>
            </div>
         </div>
         <div class="series-playlist-search mt-5 relative">
            <input type="text" placeholder="Dizi veya film ara..">
               <div class="series-playlist-search-icon absolute">
                  <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                     <circle cx="11" cy="11" r="8"></circle>
                     <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                  </svg>
               </div>
               <div class="main-search-drop fixed md:absolute">
                  <div class="main-search-mobile flex md:hidden">
                     <div class="main-search-mobile-input relative">
                        <input type="text" placeholder="Dizi veya film ara..">
                        <div class="main-search-icon absolute">
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <circle cx="11" cy="11" r="8"></circle>
                              <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                           </svg>
                        </div>
                     </div>
                     <div class="main-search-mobile-close">
                        <button class="flex items-center justify-center focus:outline-none">
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <line x1="18" y1="6" x2="6" y2="18"></line>
                              <line x1="6" y1="6" x2="18" y2="18"></line>
                           </svg>
                        </button>
                     </div>
                  </div>   
               </div>
         </div>
         <div class="series-chat-panel flex items-center justify-between">
            <div class="series-chat-total-user">
               <span class="flex items-center font-bold">
                  <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                     <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                     <circle cx="8.5" cy="7" r="4"></circle>
                     <line x1="20" y1="8" x2="20" y2="14"></line>
                     <line x1="23" y1="11" x2="17" y2="11"></line>
                  </svg>
                  <span id="memberCount">0</span>
               </span>
            </div>
            <div class="series-chat-message-button">
               <a id="messageButton" class="block relative chat-message-button " href="javascript:void(0);">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                  </svg>
               </a>
            </div>
         </div>
      </div>
      <div class="series-playlist-content  relative">
            <div class="series-playlist-boxes px-4">
               <div class="series-playlist-unkown">
                  <svg xmlns="http://www.w3.org/2000/svg" width="120" fill="none" viewBox="0 0 155 102"><rect width="116" height="50" x="18.038" y="32.528" fill="#fff" fill-opacity="0.1" rx="6" transform="rotate(-6 18.038 32.528)"></rect><rect width="20" height="20" x="34.158" y="45.586" fill="#fff" fill-opacity="0.1" rx="4" transform="rotate(-6 34.158 45.586)"></rect><rect width="56" height="4" x="62.527" y="47.632" fill="#fff" fill-opacity="0.1" rx="2" transform="rotate(-6 62.527 47.632)"></rect><rect width="27" height="4" x="63.259" y="54.594" fill="#fff" fill-opacity="0.1" rx="2" transform="rotate(-6 63.259 54.594)"></rect><rect width="114" height="48" x="19.137" y="33.418" stroke="#fff" stroke-dasharray="5 2" stroke-opacity="0.15" stroke-width="2" rx="5" transform="rotate(-6 19.137 33.418)"></rect><ellipse cx="82" cy="99" fill="#fff" fill-opacity="0.1" rx="25" ry="3"></ellipse><rect width="10" height="2" x="15.538" y="96.757" fill="#fff" fill-opacity="0.1" rx="1" transform="rotate(-54.793 15.538 96.757)"></rect><rect width="10" height="2" x="151.517" y="79.098" fill="#fff" fill-opacity="0.1" rx="1" transform="rotate(-138.74 151.517 79.098)"></rect><rect width="10" height="2" x="131.596" y="14.94" fill="#fff" fill-opacity="0.1" rx="1" transform="rotate(-61.87 131.596 14.94)"></rect><rect width="10" height="2" fill="#fff" fill-opacity="0.1" rx="1" transform="scale(-1 1) rotate(-44.067 28.485 32.486)"></rect><path fill="#fff" fill-opacity="0.2" d="M148.361 41.52c-.098-.02-.152-.13-.139-.228l.003-.023.113-.573c.117-.597.334-1.05.651-1.36.329-.32.77-.638 1.323-.95.448-.248.791-.479 1.027-.693.237-.214.391-.5.461-.858.075-.383.016-.71-.176-.984-.191-.285-.478-.466-.863-.541-.415-.081-.775-.022-1.08.18-.296.202-.483.5-.56.894l-.056.287c-.026.131-.098.185-.217.162l-1.714-.429c-.098-.019-.152-.129-.139-.227l.003-.023.035-.179c.141-.717.413-1.32.817-1.812.406-.503.9-.853 1.481-1.05.594-.206 1.236-.241 1.927-.106.671.132 1.229.396 1.674.793.457.388.773.871.946 1.45.173.58.192 1.217.056 1.91-.103.525-.27.964-.503 1.315-.221.341-.463.61-.727.806a9.39 9.39 0 01-.984.627c-.413.228-.725.434-.935.616-.21.182-.345.429-.406.74l-.081.411a.252.252 0 01-.091.15.148.148 0 01-.129.03l-1.717-.336zm.013 4.17a1.092 1.092 0 01-.767-.56c-.163-.317-.205-.68-.125-1.085.079-.406.253-.72.522-.94.269-.22.576-.296.921-.229.346.068.596.254.752.557.168.293.211.65.129 1.067-.079.406-.255.725-.526.958-.268.22-.57.297-.906.231zM104.884 9.07c-.09-.042-.116-.161-.079-.254l.009-.02.249-.53c.259-.55.58-.937.963-1.16.397-.23.902-.43 1.515-.6.495-.13.883-.27 1.165-.42.282-.15.5-.39.656-.72.166-.353.189-.685.069-.997-.115-.323-.35-.568-.705-.735-.382-.18-.746-.21-1.091-.09-.337.125-.59.368-.761.732l-.125.264c-.057.121-.14.156-.249.105l-1.558-.834c-.09-.043-.116-.162-.08-.255l.009-.02.078-.166c.311-.66.722-1.18 1.233-1.558a3.187 3.187 0 011.693-.657c.626-.055 1.258.067 1.895.367.619.291 1.095.684 1.43 1.178.349.487.537 1.032.563 1.637.027.604-.11 1.226-.41 1.865-.228.484-.498.869-.809 1.153a3.066 3.066 0 01-.902.605 9.463 9.463 0 01-1.106.367c-.458.121-.81.244-1.058.37a1.267 1.267 0 00-.574.618l-.179.38a.25.25 0 01-.125.123.148.148 0 01-.132-.002l-1.584-.745zm-1.004 4.048a1.094 1.094 0 01-.607-.73c-.081-.347-.033-.708.143-1.082.176-.375.421-.636.736-.784.314-.148.63-.148.949.002.318.15.516.391.593.724.092.325.047.68-.135 1.066-.176.374-.424.641-.743.8a1.05 1.05 0 01-.936.004zM50.166 15.927c-.08.06-.198.025-.261-.052a.37.37 0 01-.014-.018l-.345-.472c-.358-.491-.544-.959-.556-1.402-.012-.459.056-.998.202-1.617.123-.496.186-.904.19-1.223.004-.32-.102-.627-.318-.922-.23-.314-.51-.494-.841-.538-.338-.055-.666.034-.983.265-.341.25-.542.554-.602.915-.053.354.04.694.276 1.018l.172.236c.08.108.07.198-.027.27l-1.48.966c-.08.059-.198.024-.261-.052a.36.36 0 01-.014-.018l-.108-.148c-.43-.59-.69-1.2-.776-1.83a3.185 3.185 0 01.237-1.8c.252-.576.662-1.071 1.231-1.486.552-.403 1.125-.633 1.72-.69a2.98 2.98 0 011.706.292c.543.266 1.023.685 1.44 1.255.315.432.523.853.622 1.263.1.394.134.754.098 1.081a9.41 9.41 0 01-.208 1.147c-.113.46-.174.828-.183 1.106-.01.277.08.544.266.8l.248.339c.036.05.052.105.048.168a.149.149 0 01-.065.116l-1.414 1.031zm3.07 2.824a1.092 1.092 0 01-.932.182c-.344-.096-.638-.31-.882-.645-.244-.334-.355-.675-.334-1.021.02-.347.173-.624.457-.832.285-.207.591-.265.92-.173.329.076.62.286.87.63.245.334.36.68.346 1.036-.02.347-.17.621-.446.823zM3.974 60.375c-.096-.024-.145-.136-.127-.234a.346.346 0 01.005-.022l.143-.567c.148-.59.389-1.032.721-1.325.346-.302.803-.595 1.372-.878.461-.224.815-.436 1.063-.637.247-.201.416-.48.505-.833.095-.378.053-.709-.124-.992-.175-.295-.453-.49-.833-.586-.41-.102-.772-.062-1.088.122-.307.187-.509.475-.607.864l-.07.284c-.033.13-.108.18-.225.15l-1.69-.518c-.096-.025-.145-.137-.127-.235a.346.346 0 01.005-.022l.044-.177c.179-.709.482-1.297.911-1.767a3.185 3.185 0 011.535-.97c.604-.174 1.247-.175 1.93-.004.663.167 1.207.46 1.63.88.436.411.725.91.868 1.499.142.588.127 1.225-.045 1.91-.13.519-.321.948-.572 1.286-.238.33-.495.585-.769.767a9.415 9.415 0 01-1.015.573c-.425.207-.747.396-.967.567-.219.17-.367.41-.444.716l-.103.407a.251.251 0 01-.098.145.149.149 0 01-.13.024l-1.698-.427zm-.207 4.165a1.092 1.092 0 01-.736-.599c-.146-.325-.169-.689-.068-1.09.1-.402.291-.705.571-.91.28-.207.59-.267.932-.18.341.085.582.284.721.595.153.302.177.66.073 1.072-.1.402-.293.711-.576.929-.28.206-.585.267-.917.183z"></path></svg>
               </div>
               <p class="text-white font-bold mt-2">Oynatma listesi boş</p>
               <small class="text-center mt-2 leading-5	">Oynatma listesine eklenen sonraki videolar burada görünecektir.</small>
            </div>
            <div class="together-watch-chat absolute active-chat-close" id="together-watch-chat">
               <aside class="chatpanel h-full">
                     <div class="together-watch-chat-box h-full ">
                        <div class="together-watch-chat-box-inner flex h-full flex-col justify-between">
                              <div class="together-watch-chat-box-in">
                                 <div class="together-messages-box flex">
                                    <span class="inline-block">burakdzgr : 
                                    <small class="block">Abi hadi ne zaman başlıyor bu film ya?</small>
                                    </span>
                                 </div>
                                 <div class="together-messages-box flex">
                                    <span class="inline-block">burakdzgr : 
                                    <small class="block">Abi hadi ne zaman başlıyor bu film ya?</small>
                                    </span>
                                 </div>
                              </div>
                              <div class="messages-content-write">
                                 <form class="form-group flex flex-col sm:flex-row" id="message-form" method="post">
                                    <div class="form-element w-full relative">
                                          <input type="text" placeholder="Mesaj yaz..." required="">
                                          <div class="form-element-reset absolute">
                                          <button class="flex focus:outline-none" type="reset">
                                             <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                <line x1="18" y1="6" x2="6" y2="18"></line>
                                                <line x1="6" y1="6" x2="18" y2="18"></line>
                                             </svg>
                                          </button>
                                          </div>
                                    </div>
                                    <div class="form-element w-full sm:w-auto">
                                          <button class="button-first send-message flex items-center justify-center focus:outline-none w-full sm:w-auto">
                                          <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                             <line x1="22" y1="2" x2="11" y2="13"></line>
                                             <polygon points="22 2 15 22 11 13 2 9 22 2"></polygon>
                                          </svg>
                                          </button>
                                    </div>
                                 </form>
                              </div>
                        </div>
                     </div>
            </aside>
         </div>  
      </div>   
   </div>
   <div class="player-content w-full relative">
      <div class="player-content-bg-overlay bg-overlay w-full absolute top-0">
         <div class="inner" style="background-image: url('https://assets.nflxext.com/ffe/siteui/vlv3/5c235903-02cc-4228-85a2-5fcef1e47627/64b51a11-7322-496c-aab1-411ddf583abd/TR-tr-20211227-popsignuptwoweeks-perspective_alpha_website_small.jpg');"></div>
      </div>
      <div class="player-content-description flex items-center justify-center">
         <div class="player-content-description-box">
         <h4 class="font-semibold text-white text-3xl">Yalnız başına ne yapıyorsun?</h4>
         <p class="w-full">Hemen arkadaşlarına davet bağlantısı göndererek dizi/film partisini oluşturabilir, eğlencenin dibine vurabilirsin.</p>
         <div class="player-content-actions w-full mt-8">
               <ul>
                  <li>
                     <button class="focus:outline-none w-full flex justify-between hover:shadow-lg shadow-cyan-500/50" data-target=".invite-firends-modal">
                        <div class="player-content-actions-button flex items-center">
                              <svg class="mr-5" xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="none" viewBox="0 0 40 40"><circle cx="20" cy="20" r="20" fill="rgb(146, 156, 255, 0.2)"></circle><circle cx="34" cy="6" r="6" fill="#FF3D1F"></circle><path fill="#fff" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="2" d="M15.832 28c1.231.663 2.652 1 4.168 1 4.926 0 9-4.074 9-9s-4.074-9-9-9-9 4.074-9 9c0 1.516.337 2.768 1 4l-1 5 4.832-1z" opacity="0.8"></path><rect width="4" height="4" x="15" y="18" fill="#46495f" rx="2"></rect><rect width="4" height="4" x="21" y="18" fill="#46495f" rx="2"></rect></svg>
                              Arkadaşların arasından davet et
                        </div>
                        <div class="player-content-actions-icon">
                              <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><polyline points="9 18 15 12 9 6"></polyline></svg>
                        </div>
                     </button>
                  </li>
                  <li class="mt-4">
                     <button class="focus:outline-none w-full flex justify-between hover:shadow-lg shadow-cyan-500/50" data-target=".invite-firends-link-modal">
                        <div class="player-content-actions-button flex items-center">
                              <svg class="mr-5" xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="none" viewBox="0 0 40 40"><g clip-path="url(#clip0)"><circle cx="20" cy="20" r="20" fill="rgb(176, 255, 199, 0.2)"></circle><circle cx="20" cy="17" r="5" fill="#fff" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="3.6" opacity="0.8"></circle><path fill="#fff" opacity="0.8" d="M20 28c-9 0-12 8-12 8s4 4 12 4 12-4 12-4-3-8-12-8z"></path><circle cx="34" cy="6" r="6" fill="#00C56A"></circle></g><defs><clipPath id="clip0"><path fill="#fff" d="M0 0H40V40H0z"></path></clipPath></defs></svg>
                              Arkadaşlarını davet et
                        </div>
                        <div class="player-content-actions-icon">
                              <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><polyline points="9 18 15 12 9 6"></polyline></svg>
                        </div>
                     </button>
                  </li>
                  <li class="mt-4">
                  <button class="focus:outline-none w-full flex justify-between hover:shadow-lg shadow-cyan-500/50" data-target=".search-movie-and-series-modal">
                     <div class="player-content-actions-button flex items-center">
                           <svg class="mr-5" xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="none" viewBox="0 0 40 40"><circle cx="20" cy="20" r="20" fill="rgb(255, 186, 229, 0.2)"></circle><circle cx="34" cy="6" r="6" fill="#ff8f7b"></circle><path fill="#fff" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 21.895L20.227 11v7.105H27L20.227 29v-7.105H13z" opacity="0.8"></path></svg>
                           Dizi veya film ara
                     </div>
                     <div class="player-content-actions-icon">
                           <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><polyline points="9 18 15 12 9 6"></polyline></svg>
                     </div>
                  </button>
                  </li>
                  
               </ul>
         </div>
         </div>
      </div>
   </div>
</div>
<div class="invite-firends-link-modal modal modal-small fixed flex flex-col items-center justify-center">
   <div class="invite-friends-body modal-body relative overflow-y-auto">
      <div class="invite-friends-modal-content mb-5">
         <span class="block text-3xl text-white">Arkadaşlarını Davet Et</span>
         <p>Grup linkini arkadaşlarınızla paylaşın ve birlikte izlemenin keyfini çıkarın</p>
      </div>
      <div class="invite-friends-content modal-content">
         <div class="form-group">
            <div class="form-element relative">
               <input class="linkToCopy" type="text" value="<?= base_url("room/$room->slug")?>" id="pageUrl" name="pageUrl" autocomplete="off" required=""><label class="block absolute" for="pageUrl">Parti Linki</label>
               <div class="form-element-end-icon absolute">
                  <button class="flex copyButton focus:outline-none">
                     <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect>
                        <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path>
                     </svg>
                  </button>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>

<div class="invite-firends-modal modal modal-small fixed flex flex-col items-center justify-center">
   <div class="invite-friends-body modal-body relative overflow-y-auto">
      <div class="invite-friends-modal-content mb-5">
         <span class="block text-3xl text-white">Arkadaşlarını Davet Et</span>
         <p>Grup linkini arkadaşlarınızla paylaşın ve birlikte izlemenin keyfini çıkarın</p>
      </div>
      <div class="invite-friends-content modal-content">
         <div class="form-group">
            <div class="form-element relative">
               <input class="room-friends-user" type="text" value="" name="pageUrl" autocomplete="off" required="">
               <label class="block absolute" for="pageUrl">Arkadaş Ara</label>
               <div class="form-element-end-icon absolute">
                  <button class="flex copyButton focus:outline-none">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M17.5291 7.77C17.4591 7.76 17.3891 7.76 17.3191 7.77C15.7691 7.72 14.5391 6.45 14.5391 4.89C14.5391 3.3 15.8291 2 17.4291 2C19.0191 2 20.3191 3.29 20.3191 4.89C20.3091 6.45 19.0791 7.72 17.5291 7.77Z" fill="#6c7388"/>
                        <path d="M20.7916 14.7004C19.6716 15.4504 18.1016 15.7304 16.6516 15.5404C17.0316 14.7204 17.2316 13.8104 17.2416 12.8504C17.2416 11.8504 17.0216 10.9004 16.6016 10.0704C18.0816 9.8704 19.6516 10.1504 20.7816 10.9004C22.3616 11.9404 22.3616 13.6504 20.7916 14.7004Z" fill="#6c7388"/>
                        <path d="M6.44016 7.77C6.51016 7.76 6.58016 7.76 6.65016 7.77C8.20016 7.72 9.43016 6.45 9.43016 4.89C9.43016 3.29 8.14016 2 6.54016 2C4.95016 2 3.66016 3.29 3.66016 4.89C3.66016 6.45 4.89016 7.72 6.44016 7.77Z" fill="#6c7388"/>
                        <path d="M6.55109 12.8506C6.55109 13.8206 6.76109 14.7406 7.14109 15.5706C5.73109 15.7206 4.26109 15.4206 3.18109 14.7106C1.60109 13.6606 1.60109 11.9506 3.18109 10.9006C4.25109 10.1806 5.76109 9.89059 7.18109 10.0506C6.77109 10.8906 6.55109 11.8406 6.55109 12.8506Z" fill="#6c7388"/>
                        <path d="M12.1208 15.87C12.0408 15.86 11.9508 15.86 11.8608 15.87C10.0208 15.81 8.55078 14.3 8.55078 12.44C8.56078 10.54 10.0908 9 12.0008 9C13.9008 9 15.4408 10.54 15.4408 12.44C15.4308 14.3 13.9708 15.81 12.1208 15.87Z" fill="#6c7388"/>
                        <path d="M8.87078 17.9406C7.36078 18.9506 7.36078 20.6106 8.87078 21.6106C10.5908 22.7606 13.4108 22.7606 15.1308 21.6106C16.6408 20.6006 16.6408 18.9406 15.1308 17.9406C13.4208 16.7906 10.6008 16.7906 8.87078 17.9406Z" fill="#6c7388"/>
                        </svg>
                  </button>
               </div>
            </div>
            <div class="room-modal-content-in organized-modal-content-in">
               <ul class="hidden landscape user-search-list"></ul>
            </div>
         </div>
            
      </div>
   </div>
</div>
<div class="search-movie-and-series-modal modal modal-small fixed flex flex-col items-center justify-center">
   <div class="search-movie-and-series-modal-body modal-body relative overflow-y-auto">
      <div class="search-movie-and-series-header modal-header">
         <div class="search-movie-and-series-input-box flex items-center relative">
            <input type="text" placeholder="Bir film veya dizi arayın yada link yapıştırın">
            <div class="search-movie-and-series-input-icon absolute">
               <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                  <circle cx="11" cy="11" r="8"></circle>
                  <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
               </svg>
            </div>
            <div class="search-movie-and-series-drop fixed md:absolute">
               <div class="mobile-search-movie-and-series-drop flex md:hidden">
                  <div class="mobile-search-movie-and-series-input relative w-full">
                     <input type="text" placeholder="Dizi, film, oyuncu ve/veya tartisma ara..">
                     <div class="mobile-search-movie-and-series-input-icon absolute">
                        <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                           <circle cx="11" cy="11" r="8"></circle>
                           <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                        </svg>
                     </div>
                  </div>
                  <div class="mobile-search-movie-and-series-close">
                     <button class="flex items-center justify-center focus:outline-none">
                        <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                           <line x1="18" y1="6" x2="6" y2="18"></line>
                           <line x1="6" y1="6" x2="18" y2="18"></line>
                        </svg>
                     </button>
                  </div>
               </div>
               <div class="search-movie-and-series-result">
                  <div class="alert flex items-center relative error w-full">
                     <div class="alert-icon flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                           <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                        </svg>
                     </div>
                     <div class="alert-text"><span class="block">Aradığınız içerik bulunamadı.</span></div>
                     <div class="alert-close absolute">
                        <button class="flex focus:outline-none">
                           <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <line x1="18" y1="6" x2="6" y2="18"></line>
                              <line x1="6" y1="6" x2="18" y2="18"></line>
                           </svg>
                        </button>
                     </div>
                  </div>
                  <!-- <div class="search-movie-and-series-drop-box search-result-item">
                     <span class="block">Diziler</span>
                     <ul>
                        <li>
                           <a class="flex items-center justify-between" href="http://localhost/dizi/la-casa-de-papel">
                              <div class="main-search-movie-box flex items-center">
                                 <div class="main-search-movie-box-image"><img class="lazy entered loaded" data-src="http://localhost/uploads/series/original/la-casa-de-papel-9761.webp" alt="La Casa de Papel" data-ll-status="loaded" src="http://localhost/uploads/series/original/la-casa-de-papel-9761.webp"></div>
                                 <div class="main-search-movie-box-text">
                                    <span class="block">La Casa de Papel</span>
                                    <ul class="flex">
                                       <li class="relative">
                                          <div class="imdb-point flex items-center">
                                             <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 213 115" style="enable-background:new 0 0 213 115;" xml:space="preserve">
                                                <style type="text/css">.st0{fill:#FBBF14;}
                                                   .st1{fill:#010101;}
                                                   .st2{fill:#273238;}
                                                </style>
                                                <path class="st0" d="M197.8,22.4c0-0.2,0-0.5,0-0.7c-0.2,0.1-0.2-0.1-0.2-0.2c-0.5-2.6-1.5-4.9-3.2-6.9c-1.9-2.3-4.3-3.9-7.1-4.9                                        c-1.4-0.5-3-0.7-4.5-0.7c-50.7,0-101.3,0-152,0c-2.7,0-5.2,0.8-7.5,2.2c-2.6,1.6-4.6,3.8-5.9,6.7c-0.5,1.1-0.9,2.3-1.1,3.6                                        c0,0.2,0,0.2-0.2,0.3c0,0.2,0,0.5,0,0.7c0,0,0.1,0,0.1,0c0,0-0.1,0.1-0.1,0.1c0,21.3,0,42.6,0,63.8c0,0,0.1,0.1,0.1,0.1                                        c0,0.1,0,0.1-0.1,0c0,0.3,0,0.5,0,0.8c0.2-0.1,0.2,0,0.2,0.2c0.4,2.3,1.3,4.3,2.6,6.2c1.2,1.7,2.7,3.1,4.5,4.1                                        c1.9,1.2,3.9,1.8,6.1,2.1c0.6,0.1,1.2,0.1,1.8,0.1c50.5,0,101,0,151.5,0c3.4,0,6.5-1.1,9.2-3.2c2-1.5,3.4-3.4,4.5-5.6                                        c0.6-1.2,1-2.4,1.2-3.7c0-0.2,0-0.2,0.2-0.3c0-0.3,0-0.5,0-0.8c0,0-0.1,0-0.1,0c0,0,0.1-0.1,0.1-0.1c0-21.3,0-42.6,0-63.8                                        C197.7,22.5,197.7,22.5,197.8,22.4C197.7,22.4,197.7,22.4,197.8,22.4z"></path>
                                                <g>
                                                   <g>
                                                      <path class="st1" d="M16,22.4C16,22.4,16.1,22.4,16,22.4c0.1,0.1,0,0.1,0,0.1C16,22.5,16,22.4,16,22.4z"></path>
                                                      <path class="st1" d="M197.8,22.5C197.7,22.5,197.7,22.5,197.8,22.5c-0.1-0.1,0-0.1,0-0.1C197.8,22.4,197.8,22.5,197.8,22.5z"></path>
                                                      <path class="st1" d="M16,86.4C16,86.4,16.1,86.4,16,86.4c0.1,0.1,0,0.1,0,0.1C16,86.4,16,86.4,16,86.4z"></path>
                                                      <path class="st1" d="M197.8,86.5C197.7,86.5,197.7,86.5,197.8,86.5c-0.1-0.1,0-0.1,0-0.1C197.8,86.4,197.8,86.4,197.8,86.5z"></path>
                                                      <path class="st0" d="M120.2,52.4c0-5.4,0-10.8,0-16.2c0-0.5,0.1-0.6,0.6-0.6c1.1,0,2.2,0,3.2,0.5c0.8,0.4,1.1,1,1.1,1.8                                            c0,9.6,0,19.2,0,28.8c0,1.6-0.9,2.2-2.1,2.5c-0.8,0.2-1.5,0.1-2.3,0.1c-0.4,0-0.5-0.1-0.5-0.5c0-1.8,0-3.6,0-5.4                                            C120.2,59.7,120.2,56.1,120.2,52.4z"></path>
                                                      <path class="st0" d="M157.7,56.1c0-4.3,0-8.7,0-13c0-1.2,0.5-1.3,1.1-1.4c0.9-0.1,1.4,0.3,1.7,1.2c0.1,0.3,0.1,0.7,0.1,1                                            c0,8.6,0,17.3,0,25.9c0,0.9-0.2,1.2-0.9,1.4c-0.7,0.2-1.2,0-1.6-0.6c-0.3-0.4-0.4-0.8-0.4-1.3C157.7,64.8,157.7,60.4,157.7,56.1z"></path>
                                                      <path class="st2" d="M82.2,51.5c0.4-1.8,0.5-3.5,0.8-5.3c0.2-1.4,0.3-2.7,0.5-4.1c0.2-1.3,0.4-2.6,0.5-3.9c0.1-1,0.2-2,0.4-3                                            c0.1-1.1,0.2-2.1,0.4-3.2c0.2-1,0.3-2.1,0.4-3.1c0.1-0.9,0-0.9,0.9-0.9c5.1,0,10.2,0,15.3,0c0.5,0,0.6,0.1,0.6,0.6                                            c0,16.4,0,32.8,0,49.2c0,0.4-0.1,0.6-0.5,0.6c-3.2,0-6.4,0-9.6,0c-0.5,0-0.6-0.1-0.6-0.6c0-8.7,0-17.5,0-26.2c0-0.2,0-0.4,0-0.6                                            c0,0-0.1,0-0.1,0c-0.4,2.1-0.7,4.1-1.1,6.2c-0.3,1.8-0.7,3.7-1,5.5c-0.3,1.8-0.6,3.7-0.9,5.5c-0.3,1.6-0.6,3.2-0.8,4.8                                            c-0.3,1.7-0.6,3.3-0.9,5c-0.1,0.4-0.2,0.5-0.6,0.5c-2.3,0-4.5,0-6.8,0c-0.2,0-0.4,0-0.4-0.3c-0.4-2.6-0.9-5.2-1.4-7.8                                            c-0.5-2.7-1-5.3-1.5-8c-0.5-2.8-0.9-5.6-1.5-8.4c-0.2-1-0.3-2-0.6-3.1c0,0.2,0,0.4,0,0.6c0,8.8,0,17.6,0,26.4                                            c0,0.5-0.1,0.7-0.6,0.7c-3.3,0-6.6,0-9.8,0c-0.5,0-0.6-0.1-0.6-0.6c0-16.4,0-32.8,0-49.2c0-0.4,0.1-0.6,0.5-0.6                                            c4.7,0,9.4,0,14.1,0c0.3,0,0.5,0,0.6,0.4c0.3,2.1,0.7,4.2,1.1,6.3c0.4,2.3,0.8,4.5,1.2,6.8c0.3,1.9,0.6,3.7,0.9,5.6                                            C81.7,48.6,82,50.1,82.2,51.5z"></path>
                                                      <path class="st2" d="M108.4,52.8c0-8.1,0-16.1,0-24.2c0-0.6,0.2-0.7,0.7-0.7c5.4,0,10.7,0,16.1,0c2.3,0,4.6,0.1,6.8,1                                            c1.8,0.8,3.6,1.7,4.8,3.4c0.8,1.1,1.2,2.4,1.5,3.8c0.3,1.7,0.2,3.3,0.2,5c0,9,0,18,0,27c0,2.4-0.8,4.6-2.7,6.2                                            c-1.3,1.1-2.9,1.8-4.5,2.2c-2.2,0.6-4.5,0.9-6.8,0.9c-5.2,0.2-10.3,0-15.5,0.1c-0.5,0-0.4-0.3-0.4-0.6                                            C108.4,69,108.4,60.9,108.4,52.8z M120.2,52.4c0,3.7,0,7.3,0,11c0,1.8,0,3.6,0,5.4c0,0.4,0.1,0.5,0.5,0.5c0.8,0,1.5,0,2.3-0.1                                            c1.2-0.3,2.1-0.9,2.1-2.5c0-9.6,0-19.2,0-28.8c0-0.9-0.4-1.4-1.1-1.8c-1-0.5-2.1-0.4-3.2-0.5c-0.5,0-0.6,0.1-0.6,0.6                                            C120.2,41.6,120.2,47,120.2,52.4z"></path>
                                                      <path class="st2" d="M156.9,39.3c1.9-1.3,3.9-2.5,6.1-3.1c2.8-0.7,5.2-0.1,7.4,1.7c1.6,1.3,2.4,3,2.4,5.1c0,9.9,0,19.8,0,29.7                                            c0,2.8-2.2,4.6-4.3,5c-1.5,0.3-3,0.3-4.5,0.2c-1.5-0.1-2.9-0.6-4.3-1.1c-1.1-0.4-2.3-0.8-3.5-1.1c-0.5-0.1-0.7,0.1-0.9,0.4                                            c-0.3,0.6-0.5,1.2-0.6,1.8c-0.1,0.3-0.2,0.4-0.5,0.4c-3.3,0-6.6,0-9.9,0c-0.3,0-0.4-0.1-0.4-0.3c0-0.1,0-0.2,0-0.3                                            c0-16.3,0-32.6,0-49c0-0.6,0.1-0.7,0.7-0.7c3.8,0,7.6,0,11.4,0c0.7,0,0.7,0,0.7,0.8C156.9,32.2,156.9,35.7,156.9,39.3z                                            M157.7,56.1c0,4.4,0,8.7,0,13.1c0,0.5,0.1,0.9,0.4,1.3c0.4,0.6,1,0.8,1.6,0.6c0.7-0.2,0.9-0.5,0.9-1.4c0-8.6,0-17.3,0-25.9                                            c0-0.4,0-0.7-0.1-1c-0.3-0.8-0.8-1.3-1.7-1.2c-0.6,0.1-1.1,0.3-1.1,1.4C157.7,47.4,157.7,51.7,157.7,56.1z"></path>
                                                      <path class="st2" d="M44.7,53.1c0-8.2,0-16.4,0-24.5c0-0.5,0.1-0.6,0.6-0.6c3.6,0,7.1,0,10.7,0c0.5,0,0.5,0.1,0.5,0.6                                            c0,16.4,0,32.8,0,49.2c0,0.5-0.1,0.6-0.6,0.6c-3.6,0-7.1,0-10.7,0c-0.5,0-0.6-0.1-0.6-0.6C44.7,69.5,44.7,61.3,44.7,53.1z"></path>
                                                   </g>
                                                </g>
                                             </svg>
                                             <span class="block">8.2</span>
                                          </div>
                                       </li>
                                       <li class="relative"><span class="block">2017</span></li>
                                       <li class="relative">
                                          <p>Crime • Drama</p>
                                       </li>
                                       <li class="relative hidden lg:block"><span class="block">70 dk</span></li>
                                    </ul>
                                 </div>
                              </div>
                              <div class="main-search-drop-box-icon hidden xl:block">
                                 <svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <polygon points="5 3 19 12 5 21 5 3"></polygon>
                                 </svg>
                              </div>
                           </a>
                        </li>
                     </ul>
                  </div> -->
                  <div class="search-movie-and-series-result-box flex flex-col items-center py-12 my-6 text-center">
                     <span class="block">Playlist Oluştur</span>
                     <p class="block">Hemen bir oynatma listesi oluşturun ve arkadaşlarınızla film/dizi gecesi yapmanın keyfini çıkarın</p>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>


<script src="https://js.pusher.com/7.1/pusher.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>


 Pusher.logToConsole = true;
 var pusher = new Pusher('6d7dc6ebf22fd10a6359', {
   cluster: 'eu',
   channelAuthorization: { 
     endpoint: "/pusher_user_auth"
   }
 });

 var channel = pusher.subscribe('presence-cache-room-<?= $room->slug?>');
 channel.bind('room-func', function(data) {
   console.log(data.message)
 });
 function update_member_count(count){
   $("#memberCount").html(count)
 }
 channel.bind("pusher:cache_miss", () => {
   console.log("ilk alım")
});
 channel.bind("pusher:member_added", (member) => {
   // For example
  console.log('sekme actık')
 });
 channel.bind("pusher:subscription_succeeded", (members) => {
   // For example
   console.log(members,"sakso")
   update_member_count(members.count);
   members.each((member) => {
     // For example
     // add_member(member.id, member.info);
   });
 });

 channel.members.each(function (member) {
   var userId = member.id;
   var userInfo = member.info;
   console.log(userId,userInfo)
 });
</script>
