<?php 
   if(!$result){
      return "";
   }

   if($media == "movies"){
      $link = base_url("film/$result->alias");
   }else {
      $link = base_url("dizi/$result->alias");
   }
?>
<div class="widget-slider relative mb-5">
  <div class="widget-slider-image">
    <img class="lazy" width="100%" height="300" data-src="<?= base_url("uploads/$media/cover/original/$result->cover")?>" alt="<?= $result->name?>">
  </div>
  <div class="widget-body flex flex-col justify-center items-start absolute ">
    <?php
      if($result->logo){
    ?>
    <div class="widget-logo">
      <img class="lazy" data-src="<?= base_url("uploads/$media/logo/original/$result->logo")?>" width="150">
    </div>
    <?php } ?>
    <div class="widget-title flex flex-col mt-2">
      <a href="<?= $link?>"><?= $result->name?></a>
      <ul class="flex">
        <li class="mr-2">
          <small class="">Yıl: <?= $result->year?></small>
        </li> 
        <li>
          <small class="">Tür: <?= categoryParse($result->category)?></small>
        </li>
      </ul>
    </div>
    <div class="widget-footer w-full md:w-2/3">
      <p><?= kisalt($result->overview,250)?></p>
    </div>
    <div class="widget-actions mt-6">
      <ul class="flex">
        <li>
          <a href="<?= $link?>" class="flex items-center">
            <svg viewBox="0 0 57.62 44.59"><g id="layer1" data-name="Layer 2"><g id="katman_1" data-name="katman 1"><path class="cls-1" d="M57.62,21.78c0,12.59-9.93,22.81-22.17,22.81S13.27,34.33,13.27,21.78C13.27-1.51-27.46,0,33.79,0,46.56,0,57.62,9.18,57.62,21.78"></path>
              <path class="cls-2" d="M29.15,11.93a.29.29,0,0,0-.41.05.24.24,0,0,0-.06.22L28.33,32a.28.28,0,0,0,.23.33.35.35,0,0,0,.23,0l19.14-9.61c.26-.13.27-.35,0-.48Z"></path></g></g>
              <g id="layer2" data-name="Layer 2"><g id="katman_1" data-name="katman 1"><path class="cls-1" d="M57.62,21.78c0,12.59-9.93,22.81-22.17,22.81S13.27,34.33,13.27,21.78C13.27-1.51-27.46,0,33.79,0,46.56,0,57.62,9.18,57.62,21.78"></path></g></g></svg>
              <span>Şimdi İzle</span>
          </a>
        </li>
        <li>
          <a href="" class="flex items-center">
            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
               <path class="cls-2" d="M29.15,11.93a.29.29,0,0,0-.41.05.24.24,0,0,0-.06.22L28.33,32a.28.28,0,0,0,.23.33.35.35,0,0,0,.23,0l19.14-9.61c.26-.13.27-.35,0-.48Z"></path>
              <path opacity="0.4" d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" fill="#fbc607"/>
              <path d="M6 14.8901C5.59 14.8901 5.25 14.5501 5.25 14.1401V9.8501C5.25 9.4401 5.59 9.1001 6 9.1001C6.41 9.1001 6.75 9.4401 6.75 9.8501V14.1401C6.75 14.5601 6.41 14.8901 6 14.8901Z" fill="#fbc607"/>
              <path d="M9 16.3202C8.59 16.3202 8.25 15.9802 8.25 15.5702V8.43018C8.25 8.02018 8.59 7.68018 9 7.68018C9.41 7.68018 9.75 8.02018 9.75 8.43018V15.5702C9.75 15.9902 9.41 16.3202 9 16.3202Z" fill="#fbc607"/>
              <path d="M12 17.75C11.59 17.75 11.25 17.41 11.25 17V7C11.25 6.59 11.59 6.25 12 6.25C12.41 6.25 12.75 6.59 12.75 7V17C12.75 17.41 12.41 17.75 12 17.75Z" fill="#fbc607"/>
              <path d="M15 16.3202C14.59 16.3202 14.25 15.9802 14.25 15.5702V8.43018C14.25 8.02018 14.59 7.68018 15 7.68018C15.41 7.68018 15.75 8.02018 15.75 8.43018V15.5702C15.75 15.9902 15.41 16.3202 15 16.3202Z" fill="#fbc607"/>
              <path d="M18 14.8901C17.59 14.8901 17.25 14.5501 17.25 14.1401V9.8501C17.25 9.4401 17.59 9.1001 18 9.1001C18.41 9.1001 18.75 9.4401 18.75 9.8501V14.1401C18.75 14.5601 18.41 14.8901 18 14.8901Z" fill="#fbc607"/>
            </svg>
            <span>Fragmanı İzle</span>
          </a>
        </li>
      </ul>
    </div>
  </div>
</div>
