
<div class="landing-home">
    <div class="py-16 bg-gradient-to-b from-yeez to-yeez-up">  
        <div class="container m-auto text-gray-600 px-6 md:px-12 xl:px-6">
            <div class="mb-20 text-center space-y-4 px-6 md:px-0">
              <h2 class="text-center text-2xl text-white font-bold md:text-4xl">Bazı Kullanıcılarımızın Geri Bildirimleri</h2>
              <span class="green-mark text-sm mt-5 block">Sizleride aramızda görmekten mutluluk duyarız</span>
            </div>

            <div class="grid lg:grid-cols-2">
              <div class="relative"> 
                <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" class="w-16 mb-6 mx-auto text-white-200" viewBox="0 0 100.73 79.702">
                  <path class="fill-current" d="M88.248,134.066a26.577,26.577,0,0,1-8.2-6.592,32.513,32.513,0,0,1-5.567-9.668,33.443,33.443,0,0,1-2.051-11.792A44.325,44.325,0,0,1,76.163,87.7,47.629,47.629,0,0,1,86.2,73.128a50.181,50.181,0,0,1,32.08-14.282v6.738a56.167,56.167,0,0,0-12.451,5.273,44.3,44.3,0,0,0-10.108,7.837,38.039,38.039,0,0,0-6.738,9.595,23.889,23.889,0,0,0-2.49,10.547,12.144,12.144,0,0,0,1.246,5.639q1.245,2.417,3.149,2.417a6.138,6.138,0,0,0,3.149-.733q1.246-.733,2.49-1.612a16.493,16.493,0,0,1,2.93-1.611,11.354,11.354,0,0,1,4.468-.733,12.4,12.4,0,0,1,5.493,1.246,14.721,14.721,0,0,1,4.541,3.443,16.628,16.628,0,0,1,3.149,5.273,18.362,18.362,0,0,1,1.172,6.592,16.108,16.108,0,0,1-1.538,7.032,16.918,16.918,0,0,1-4.248,5.566,21.084,21.084,0,0,1-6.372,3.735,22.351,22.351,0,0,1-17.871-1.025Zm-52.88,0a26.58,26.58,0,0,1-8.2-6.592,32.513,32.513,0,0,1-5.567-9.668,33.443,33.443,0,0,1-2.05-11.792A44.324,44.324,0,0,1,23.282,87.7,47.755,47.755,0,0,1,47.819,63.167,50.53,50.53,0,0,1,65.4,58.846v6.738a53.934,53.934,0,0,0-12.524,5.273,46.55,46.55,0,0,0-10.108,7.837,37.156,37.156,0,0,0-6.811,9.595,23.877,23.877,0,0,0-2.49,10.547,11.59,11.59,0,0,0,1.319,5.639q1.318,2.417,3.076,2.417a6.14,6.14,0,0,0,3.149-.733q1.245-.733,2.563-1.612a19.279,19.279,0,0,1,3-1.611,11.36,11.36,0,0,1,4.468-.733,12.4,12.4,0,0,1,5.494,1.246,14.717,14.717,0,0,1,4.541,3.443,16.63,16.63,0,0,1,3.15,5.273,18.362,18.362,0,0,1,1.172,6.592,15.5,15.5,0,0,1-1.612,7.032,17.833,17.833,0,0,1-4.321,5.566,21.3,21.3,0,0,1-6.3,3.735,21.078,21.078,0,0,1-7.691,1.391A21.737,21.737,0,0,1,35.367,134.066Z" transform="translate(-18.547 -57.78)" stroke-width="2"/>
                </svg>
                
                <div class="absolute top-16 testimonial space-y-4 text-center transition duration-300 text-white" id="person">
                  <p class="leading-9">Gece nöbetine çıkmadan önce bu siteden yüksek kalitede dizi ve film izliyorum gayet keyifli.</p>
                  <div>
                    <h6 class="text-lg font-semibold text-white">Stark House Bastard</h6>
                    <span class="green-mark text-sm">Kara Kale Komutanı</span>
                  </div>
                </div>
                <div class="absolute top-16 testimonial invisible space-y-4 text-center scale-90 transition duration-300" id="person2">
                  <p class="leading-9 text-white">Hmmmm... Uzun zamandır görülerimde gördüğüm kayıp kızımı bu sitede buldum. Allah herkesten razı olsun.</p>
                  <div>
                    <h6 class="text-lg font-semibold text-white">Rivialı Geralt</h6>
                    <span class="green-mark text-sm">Witcher</span>
                  </div>
                </div>
                <div class="absolute top-16 testimonial invisible space-y-4 text-center scale-90 transition duration-300" id="person3">
                  <p class="leading-9 text-white">Skyler'dan ve novalgine pişirmekten uzaklaştığım aynı zamanda kafa dinlediğim tek yer.</p>
                  <div>
                    <h6 class="text-lg font-semibold text-white">Walter White</h6>
                    <span class=" text-sm green-mark">İlaç Mümessili</span>
                  </div>
                </div>
                <div class="absolute top-16 testimonial invisible space-y-4 text-center scale-90 transition duration-300" id="person4">
                  <p class="leading-9 text-white">Gecelevi uyumadan önce konuşmayı seviyovum. Hevvy benimle konuşmadıgı için kendimi bu siteye atıyovum. Gevçekten uyumama yavdımcı oluyov.</p>
                  <div>
                    <h6 class="text-lg font-semibold text-white">Ron Weasley</h6>
                    <span class="green-mark text-sm">Seherbaz</span>
                  </div>
                </div>
                <div class="absolute top-16 testimonial invisible space-y-4 text-center scale-90 transition duration-300" id="person5">
                  <p class="leading-9 text-white">Yılgın bir hoşgörü ile benimsendiğim bu sitede, İlkkan gibi insanlarla vakit geçirmekten daha güzel ne olabilir.</p>
                  <div>
                    <h6 class="text-lg font-semibold text-white">Yılmaz</h6>
                    <span class="green-mark text-sm">Çaça - Cosplay Manager</span>
                  </div>
                </div>
                <div class="absolute top-16 testimonial invisible space-y-4 text-center scale-90 transition duration-300" id="person6">
                  <p class="leading-9 text-white">Eskiyle ilgilenmem. Gelecek de artık yeeztv'de çükü kalitenin adresi yeez.</p>
                  <div>
                    <h6 class="text-lg font-semibold text-white">Thomas Shelby</h6>
                    <span class="green-mark text-sm">Serbest Meslek Erbabı</span>
                  </div>
                </div>
              </div>
              <div class="relative m-auto w-full md:w-7/12 lg:w-9/12 xl:w-7/12">
                <div role="button" data-name="person" class="person w-28 h-28 mb-8 mx-auto rounded-full ring-4 ring-offset-4 ring-offset-yellow-50 ring-yellow-400 cursor-pointer group transition duration-300">
                  <img class="object-cover w-100 h-100 rounded-full" src="<?=base_url("assets/landing/images/jon-snow.jpg")?>" alt="person" loading="lazy" width="" height="">
                </div>

                <div class="flex justify-between">

                  <div role="button" data-name="person2" class="person w-16 h-16 rounded-full ring-offset-4 ring-offset-yellow-50 ring-yellow-400 transition duration-300">
                    <img class="object-cover rounded-full" src="<?=base_url("assets/landing/images/geralt.jpg")?>" alt="person" loading="lazy" width="" height="">
                  </div>
                  
                  <div role="button" data-name="person3" class="person w-24 h-24 rounded-full ring-offset-4 ring-offset-yellow-50 ring-yellow-400 transition duration-300">
                    <img class="object-cover rounded-full" src="<?=base_url("assets/landing/images/ww.jpg")?>" alt="person" loading="lazy" width="" height="">
                  </div>

                  <div role="button" data-name="person4" class="person w-16 h-16 mt-auto rounded-full ring-offset-4 ring-offset-yellow-50 ring-yellow-400 transition duration-300">
                    <img class="object-cover rounded-full" src="<?= base_url("assets/landing/images/ron.jpg") ?>" alt="person" loading="lazy" width="" height="">
                  </div>
                </div>

                <div class="flex items-center">
                  <div role="button" data-name="person5" class="person w-32 h-32 rounded-full ring-offset-4 ring-offset-yellow-100 ring-yellow-400 transition duration-300">
                    <img class="object-cover rounded-full" src="<?=base_url("assets/landing/images/feyyaz.jpg")?>" alt="person" loading="lazy" width="" height="">
                  </div>
                  
                  <div role="button" data-name="person6" class="person w-16 h-16 mx-auto rounded-full ring-offset-4 ring-offset-yellow-100 ring-yellow-400 transition duration-300">
                    <img class="object-cover rounded-full" src="<?=base_url("assets/landing/images/thomas.jpg")?>" alt="person" loading="lazy" width="" height="">
                  </div>
                </div>
              </div>
            </div>
        </div>
    </div>
    <svg xmlns="http://www.w3.org/2000/svg" class="w-full rotate-180 -mt-0.5" viewBox="0 0 1367.743 181.155">
      <path class="fill-current text-yeez-100" id="wave" data-name="wave" d="M0,0S166.91-56.211,405.877-49.5,715.838,14.48,955.869,26.854,1366,0,1366,0V115H0Z" transform="translate(1.743 66.155)"></path>
    </svg>


    <script>
      let persons = document.querySelectorAll('.person')
      let personsTestimonials = document.querySelectorAll('.testimonial')

      function showTestimonial(person, testimonial){
        person.classList.toggle('active')
        testimonial.classList.toggle('hidden')
      }

      persons.forEach(person => {
        person.addEventListener('click', ()=>{
          let personTarget = person.getAttribute('data-name')
          
          personsTestimonials.forEach(personTestimonial =>{
            
            let testmonialTarget = personTestimonial.getAttribute('id')

            if (personTarget == testmonialTarget){
              personTestimonial.classList.remove('invisible')
              personTestimonial.classList.remove('scale-90')
              person.classList.toggle('ring-4')
            } else {
              personTestimonial.classList.add('invisible')
              personTestimonial.classList.add('scale-90')
              person.classList.remove('ring-0')
            }
          })
        })
      })
    </script>
	  <div class="relative flex flex-col items-center bg-cyan-900 overflow-hidden mt-20">
	      <div class="relative z-[1] container m-auto px-6 md:px-12">
	          <div class="m-auto text-center md:w-8/12 lg:w-8/12">
	              <h3 class="text-2xl text-white font-bold md:text-5xl"><span class="text-sky-400 green-mark">Ücretsiz</span> olarak tüm kanallardan faydanalanın</h3>
	          </div>
	          <div class="m-auto mt-16 md:w-11/12 lg:w-8/12 xl:w-10/12">
	              <div class="flex flex-wrap justify-center gap-6">
	                  <div class="group py-2 px-4 border border-opacity-10 rounded-xl bg-white bg-opacity-5 hover:bg-opacity-10  flex justify-center items-center">
	                      <a target="__blank" href="<?= base_url("kanal/netflix")?>"><img width="120"  src="https://image.tmdb.org/t/p/original/wwemzKWzjKYJFfCeiB57q3r4Bcm.png" class=" contrast-0 transition group-hover:contrast-100" loading="lazy" alt="logo"></a>
	                  </div>
	                  <div class="group py-2 px-4 border border-opacity-10 rounded-xl bg-white bg-opacity-5 hover:bg-opacity-10  flex justify-center items-center">
	                      <a target="__blank" href="<?= base_url("kanal/amazon")?>"><img width="120"  src="https://image.tmdb.org/t/p/original/ifhbNuuVnlwYy5oXA5VIb2YR8AZ.png" class="contrast-0 transition group-hover:contrast-100" loading="lazy" alt="logo"></a>
	                  </div>
	                  <div class="group py-2 px-4 border border-opacity-10 rounded-xl bg-white bg-opacity-5 hover:bg-opacity-10  flex justify-center items-center">
	                      <a target="__blank" href="<?= base_url("kanal/exxen")?>"><img width="120"  src="https://image.tmdb.org/t/p/original/eHFYIWTLJfioisjOSB7x504N9vf.png" class="contrast-0 transition group-hover:contrast-100" loading="lazy" alt="logo"></a>
	                  </div>
	                  <div class="group py-2 px-4 border border-opacity-10 rounded-xl bg-white bg-opacity-5 hover:bg-opacity-10  flex justify-center items-center">
	                      <a target="__blank" href="<?= base_url("kanal/hbo")?>"><img width="120"  src="https://image.tmdb.org/t/p/original/tuomPhY2UtuPTqqFnKMVHvSb724.png" class="contrast-0 transition group-hover:contrast-100" loading="lazy" alt="logo"></a>
	                  </div>
	                  <div class="group py-2 px-4 border border-opacity-10 rounded-xl bg-white bg-opacity-5 hover:bg-opacity-10  flex justify-center items-center">
	                      <a target="__blank" href="<?= base_url("kanal/blutv")?>"><img width="120"  src="https://image.tmdb.org/t/p/original/aY0a4ZsUyG0zYKDE9H9I1eT4qdq.png" class="contrast-0 transition group-hover:contrast-100" loading="lazy" alt="logo"></a>
	                  </div>
	                  <div class="group py-2 px-4 border border-opacity-10 rounded-xl bg-white bg-opacity-5 hover:bg-opacity-10  flex justify-center items-center">
	                      <a target="__blank" href="<?= base_url("kanal/apple-tv")?>"><img width="120"  src="https://image.tmdb.org/t/p/original/4KAy34EHvRM25Ih8wb82AuGU7zJ.png" class="contrast-0 transition group-hover:contrast-100" loading="lazy" alt="logo"></a>
	                  </div>
	              </div>
	          </div>
	      </div>
	     
	  </div>   

<div class="py-16  mt-20" style="    background: #151a28;">
    <div class="container m-auto px-6 space-y-8 md:px-12 lg:px-20">
        <div class="items-center justify-center gap-16 text-center md:text-left md:flex">
            <div class="order-last mb-6 space-y-6 md:mb-0 md:w-7/12 lg:w-6/12">
                <h1 class="text-4xl text-white font-bold md:text-5xl">Hemen indir</h1>
                <p class="text-lg text-gray-300">Çok yakında yayınlanacak olan mobil uygulama ve smart tv uygulamamızı indirmek için takipte kalın.</p>
                <div class="flex flex-wrap justify-center gap-4 lg:gap-6 md:justify-start">
                    <a href="#" target="blank" title="For Android" aria-label="google play" class="block overflow-hidden">
                        <img src="<?= base_url("assets/landing/images/google_play.png")?>" width="153" height="46" alt="google play badge">
                    </a>
                    <a href="#" target="blank" title="For iPhone" aria-label="app store" class="block overflow-hidden">
                        <img src="<?= base_url("assets/landing/images/app-store.png")?>" width="153" height="46" alt="apple store badge">
                    </a>
                </div>
            </div>
            <img src="<?= base_url("assets/landing/images/3-devices-black.png")?>" class="md:w-5/12" loading="lazy" alt="mobility_illustration">
        </div>
    </div>
</div> 
                                                     
  <section id="main-features" class="main-features">
      <div class="container mx-auto">
          <div class="main-features-items flex flex-col items-center">
              <div class="main-features-head text-center aos-init aos-animate" data-aos="fade-zoom-in">
                  <h3 class="flex flex justify-center">
                      Neler
                      <span class="block">Yapabilirsiniz?</span>
                  </h3>
                  <p>
                      VIP Kullanıcılarımıza özel neler sunuyoruz göz atın!
                  </p>
              </div>
              <div class="main-features-content flex flex-wrap">
                  <div class="main-features-box w-1/4 left-side">
                      <div class="one-feature one aos-init aos-animate" data-aos="fade-right" data-aos-delay="1000">
                          <div class="one-feature-head flex items-center ">
                              <h5 class="text-left">Tüm içeriğe erişim imkanı</h5>
                              <span class="block lnr">
                                  <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 9.9-1"></path></svg>
                              </span>
                          </div>
                          <p class="text-left">
                              Tüm platformlar ve içerik tek bir yerde! İnternette bulamayacağınız tüm dizi ve filmlere <a href="<?= base_url()?>"><strong class="green-mark">yeeztv.com</strong></a>'a kayıt olarak ulaşabilirsiniz. 
                            
                              Her platform için ayrı ayrı ödeme yapmanız gerekmez.
                          </p>
                      </div>
                      <div class="one-feature one aos-init aos-animate" data-aos="fade-right" data-aos-delay="1400">
                          <div class="one-feature-head flex items-center">
                              <h5 class="text-left">YeezTV elinizin altında</h5>
                              <span class="block lnr lnr-home"></span>
                          </div>
                          <p class="text-left">
                            Yeeztv uygulamaları tüm akıllı cihazlarınıza uygun olarak tasarlanmıştır.
                            <br>
                            <a href="<?= base_url()?>"><strong class="green-mark">yeeztv</strong></a>, canın dizi veya film izlemek istediğinde 
                            her zaman yanı başında.
                          </p>
                      </div>
                      <div class="one-feature aos-init aos-animate" data-aos="fade-right" data-aos-delay="1800">
                          <div class="one-feature-head flex items-center ">
                              <h5 class="text-left">Kaldığın yerden devam et</h5>
                              <span class="block lnr">
                                  <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><circle cx="12" cy="12" r="10"></circle><polygon points="10 8 16 12 10 16 10 8"></polygon></svg>
                              </span>
                          </div>
                          <p class="text-left">
                              Film ve Dizi izlerken kesintiye mi uğradınız?  <a href="<?= base_url()?>"><strong class="green-mark">yeeztv</strong></a>, sizi yarıda kalan bölümleri ve filmleri takip etme derdinden kurtarır.
                          </p>
                      </div>
                  </div>
                  <div class="main-features-box text-center w-2/4 flex items-center justify-center relative">
                      <div class="features-circle">
                          <div class="circle-svg aos-init aos-animate" data-aos="zoom-in" data-aos-delay="400">
                              <svg version="1.1" id="features_circle" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="543px" height="542.953px" viewBox="0 0 543 542.953" enable-background="new 0 0 543 542.953" xml:space="preserve">
                                  <g>
                                      <circle fill="none" stroke="#" stroke-width="3"stroke-miterlimit="10" stroke-dasharray="11.9474,11.9474"cx="271.5" cy="271.516" r="270"></circle>
                                      <animateTransform
                                              attributeName="transform"
                                              type="rotate"
                                              from="0"
                                              to="360"
                                              dur="50s"
                                              repeatCount="indefinite"
                                      ></animateTransform>
                                  </g>
                            </svg>
                          </div>
                          <img data-aos="fade-up" data-aos-delay="200" src="<?= base_url("assets/landing/images/mobile-3.png")?>" class="img-fluid aos-init aos-animate" alt="" />
                      </div>
                  </div>
                  <div class="main-features-box w-1/4 right-side">
                      <div class="one-feature aos-init aos-animate" data-aos="fade-left" data-aos-delay="1000">
                          <div class="one-feature-head flex items-center justify-end">
                              <span class="lnr lnr-pointer-right"></span>
                              <h5 class="text-right">Sosyalleş</h5>
                          </div>
                          <p class="text-right">
                              <a href="<?= base_url()?>"><strong class="green-mark">yeeztv</strong></a>'ye kayıt olan tüm kullanıcılarımız akış sayfasında merak ettikleri dizi ve filmler hakkında topluluğa soru sorarak, anket oluşturarak ve fotoğraflar paylaşarak sosyalleşme imkanı buluyor.
                          </p>
                      </div>
                      <div class="one-feature aos-init aos-animate" data-aos="fade-left" data-aos-delay="1400">
                          <div class="one-feature-head flex items-center justify-end">
                              <span class="block lnr lnr-users">
                                  
                              </span>
                              <h5 class="text-right">Birlikte İzle!</h5>
                          </div>
                          <p class="text-right">
                            Arkadaşların ile grup oluşturarak istediğin dizi ve filmleri birlikte eş zamanlı olarak izleme imkanına sahip olabilirsiniz.
                          </p>
                      </div>
                      <div class="one-feature aos-init aos-animate" data-aos="fade-left" data-aos-delay="1800">
                          <div class="one-feature-head flex items-center justify-end">
                              <span class="block lnr lnr-star"></span>
                              <h5 class="text-right">Görev Sistemi</h5>
                          </div>
                          <p class="text-right">
                            <strong class="green-mark">yeeztv</strong></a>'ye kayıt olduğunuzda sizin için hazırlanan görevleri tamamlayarak arkadaşlarınız ile rekabete geçebilirsiniz. Tamamladığınız bu görevler sizlere deneyim puanı ve ekstra ödüller kazandırır. Deneyim puanlarını biriktirerek sitemizde yüksek seviyelere ulaşabilirsiniz ve yüksek seviye ödüllerinden faydalanabilirsiniz.
                          </p>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </section>
</div>
