<?php
   $seriesName = !empty($_GET['seriesName']) ? $_GET['seriesName'] : '';
   $episode = !empty($_GET['episode']) ? $_GET['episode'] : '';
   $season = !empty($_GET['season']) ? $_GET['season'] : '';
   $year = !empty($_GET['year']) ? $_GET['year'] : '';
   $cover = !empty($_GET['cover']) ? 'https://filmgani.com/'.$_GET['cover'] : '';
   $seriesPoster = !empty($_GET['poster']) ? 'https://filmgani.com/'.$_GET['poster'] : '';
   $poster = 'https://filmgani.com/assets/images/yeeztv.png';
   
   $episodeDetail = $episode ? "$season. Sezon $episode. Bölüm" :  "Yıl $year";

$parse = json_decode($url);

$tracks = [];
$videoUrl = '';

// Check if data and tracks are not empty
if (!empty($parse->data->sources)) {
    $videoUrl = $parse->data->sources[0]->url;  // Video URL
}

if (!empty($parse->data->tracks)) {
    foreach ($parse->data->tracks as $track) {
        $tracks[] = [
            'file' => $track->file,
            'kind' => $track->kind,
            'label' => $track->label ?? '',
            'default' => $track->default ?? false
        ];
    }
}
?>

<html>
  <head>
    <meta charset="utf-8">
    <style type="text/css">
      html, body {
        margin: 0;
        padding: 0;
        width: 100%;
        height: 100%;
        overflow: hidden;
        background-color: #000;
        font-family: 'Roboto', sans-serif;
      }
      
      .jw-logo {
        display: none;
      }
      
      #myElement {
        position: absolute;
        top: 0;
        left: 0;
        width: 100vw !important;
        height: 100vh !important;
      }

      /* Modern stil eklentileri */
      .jw-slider-time {
        height: 5px !important;
      }

      .jw-progress {
        background: linear-gradient(to right, #FF0000, #FF6B6B) !important;
      }

      .jw-button-color {
        color: #ffffff !important;
      }

      .jw-text-elapsed, .jw-text-duration {
        font-weight: 500 !important;
      }

      .jw-controlbar {
        background: linear-gradient(0deg, rgba(0,0,0,0.9) 0%, transparent 100%) !important;
        padding: 20px !important;
      }

      .jw-title {
        background: linear-gradient(180deg, rgba(0,0,0,0.9) 0%, transparent 100%) !important;
        padding: 20px !important;
      }

      .jw-title-primary {
        font-size: 1.5em !important;
        font-weight: 600 !important;
      }

      .jw-settings-menu {
        background: rgba(28, 28, 28, 0.9) !important;
        backdrop-filter: blur(10px) !important;
        border-radius: 8px !important;
      }

      .jw-settings-topbar {
        border-radius: 8px 8px 0 0 !important;
      }

      .jw-captions {
        font-family: 'Noto Sans JP', sans-serif !important;
      }

      /* Hover efektleri */
      .jw-slider-time:hover .jw-progress {
        transform: scaleY(1.5);
        transition: transform 0.2s ease;
      }

      .jw-button-container button:hover {
        transform: scale(1.1);
        transition: transform 0.2s ease;
      }

      /* Kaynak değiştirici menü */
      .source-switcher {
        position: absolute;
        top: 10px;
        right: 10px;
        z-index: 1000;
      }

      .source-dropdown {
        position: relative;
        display: inline-block;
      }

      .source-button {
        background: rgba(28, 28, 28, 0.9);
        backdrop-filter: blur(10px);
        border: none;
        color: #fff;
        padding: 12px 20px;
        border-radius: 6px;
        cursor: pointer;
        font-family: 'Roboto', sans-serif;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all 0.2s ease;
      }

      .source-button:after {
        content: '';
        width: 0;
        height: 0;
        border-left: 5px solid transparent;
        border-right: 5px solid transparent;
        border-top: 5px solid #fff;
        margin-left: 5px;
      }

      .source-button:hover {
        background: rgba(40, 40, 40, 0.9);
      }

      .source-list {
        display: none;
        position: absolute;
        right: 0;
        top: 100%;
        margin-top: 5px;
        background: rgba(28, 28, 28, 0.95);
        backdrop-filter: blur(10px);
        border-radius: 6px;
        padding: 5px 0;
        min-width: 160px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
      }

      .source-list.show {
        display: block;
        animation: fadeIn 0.2s ease;
      }

      .source-item {
        padding: 10px 15px;
        color: #fff;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all 0.2s ease;
      }

      .source-item:hover {
        background: rgba(255, 255, 255, 0.1);
      }

      .source-item.active {
        background: linear-gradient(90deg, #FF0000, #FF6B6B);
      }

      .source-item i {
        font-size: 12px;
        opacity: 0;
        transition: opacity 0.2s ease;
      }

      .source-item.active i {
        opacity: 1;
      }

      @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
      }

      .source-info {
        position: absolute;
        top: 60px;
        right: 10px;
        background: rgba(28, 28, 28, 0.95);
        backdrop-filter: blur(10px);
        color: #fff;
        padding: 8px 16px;
        border-radius: 6px;
        font-size: 13px;
        opacity: 0;
        transform: translateY(-10px);
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
      }

      .source-info.show {
        opacity: 1;
        transform: translateY(0);
      }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;600&family=Noto+Sans+JP&display=swap" rel="stylesheet">
  </head>
  <body>
    <div class='video'>
      <script src="https://use.fontawesome.com/20603b964f.js"></script>
      <script type="text/javascript" src="https://content.jwplatform.com/libraries/hDZaZjnc.js"></script>
      <script type="text/javascript">
        jwplayer.key = 'Y8nORY7CUY5RnlN/f8onh+AXI1ZWodkujMJAXBwpcAnDG5N4';
      </script>
      <div id="myElement"></div>
      <div class="source-switcher">
        <div class="source-dropdown">
          <button class="source-button">
            <i class="fa fa-play-circle"></i>
            Video Kaynağı
          </button>
          <div class="source-list">
            <?php if (!empty($parse->data->sources)): ?>
              <?php foreach ($parse->data->sources as $index => $source): ?>
                <div class="source-item <?= $index === 0 ? 'active' : '' ?>" data-source="<?= $index + 1 ?>">
                  <i class="fa fa-check"></i>
                  Kaynak <?= $index + 1 ?>
                </div>
              <?php endforeach; ?>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <div class="source-info"></div>
      <script type="text/javascript">
        const videoSources = <?= json_encode(array_map(function($source, $index) {
          return [
            'file' => $source->url,
            'label' => 'Kaynak ' . ($index + 1)
          ];
        }, $parse->data->sources, array_keys((array)$parse->data->sources)), JSON_PRETTY_PRINT) ?>;

        jwplayer("myElement").setup({
          primary: "html5",
          controls: true,
          displaytitle: true,
          image: "<?= $image ?>",
          displaydescription: false,
          width: "100%",
          height: "100%",
          preload: "metadata",
          stretching: "uniform",
          autostart: false,
          horizontalVolumeSlider: true,
          repeat: false,
          skin: {
            name: "netflix",
            menus: {
              background: "rgba(28, 28, 28, 0.9)"
            },
            timeslider: {
              progress: "linear-gradient(90deg, #FF6B6B, #FF8E53)",
              rail: "rgba(255, 255, 255, 0.3)"
            },
            tooltips: {
              background: "rgba(28, 28, 28, 0.9)",
              text: "#ffffff"
            }
          },
          type: "hls",
          playlist: [{
            file: '<?= $videoUrl ?>',
            tracks: <?= json_encode($tracks, JSON_PRETTY_PRINT) ?>,
            title: "Video",
            mediaid: "ddra573"
          }],
          captions: {
            color: "#ffffff",
            backgroundColor: "#000000",
            backgroundOpacity: 60,
            fontOpacity: 100,
            edgeStyle: "dropshadow",
            fontFamily: "Noto Sans JP, sans-serif",
            fontSize: 16
          },
          localization: {
            nextUp: "Sıradaki Bölüm",
            playlist: "Bölümler",
            related: "Benzer Animeler",
            playback: "Oynat",
            pause: "Duraklat",
            prev: "Önceki Bölüm",
            next: "Sonraki Bölüm",
            volume: "Ses Seviyesi",
            settings: "Ayarlar",
            fullscreen: "Tam Ekran"
          }
        });

        // Klavye kısayolları
        document.addEventListener('keydown', function(e) {
          switch(e.key) {
            case ' ':
              jwplayer().play();
              break;
            case 'f':
              jwplayer().setFullscreen();
              break;
            case 'ArrowRight':
              jwplayer().seek(jwplayer().getPosition() + 10);
              break;
            case 'ArrowLeft':
              jwplayer().seek(jwplayer().getPosition() - 10);
              break;
          }
        });

        // Dropdown menü kontrolü
        const sourceButton = document.querySelector('.source-button');
        const sourceList = document.querySelector('.source-list');

        sourceButton.addEventListener('click', (e) => {
          e.stopPropagation();
          sourceList.classList.toggle('show');
        });

        document.addEventListener('click', (e) => {
          if (!sourceList.contains(e.target)) {
            sourceList.classList.remove('show');
          }
        });

        // Kaynak değiştirme işlemleri
        document.querySelectorAll('.source-item').forEach(item => {
          item.addEventListener('click', function() {
            const sourceId = parseInt(this.dataset.source) - 1;
            const source = videoSources[sourceId];
            
            // Aktif kaynak stilini güncelle
            document.querySelector('.source-item.active').classList.remove('active');
            this.classList.add('active');
            
            // Dropdown'ı kapat
            sourceList.classList.remove('show');
            
            // Video kaynağını değiştir
            const currentTime = jwplayer().getPosition();
            jwplayer().load({
              file: source.file,
              tracks: jwplayer().getPlaylist()[0].tracks
            });
            
            // Video pozisyonunu koru
            jwplayer().once('ready', function() {
              jwplayer().seek(currentTime);
              jwplayer().play();
            });
            
            // Kaynak değişikliği bilgisini göster
            const sourceInfo = document.querySelector('.source-info');
            sourceInfo.textContent = `Kaynak değiştirildi: ${source.label}`;
            sourceInfo.classList.add('show');
            
            setTimeout(() => {
              sourceInfo.classList.remove('show');
            }, 3000);
          });
        });

        // Video hata durumunda otomatik kaynak değiştirme
        jwplayer().on('error', function() {
          const currentSource = document.querySelector('.source-item.active').dataset.source;
          const nextSource = (parseInt(currentSource) % videoSources.length) + 1;
          document.querySelector(`[data-source="${nextSource}"]`).click();
        });
      </script>
    </div>
  </body>
</html>
