
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="Content-Language" content="en-us"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>TV Not found </title>
    <link href="https://fonts.googleapis.com/css?family=Source+Code+Pro:400,500,600,700,900,300,200" rel="stylesheet" type="text/css" />
    <link href="https://fonts.googleapis.com/css?family=VT323" rel="stylesheet" type="text/css" />
    <style type="text/css">
        @keyframes screen-turn-on {
            0% {
                width: 0%;
                height: 1px;
                border-radius: 0px;
                background-color: #b0b0b0;
            }
            50% {
                width: 100%;
                height: 1px;
                border-radius: 0px;
                background-color: #b0b0b0;
            }
            51% {
                width: 100%;
                height: 1px;
                border-radius: 0px;
                background-color: #b0b0b0;
            }
            70% {
                width: 100%;
                height: 1px;
                border-radius: 0px;
                background-color: #b0b0b0;
            }
            80% {
                width: 100%;
                height: calc(100vh - 60px);
                border-radius: 5px;
                background-color: #b0b0b0;
            }
            100% {
                width: 100%;
                height: calc(100vh - 60px);
                border-radius: 5px;
                background-color: #454545;
            }
        }
        @keyframes shiver {
            0%   {  transform: translate(1px, 1px); text-shadow: 6px 0 rgba(255,0,0,0.9), -6px 0 rgba(0,0,255,0.9);  }
            5%   {  transform: translate(1px, 1px); text-shadow: 3px 0 rgba(255,0,0,0.9), -3px 0 rgba(0,0,255,0.9);  }
            10%  {  transform: translate(1px, 1px); text-shadow: 5px 0 rgba(255,0,0,0.9), -5px 0 rgba(0,0,255,0.9);  }
            15%  {  transform: translate(1px, 1px); text-shadow: 7px 0 rgba(255,0,0,0.9), -7px 0 rgba(0,0,255,0.9);  }
            20%  {  transform: translate(1px, 2px); text-shadow: 2px 0 rgba(255,0,0,0.9), -2px 0 rgba(0,0,255,0.9);  }
            25%  {  transform: translate(1px, 2px); text-shadow: 2px 0 rgba(255,0,0,0.9), -2px 0 rgba(0,0,255,0.9);  }
            30%  {  transform: translate(1px, 2px); text-shadow: 3px 0 rgba(255,0,0,0.9), -3px 0 rgba(0,0,255,0.9);  }
            35%  {  transform: translate(1px, 2px); text-shadow: 2px 0 rgba(255,0,0,0.9), -2px 0 rgba(0,0,255,0.9);  }
            40%  {  transform: translate(2px, 1px); text-shadow: 2px 0 rgba(255,0,0,0.9), -2px 0 rgba(0,0,255,0.9);  }
            45%  {  transform: translate(2px, 1px); text-shadow: 3px 0 rgba(255,0,0,0.9), -3px 0 rgba(0,0,255,0.9);  }
            50%  {  transform: translate(2px, 1px); text-shadow: 3px 0 rgba(255,0,0,0.9), -3px 0 rgba(0,0,255,0.9);  }
            55%  {  transform: translate(2px, 1px); text-shadow: 4px 0 rgba(255,0,0,0.9), -4px 0 rgba(0,0,255,0.9);  }
            60%  {  transform: translate(1px, 1px); text-shadow: 2px 0 rgba(255,0,0,0.9), -2px 0 rgba(0,0,255,0.9);  }
            65%  {  transform: translate(1px, 1px); text-shadow: 5px 0 rgba(255,0,0,0.9), -5px 0 rgba(0,0,255,0.9);  }
            70%  {  transform: translate(1px, 1px); text-shadow: 3px 0 rgba(255,0,0,0.9), -3px 0 rgba(0,0,255,0.9);  }
            75%  {  transform: translate(1px, 1px); text-shadow: 2px 0 rgba(255,0,0,0.9), -2px 0 rgba(0,0,255,0.9);  }
            80%  {  transform: translate(2px, 1px); text-shadow: 5px 0 rgba(255,0,0,0.9), -5px 0 rgba(0,0,255,0.9);  }
            85%  {  transform: translate(2px, 1px); text-shadow: 3px 0 rgba(255,0,0,0.9), -3px 0 rgba(0,0,255,0.9);  }
            90%  {  transform: translate(2px, 2px); text-shadow: 5px 0 rgba(255,0,0,0.9), -5px 0 rgba(0,0,255,0.9);  }
            95%  {  transform: translate(2px, 2px); text-shadow: 2px 0 rgba(255,0,0,0.9), -2px 0 rgba(0,0,255,0.9);  }
            100% {  transform: translate(1px, 2px); text-shadow: 3px 0 rgba(255,0,0,0.9), -3px 0 rgba(0,0,255,0.9);  }
        }
        body, #screen {
            box-sizing: border-box;
            -webkit-user-select: none;
            -moz-user-select: none;
            -o-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }
        body {
            margin: 0;
            background-color: #000;
            font-family: "Source Code Pro", monospace;
            overflow: hidden;
        }
        #screen:after {
            content: "";
            position: absolute;
            top: 30px;
            right: 30px;
            bottom: 30px;
            left: 30px;
            background-image: -webkit-linear-gradient(bottom, rgba(255, 255, 255, 0.2) 33.3%, rgba(255, 255, 255, 0.4) 33.3%, rgba(255, 255, 255, 0.4) 66.7%, rgba(255, 255, 255, 0.6) 66.7%), -webkit-linear-gradient(left, rgba(255, 0, 0, 0.7) 33.3%, rgba(0, 255, 0, 0.7) 33.3%, rgba(0, 255, 0, 0.6) 66.7%, rgba(0, 0, 255, 0.6) 66.7%);
            background-image: -moz-linear-gradient(bottom, rgba(255, 255, 255, 0.2) 33.3%, rgba(255, 255, 255, 0.4) 33.3%, rgba(255, 255, 255, 0.4) 66.7%, rgba(255, 255, 255, 0.6) 66.7%), -webkit-linear-gradient(left, rgba(255, 0, 0, 0.7) 33.3%, rgba(0, 255, 0, 0.7) 33.3%, rgba(0, 255, 0, 0.6) 66.7%, rgba(0, 0, 255, 0.6) 66.7%);
            background-image: linear-gradient(to top, rgba(255, 255, 255, 0.2) 33.3%, rgba(255, 255, 255, 0.4) 33.3%, rgba(255, 255, 255, 0.4) 66.7%, rgba(255, 255, 255, 0.6) 66.7%), linear-gradient(to right, rgba(255, 0, 0, 0.7) 33.3%, rgba(0, 255, 0, 0.7) 33.3%, rgba(0, 255, 0, 0.6) 66.7%, rgba(0, 0, 255, 0.6) 66.7%);
            background-size: 3px 3px;
            mix-blend-mode: multiply;
            border-radius: 5px;
            background-color: #00f;
            pointer-events: none;
        }
        #screen {
            margin: 30px;
            height: calc(100vh - 60px);
            width: calc(100vw - 60px);
            background: #0a0a0a;
            color: #fff;
            text-shadow: 2px 0 rgba(255, 0, 0, 0.9), -2px 0 rgba(0, 0, 255, 0.9);
            border-radius: 5px;
        }
        .on #screen {
            background-color: #222;
        }
        #content-holder {
            padding: 0;
            height: calc(100vh - 60px);
            width: calc(100vw - 60px);
            display: flex;
            justify-content: center;
            align-items: center;
            align-content: center;
            text-align: center;
            overflow: hidden;
        }
        #content {
            background-color: #b0b0b0;
            display: flex;
            justify-content: center;
            align-items: center;
            align-content: center;
            text-align: center;
            overflow: hidden;
            height: 0;
            position: relative;
        }
        .on #content {
            animation: screen-turn-on .4s linear .5s 1 forwards;
        }
        #power {
            bottom: 12px;
            position: absolute;
            right: 45px;
            cursor: pointer;
        }
        #power svg {
            width: 24px;
            height: 24px;
            color: #fff;
        }
        .on #power svg {
            color: #6bf457;
        }
        #channel {
            position: absolute;
            top: 15px;
            left: 25px;
            font-size: 4vw;
            font-family: "VT323", monospace;
            vertical-align: middle;
            color: #fbff68;
            animation: shiver 1s linear .5s infinite;
        }
        #text {
            color: #ededed;
            text-align: left;
            padding: 0px 20px;
            text-align: center;
            font-weight: 200;
            font-size: 1.4em;
            animation: shiver 1s linear .5s infinite;
        }
        .figure {
            display: block;
            position: absolute;
            width: 0;
            height: 0;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            margin: auto;
            border-top: 300px solid #fff;
            border-right: 150px solid transparent;
            border-left: 150px solid transparent;
            border-bottom: 0 solid transparent;
            -webkit-filter: drop-shadow(0 0 10px rgba(255,255,255,1));
            -moz-filter: drop-shadow(0 0 10px rgba(255,255,255,1));
            -o-filter: drop-shadow(0 0 10px rgba(255,255,255,1));
            -ms-filter: drop-shadow(0 0 10px rgba(255,255,255,1));
            filter: drop-shadow(0 0 10px rgba(255,255,255,1));
            animation: shiver 1s linear .5s infinite;
        }
        .figure:before {
            display: block;
            content: '';
            position: absolute;
            z-index: 99;
            width: 0;
            height: 0;
            top: -260px;
            left: -90px;
            margin: auto;
            border-top: 180px solid #6b6b6b;
            border-right: 90px solid transparent;
            border-left: 90px solid transparent;
            border-bottom: 0 solid transparent;
        };
    </style>
</head>
<body id="wrapper" class="on">
    <div id="screen">
        <div id="content-holder">
            <div id="content">
                <div id="app">
                    <div id="channel"><?= $channel?></div>
                    <div class=""><img src="<?= $logo?>"></div>
                     <div id="text"><?= $text?></div>
                   
                </div>
            </div>
        </div>
    </div>
    <div id="power" onclick="power();">
        <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="3" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><path d="M18.36 6.64a9 9 0 1 1-12.73 0"></path><line x1="12" y1="2" x2="12" y2="12"></line></svg>
    </div>
    <script type="text/javascript">
        let power = function() {
            let body = document.getElementById("wrapper");
            body.className = (body.className == "on") ? "off" : "on";
        }
    </script>
</body>
</html>