
/* ------------------------------------------------------------------------------
 *
 *  # Webicrea core system.
 *
 *  Includes minimum required JS code for proper template functioning
 *
 * ---------------------------------------------------------------------------- */
 var formatter = new Intl.NumberFormat('en-US', {
  style: 'currency',
  currency: 'USD',

  // These options are needed to round to whole numbers if that's what you want.
  //minimumFractionDigits: 0, // (this suffices for whole numbers, but will print 2500.10 as $2,500.1)
  //maximumFractionDigits: 0, // (causes 2500.99 to be printed as $2,501)
});
 var getUrlParameter = function getUrlParameter(sParam) {
  var sPageURL = decodeURIComponent(window.location.search.substring(1)),
    sURLVariables = sPageURL.split("&"),
    sParameterName,
    i;

  for (i = 0; i < sURLVariables.length; i++) {
    sParameterName = sURLVariables[i].split("=");

    if (sParameterName[0] === sParam) {
      return sParameterName[1] === undefined ? true : sParameterName[1];
    }
  }
};
 // Setting datatable defaults
$(document).ready(function () {
 $('.modal').on("hidden.bs.modal", function (e) { //fire on closing modal box
        if ($('.modal:visible').length) { // check whether parent modal is opend after child modal close
            $('body').addClass('modal-open'); // if open mean length is 1 then add a bootstrap css class to body of the page
        }
    });
});
$.extend( $.fn.dataTable.defaults, {
    autoWidth: false,
    dom: '<"datatable-header"fl><"datatable-scroll"t><"datatable-footer"ip>',
    language: {
        emptyTable: "Listelenecek içerik bulunamadı.",
        search: '<span>Ara:</span> _INPUT_',
        "info":           "_TOTAL_ kayıttan _START_ ile _END_ arası gösteriliyor",
        "infoEmpty":      "0 kayıttan 0 ile 0 arası gösteriliyor",
        searchPlaceholder: 'Arama yapmak için...',
        lengthMenu: '<span>Limit:</span> _MENU_',
        paginate: { 'first': 'First', 'last': 'Last', 'next': $('html').attr('dir') == 'rtl' ? '&larr;' : '&rarr;', 'previous': $('html').attr('dir') == 'rtl' ? '&rarr;' : '&larr;' }
    }
});
function getBase64(file) {
   var reader = new FileReader();
   reader.readAsDataURL(file);
   reader.onload = function () {
    window.cast_poster = reader.result
    return reader.result
   };
   reader.onerror = function (error) {
     console.log('Error: ', error);
   };
}
function changeSwitchery(element, checked) {
  if ( ( element.is(':checked') && checked == false ) || ( !element.is(':checked') && checked == true ) ) {
    element.parent().find('.switchery').trigger('click');
  }
}
$.fn.getObjectInValue = function(key,param,value,responseType = false) { // $(obj).getObjectInValue('episodes',"id",2051141);
var count = 0;
 for( var prop in this ) {
      if( this[prop].hasOwnProperty(key ) ) {
        var obj = this[prop][key];
        var sa = Object.keys(obj).find(key => obj[key][param] == value);
        if(typeof sa != "undefined"){
            if(responseType){
              return {
                parentIndex : count,
                childIndex : sa
              }
            }
           return sa;
        }
      }
      count += 1;
  }
};
$.fn.getObjectValue = function(param,value,responseType = false) { // $(obj).getObjectInValue('episodes',"id",2051141);
  var count = 0;
  for( var prop in this ) {
    var obj = this[prop][param];
    var check = obj == value;

    if(typeof check != "undefined"){
        if(responseType){
          return {
            parentIndex : count,
            childIndex : check
          }
        }
       return check;
    }
      count += 1;
  }
};
var swalInit = swal.mixin({
    buttonsStyling: false,
    confirmButtonClass: 'btn btn-primary',
    cancelButtonClass: 'btn btn-light'
});

// Setup module
// ------------------------------
var Buttons = function() {
    //
    // Setup module components
    //
    // Progress buttons
    var _componentLadda = function() {
        if (typeof Ladda == 'undefined') {
            console.warn('Warning - ladda.min.js is not loaded.');
            return;
        }

        // Button with spinner
        Ladda.bind('.btn-ladda-spinner', {
            dataSpinnerSize: 16,
            timeout: 2000
        });

        // Button with progress
        Ladda.bind('.btn-ladda-progress', {
            callback: function(instance) {
                var progress = 0;
                var interval = setInterval(function() {
                    progress = Math.min(progress + Math.random() * 0.1, 1);
                    instance.setProgress(progress);

                    if( progress === 1 ) {
                        instance.stop();
                        clearInterval(interval);
                    }
                }, 200);
            }
        });
    };

    // Loading button
    var _componentLoadingButton = function() {
        $('.btn-loading').on('click', function () {
            var btn = $(this),
                initialText = btn.data('initial-text'),
                loadingText = btn.data('loading-text');
            btn.html(loadingText).addClass('disabled');
            setTimeout(function () {
                btn.html(initialText).removeClass('disabled');
            }, 3000)
        });
    };


    //
    // Return objects assigned to module
    //

    return {
        init: function() {
            _componentLadda();
            _componentLoadingButton();
        }
    }
}();
function mutliStringReplace(object, string) {
      var val = string
      var entries = Object.entries(object);
      entries.forEach((para)=> {
          var find = '{' + para[0] + '}'
          var regExp = new RegExp(find,'g')
       val = val.replace(regExp, para[1])
    })
  return val;
}

var origin = window.location.origin;
var loader = '<i class="icon-spinner2 spinner"></i>';
var pathname = window.location.pathname
pathname = pathname.replace('/panel/','')
var getNotif = function(types,message){
    Noty.overrideDefaults({
        theme: 'limitless',
        layout: 'topRight',
        type: 'alert',
        timeout: 2500
    });
   new Noty({
      text: message,
      type: types
  }).show();
}
var Webicrea = function () {
    var coreData;
    var setLoading = function(element){
      $(element).block({
          message: '<i class="icon-spinner spinner"></i>',
          overlayCSS: {
              backgroundColor: '#1B2024',
              opacity: 0.85,
              cursor: 'wait'
          },
          css: {
              border: 0,
              padding: 0,
              backgroundColor: 'none',
              color: '#fff'
          }
      });
    }
    var unLoading = function(element){
       $(element).unblock();
    }
    var setLoading = function(element){
      $(element).block({
          message: '<i class="icon-spinner spinner"></i>',
          overlayCSS: {
              backgroundColor: '#1B2024',
              opacity: 0.85,
              cursor: 'wait'
          },
          css: {
              border: 0,
              padding: 0,
              backgroundColor: 'none',
              color: '#fff'
          }
      });
    }
    var coreInit = function(table){
      $(document).on('click',"[data-delete]", function() {
        var user_id = $("[data-user-id]").data("user-id");
        var id = $(this).data("delete");
        var type = $(this).data("type");
        var movie_alias  = $("#movies-alias").val();
        var series_alias = $("#series-alias").val();

        var parent = $("[data-delete='"+id+"']").closest("tr");
        swalInit.fire({
          title: 'Uyarı!',
          text: 'Bu silme işlemini yapmak istediğinize emin misiniz!',
          type: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Evet, sil!',
          cancelButtonText: 'Hayır'
        }).then(function(result) {
            if(result.value) {
                $.ajax({
                  type:"POST",
                  url:origin+"/panel/"+type,
                  data:{id,movie_alias,series_alias,user_id},
                  dataType:'json',
                  success:function(result){
                    if(result.success){
                      swalInit.fire(
                          'Başarılı!',
                          'Silme işlemi başarıyla gerçekleştirildi.',
                          'success'
                      );
                       $("#item-"+id).remove()
                      if(result.notable){
                        parent.remove();

                        if(type.indexOf("season") != "-1"){
                          $("[data-season-item='"+id+"']").remove();
                          $("#episode_season option[value='"+id+"']").remove();
                        }else if(type.indexOf('series/cast/delete') != "-1"){
                          $("#cast-"+id).remove()
                        }else if(type.indexOf('movies/cast/delete') != "-1"){
                          $("#cast-"+id).remove()
                        }else if(type.indexOf('animes/cast/delete') != "-1"){
                          $("#cast-"+id).remove()
                        }

                      }else {
                        if(table){
                          table.ajax.reload()
                        }
                      }
                    }
                  },
                  error:function(e){
                      console.log(e)
                  },
                  complete:function(){
                  }
                });
            }
        });;
      });
    }
    var _searchTmdbContent = function(){
        var resultStatus = 0;
        $(document).click(function(event){
            var target = event.target;
            if (!$(target).is(".search-result-container,.search-result-container *,.search-tmdb, .search-tmdb *")) {
                $(".search-result-container").hide();
            }
        });
        $("#tmdb-search-value").focus(function(){
            if(resultStatus == 1){
                $(".search-result-container").show();
            } 
        });
        $(document).on("click","#tmdb-search-button",function(){
            var content = $("#tmdb-search-value").val();
            var media = $("#media").val();
            if(content){
                var t = $(this);
                var html = t.html();
                t.html(loader);
                t.prop('disabled',true);
                $.ajax({
                    type:"POST",
                    url:origin+"/panel/tmdb/search",
                    data:{content,media},
                    dataType:'json',
                    success:function(result){
                        if(result.success){
                            $(".search-result-container").show();
                             resultStatus = 1;
                            $(".search-result-container ul").html(result.theme);
                        }else if(result.error) {
                            getNotif('error',result.message)
                        }
                    },
                    error:function(e){
                        console.log(e)
                    },
                    complete:function(){
                         t.html(html);
                        t.prop('disabled',false);
                    }
                });
            } else {
                getNotif('error','Lütfen aramak istediğiniz diziyi yazınız.');
            }
        });
        $(document).on("click","#anime-search-button",function(){
            var content = $("#anime-search-value").val();
            var media = $(".anime-provider").val();
            if(content){
                var t = $(this);
                var html = t.html();
                t.html(loader);
                t.prop('disabled',true);
                $.ajax({
                    type:"POST",
                    url:origin+"/panel/anime/search",
                    data:{content,media},
                    dataType:'json',
                    success:function(result){
                        if(result.success){
                            $(".search-result-container").show();
                             resultStatus = 1;
                            $(".search-result-container ul").html(result.theme);
                        }else if(result.error) {
                            getNotif('error',result.message)
                        }
                    },
                    error:function(e){
                        console.log(e)
                    },
                    complete:function(){
                         t.html(html);
                        t.prop('disabled',false);
                    }
                });
            } else {
                getNotif('error','Lütfen aramak istediğiniz animeyi yazınız.');
            }
        });

        $(document).on("click","[data-active-anime]",function (){
            var id = $(this).data('active-anime');
            var title = $(this).data('title');
            $("#anime-search-value").val(title)
            if(id){
                $("#active-anime").val(id);
            }
        });

        $(document).on("click","[data-bot-active]",function (){
            var id = $(this).data('bot-active');

            var title = $(this).data('title');
            $("#bot-search-value").val(title)
            if(id){
                $("#active-content").val(id);
            }
        });

        $(document).on("click", "#anime-add-content", function () {
            var id = $("#tmdbId").val();
            var media = $(".anime-provider").val();
            var group = $(".anime-group").val();
            var service = $(".anime-service").val();
            var anime_id = $("#active-anime").val();
            var video_category = $("#video_category").val();
            var range_episode_start = $("#range_episode_start").val();
            var range_episode_end = $("#range_episode_end").val();
            var range_episode = [range_episode_start, range_episode_end]
            var not_video = $("#not_video").is(":checked") ? 1 : 0;

            if (id) {
                var t = $(this);
                var html = t.html();
                t.html(loader);
                t.prop('disabled', true);
                $.ajax({
                    type: "POST",
                    url: origin + "/panel/anime/info",
                    data: {id, media,anime_id, group, service,not_video,range_episode,video_category},
                    dataType: 'json',
                    success: function (result) {
                        if(result.success){
                            getNotif("success",result.success);
                          }else {
                            getNotif("error",result.error);
                          }

                        if(result.logs){
                            $("#accordion").html(result.logs)
                        }
                    },
                    error: function (e) {
                        console.log(e)
                    },
                    complete: function () {
                        t.html(html);
                        t.prop('disabled', false);
                    }
                });
            } else {
                getNotif('error', 'İlgili içeriğin bilgileri eksik oldugu için getirilemedi..');
            }
        })

        $(document).on("click","#bot-search-button",function(){
            var content = $("#bot-search-value").val();
            var media = $(".bot-provider").val();
            if(content){
               $(".active-content-detail").html('')
               $("#accordion").html('')
                var t = $(this);
                var html = t.html();
                t.html(loader);
                t.prop('disabled',true);
                $.ajax({
                    type:"POST",
                    url:origin+"/panel/bot/search",
                    data:{content,media},
                    dataType:'json',
                    success:function(result){
                        if(result.success){
                            $(".search-result-container").show();

                             resultStatus = 1;
                            $(".search-result-container ul").html(result.theme);
                        }else if(result.error) {
                            getNotif('error',result.message)
                        }
                    },
                    error:function(e){
                        console.log(e)
                    },
                    complete:function(){
                         t.html(html);
                        t.prop('disabled',false);
                    }
                });
            } else {
                getNotif('error','Lütfen aramak istediğiniz animeyi yazınız.');
            }
        });

        $(document).on("click", "#bot-add-content", function () {
            var id = $("#tmdbId").val();
            var content_id = $("#active-content").val();
            var type = $(this).data("type");
            type = type == 'series' ? '' : type;
            var media = $(".bot-provider").val();
            var range_episode_start = $("#range_episode_start").val();
            var range_episode_end = $("#range_episode_end").val();
            var range_episode = [range_episode_start, range_episode_end]
            var not_video = $("#not_video").is(":checked") ? 1 : 0;

            if (id) {
                var t = $(this);
                var html = t.html();
                t.html(loader);
                t.prop('disabled', true);
                $.ajax({
                    type: "POST",
                    url: origin + "/panel/bot/add/" + type,
                    data: {id, type, media,content_id, not_video,range_episode},
                    dataType: 'json',
                    success: function (result) {
                        if(result.success){
                            getNotif("success",result.success);
                          }else {
                            getNotif("error",result.error);
                          }

                        if(result.logs){
                            $("#accordion").html(result.logs)
                        }
                    },
                    error: function (e) {
                        console.log(e)
                    },
                    complete: function () {
                        t.html(html);
                        t.prop('disabled', false);
                    }
                });
            } else {
                getNotif('error', 'İlgili içeriğin bilgileri eksik oldugu için getirilemedi..');
            }
        })
    }
    var _tmdbGetData = function(){
      $(document).on("click","#tmdb-add-content",function(){
        $(".category-list").val(null).trigger('change')
          var tmdbId    = $("#tmdbId").val();
          var media     = $("#media").val();
          var language  = $(".tmdb-language").val();
          if(tmdbId){
              var t = $(this);
              var html = t.html();
              t.prop('disabled',true);
              t.html(loader);
              $.ajax({
                  type:"POST",
                  url:origin+"/panel/tmdb/get/"+media,
                  data:{tmdbId,language,media},
                  dataType:'json',
                  success:function(result){
                      if(media == "anime"){

                        if(result.coverImage.extraLarge){
                          $(".profile-thumb img").attr("src",result.coverImage.extraLarge);
                        }
                        if(result.bannerImage){
                          $("#avatar-cover").attr('src',result.bannerImage);
                          $(".profile-cover-img").css("background","url("+result.bannerImage+") no-repeat");
                          $(".profile-cover-img").css("background-size","cover");
                        }
                        $("#series-name").val(result.title.userPreferred);
                        $("#en-name").val(result.title.english);
                        $(".top-names").html(result.title.userPreferred);
                        $("#original-name").val(result.title.native);
                        $("#anime-alias").val(result.title.userPreferred);
                        if(result.startDate.month <= 9){
                          var month = "0"+result.startDate.month
                        }else {
                          var month = result.startDate.month;
                        }
                        $(".series-air-date").val(`${result.startDate.year}-${month}-${result.startDate.day} 00:00`);
                        var categoryList = [];
                        $.each(result.genres, function(i,e){
                            if ($('.category-list').find("option[value='" + e.id + "']").length) {
                            } else { 
                                var newOption = new Option(e.name, e.id, true, true);
                                $('.category-list').append(newOption).trigger('change');
                            } 
                            categoryList.push(e.id)
                        });
                        $('.category-list').val(categoryList).trigger('change');
                     
                        $("#series-desc").val(result.description);
                        $("#year").val(result.startDate.year);
                        $("#time").val(result.duration);
                        $("#fragman").val(result.trailer ? result.trailer.id : "")
                        $("#point").val(result.popularity)
                        $("#anilist-id").val(result.id)
                        $("#mal-id").val(result.idMal)
                        $("#country").val(result.countryOfOrigin)
                        $("#status").val(result.status).change()
                        $("#type").val(result.type).change()
                        $("#format").val(result.format).change()
                        $("#season").val(result.seasonInt)
                        $("#episode").val(result.episodes)
                        $("#meanScore").val(result.meanScore)
                        $("#relations").val(JSON.stringify(result.relations.nodes))
                      
                        var cast_list = ""
                        if(result.characters.edges){
                            $.each(result.characters.edges,function(i,item){
                                cast_list += `
                                    <li>
                                       <a href="javascript:;" class="media">
                                          <div class="mr-3">
                                             <img src="`+item.node.image.large+`" class="" width="55" height="68" alt="">
                                          </div>
                                          <div class="media-body">
                                             <div class="media-title font-weight-semibold">`+item.node.name.userPreferred+`</div>
                                             <span class="text-muted font-size-sm">`+item.role+`</span>
                                          </div>
                                          <div class="align-self-center ml-3">
                                             <span class="badge badge-mark bg-success border-success"></span>
                                          </div>
                                       </a>
                                    </li>
                                `;
                            });
                            $("#cast-list").html(cast_list)
                            $("#cast-obj").val(JSON.stringify(result.characters.edges))
                        }
                         var crew_list = ""
                        if(result.staff.edges){
                            $.each(result.staff.edges,function(i,item){
                                crew_list += `
                                    <li>
                                       <a href="javascript:;" class="media">
                                          <div class="mr-3">
                                             <img src="`+item.node.image.large+`" class="" width="55" height="68" alt="">
                                          </div>
                                          <div class="media-body">
                                             <div class="media-title font-weight-semibold">`+item.node.name.userPreferred+`</div>
                                             <span class="text-muted font-size-sm">`+item.role+`</span>
                                          </div>
                                          <div class="align-self-center ml-3">
                                             <span class="badge badge-mark bg-success border-success"></span>
                                          </div>
                                       </a>
                                    </li>
                                `;
                            });
                            $("#crew-list").html(crew_list)
                            $("#crew-json").val(JSON.stringify(result.staff.edges))
                        }
                        return true;
                      }

                      if(result.images.posters){
                        $.each(result.images.posters,function(a,i){
                          var item = `
                            <div class="col-lg-4">
                               <div class="card">
                                  <div class="card-img-actions">
                                     <img class="card-img-top img-fluid" src="https://image.tmdb.org/t/p/original${i.file_path}" alt="">
                                     <div class="card-img-actions-overlay card-img-top">
                                        <a href="https://image.tmdb.org/t/p/original${i.file_path}" class="btn btn-outline-white border-2" data-popup="lightbox">
                                           Önizle
                                        </a>
                                        <button class="btn btn-outline-white ml-2 border-2" data-select-images="poster" data-url="https://image.tmdb.org/t/p/original${i.file_path}" >
                                           Seç
                                        </button>
                                     </div>
                                  </div>
                               </div>
                            </div>
                          `;
                          $(".poster-list").append(item)
                        });
                        
                      }
                      if(result.images.backdrops){
                        $.each(result.images.backdrops,function(a,i){
                          var item = `
                            <div class="col-lg-4">
                               <div class="card">
                                  <div class="card-img-actions">
                                     <img class="card-img-top img-fluid" src="https://image.tmdb.org/t/p/original${i.file_path}" alt="">
                                     <div class="card-img-actions-overlay card-img-top">
                                        <a href="https://image.tmdb.org/t/p/original${i.file_path}" class="btn btn-outline-white border-2" data-popup="lightbox2">
                                           Önizle
                                        </a>
                                        <button class="btn btn-outline-white ml-2 border-2" data-select-images="cover" data-url="https://image.tmdb.org/t/p/original${i.file_path}" >
                                           Seç
                                        </button>
                                     </div>
                                  </div>
                               </div>
                            </div>
                          `;
                          $(".cover-list").append(item)
                        });
                        
                      }
                      if(result.images.logos){
                        $.each(result.images.logos,function(a,i){
                          var item = `
                            <div class="col-lg-4">
                               <div class="card">
                                  <div class="card-img-actions">
                                     <img class="card-img-top img-fluid" src="https://image.tmdb.org/t/p/original${i.file_path}" alt="">
                                     <div class="card-img-actions-overlay card-img-top">
                                        <a href="https://image.tmdb.org/t/p/original${i.file_path}" class="btn btn-outline-white border-2" data-popup="lightbox3">
                                           Önizle
                                        </a>
                                        <button class="btn btn-outline-white ml-2 border-2" data-select-images="logo" data-url="https://image.tmdb.org/t/p/original${i.file_path}" >
                                           Seç
                                        </button>
                                     </div>
                                  </div>
                               </div>
                            </div>
                          `;
                          $(".logo-list").append(item)
                        });
                      }
                      GLightbox({
                          selector: '[data-popup="lightbox"]',
                          loop: true,
                          svg: {
                              next: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"> <g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>',
                              prev: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>'
                          }
                      });
                      GLightbox({
                          selector: '[data-popup="lightbox2"]',
                          loop: true,
                          svg: {
                              next: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"> <g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>',
                              prev: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>'
                          }
                      });
                      GLightbox({
                          selector: '[data-popup="lightbox3"]',
                          loop: true,
                          svg: {
                              next: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"> <g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>',
                              prev: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>'
                          }
                      });
                      $("#season-obj").val(JSON.stringify(result.seasons));
                      window.seasons = result.seasons;

                      $("#crew-obj").val(JSON.stringify(result.credits.crew));
                      $("#cast-obj").val(JSON.stringify(result.credits.cast));
                      $("#season-count").html(result.number_of_seasons);
                      $("#vote-count").val(result.vote_count);
                      console.log(result.vote_count)

                      $("#episode-count").html(result.number_of_episodes);
                      $(".series-episode-list").html(result.theme);
                      var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
                      elems.forEach(function(html) {
                          var switchery = new Switchery(html);
                      });
                      // Initialize
                      $('[data-popup="tooltip"]').tooltip();

                      // Demo tooltips, remove in production
                      var demoTooltipSelector = '[data-popup="tooltip-demo"]';
                      if($(demoTooltipSelector).is(':visible')) {
                          $(demoTooltipSelector).tooltip('show');
                          setTimeout(function() {
                              $(demoTooltipSelector).tooltip('hide');
                          }, 2000);
                      }
                      var coverUri = "https://image.tmdb.org/t/p/original";
                      var posterUri = "https://image.tmdb.org/t/p/original";
                      if(result.backdrop_path){
                        $(".profile-thumb img").attr("src",posterUri+result.poster_path);
                      }
                      if(result.backdrop_path){
                        $("#avatar-cover").attr('src',coverUri+result.backdrop_path);
                        $(".profile-cover-img").css("background","url(https://image.tmdb.org/t/p/original"+result.backdrop_path+") no-repeat");
                        $(".profile-cover-img").css("background-size","cover");
                      }
                      if(result.images.logos.length >= 1){
                        $("#logo").attr('src',coverUri+result.images.logos[0].file_path);
                      }
                      $("#series-name").val(result.name);
                      $(".top-names").html(result.name);
                      $("#original-name").val(result.original_name);
                      $("#series-alias").val(result.seflink);
                      $(".series-air-date").val(result.first_air_date);
                      var categoryList = [];
                      $.each(result.genres, function(i,e){
                          if ($('.category-list').find("option[value='" + e.id + "']").length) {
                          } else { 
                              var newOption = new Option(e.name, e.id, true, true);
                              $('.category-list').append(newOption).trigger('change');
                          } 
                          categoryList.push(e.id)
                      });
                      $('.category-list').val(categoryList).trigger('change');

                      $("#series-desc").val(result.overview);
                      $("#year").val((result.first_air_date) ? result.first_air_date.split("-")[0] : '');
                      $("#time").val(result.episode_run_time[0]);
                      var channels = []
                      $.each(result.networks, function(i,e){
                          channels.push(e.name);
                          var newOption = new Option(e.name, e.id, true, true);
                          $('#channel').append(newOption).trigger('change');
                      });
                      // $("#channel").val(channels.join(','))
                      $("#channel-json").val(JSON.stringify(result.networks));
                      var videos = []
                      $.each(result.videos, function(i,e){
                          videos.push(e.key);
                      });
                      $("#fragman").val(videos.join(','))
                      $("#fragman-json").val(JSON.stringify(result.videos));
                      $("#imdb-id").val(result.external_ids.imdb_id);
                      $("#imdb-point").val(result.imdb_vote);
                      var country = []
                      $.each(result.origin_country, function(i,e){
                          country.push(e);
                      });
                      $("#country").val(country.join(','));
                      $(".profile-cover").slideDown();
                      var cast_list = ""
                      if(result.credits.cast){
                          $.each(result.credits.cast,function(i,item){
                              cast_list += `
                                  <li>
                                     <a href="javascript:;" class="media">
                                        <div class="mr-3">
                                           <img src="https://image.tmdb.org/t/p/w45`+item.profile_path+`" class="" width="55" height="68" alt="">
                                        </div>
                                        <div class="media-body">
                                           <div class="media-title font-weight-semibold">`+item.name+`</div>
                                           <span class="text-muted font-size-sm">`+item.character+`</span>
                                        </div>
                                        <div class="align-self-center ml-3">
                                           <span class="badge badge-mark bg-success border-success"></span>
                                        </div>
                                     </a>
                                  </li>
                              `;
                          });
                          $("#cast-list").html(cast_list)
                          $("#cast-obj").val(JSON.stringify(result.credits.cast))
                      }
                      var crew_list = ""
                      if(result.credits.crew){
                          $.each(result.credits.crew,function(i,item){
                              crew_list += `
                                  <li>
                                     <a href="javascript:;" class="media">
                                        <div class="mr-3">
                                           <img src="https://image.tmdb.org/t/p/w45`+item.profile_path+`" class="" width="55" height="68" alt="">
                                        </div>
                                        <div class="media-body">
                                           <div class="media-title font-weight-semibold">`+item.original_name+`</div>
                                           <span class="text-muted font-size-sm">`+item.department+`</span>
                                        </div>
                                        <div class="align-self-center ml-3">
                                           <span class="badge badge-mark bg-success border-success"></span>
                                        </div>
                                     </a>
                                  </li>
                              `;
                          });
                          $("#crew-list").html(crew_list)
                          $("#crew-json").val(JSON.stringify(result.credits.crew))
                      }
                      $("#modal_bot").modal('hide')
                  },
                  error:function(e){
                      console.log(e)
                  },
                  complete:function(){
                      t.html(html);
                      t.prop('disabled',false);
                  }
              });
          }
      });
      $(document).on("click","#tmdb-add-movie",function(){
        $(".category-list").val(null).trigger('change')
          var tmdbId    = $("#tmdbId").val();
          var media     = $("#media").val();
          var language  = $(".tmdb-language").val();
          if(tmdbId){
              var t = $(this);
              var html = t.html();
              t.prop('disabled',true);
              t.html(loader);
              $.ajax({
                  type:"POST",
                  url:origin+"/panel/tmdb/get/"+media,
                  data:{tmdbId,language,media},
                  dataType:'json',
                  success:function(result){
                      if(result.images.posters){
                        $(".poster-list").html("");

                        $.each(result.images.posters,function(a,i){
                          var item = `
                            <div class="col-lg-4">
                               <div class="card">
                                  <div class="card-img-actions">
                                     <img class="card-img-top img-fluid" src="https://image.tmdb.org/t/p/original${i.file_path}" alt="">
                                     <div class="card-img-actions-overlay card-img-top">
                                        <a href="https://image.tmdb.org/t/p/original${i.file_path}" class="btn btn-outline-white border-2" data-popup="lightbox">
                                           Önizle
                                        </a>
                                        <button class="btn btn-outline-white ml-2 border-2" data-select-images="poster" data-url="https://image.tmdb.org/t/p/original${i.file_path}" >
                                           Seç
                                        </button>
                                     </div>
                                  </div>
                               </div>
                            </div>
                          `;
                          $(".poster-list").append(item)
                        });
                        
                      }
                      if(result.images.backdrops){
                        $(".cover-list").html("");

                        $.each(result.images.backdrops,function(a,i){
                          var item = `
                            <div class="col-lg-4">
                               <div class="card">
                                  <div class="card-img-actions">
                                     <img class="card-img-top img-fluid" src="https://image.tmdb.org/t/p/original${i.file_path}" alt="">
                                     <div class="card-img-actions-overlay card-img-top">
                                        <a href="https://image.tmdb.org/t/p/original${i.file_path}" class="btn btn-outline-white border-2" data-popup="lightbox2">
                                           Önizle
                                        </a>
                                        <button class="btn btn-outline-white ml-2 border-2" data-select-images="cover" data-url="https://image.tmdb.org/t/p/original${i.file_path}" >
                                           Seç
                                        </button>
                                     </div>
                                  </div>
                               </div>
                            </div>
                          `;
                          $(".cover-list").append(item)
                        });
                        
                      }
                      if(result.images.logos){
                        $(".logo-list").html("");
                        $("#logo-content").show();
                        var logoPath = result.images.logos[0] ? result.images.logos[0].file_path : '';
                        $("#logo").attr('src',"https://image.tmdb.org/t/p/original"+logoPath)
                        $.each(result.images.logos,function(a,i){
                          var item = `
                            <div class="col-lg-4">
                               <div class="card">
                                  <div class="card-img-actions">
                                     <img class="card-img-top img-fluid" src="https://image.tmdb.org/t/p/original${i.file_path}" alt="">
                                     <div class="card-img-actions-overlay card-img-top">
                                        <a href="https://image.tmdb.org/t/p/original${i.file_path}" class="btn btn-outline-white border-2" data-popup="lightbox3">
                                           Önizle
                                        </a>
                                        <button class="btn btn-outline-white ml-2 border-2" data-select-images="logo" data-url="https://image.tmdb.org/t/p/original${i.file_path}" >
                                           Seç
                                        </button>
                                     </div>
                                  </div>
                               </div>
                            </div>
                          `;
                          $(".logo-list").append(item)
                        });
                      }
                      GLightbox({
                          selector: '[data-popup="lightbox"]',
                          loop: true,
                          svg: {
                              next: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"> <g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>',
                              prev: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>'
                          }
                      });
                      GLightbox({
                          selector: '[data-popup="lightbox2"]',
                          loop: true,
                          svg: {
                              next: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"> <g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>',
                              prev: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>'
                          }
                      });
                      GLightbox({
                          selector: '[data-popup="lightbox3"]',
                          loop: true,
                          svg: {
                              next: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"> <g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>',
                              prev: document.dir == "rtl" ? '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M360.731,229.075l-225.1-225.1c-5.3-5.3-13.8-5.3-19.1,0s-5.3,13.8,0,19.1l215.5,215.5l-215.5,215.5c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4c3.4,0,6.9-1.3,9.5-4l225.1-225.1C365.931,242.875,365.931,234.275,360.731,229.075z"/></g></svg>' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.175 477.175" xml:space="preserve"><g><path d="M145.188,238.575l215.5-215.5c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-225.1,225.1c-5.3,5.3-5.3,13.8,0,19.1l225.1,225c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4c5.3-5.3,5.3-13.8,0-19.1L145.188,238.575z"/></g></svg>'
                          }
                      });
                      $("#movies-name").val(result.title);
                      $(".top-names").html(result.title);
                      $("#original-name").val(result.original_title);
                      $("#movies-alias").val(result.seflink);
                      $(".movies-air-date").val(result.release_date);
                      $("#crew-obj").val(JSON.stringify(result.credits.crew));
                      $("#cast-obj").val(JSON.stringify(result.credits.cast));
                      $("#movies-desc").val(result.overview);
                      $("#time").val(result.runtime);
                      $("#vote-count").val(result.vote_count);

                      var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
                      elems.forEach(function(html) {
                          var switchery = new Switchery(html);
                      });
                      // Initialize
                      $('[data-popup="tooltip"]').tooltip();

                      var demoTooltipSelector = '[data-popup="tooltip-demo"]';
                      if($(demoTooltipSelector).is(':visible')) {
                          $(demoTooltipSelector).tooltip('show');
                          setTimeout(function() {
                              $(demoTooltipSelector).tooltip('hide');
                          }, 2000);
                      }
                      var coverUri = "https://image.tmdb.org/t/p/original";
                      var posterUri = "https://image.tmdb.org/t/p/original";
                      if(result.backdrop_path){
                        $(".profile-thumb img").attr("src",posterUri+result.poster_path);
                      }
                      if(result.backdrop_path){
                        $("#avatar-cover").attr('src',coverUri+result.backdrop_path);
                        $(".profile-cover-img").css("background","url(https://image.tmdb.org/t/p/original"+result.backdrop_path+") no-repeat");
                        $(".profile-cover-img").css("background-size","cover");
                      }
                      
                      var categoryList = [];
                      $.each(result.genres, function(i,e){
                          if ($('.category-list').find("option[value='" + e.id + "']").length) {
                          } else { 
                              var newOption = new Option(e.name, e.id, true, true);
                              $('.category-list').append(newOption).trigger('change');
                          } 
                          categoryList.push(e.id)
                      });
                      $('.category-list').val(categoryList).trigger('change');

                      var videos = []
                      $.each(result.videos, function(i,e){
                          videos.push(e.key);
                      });
                      $("#fragman").val(videos.join(','))
                      $("#fragman-json").val(JSON.stringify(result.videos));
                      $("#imdb-id").val(result.external_ids.imdb_id);
                      $("#imdb-point").val(result.imdb_vote);
                      $("#budget").val(formatter.format(result.budget));
                      $("#revenue").val(formatter.format(result.revenue));
                      if(result.belongs_to_collection != null){
                        $("#collect-movies").val( result.belongs_to_collection.name);
                        $("#collect-moviesJson").val( JSON.stringify(result.boxset));
                      }
                      var country = []
                      $.each(result.production_countries, function(i,e){
                          country.push(e.iso_3166_1);
                      });
                      $("#country").val(country.join(','));
                      $(".profile-cover").slideDown();
                      var cast_list = ""
                      if(result.credits.cast){
                          $.each(result.credits.cast,function(i,item){
                            if(item.profile_path){
                               cast_list += `
                                  <li>
                                     <a href="javascript:;" class="media">
                                        <div class="mr-3">
                                           <img src="https://image.tmdb.org/t/p/w45`+item.profile_path+`" class="" width="55" height="68" alt="">
                                        </div>
                                        <div class="media-body">
                                           <div class="media-title font-weight-semibold">`+item.name+`</div>
                                           <span class="text-muted font-size-sm">`+item.character+`</span>
                                        </div>
                                        <div class="align-self-center ml-3">
                                           <span class="badge badge-mark bg-success border-success"></span>
                                        </div>
                                     </a>
                                  </li>
                              `;
                            }
                             
                          });
                          $("#cast-list").html(cast_list)
                          $("#cast-obj").val(JSON.stringify(result.credits.cast))
                      }
                     /* var crew_list = ""
                      if(result.credits.crew){
                          $.each(result.credits.crew,function(i,item){
                              crew_list += `
                                  <li>
                                     <a href="javascript:;" class="media">
                                        <div class="mr-3">
                                           <img src="https://image.tmdb.org/t/p/w45`+item.profile_path+`" class="" width="55" height="68" alt="">
                                        </div>
                                        <div class="media-body">
                                           <div class="media-title font-weight-semibold">`+item.original_name+`</div>
                                           <span class="text-muted font-size-sm">`+item.department+`</span>
                                        </div>
                                        <div class="align-self-center ml-3">
                                           <span class="badge badge-mark bg-success border-success"></span>
                                        </div>
                                     </a>
                                  </li>
                              `;
                          });
                          $("#crew-list").html(crew_list)
                          $("#crew-json").val(JSON.stringify(result.credits.crew))
                      }*/
                      $("#modal_bot").modal('hide')
                  },
                  error:function(e){
                      console.log(e)
                  },
                  complete:function(){
                      t.html(html);
                      t.prop('disabled',false);
                  }
              });
          }
      });
      $(document).on("click","[data-select-images]",function(){
        var type = $(this).data("select-images");
        var image = $(this).data("url");

        $("."+type+"-list [data-select-images='"+type+"']").removeClass("btn-success").addClass("btn-outline-white border-2").text('Seç');
        $(this).removeClass("btn-outline-white border-2").addClass('btn-success').text("Seçildi");

        if(type == 'poster'){
          $("#avatar").attr('src',image);
          $("#avatar-source").val(image);
        }else if(type == 'cover'){
          $("#avatar-cover").attr('src',image);
          $("#cover-source").val(image);
          $(".profile-cover-img").css("background-image",'url('+image+')')
        }else if(type == 'logo'){
          $("#logo-content").show();
          $("#logo").attr('src',image);
          $("#logo-source").val(image);

        }
      });
    }

    var _selectTmdbContent = function(){
        $(document).on("click","[data-tmdbid]",function(){
            var id =$(this).data("tmdbid");
            var title = $(this).data("title");
            var image = $(this).data("image");
            if(id){
                $("#tmdbId").val(id);
                $(".search-result-container").hide();
                $("#tmdb-search-value").val(title)

                $(".active-content-detail").html(`<div class="d-flex align-items-center">
                        <a href="javascript:;">
                           <img src="${image}" width="40" height="40" class="rounded-pill" alt="">
                        </a>

                        <div class="flex-fill ms-3  ml-2">
                           <div class="fw-semibold">  ${title}</div>
                         
                        </div>
                     </div>`);
            }
        })
    }
    var imageCropper = function(){
          var avatar = document.getElementById('avatar');
          var image = document.getElementById('image');
          var input = document.getElementById('input');
          var ajax = $("#input").data("ajax")
          var user_id = $("[data-id]").data("id");
          var $progress = $('.progress');
          var $progressBar = $('.progress-bar');
          var $alert = $('.alert');
          var $modal = $('#modal');
          var cropper;

          $('[data-toggle="tooltip"]').tooltip();

          input.addEventListener('change', function (e) {
            var files = e.target.files;
            var done = function (url) {
              input.value = '';
              image.src = url;
              $alert.hide();
              $modal.modal('show');
            };
            var reader;
            var file;
            var url;

            if (files && files.length > 0) {
              file = files[0];

              if (URL) {
                done(URL.createObjectURL(file));
              } else if (FileReader) {
                reader = new FileReader();
                reader.onload = function (e) {
                  done(reader.result);
                };
                reader.readAsDataURL(file);
              }
            }
          });

          $modal.on('shown.bs.modal', function () {
            cropper = new Cropper(image, {
              viewMode: 1,
            });
          }).on('hidden.bs.modal', function () {
            cropper.destroy();
            cropper = null;
          });

          document.getElementById('crop').addEventListener('click', function () {
            var initialAvatarURL;
            var canvas;

            $modal.modal('hide');

            if (cropper) {
              canvas = cropper.getCroppedCanvas({
                width: 768,
                height: 1152,
              });
              initialAvatarURL = avatar.src;
              avatar.src = canvas.toDataURL();
              $("#avatar-source").val(canvas.toDataURL() )

              // $progress.show();
              // $alert.removeClass('alert-success alert-warning');
              canvas.toBlob(function (blob) {
                if(ajax){
                  var formData = new FormData();
                  formData.append('avatar', blob);
                  formData.append('user_id', user_id);
                  $.ajax(ajax, {
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,

                    xhr: function () {
                      var xhr = new XMLHttpRequest();

                      xhr.upload.onprogress = function (e) {
                        var percent = '0';
                        var percentage = '0%';

                        if (e.lengthComputable) {
                          percent = Math.round((e.loaded / e.total) * 100);
                          percentage = percent + '%';
                          $progressBar.width(percentage).attr('aria-valuenow', percent).text(percentage);
                        }
                      };

                      return xhr;
                    },

                    success: function () {
                      $alert.show().addClass('alert-success').text('Upload success');
                    },

                    error: function () {
                      avatar.src = initialAvatarURL;
                      $alert.show().addClass('alert-warning').text('Upload error');
                    },

                    complete: function () {
                      $progress.hide();
                    },
                  });
                }
              });
            }
          });
    }
    var imageCropperCover = function(){
          var avatar = document.getElementById('avatar-cover');
          var image = document.getElementById('image-cover');
          var input = document.getElementById('input-cover');
           var ajax = $("#input-cover").data("ajax")
          var user_id = $("[data-id]").data("id");
          var $progress = $('.progress');
          var $progressBar = $('.progress-bar');
          var $alert = $('.alert');
          var $modal = $('#modal-cover');
          var cropper;

          $('[data-toggle="tooltip"]').tooltip();

          input.addEventListener('change', function (e) {
            var files = e.target.files;
            var done = function (url) {
              input.value = '';
              image.src = url;
              $alert.hide();
              $modal.modal('show');
            };
            var reader;
            var file;
            var url;

            if (files && files.length > 0) {
              file = files[0];

              if (URL) {
                done(URL.createObjectURL(file));
              } else if (FileReader) {
                reader = new FileReader();
                reader.onload = function (e) {
                  done(reader.result);
                };
                reader.readAsDataURL(file);
              }
            }
          });

          $modal.on('shown.bs.modal', function () {
            cropper = new Cropper(image, {
              aspectRatio: 1280/720 ,
              viewMode: 1,
            });
          }).on('hidden.bs.modal', function () {
            cropper.destroy();
            cropper = null;
          });

          document.getElementById('crop-cover').addEventListener('click', function () {
            var initialAvatarURL;
            var canvas;

            $modal.modal('hide');

            if (cropper) {
              canvas = cropper.getCroppedCanvas({
                width: 1280,
                height: 720,
              });
              initialAvatarURL = avatar.src;
              $(".profile-cover-img").css('background-image', 'url(' + canvas.toDataURL() + ')');
              $(avatar).attr('src',canvas.toDataURL() )
              $("#cover-source").val(canvas.toDataURL() )
              // $progress.show();
              // $alert.removeClass('alert-success alert-warning');
              canvas.toBlob(function (blob) {
                if(ajax){
                  var formData = new FormData();
                  formData.append('cover', blob);
                  formData.append('user_id', user_id);
                  $.ajax(ajax, {
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,

                    xhr: function () {
                      var xhr = new XMLHttpRequest();

                      xhr.upload.onprogress = function (e) {
                        var percent = '0';
                        var percentage = '0%';

                        if (e.lengthComputable) {
                          percent = Math.round((e.loaded / e.total) * 100);
                          percentage = percent + '%';
                          $progressBar.width(percentage).attr('aria-valuenow', percent).text(percentage);
                        }
                      };

                      return xhr;
                    },

                    success: function () {
                      $alert.show().addClass('alert-success').text('Upload success');
                    },

                    error: function () {
                      avatar.src = initialAvatarURL;
                      $alert.show().addClass('alert-warning').text('Upload error');
                    },

                    complete: function () {
                      $progress.hide();
                    },
                  });
                }
              });
            }
          });
    }
    var logoCropper = function(){
          var avatar = document.querySelector('.avatar-logo');
          var image = document.getElementById('image-logo');
          var input = document.getElementById('input-logo');
          var $progress = $('.progress');
          var $progressBar = $('.progress-bar');
          var $alert = $('.alert');
          var $modal = $('#modal-logo');
          var cropper;

          $('[data-toggle="tooltip"]').tooltip();

          if($("#input-logo").length){
            input.addEventListener('change', function (e) {
              var files = e.target.files;
              var done = function (url) {
                input.value = '';
                image.src = url;
                $alert.hide();
                $modal.modal('show');
              };
              var reader;
              var file;
              var url;

              if (files && files.length > 0) {
                file = files[0];

                if (URL) {
                  done(URL.createObjectURL(file));
                } else if (FileReader) {
                  reader = new FileReader();
                  reader.onload = function (e) {
                    done(reader.result);
                  };
                  reader.readAsDataURL(file);
                }
              }
            });
        

          $modal.on('shown.bs.modal', function () {
            cropper = new Cropper(image, {
              aspectRatio: 265/105 ,
              viewMode: 1,
            });
          }).on('hidden.bs.modal', function () {
            cropper.destroy();
            cropper = null;
          });

          document.getElementById('crop-logo').addEventListener('click', function () {
            var initialAvatarURL;
            var canvas;

            $modal.modal('hide');

            if (cropper) {
              canvas = cropper.getCroppedCanvas({
                width: 1280,
                height: 720,
              });
              initialAvatarURL = avatar.src;
              $("#logo").attr('src',canvas.toDataURL());
              $(avatar).attr('src',canvas.toDataURL() )
              $("#logo-source").val(canvas.toDataURL() )
              canvas.toBlob(function (blob) {
              });
            }
          });
      }
    }
    var _seriesCastPosterInject = function(){
      var cast_json = $("#cast-obj").val() ? JSON.parse($("#cast-obj").val()) : [];
      $("#cast-list img").each(function(a,i){
        var poster    = $(this).attr('src');
        var id        = parseInt($(this).data("id"));
        var check     = Object.keys(cast_json).filter(item => cast_json[item].id == id)[0]
        if(check >= 0){
          cast_json[check].poster = poster;
        }
      });
      $("#cast-obj").val(JSON.stringify(cast_json));
    }
    var _seriesAdd = function(){
        $(".create-series").click(function(){
          var validator = $( ".series-form" ).validate();
          if(validator.form()){
            _seriesCastPosterInject();

            var name            = $("#series-name").val();
            var original_name   = $("#original-name").val();
            var series_alias    = $("#series-alias").val();
            var series_air_date = $(".series-air-date").val();
            var category_list   = $(".category-list").val();
            var series_desc     = $("#series-desc").val();
            var user_access     = $("#user-access").val();
            var fragman         = $("#fragman").val();
            var fragmanJson         = $("#fragman-json").val();
            var popular         = $("#popular").val();
            var status          = $("#status").val();
            var imdb_point      = $("#imdb-point").val();
            var year            = $("#year").val();
            var imdb_id         = $("#imdb-id").val();
            var country         = $("#country").val();
            var channel         = $("#channel").val();
            var channels        = $("#channel-json").val();
            var time            = $("#time").val();
            var seasons         = $("#season-obj").val();
            var crews           = $("#crew-obj").val();
            var cast            = $("#cast-obj").val();
            var tmdbId          = $("#tmdbId").val();
            var active          = $("#series-active").is(":checked") ? 1 : 0;
            var poster          = $("#avatar").attr("src");
            var cover           = $("#avatar-cover").attr("src"); 
            var logo           = $("#logo").attr("src"); 
            var seo_title       = $("#seo_title").val(); 
            var seo_desc        = $("#seo_desc").val(); 
            var noindex        = $("#noindex").is(":checked") ? 1 : 0;
            var created_at          = $("#created_at").val() ;
            var vote_count        = $("#vote-count").val()
            var episode_mask          = $("#episode_mask").val() ;

            var link        = $("#external_link").val()
            /*Extension*/
            var no_season       = $("#no_season").is(":checked") ? 1 : null; 
            var custom_episode  = $("#custom_episode_status").is(":checked") ? 1 : null; 

            var episode_name      = $("#custom-episode-name").val();
            var episode_number    = $("#custom-episode-number").val();
            var episode_season    = $("#custom-episode-season").val();
            var episode_link      = $("#custom-episode-link").val();
            var episode_date      = $("#custom-episode-airdate").val();
            var episode_note      = $("#custom-episode-note").val();
            var episode_overview  = $("#custom-episode-overview").val();
            var episode_seo_title  = $("#custom-episode-seo-title").val();
            var episode_seo_desc  = $("#custom-episode-seo-desc").val();
            var episode_day     = $("#custom-episode_day").val();
            var episode_multi     = $("#custom_multi_episode").is(":checked") ? 1 : null; 
            var episode_main     = $("#custom_episode_main").is(":checked") ? 1 : null; 

            var not_member  = $(" .custom-not_member").is(":checked") ? 1 : 0;
            var only_mobile  = $(" .custom-only_mobile").is(":checked") ? 1 : 0;
            var only_yandex  = $(" .custom-only_yandex").is(":checked") ? 1 : 0;
            var abroad  = $(" .custom-abroad").is(":checked") ? 1 : 0;
            var dmca  = $(" .dmca").is(":checked") ? 1 : 0;

            var custom_access = {
              not_member,
              only_mobile,
              only_yandex,
              abroad,
              dmca
            }
              
            var countdown       = $("#countdown").is(":checked") ? 1 : null; 
            var apk             = $("#apk").is(":checked") ? 1 : null; 
            var tags            = $("#tags").val(); 
            var tiers            = $("#tiers").val(); 
            var collectseries  = $("#collect-series").val(); 

            var t = $(this);
            var html = t.html();
            t.html(loader);
            t.prop('disabled',true);
            $.ajax({
                type:"POST",
                url:origin+"/panel/series/create",
                data:{
                   /*Ex*/
                    no_season,
                    countdown,
                    apk,
                    tags,
                    collectseries,
                    link,
                   /*Ex*/
                    /*Custom Episode*/
                    custom_episode,
                    episode_name,    
                    episode_number,  
                    episode_season,  
                    episode_link   , 
                    episode_date    ,
                    episode_note    ,
                    episode_overview,
                    episode_multi   ,
                    episode_seo_title,
                    episode_seo_desc,
                    episode_day,
                    episode_main,
                    custom_access,
                    /*Custom Episode*/
                    name,
                    original_name,
                    series_alias,
                    series_air_date,
                    category_list,
                    tags,
                    active,
                    series_desc,
                    user_access,
                    fragman,
                    fragmanJson,
                    popular,
                    status,
                    imdb_point,
                    year,
                    imdb_id,
                    country,
                    channel,
                    channels,
                    time,
                    tmdbId,
                    poster,
                    cover,
                    logo,
                    seasons,
                    crews,
                    cast,
                    tiers,
                    seo_title,
                    seo_desc,
                    noindex,
                    vote_count,
                    episode_mask,
                    created_at
                },
                dataType:'json',
                success:function(result){
                  if(result.success){
                    getNotif("success",result.success);
                  }else {
                    getNotif("error",result.error);
                  }
                },
                error:function(e){
                    console.log(e)
                },
                complete:function(){
                     t.html(html);
                    t.prop('disabled',false);
                }
            });
          }
        });
    }
    var _seriesEdit = function(){
        $(".edit-series").click(function(){
          var validator = $( ".series-form" ).validate();
          if(validator.form()){
            var id              = $(this).data("id");
            var name            = $("#series-name").val();
            var original_name   = $("#original-name").val();
            var series_alias    = $("#series-alias").val();
            var series_air_date = $(".series-air-date").val();
            var category_list   = $(".category-list").val();
            var series_desc     = $("#series-desc").val();
            var user_access     = $("#user-access").val();
            var redirect     = $("#redirect").is(":checked") ? 1 : 0;
            var fragman         = $("#fragman").val();
            var popular         = $("#popular").val();
            var status          = $("#status").val();
            var imdb_point      = $("#imdb-point").val();
            var year            = $("#year").val();
            var imdb_id         = $("#imdb-id").val();
            var country         = $("#country").val();
            var channel         = $("#channel").val();
            var time            = $("#time").val();
            var seasons         = $("#season-obj").val();
            var crews           = $("#crew-obj").val();
            var cast            = $("#cast-obj").val();
            var tmdbId          = $("#tmdbId").val();
            var active          = $("#series-active").is(":checked") ? 1 : 0;
            var noindex        = $("#noindex").is(":checked") ? 1 : 0;
            var link        = $("#external_link").val()
           
            var poster          = $("#avatar-source").val();
            var cover           = $("#cover-source").val(); 
            var logo            = $("#logo-source").val(); 
            var seo_title       = $("#seo_title").val(); 
            var seo_desc        = $("#seo_desc").val(); 
            var created_at          = $("#created_at").val() ;

            /*Extension*/
            var no_season       = $("#no_season").is(":checked") ? 1 : null; 
            var countdown       = $("#countdown").is(":checked") ? 1 : null; 
            var apk             = $("#apk").is(":checked") ? 1 : null; 
            var tags            = $("#tags").val(); 
            var collectseries  = $("#collect-series").val(); 
            var tiers            = $("#tiers").val(); 
            
            var t = $(this);
            var html = t.html();
            t.html(loader);
            t.prop('disabled',true);
            $.ajax({
                type:"POST",
                url:origin+"/panel/series/update",
                data:{
                   /*Ex*/
                    no_season,
                    countdown,
                    apk,
                    tags,
                    collectseries,
                   /*Ex*/
                    link,
                    redirect,
                    id,
                    name,
                    original_name,
                    series_alias,
                    series_air_date,
                    category_list,
                    tags,
                    active,
                    series_desc,
                    user_access,
                    fragman,
                    popular,
                    status,
                    imdb_point,
                    year,
                    imdb_id,
                    country,
                    channel,
                    time,
                    poster,
                    logo,
                    tiers,
                    cover,
                    seo_title,
                    seo_desc,
                    noindex,
                    created_at
                },
                dataType:'json',
                success:function(result){
                  if(result.success){
                    getNotif("success",result.success);
                  }else {
                    getNotif("error",result.error);
                  }
                },
                error:function(e){
                    console.log(e)
                },
                complete:function(){
                     t.html(html);
                    t.prop('disabled',false);
                }
            });
          }
        });
    }
    var seriesTable = function(){
      var table = $("#series-list").DataTable({
        processing: true,
        serverSide: true,
         "order": [[ 0, "desc" ]],
         columnDefs: [
          { orderable: false, targets: [8,9] },
        ],

        ajax: {
          url: origin + "/panel/get/series",
          type: "POST",
          data:{
            "custom_access":getUrlParameter('access')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "original" },
          { data: "alias" },
          { data: "season" },
          { data: "episode" },
          { data: "cuff" },
          { data: "combine" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
    }
    var seasonAdd = function(){
      var seasonObj = []
      var multiple = $("#multi_season").is(":checked") ? 1 : 0;
      $('#add-season-modal').on('shown.bs.modal', function (e) {
         seasonObj = $("#season-obj").val() ? JSON.parse($("#season-obj").val()) : []
        $('#episodes-list').modal('hide')
        $("#season-number").focus()
      });
      $('#add-season-modal').on('hidden.bs.modal', function (e) {
        $('#episodes-list').modal('show')
      });

      $(document).on("click","#series-add-season",function(){
        var season = parseInt($("#season-number").val());
        if(season){
          if(multiple){
            for(var i = 1;i <= season;i++){
              var obj = {
                air_date: new Date().toISOString().split('T')[0],
                episode_count:0,
                id:"",
                name:"Sezon "+i,
                overview:"",
                episodes:[],
                poster_path:"",
                season_number:i
              }
              var check = Object.keys(seasonObj).filter(function(row) {
                return seasonObj[row].season_number===i;
              });
              if(!check.length){
                seasonObj.push(obj);
                $('#add-season-modal').modal('hide')
              }
            }
          }else {
            var obj = {
              air_date: new Date().toISOString().split('T')[0],
              episode_count:0,
              id:"",
              name:"Sezon "+season,
              overview:"",
              episodes:[],
              poster_path:"",
              season_number:season
            }
            var check = Object.keys(seasonObj).filter(function(row) {
              return seasonObj[row].season_number===season;
            });
            if(!check.length){
              seasonObj.push(obj);
              $('#add-season-modal').modal('hide')
            }
          }
        }
        initSeasonEpisode(seasonObj)
        $("#season-obj").val(JSON.stringify(seasonObj))
        var optList = []
        $.each(seasonObj,function(a,i){
          optList.push('<option value="'+i.season_number+'">Sezon '+i.season_number+'</option>')
        });
        console.log(seasonObj);
        console.log(optList);
        $("#episode_season").html(optList.join(""));
        $("#episode_season").trigger('change')
      });

      window.seasonObj = seasonObj;
    }
    var episodeAdd = function(){
      var seasonObj = window.seasonObj;
      var episodeObj = [];
      $('#add-episode-modal').on('shown.bs.modal', function (e) {
        $('#episodes-list').modal('hide');
        if(!seasonObj.length){
          seasonObj = $("#season-obj").val() ? JSON.parse($("#season-obj").val()) : [];
        }
      });
      $('#add-episode-modal').on('hidden.bs.modal', function (e) {
        $('#episodes-list').modal('show')
      });
      $(document).on("click","#episode-add-season",function(){
        var multiple = $("#multi_episode").is(":checked") ? 1 : 0;

        $(this).attr("data-loading");
        $(this).prop("disabled",true);
        var season    = $("#episode_season").val();
        var name      = $("#episode-name").val();
        var number    = $("#episode-number").val();
        var link      = $("#episode-link").val();
        var date      = $("#episode-airdate").val();
        var note      = $("#episode-note").val();
        var overview  = $("#episode-overview").val();
        var status  = $("#episode-status").val();
        var main      = $("#episode_main:checked").val();
      
        if(multiple){
          for(var i = 1;i<= number;i++){
            var check = seasonObj[season - 1].episodes.filter(function(row){
              if(row.season_number == season && row.episode_number == i){
                return true;
              }
              return false;
            });
            var obj = {
              'episode': i,
              'season': season,
              'date': date
            }

            var text = name;
            var text2 = link;
            text = mutliStringReplace(obj,text)
            text2 = mutliStringReplace(obj,text2)

            var obj = {
              "air_date":date,
              "episode_number":i,
              "name":text,
              "note":note,
              "link": text2,
              "status": status,
              "overview":overview,
              "season_number":season,
              "id":Math.floor(Math.random() * 9999  + 1) + "wc",
              "main":parseInt(main),
            }
            if(!check.length){
              seasonObj[season - 1].episodes.push(obj)
            }else {
              getNotif('error',`${season}. Sezon için ${i}. Bölüm eklenmiş görünüyor.`);
            }
          }
        }else {
          var check = seasonObj[season - 1].episodes.filter(function(row){
            if(row.season_number == season && row.episode_number == number){
              return true;
            }
            return false;
          });
          var obj = {
            "air_date":date,
            "episode_number":number,
            "note":note,
            "link": link,
            "name":name,
            "overview":overview,
            "season_number":season,
            "id":Math.floor(Math.random() * 9999  + 1) + "wc",
            "main":parseInt(main),
          }
          if(!check.length){
            seasonObj[season - 1].episodes.push(obj)
          }else {
            getNotif('error',`${season}. Sezon için ${number}. Bölüm eklenmiş görünüyor.`);
          }
        }
        $("#episode-add-season").removeAttr("data-loading");
        $("#episode-add-season").prop("disabled",false);
        $('#add-episode-modal').modal('hide')
        coreData = seasonObj
        initSeasonEpisode(seasonObj);
        window.seasons = seasonObj;
        $("#season-obj").val(JSON.stringify(seasonObj))
      });
    }
    var episodeEdit = function(){
      $('#episode-edit').on('shown.bs.modal', function (e) {
        $('#episodes-list').modal('hide')
      });
      $('#episode-edit').on('hidden.bs.modal', function (e) {
        $('#episodes-list').modal('show')
      });
      $(document).on("click",".episode-edit",function(){
        episode = $(this).data("episode");
        season  = $(this).data("season");
        $(".episode-count").html(episode);
        $(".season-count").html(season);
        var coreData = window.seasons;
        check = Object.keys(coreData).filter(function(row) {
          if(coreData[row].season_number == season){
            return row;
          }
        });
        if(check.length){
          seasonKey = parseInt(check.join(""));
          data = coreData[seasonKey];
          dataEpisode = coreData[seasonKey].episodes;
          checkEpisode = Object.keys(dataEpisode).filter(function(row) {
            if(dataEpisode[row].episode_number == episode){
              return row;
            }
          });
          episodeKey = parseInt(checkEpisode.join(""));
          episodeItem = dataEpisode[episodeKey];
          
          $(".episode-number").val(episodeItem.episode_number);
          $(".episode-date").val(episodeItem.air_date);
          $(".episode-url").val(episodeItem.link);
          $(".episode-name").val(episodeItem.name);
          $(".episode-desc").val(episodeItem.overview);
          $(".episode-note").val(episodeItem.note);
          $(".episode_main").attr("checked",1);
          $(".episode_main").click();
        }
      });
      $(document).on("click","#episode-edit-season",function(){
        var coreData = window.seasons;
        var date      = $(".episode-date").val();
        var link      = $(".episode-url").val();
        var name      = $(".episode-name").val();
        var overview  = $(".episode-desc").val();
        var note      = $(".episode-note").val();
        var number    = $(".episode-number").val();
        var main      = $(".episode_main").is(":checked") ? 1 : 0;
        var obj = {
          "air_date":date,
          "episode_number":number,
          "link":link,
          "note":note,
          "name":name,
          "overview":overview,
          "season_number":season,
          "id":"",
          "main":parseInt(main),
        }
        coreData[seasonKey].episodes[episodeKey] = obj
        $("#season-obj").val(JSON.stringify(coreData))
      });
    }
    var initSeasonEpisode = function(seasonList){
      $.ajax({
        type:"POST",
        url:origin+"/panel/series/season/init",
        data:{"season":seasonList},
        dataType:'json',
        success:function(result){
          if(result.success){
            $(".series-episode-list").html(result.data);
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            $('[data-popup="tooltip"]').tooltip();

          }
        },
        error:function(e){
            console.log(e)
        },
        complete:function(){
        }
      });
      return seasonList
    }
    var replaceUndefinedOrNull = function (key, value) {
      if (value === null || value === undefined) {
      }

      return value;
    }
    var animeTable = function(){
      var table = $("#anime-list").DataTable({
        processing: true,
        serverSide: true,
         "order": [[ 0, "desc" ]],
         columnDefs: [
          { orderable: false, targets: [8,9] },
        ],

        ajax: {
          url: origin + "/panel/get/anime",
          type: "POST",
          data:{
            "custom_access":getUrlParameter('access')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "original" },
          { data: "alias" },
          { data: "season" },
          { data: "episode" },
          { data: "type" },
          { data: "cuff" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
    }
    var animeAdd = function(){
        $(".create-anime").click(function(){
          var validator = $( ".series-form" ).validate();
          if(validator.form()){
            _seriesCastPosterInject();

            var name            = $("#series-name").val();
            var original_name   = $("#original-name").val();
            var en_title     = $("#en-name").val();

            var alias           = $("#anime-alias").val();
            var air_date        = $(".series-air-date").val();
            var category_list   = $(".category-list").val();
            var series_desc     = $("#series-desc").val();
            var user_access     = $("#user-access").val();
            var fragman         = $("#fragman").val();
            var fragmanJson      = $("#fragman-json").val();
            var popular         = $("#popular").val();
            var status          = $("#status").val();
            var vote_count      = $("#point").val();
            var year            = $("#year").val();
            var anilist_id      = $("#anilist-id").val();
            var mal_id      = $("#mal-id").val();
            var country         = $("#country").val();
            var channel         = $("#channel").val();
            var channels        = $("#channel-json").val();
            var time            = $("#time").val();
            var seasons         = $("#season").val();
            var episode         = $("#episode").val();
            var crews           = $("#crew-obj").val();
            var meanScore           = $("#meanScore").val();
            var cast            = $("#cast-obj").val();
            var active          = $("#series-active").is(":checked") ? 1 : 0;
            var poster          = $("#avatar").attr("src");
            var cover           = $("#avatar-cover").attr("src"); 
            var is_season         = $("#is_season").is(":checked") ? 1 : 0;
            var logo           = $("#logo").attr("src"); 
            var seo_title       = $("#seo_title").val(); 
            var seo_desc        = $("#seo_desc").val(); 
            var noindex         = $("#noindex").is(":checked") ? 1 : 0;
            var created_at      = $("#created_at").val() ;
            var type            = $("#type").val() ;
            var format          = $("#format").val() ;
            var episode_mask          = $("#episode_mask").val() ;

            /*Extension*/
            var countdown       = $("#countdown:checked").val(); 
            var apk             = $("#apk:checked").val(); 
            var tags            = $("#tags").val(); 
            var tiers            = $("#tiers").val(); 
            var relations            = $("#relations").val() ? JSON.parse($("#relations").val()) : []; 
           
            var t = $(this);
            var html = t.html();
            t.html(loader);
            t.prop('disabled',true);
            $.ajax({
                type:"POST",
                url:origin+"/panel/anime/create",
                data:{
                   /*Ex*/
                    countdown,
                    apk,
                    tags,
                   /*Ex*/
                    name          ,
                    original_name ,
                    en_title ,
                    alias         ,
                    air_date      ,
                    category_list ,
                    series_desc   ,
                    user_access   ,
                    fragman       ,
                    fragmanJson   ,
                    popular       ,
                    meanScore       ,
                    status        ,
                    vote_count    ,
                    year          ,
                    anilist_id    ,
                    mal_id    ,
                    country       ,
                    channel       ,
                    channels      ,
                    time          ,
                    seasons       ,
                    is_season       ,
                    episode       ,
                    crews         ,
                    cast          ,
                    active        ,
                    poster        ,
                    cover         ,
                    logo          ,
                    seo_title     ,
                    seo_desc      ,
                    noindex       ,
                    created_at    ,
                    type          ,
                    format        ,
                    episode_mask        ,
                    relations        ,
                },
                dataType:'json',
                success:function(result){
                  if(result.success){
                    getNotif("success",result.success);
                  }else {
                    getNotif("error",result.error);
                  }
                },
                error:function(e){
                    console.log(e)
                },
                complete:function(){
                     t.html(html);
                    t.prop('disabled',false);
                }
            });
          }
        });
    }
    var animeEdit = function(){
        $(".edit-anime").click(function(){
          var validator = $( ".series-form" ).validate();
          if(validator.form()){
            _seriesCastPosterInject();

            var id              = $("#movies-id").val();
            var name            = $("#series-name").val();
            var original_name   = $("#original-name").val();
            var alias           = $("#anime-alias").val();
            var air_date        = $(".series-air-date").val();
            var category_list   = $(".category-list").val();
            var series_desc     = $("#series-desc").val();
            var en_title     = $("#en-name").val();
            var user_access     = $("#user-access").val();
            var fragman         = $("#fragman").val();
            var fragmanJson      = $("#fragman-json").val();
            var popular         = $("#popular").val();
            var status          = $("#status").val();
            var vote_count      = $("#point").val();
            var year            = $("#year").val();
            var anilist_id      = $("#anilist-id").val();
            var mal_id      = $("#mal-id").val();
            var country         = $("#country").val();
            var channel         = $("#channel").val();
            var channels        = $("#channel-json").val();
            var time            = $("#time").val();
            var seasons         = $("#season").val();
            var episode         = $("#episode").val();
            var crews           = $("#crew-obj").val();
            var cast            = $("#cast-obj").val();
            var active          = $("#series-active").is(":checked") ? 1 : 0;
            var meanScore          = $("#meanScore").val(); 
            var poster          = $("#avatar-source").val(); 
            var logo           = $("#logo-source").val(); 
            var cover           = $("#cover-source").val(); 
            var seo_title       = $("#seo_title").val(); 
            var seo_desc        = $("#seo_desc").val(); 
            var noindex         = $("#noindex").is(":checked") ? 1 : 0;
            var is_season         = $("#is_season").is(":checked") ? 1 : 0;
            var created_at      = $("#created_at").val() ;
            var type            = $("#type").val() ;
            var format          = $("#format").val() ;
            var user_access     = $("#user-access").val();

            /*Extension*/
            var countdown       = $("#countdown:checked").val(); 
            var apk             = $("#apk:checked").val(); 
            var tags            = $("#tags").val(); 
            var tiers            = $("#tiers").val(); 

            var t = $(this);
            var html = t.html();
            t.html(loader);
            t.prop('disabled',true);
            $.ajax({
                type:"POST",
                url:origin+"/panel/anime/update",
                data:{
                  id,
                   /*Ex*/
                    countdown,
                    apk,
                    tags,
                   /*Ex*/
                    name          ,
                    original_name ,
                    en_title ,
                    alias         ,
                    air_date      ,
                    category_list ,
                    series_desc   ,
                    user_access   ,
                    fragman       ,
                    fragmanJson   ,
                    meanScore   ,
                    popular       ,
                    status        ,
                    vote_count    ,
                    year          ,
                    anilist_id    ,
                    mal_id    ,
                    country       ,
                    channel       ,
                    channels      ,
                    time          ,
                    seasons       ,
                    episode       ,
                    user_access         ,
                    crews         ,
                    cast          ,
                    tiers        ,
                    active        ,
                    poster        ,
                    cover         ,
                    logo          ,
                    seo_title     ,
                    seo_desc      ,
                    noindex       ,
                    created_at    ,
                    type          ,
                    is_season          ,
                    format        ,
                },
                dataType:'json',
                success:function(result){
                  if(result.success){
                    getNotif("success",result.success);
                  }else {
                    getNotif("error",result.error);
                  }
                },
                error:function(e){
                    console.log(e)
                },
                complete:function(){
                     t.html(html);
                    t.prop('disabled',false);
                }
            });
          }
        });
    }
    var AnimeAddVideo = function(){
      var videosList = [];
      $(document).on("click","[data-movies-action]",function(){
        var videos = $("#videos-obj").val() ? JSON.parse($("#videos-obj").val()) : [];
        var type  = $(this).data("movies-action");
        var id    = $(this).data("video-id");
        var parent = $(this).closest("tr");
        if(type == 'VIDEO_DELETE'){
          var check = Object.keys(videos).filter(key => videos[key]["video_id"] === id)[0];
          if(check != undefined){
            delete videos[check];
            videos = videos.filter(Boolean);
            $("#videos-obj").val(JSON.stringify(videos));
            parent.remove()
          }

        }
      });
      $(document).on("click","#add-video-animes",function(){
        var validator   = $( ".video-add-form" ).validate();
        if(validator.form()){
          var video_service   = $("#video_service").val();
          var video_group     = $("#video-group").val();
          var video_link      = $("#video-link").val();
          var video_sort      = $("#video-sort").val();
          var video_download  = $("#video-download").val();
          var video_id        = Math.floor(Math.random() * 9999  + 1);

          var obj = {
            video_service,
            video_group,
            video_link,
            video_sort,
            video_download,
            video_id
          }
          videosList.push(obj);
          var videos_count = parseInt($("#videos-count").html());

          $("#videos-count").html(videos_count += 1);
          $("#add-video-modal").modal('hide');
          var theme = `
            <tr>
                <td>${video_service}</td>
                <td>${video_group}</td>
                <td><a href="${video_link}">Video Link</a></td>
                <td class="text-center">
                   <button type="button" class="btn btn-danger" data-movies-action="VIDEO_DELETE" data-video-id="${video_id}"><i class="icon-trash mr-2"></i> Sil</button>
                </td>
             </tr>
          `;
          $("#video-list-table").append(theme);
          $("#videos-obj").val(JSON.stringify(videosList));
        }
      });
      $(document).on("click","#add-anime-video",function(){
        var id       = $("#video-add-episode").val();
        var anime_id       = $(this).data("anime-id");
        var alias           = $("#movies-alias").val();
        var video_service   = $("#video_service").val();
        var video_group     = $("#video-group").val();
        var video_link      = $("#video-link").val();
        var video_cover     = $("#video-cover").val();
        var video_sort      = $("#video-sort").val();
        var video_tiers      = $("#video_tiers").val();
        var video_download  = $("#video-download").val();
        var validator       = $( "#add-video-modal .video-add-form" ).validate();
        if(validator.form()){
          $.ajax({
            type:"POST",
            url:origin+"/panel/animes/video/add",
            data:{
              id,
              anime_id,
              alias,
              video_service,
              video_group,
              video_link,
              video_cover,
              video_sort,
              video_tiers,
              video_download,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }else {
          getNotif('error','Lütfen gerekli alanları doldurunuz.');
        }
      });
    }
   
    var videoAdd = function(){
      $('#add-video-modal').on('shown.bs.modal', function (e) {
        $('#episodes-list').modal('hide')
      });
      $('#add-video-modal').on('hidden.bs.modal', function (e) {
        $('#episodes-list').modal('show')
      });

      $('#clone-episode-modal').on('shown.bs.modal', function (e) {
        $('#episodes-list').modal('hide')
      });
      $('#clone-episode-modal').on('hidden.bs.modal', function (e) {
        $('#episodes-list').modal('show')
      });
      $(document).on("click","[data-episode-action]",function(){
        var episode_id  = $(this).data("episode-id");
        var action      = $(this).data("episode-action");
        $("#add-episode-video").attr("data-set-id",episode_id);
        var key         = $(window.seasons).getObjectInValue('episodes',"id",episode_id,true);
        var parent      = $(this).closest('tr');
        $("#add-video").attr("data-episode-id",episode_id);
        $("#add-anime-video").attr("data-id",episode_id);
        if(action == 'VIDEO_ADD'){
          $("#add-video-modal").modal('show');
          var newVideoList  = []
          if(typeof key != "undefined" ){
            var seasonId      = window.seasons[key.parentIndex].id
            var seasonNumber  = window.seasons[key.parentIndex].season_number
            var episodeId     = window.seasons[key.parentIndex].episodes[key.childIndex].id
            var episodeNumber = window.seasons[key.parentIndex].episodes[key.childIndex].episode_number
            $("#video-add-episode").val(episodeNumber);
            $("#video-add-season").val(seasonNumber);
            
          }
        }else if(action == 'BOT_VIDEO_ADD'){

        }else if(action == 'QUICK_VIDEO_ADD'){
          
        }else if(action == 'CLONE_EPISODE'){
           $("#clone-episode-modal").modal('show');
          $("#clone-episode-modal").attr("data-id",episode_id);

        }else if(action == 'EPISODE_VIDEO_ADD'){
          $("#add-video-modal").modal('show');
          var season      = $(this).data("season");
          var episode     = $(this).data("episode");
          var episode_id  = $(this).data("episode-id");
          var season_id   = $(this).data("season-id");
          $("#video-add-season").val(season_id).change();
          setTimeout(function(){
            $("#video-add-episode").val(episode_id).change();
          },300);
          
        }else if(action == 'EPISODE_MOVE'){
          $("#move-episode-modal").modal('show');

          SearchSelect("#move-episode-modal")
          var season      = $(this).data("season");
          var episode     = $(this).data("episode");
          var episode_id  = $(this).data("episode-id");
          var season_id   = $(this).data("season-id");
          $("#move-episode-id").val(episode_id)
          $("#movie-episode-number").val(episode)
         
          
        }else if(action == 'VIDEO_DELETE'){
          var episode_id  = $(this).data("episode-id");
          var video_id    = $(this).data("video-id");
          var key         = $(window.seasons).getObjectInValue('episodes',"id",episode_id,true);

          var obj = window.seasons;
          var videos = obj[key.parentIndex]["episodes"][key.childIndex];
          var videoKey = $(videos).getObjectInValue('videos',"video_id",video_id);
          delete obj[key.parentIndex]["episodes"][key.childIndex]["videos"][videoKey];
          var videosFilter = obj[key.parentIndex]["episodes"][key.childIndex]["videos"].filter(Boolean);
          window.seasons[key.parentIndex]["episodes"][key.childIndex]["videos"] = videosFilter
          $("#season-obj").val(JSON.stringify(window.seasons))
          console.log(videoKey)
          parent.remove();
          var videos_count = parseInt($("#videos-count").html());
          $("#videos-count").html(videos_count - 1);
          
        }else if(action == 'EPISODE_DELETE'){
          var obj = window.seasons;
          delete obj[key.parentIndex]["episodes"][key.childIndex]
          parent.remove();
          obj = window.seasons[key.parentIndex].episodes.filter(Boolean)
          window.seasons[key.parentIndex].episodes = obj;
          $("#season-obj").val(JSON.stringify(window.seasons))
        }
      });
      $(document).on("click","#add-episode-video",function(){
        var video_service   = $("#video_service").val();
        var alias           = $("#series-alias").val();
        var video_group     = $("#video-group").val();
        var video_link      = $("#video-link").val();
        var video_cover     = $("#video-cover").val();
        var video_sort      = $("#video-sort").val();
        var video_download  = $("#video-download").val();
        var video_tiers  = $("#video_tiers").val();
        var validator     = $( ".video-add-form" ).validate();
        var episode_id     = $(".video-episode-list").val() // $(this).data("set-id");
        if(validator.form()){
          $.ajax({
            type:"POST",
            url:origin+"/panel/episode/video/add",
            data:{
              episode_id,
              alias,
              video_service,
              video_group,
              video_tiers,
              video_link,
              video_cover,
              video_sort,
              video_download,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
                $("#video-add-form").trigger('reset');
                $("#videoStatus-"+episode_id).removeClass("badge-danger").addClass("badge-success").text("Videosu var")
                // $("#add-video-modal").modal('hide');
                $("#video-group").val(null).change();
                $("#video_service").val(null).change();
                $("#video_tiers").val(null).change();
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }else {
          getNotif('error','Lütfen gerekli alanları doldurunuz.');
        }
      });
      $(document).on("click","#add-video",function(){
        var episode_id    = $(this).attr("data-episode-id");
        var parent        = $("#episodes-list").find("[data-episode-id="+episode_id+"]").closest("tr");
        var key           = $(window.seasons).getObjectInValue('episodes',"id",episode_id,true);
        var seasonNumber  = window.seasons[key.parentIndex].season_number
        var episodeNumber = window.seasons[key.parentIndex].episodes[key.childIndex].episode_number

        var video_data  = $("#video-add-form").serialize();
        var validator   = $( ".video-add-form" ).validate();
        if(validator.form()){
          var video_service = $("#video_service").val();
          var video_group   = $("#video-group").val();
          var video_link    = $("#video-link").val();
          var video_sort    = $("#video-sort").val();
          var video_download = $("#video-download").val();
          var video_id      = Math.floor(Math.random() * 9999  + 1);

          var obj = {
            video_service,
            video_group,
            video_link,
            video_sort,
            video_download,
            video_id
          }
          var videosObj = window.seasons[key.parentIndex].episodes[key.childIndex].videos;
          if(typeof videosObj != "undefined"){
            videosObj = window.seasons[key.parentIndex].episodes[key.childIndex].videos;
            videosObj.push(obj);
          }else {
            videosObj = window.seasons[key.parentIndex].episodes[key.childIndex].videos = [];
            videosObj.push(obj);
          }

          $("#season-obj").val(JSON.stringify(window.seasons));
          var videos_count = parseInt($("#videos-count").html());

          $("#videos-count").html(videos_count += 1);
          $("#add-video-modal").modal('hide');

          parent.find(".badge").removeClass("badge-danger").addClass("badge-success").html("Videosu var");
          var theme = `
            <tr>
                <td>${seasonNumber}. Sezon - ${episodeNumber}. Bölüm</td>
                <td>${video_service}</td>
                <td>${video_group}</td>
                <td><a href="${video_link}">Video Link</a></td>
                <td class="text-center">
                   <button type="button" class="btn btn-danger" data-episode-action="VIDEO_DELETE" data-episode-id="${episode_id}" data-video-id="${video_id}"><i class="icon-trash mr-2"></i> Sil</button>
                </td>
             </tr>
          `;
          $("#video-list-table").append(theme);
        }
      });
    }
    var addCast = function(){
       $(".select-cast").select2({
          tags: [],
          ajax: {
              url:origin+"/panel/cast/search",
              dataType: 'json',
              type: "GET",
              data: function (term) {
                  return {
                      search: term.term
                  };
              },
               processResults: function (data) {
                  return {
                      results: $.map(data, function (item) {
                          return {
                              text: item.name,
                              slug: item.link,
                              id: item.link
                          }
                      })
                  };
              }
          }
      });
      $(document).on("click","#add-cast",function(){
        var series_id       = $(this).data("id");
        var movies_id       = $(this).data("movies");
        var animes_id       = $(this).data("animes");
        var adult_id       = $(this).data("adult");
        var cast_json       = $("#cast-obj").val() ? JSON.parse($("#cast-obj").val()) : [];
        var alias           = $("#series-alias").val();
        var obj             = {};
        var id              = Math.floor( Math.random() * 90000000);
        var gender          = $("#cast-gender").val();
        var character_name  = $("#character-name").val();
        var cast_name       = $("#cast-name").val();
        var cast_id         = $("#cast-id").val();
        var check           = $(cast_json).getObjectValue("character",character_name,false);
        var reader          = new FileReader();
        
        if(series_id){ // Edit Page
          var validator = $( "#cast-add-form" ).validate();
          if(validator.form()){
            $.ajax({
              type:"POST",
              url:origin+"/panel/series/cast/add",
              data:{
                alias,
                series_id,
                character_name,
                cast_id,
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                  var theme = result.theme
                  $("#cast-list").append(theme)
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
              }
            });
          }
        }else if(movies_id){
          var validator = $( "#cast-add-form" ).validate();
          if(validator.form()){
            $.ajax({
              type:"POST",
              url:origin+"/panel/movies/cast/add",
              data:{
                movies_id,
                character_name,
                cast_id,
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                  var theme = result.theme
                  $("#cast-list").append(theme)
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
              }
            });
          }
        }else if(adult_id){
          var validator = $( "#cast-add-form" ).validate();
          if(validator.form()){
            $.ajax({
              type:"POST",
              url:origin+"/panel/adult/cast/add",
              data:{
                adult_id,
                character_name,
                cast_id,
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                  var theme = result.theme
                  $("#cast-list").append(theme)
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
              }
            });
          }
        }else if(animes_id){
          var validator = $( "#cast-add-form" ).validate();
          if(validator.form()){
            $.ajax({
              type:"POST",
              url:origin+"/panel/animes/cast/add",
              data:{
                animes_id,
                character_name,
                cast_id,
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                  var theme = result.theme
                  $("#cast-list").append(theme)
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
              }
            });
          }
        }else {
            var obj = {
              adult:false,
              character:character_name,
              credit_id:"",
              gender:gender,
              id:id,
              known_for_department:"Acting",
              name:cast_name,
              order:0,
              original_name:character_name,
              popularity:1,
            }
            var images = $("#cast-poster")[0].files[0];
            var reader = new FileReader();

            reader.onload = function (e) {
                var base64Image = reader.result;
                $("#cast-"+id).find("img").attr('src', base64Image);

                obj.poster = base64Image;  

                if(!check) {
                    cast_json.push(obj);
                    var theme = `
                        <li id="cast-${id}">
                            <a href="javascript:;" class="media">
                                <div class="mr-3">
                                    <img src="${base64Image}" class="" data-id="${id}" width="55" height="68" alt="">
                                </div>
                                <div class="media-body">
                                    <div class="media-title font-weight-semibold">${cast_name}</div>
                                    <span class="text-muted font-size-sm">${character_name}</span>
                                </div>
                                <div class="align-self-center ml-3">
                                    <span class="badge badge-mark bg-success border-success"></span>
                                </div>
                            </a>
                        </li>
                    `;
                    $("#cast-list").append(theme);
                    $("#cast-obj").val(JSON.stringify(cast_json));
                }
            };

            if (images) {
                reader.readAsDataURL(images);
            }

        }
      });
    }
    var subtitleAdd = function(){
      $('#add-subtitle-modal').on('shown.bs.modal', function (e) {
        $('#videos-list').modal('hide')
      });
      var content_id = 0;
      var type = "";
      $("[data-sub-id]").click(function(){
        content_id = $(this).data("sub-id");
        type = $(this).data("type");

      })
      $(document).on("click","#add-subtitle",function(){
        var link = $("#subtitle-link").val();
        var language = $("#sub_lang").val();
        var defaults = $("#sub-default").val() ? 1 :0;
        var file = $("#subtitle-file")[0].files[0];
        var formData = new FormData();
        formData.append('link',link);
        formData.append('language',language);
        formData.append('file',file);
        formData.append('type',type);
        formData.append('defaults',defaults);
        formData.append('content_id',content_id);
        $.ajax({
          type: "POST",
          url: "/panel/subtitle/add",
          data: formData,
          dataType:'JSON',
          contentType: false,
          processData: false,
          success: function(result) {
            if(result.success) {
              getNotif('success', result.message);
              $("#subtitle-add-form").trigger('reset')
            }else {
              getNotif('error', result.message);
            }
          },
          complete: function() {
          }
        });
      });
    }
    var addCrew = function(){
      $(document).on("click","#add-crew",function(){
        var crew_json       = $("#crew-json").val() ? JSON.parse($("#crew-json").val()) : [];
        var obj             = {};
        var id              = Math.floor( Math.random() * 200000);
        var gender          = $("#crew-gender").val();
        var department      = $("#crew-department").val();
        var crew_name       = $("#crew-name").val();
        var check           = $(crew_json).getObjectValue("name",crew_name,false);
        var images          = $("#crew-poster")[0].files[0];
        var reader          = new FileReader();
        var image;
        reader.addEventListener("load", function () {
          var image = reader.result;
          $("#crew-"+id).find("img").attr('src',image)
        }, false);
        if (images) {
          reader.readAsDataURL(images);
        }
        if(!check){
          var obj = {
            adult:false,
            credit_id:"",
            department,
            gender,
            id,
            job:"",
            known_for_department:"",
            name:crew_name,
            original_name:crew_name,
            popularity:1,
            profile_path:"",
          }
          crew_json.push(obj);
          var theme = `
            <li id="crew-${id}">
               <a href="javascript:;" class="media">
                  <div class="mr-3">
                     <img src="" class="" width="55" height="68" alt="">
                  </div>
                  <div class="media-body">
                     <div class="media-title font-weight-semibold">${crew_name}</div>
                     <span class="text-muted font-size-sm">${department}</span>
                  </div>
                  <div class="align-self-center ml-3">
                     <span class="badge badge-mark bg-success border-success"></span>
                  </div>
               </a>
            </li>
          `;
          $("#crew-list").append(theme)
          $("#crew-json").val(JSON.stringify(crew_json));
        }
      });
    }
    var seasonSetActive = function(){
      $(document).on("click",".season-active",function(){
        var value = $(this).is(":checked") ? 1 : 0;
        var id    = $(this).data("id");
        var type = $(this).data("type") == 2 ? 'anime' : 'series';
        if(id){
          $.ajax({
            type:"POST",
            url:origin+"/panel/"+type+"/season/active",
            data:{"active":value,id},
            dataType:'json',
            success:function(result){
              if(result.success){
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var setEpisodeMain = function(){
      $(document).on("click",".set-episode-main",function(){
        var value = $(this).is(":checked") ? 1 : 0;
        var id    = $(this).data("id");
        if(id){
          $.ajax({
            type:"POST",
            url:origin+"/panel/series/episode/main",
            data:{"active":value,id},
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
              }else {
                getNotif('error',result.message);

              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var setAnimeEpisodeMain = function(){
      $(document).on("click",".set-episode-anime-main",function(){
        var value = $(this).is(":checked") ? 1 : 0;
        var id    = $(this).data("id");
        if(id){
          $.ajax({
            type:"POST",
            url:origin+"/panel/anime/episode/main",
            data:{"active":value,id},
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
              }else {
                getNotif('error',result.message);

              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var getEpisode = function(){
      $(document).on("click","[data-get-episode]",function(){
        var id = $(this).data("get-episode");
        if(id){
          $.ajax({
            type:"POST",
            url:origin+"/panel/get/episode",
            data:{id},
            dataType:'json',
            success:function(result){
              if(result.success){
                $(".season-count").text(result.data.season_number);
                $(".episode-count").text(result.data.e_num);
                $(".episode-number").val(result.data.e_num);
                $(".episode-date").val(result.data.e_air_date);
                $(".episode-url").val(result.data.e_link);
                $(".episode-name").val(result.data.e_name);
                $(".episode-desc").val(result.data.e_overview);
                $(".episode-note").val(result.data.e_note);
                $(".episode-status").val(result.data.e_status).trigger('change');
                $(".episode-id").val(result.data.e_id);
                $(".episode-seo-title").val(result.data.seo_title);
                $(".episode-seo-desc").val(result.data.seo_desc);
                $(".episode-air-date").val(result.data.updated_at);
                var element = $('.episode_main');
                var element_apk = $('.episode_apk');
                var episode_active = $('.episode_active');
                changeSwitchery(element,parseInt(result.data.main) ? 1 : 0);
                changeSwitchery(element_apk,parseInt(result.data.apk) ? 1 : 0);
                changeSwitchery(episode_active,parseInt(result.data.active) ? 1 : 0);

                
                var dmca          = $('#episode-edit .dmca');
                var not_member    = $('#episode-edit .custom-not_member');
                var only_mobile   = $('#episode-edit .custom-only_mobile');
                var only_yandex   = $('#episode-edit .custom-only_yandex');
                var abroad        = $('#episode-edit .custom-abroad');
                var customAccess  = result.data.custom_access ? JSON.parse(result.data.custom_access) : null;

                changeSwitchery(element,parseInt(result.data.main) ? 1 : 0);
                changeSwitchery(element_apk,parseInt(result.data.apk) ? 1 : 0);
                changeSwitchery(episode_active,parseInt(result.data.active) ? 1 : 0);
                if(customAccess){
                  changeSwitchery(not_member,parseInt(customAccess.not_member) ? 1 : 0);
                  changeSwitchery(only_mobile,parseInt(customAccess.only_mobile) ? 1 : 0);
                  changeSwitchery(only_yandex,parseInt(customAccess.only_yandex) ? 1 : 0);
                  changeSwitchery(abroad,parseInt(customAccess.abroad) ? 1 : 0);
                  changeSwitchery(dmca,parseInt(customAccess.dmca) ? 1 : 0);
                }
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var editEpisode = function(){
      $(document).on("click","#series-episode-edit",function(){
          var id              = $(".episode-id").val();
          var date            = $(".episode-date").val();
          var link            = $(".episode-url").val();
          var name            = $(".episode-name").val();
          var overview        = $(".episode-desc").val();
          var note            = $(".episode-note").val();
          var number          = $(".episode-number").val();
          var seo_title       = $(".episode-seo-title").val();
          var seo_desc        = $(".episode-seo-desc").val();
          var updated_at      = $(".episode-air-date").val();
          var status      = $(".episode-status").val();
          var main            = $(".episode_main").is(":checked") ? 1 : 0;
          var episode_apk     = $(".episode_apk").is(":checked") ? 1 : 0;
          var episode_active  = $(".episode_active").is(":checked") ? 1 : 0;
          
          var not_member  = $("#episode-edit .custom-not_member").is(":checked") ? 1 : 0;
          var only_mobile  = $("#episode-edit .custom-only_mobile").is(":checked") ? 1 : 0;
          var only_yandex  = $("#episode-edit .custom-only_yandex").is(":checked") ? 1 : 0;
          var abroad  = $("#episode-edit .custom-abroad").is(":checked") ? 1 : 0;
          var dmca  = $("#episode-edit .dmca").is(":checked") ? 1 : 0;

          var custom_access = {
            not_member,
            only_mobile,
            only_yandex,
            abroad,
            dmca
          }
          var validator       = $( ".series-episode-edit-form" ).validate();
          if(validator.form()){
            $.ajax({
              type:"POST",
              url:origin+"/panel/episode/update",
              data:{
                id,
                date,
                link,
                name,
                overview,
                note,
                number,
                main,
                status,
                seo_title,
                seo_desc,
                episode_apk,
                updated_at,
                episode_active,
                custom_access
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
              }
            });
          }else {
            getNotif('error','Lütfen gerekli alanları doldurunuz.')
          }
      });
    }
    var getAnimeEpisode = function(){
      $(document).on("click","[data-get-anime-episode]",function(){
        var id = $(this).data("get-anime-episode");
        if(id){
          $.ajax({
            type:"POST",
            url:origin+"/panel/anime/get/episode",
            data:{id},
            dataType:'json',
            success:function(result){
              if(result.success){
                $(".season-count").text(1);
                $(".episode-count").text(result.data.episode);
                $(".episode-number").val(result.data.episode);
                $(".episode-date").val(result.data.air_date);
                $(".episode-url").val(result.data.slug);
                $(".episode-name").val(result.data.name);
                $(".episode-desc").val(result.data.overview);
                $(".episode-note").val(result.data.note);
                $(".episode-id").val(result.data.episode_id);
                $(".episode-air-date").val(result.data.updated_at);
                var element = $('.episode_main');
                var element_apk = $('.episode_apk');
                var episode_active = $('.episode_active');

                var dmca = $('.dmca');
                var not_member = $('.custom-not_member');
                var only_mobile = $('.custom-only_mobile');
                var only_yandex = $('.custom-only_yandex');
                var abroad = $('.custom-abroad');
                var customAccess = result.data.custom_access ? JSON.parse(result.data.custom_access) : null;

                changeSwitchery(element,parseInt(result.data.main) ? 1 : 0);
                changeSwitchery(element_apk,parseInt(result.data.apk) ? 1 : 0);
                changeSwitchery(episode_active,parseInt(result.data.active) ? 1 : 0);
                if(customAccess){
                  changeSwitchery(not_member,parseInt(customAccess.not_member) ? 1 : 0);
                  changeSwitchery(only_mobile,parseInt(customAccess.only_mobile) ? 1 : 0);
                  changeSwitchery(only_yandex,parseInt(customAccess.only_yandex) ? 1 : 0);
                  changeSwitchery(abroad,parseInt(customAccess.abroad) ? 1 : 0);
                  changeSwitchery(dmca,parseInt(customAccess.dmca) ? 1 : 0);
                }
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var editAnimeEpisode = function(){
      $(document).on("click","#anime-episode-edit",function(){
          var id              = $(".episode-id").val();
          var date            = $(".episode-date").val();
          var alias          = $("#anime-alias").val();
          var link            = $(".episode-url").val();
          var name            = $(".episode-name").val();
          var overview        = $(".episode-desc").val();
          var note            = $(".episode-note").val();
          var number          = $(".episode-number").val();
          var updated_at      = $(".episode-air-date").val();
          var main            = $(".episode_main").is(":checked") ? 1 : 0;
          var episode_apk     = $(".episode_apk").is(":checked") ? 1 : 0;
          var episode_active  = $(".episode_active").is(":checked") ? 1 : 0;
          var validator = $( ".series-episode-edit-form" ).validate();
          var not_member  = $(".custom-not_member").is(":checked") ? 1 : 0;
          var only_mobile  = $(".custom-only_mobile").is(":checked") ? 1 : 0;
          var only_yandex  = $(".custom-only_yandex").is(":checked") ? 1 : 0;
          var abroad  = $(".custom-abroad").is(":checked") ? 1 : 0;
          var dmca  = $(".dmca").is(":checked") ? 1 : 0;

          var custom_access = {
            not_member,
            only_mobile,
            only_yandex,
            abroad,
            dmca
          }
          if(validator.form()){
            $.ajax({
              type:"POST",
              url:origin+"/panel/anime/episode/update",
              data:{
                id,
                alias,
                date,
                link,
                name,
                overview,
                note,
                number,
                main,
                episode_apk,
                updated_at,
                episode_active,
                custom_access,
                
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
              }
            });
          }else {
            getNotif('error','Lütfen gerekli alanları doldurunuz.')
          }
      });
    }
    var addAnimeEpisode = function(){
      $(document).on("click","#anime-episode-add",function(){
          var id              = $(this).data("id");
          var name            = $("#episode-name").val();
          var season          = $("#episode_season").val();
          var number          = $("#episode-number").val();
          var series_name          = $("#series-name").val();
          var alias          = $("#anime-alias").val();
          var link            = $("#episode-link").val();
          var date            = $("#episode-airdate").val();
          var note            = $("#episode-note").val();
          var overview        = $("#episode-overview").val();
          var seo_title        = $("#episode-seo-title").val();
          var seo_desc        = $("#episode-seo-desc").val();
          var main            = $("#episode_main:checked").val();
          var day             = $("#episode_day").val();
          var multi_episode   = $("#multi_episode").is(":checked") ? 1 : 0;
          var episode_active  = $("#episode_active").is(":checked") ? 1 : 0;
          var episode_apk     = $("#episode_pk").is(":checked") ? 1 : 0;
          var validator = $( ".series-episode-add-form" ).validate();
          if(validator.form()){
            $.ajax({
              type:"POST",
              url:origin+"/panel/anime/episode/add",
              data:{
                id,
                alias,
                name,
                number,
                season,
                series_name,
                link,
                date,
                note,
                overview,
                main,
                seo_title,
                seo_desc,
                multi_episode,
                episode_active,
                day,
                episode_apk
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
              }
            });
          }else {
            getNotif('error','Lütfen gerekli alanları doldurunuz.')
          }
      });
    }  
    var addEpisode = function(){
      $(document).on("click","#series-episode-add",function(){
          var id              = $(this).data("id");
          var season          = $("#episode_season").val();
          var name            = $("#episode-name").val();
          var number          = $("#episode-number").val();
          var series          = $("#series-name").val();
           var seo_title        = $("#episode-seo-title").val();
          var seo_desc        = $("#episode-seo-desc").val();
          var link            = $("#episode-link").val();
          var date            = $("#episode-airdate").val();
          var note            = $("#episode-note").val();
          var status            = $("#episode-status").val();
          var overview        = $("#episode-overview").val();
          var main            = $("#episode_main:checked").val();
          var day     = $("#episode_day").val();
          var multi_episode   = $("#multi_episode").is(":checked") ? 1 : 0;
          var episode_active  = $("#episode_active").is(":checked") ? 1 : 0;
          var episode_apk     = $("#episode_pk").is(":checked") ? 1 : 0;
          var validator = $( ".series-episode-add-form" ).validate();

          var not_member  = $("#add-episode-modal .custom-not_member").is(":checked") ? 1 : 0;
          var only_mobile  = $("#add-episode-modal .custom-only_mobile").is(":checked") ? 1 : 0;
          var only_yandex  = $("#add-episode-modal .custom-only_yandex").is(":checked") ? 1 : 0;
          var abroad  = $("#add-episode-modal .custom-abroad").is(":checked") ? 1 : 0;
          var dmca  = $("#add-episode-modal .dmca").is(":checked") ? 1 : 0;

          var custom_access = {
            not_member,
            only_mobile,
            only_yandex,
            abroad,
            dmca
          }

          if(validator.form()){
            $.ajax({
              type:"POST",
              url:origin+"/panel/episode/add",
              data:{
                id,
                season,
                name,
                series,
                number,
                link,
                seo_title,
                seo_desc,
                custom_access,
                date,
                note,
                status,
                overview,
                main,
                multi_episode,
                episode_active,
                day,
                episode_apk
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
              }
            });
          }else {
            getNotif('error','Lütfen gerekli alanları doldurunuz.')
          }
      });
    }
    var addSeason = function(){
      $(document).on("click","#add-season",function(){
        var season = $("#season-number").val();
        console.log(season)
        var id = $(this).data("id");
        var type = $(this).data("type") == 2 ? 'animes' : 'series';
        if(season){
          $.ajax({
            type:"POST",
            url:origin+"/panel/"+type+"/season/add",
            data:{id,season},
            dataType:'json',
            success:function(result){
              if(result.success){
               getNotif('success',result.message);
              }else {
               getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }else {
          getNotif('error','Lütfen sezon giriniz.');
        }
      });
    }
    var dayNeed = function(){
      $(document).on("change","#multi_episode",function(){
        var value = $(this).is(":checked") ? 1 : 0;
        if(value){
          $(".episode-day-need").show();
        }else {
          $(".episode-day-need").hide();
        }
      })
    }
    var pagesTable = function(){
      var table = $("#pages-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [7] },
        ],
        ajax: {
          url: origin + "/panel/pages/list",
          type: "POST",
          data:{
            "type":getUrlParameter('type'),
            "content":getUrlParameter('content')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "title" },
          { data: "desc" },
          { data: "sort" },
          { data: "limit" },
          { data: "created_at" },
          { data: "main" },
          { data: "action" },
        ],
      });
    }
    var fragmanTable = function(){
      var table = $("#fragman-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [7] },
        ],
        ajax: {
          url: origin + "/panel/fragman/list",
          type: "POST",
          data:{
            "type":getUrlParameter('type'),
            "content":getUrlParameter('content')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "f_title" },
          { data: "sub_title" },
          { data: "f_video" },
          { data: "f_air_date" },
          { data: "type" },
          { data: "main" },
          { data: "action" },
        ],
      });
    }
    var siteTable = function(){
      var table = $("#site-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [4] },
        ],
        ajax: {
          url: origin + "/panel/site/list",
          type: "POST",
          data:{
            "type":getUrlParameter('type'),
            "content":getUrlParameter('content')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "title" },
          { data: "site_url" },
          { data: "status" },
          { data: "action" },
        ],
      });
    }
    var fragmanType = function(){
      $(document).on("change","#fragman_type",function(){
        var type = $(this).val();
        $(".fragman_content").removeAttr("id")
        $(".fragman_content").val(null).change()
        if(type == 1){
          $(".fragman_content").attr("id","search-series")
          searchSeries();
        }else if(type == 2){
          $(".fragman_content").attr("id","search-movies")
          searchMovies();
        }else {
         $(".fragman_content").attr("id","search-animes")
          searchAnimes();
        }
      })
    }
    var GoogleTable = function(){
      var table = $("#google-status-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [7] },
        ],
        ajax: {
          url: origin + "/panel/google/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "url" },
          { data: "status" },
          { data: "type" },
          { data: "created_at" },
          { data: "updated_at" },
          { data: "last_updated" },
          { data: "action" },

        ],
      });
    }
    var TagTable = function(){
      var table = $("#tags-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [5] },
        ],
        ajax: {
          url: origin + "/panel/tag/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "t_id" },
          { data: "t_title" },
          { data: "t_desc" },
          { data: "t_date" },
          { data: "t_active" },
          { data: "action" },
   
        ],
      });
    }
    var CategoryTable = function(){
      var table = $("#series-category-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [8] },
        ],
        ajax: {
          url: origin + "/panel/category/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "title_en" },
          { data: "alias_tr" },
          { data: "alias_en" },
          { data: "type" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
    }
    var LiveTV = function(){
      var table = $("#livetv-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [5] },
        ],
        ajax: {
          url: origin + "/panel/livetv/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "alias" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
    }
    var AvatarTable = function(){
      var table = $("#avatar-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [3] },
        ],
        ajax: {
          url: origin + "/panel/avatar/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "title" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
    }
    var CollectionTable = function(){
      var table = $("#collection-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [3] },
        ],
        ajax: {
          url: origin + "/panel/collection/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "title" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
    }
    var EpisodeGroupTable = function(){
      var table = $("#episode-group-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [5] },
        ],
        ajax: {
          url: origin + "/panel/episode-group/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "title" },
          { data: "type" },
          { data: "active" },
          { data: "action" },
   
        ],
      });
    }
    var CategoryUpdate = function(){
      $(document).on("click","[data-category-update]",function(){
        var type = $(this).data("category-update");
        var lang = $(this).data("lang");
        $.ajax({
          type:"POST",
          url:origin+"/panel/category/update",
          data:{type,lang},
          dataType:'json',
          success:function(result){
            if(result.success){
             getNotif('success',result.message);
            }else {
             getNotif('error',result.message);
            }
          },
          error:function(e){
              console.log(e)
          },
          complete:function(){
          }
        });
      });
    }
    var SetActive = function(){
      $(document).on("click","[data-set-active]",function(){
        var id      = $(this).data("set-active");
        var type    = $(this).data("type");
        var combine = $(this).data('combine')
        var checked = $(this).is(":checked") ? 1 : 0;
        if(id && type){
          $.ajax({
            type:"POST",
            url:origin+"/panel/"+type,
            data:{id,checked,combine},
            dataType:'json',
            success:function(result){
              if(result.success){
               getNotif('success',result.message);
              }else {
               getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var BoxsetTable = function(){
      var table = $("#boxset-movies-list").DataTable({
        processing: true,
        serverSide: true,
         "order": [[ 0, "desc" ]],
         columnDefs: [
          { orderable: false, targets: [4] },
        ],
        ajax: {
          url: origin + "/panel/movies/boxset/list",
          type: "POST",
          
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "title" },
          { data: "alias" },
          { data: "description" },
          { data: "action" },
   
        ],
      });
    }
    var MoviesTable = function(){
      var table = $("#movies-list").DataTable({
        processing: true,
        serverSide: true,
         "order": [[ 0, "desc" ]],
         columnDefs: [
          { orderable: false, targets: [7,8] },
        ],
        ajax: {
          url: origin + "/panel/movies/get",
          type: "POST",
          data:{
            "custom_access":getUrlParameter('access')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "movies_id" },
          { data: "image" },
          { data: "name" },
          { data: "original" },
          { data: "alias" },
          { data: "imdb_rate" },
          { data: "imdb_id" },
          { data: "cuff" },
          { data: "combine" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
    }
    var AdultTable = function(){
      var table = $("#adult-list").DataTable({
        processing: true,
        serverSide: true,
         "order": [[ 0, "desc" ]],
         columnDefs: [
          { orderable: false, targets: [6] },
        ],
        ajax: {
          url: origin + "/panel/adult/get",
          type: "POST",
          data:{
            "custom_access":getUrlParameter('access')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "alias" },
          { data: "video" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
    }
    var AdultAdd = function(){
        $(".create-adults").click(function(){
          var validator = $( ".series-form" ).validate();
          if(validator.form()){

            var name            = $("#movies-name").val();
            var movies_alias    = $("#movies-alias").val();
            var category_list   = $(".category-list").val();
            var movies_desc     = $("#movies-desc").val();
            var country         = $("#country").val();
            var time            = $("#time").val();
            var cast            = $("#cast-obj").val();
            var channels            = $("#channel").val();

            var active          = $("#movies-active").is(":checked") ? 1 : 0;
            var tags            = $(".tags").val();
            var poster          = $("#avatar").attr("src");
            var cover           = $("#avatar-cover").attr("src"); 
            var seo_title       = $("#seo_title").val(); 
            var seo_desc        = $("#seo_desc").val(); 
            var videos          = $("#videos").val() ;

            /*Extension*/
            var tags            = $("#tags").val(); 

            var t = $(this);
            var html = t.html();
            t.html(loader);
            t.prop('disabled',true);
            $.ajax({
                type:"POST",
                url:origin+"/panel/adult/create",
                data:{
                   /*Ex*/
                    tags,
                   /*Ex*/
                    name,
                    movies_alias,
                    category_list,
                    channels,
                    tags,
                    active,
                    movies_desc,
                    country,
                    time,
                    poster,
                    cover,
                    cast,
                    seo_title,
                    seo_desc,
                    videos
                },
                dataType:'json',
                success:function(result){
                  if(result.success){
                    getNotif("success",result.success);
                  }else {
                    getNotif("error",result.error);
                  }
                },
                error:function(e){
                    console.log(e)
                },
                complete:function(){
                     t.html(html);
                    t.prop('disabled',false);
                }
            });
          }
        });
    }
    var AdultAction = function(){

      $('.category-list').on('select2:unselect', function(event) {
          var id = event.params.data.id;
          var categories = JSON.parse($('#category-obj').val());
          var filteredCategories = categories.filter(function(category) {
              return category.id != id;
          });
          $('#category-obj').val(JSON.stringify(filteredCategories));
      });
      $("[data-adult-action]").click(function(){
         var type            = $(this).data('adult-action');
         var videoCategory            = $("#category").val();
         var page            = $("#adult-page").val();

         var category = [];

         var adultCategory = $('.category-list').select2('data')

            $.each(adultCategory,function(a,i){
               var obj = {
                  id: i.id,
                  name: i.text
               }
              category.push(obj)
            })
         var category =  $('#category-obj').val()
    

         var t = $(this);
         var html = t.html();
         t.html(loader);
         t.prop('disabled',true);
         $.ajax({
             type:"POST",
             url:origin+"/panel/adult/bot-action",
             data:{
                type,
                category,
                page,
                videoCategory
             },
             dataType:'json',
             success:function(result){
               if(type == 'getCategory'){
                  $("#category-obj").val(JSON.stringify(result.data))

                  $('.category-list').val("").trigger('change')
                  $.each(result.data, function(i,e){
                    var newOption = new Option(e.name + " | " + e.alias, e.id, true, true);
                    $('.category-list').append(newOption).trigger('change');
                  });
               }else if(type == 'getCategoriesVideo'){
                  var theme = "";
                  $.each(result.data, function(a,i ){
                      theme += `
                       <div class="col-md-2 ">
                        <div class="card flex-fill bg-light d-flex justify-content-between">
                           <div class="card-img-actions">
                              <img class="img-fluid" src="${i.image}" alt="">
                              <div class="card-img-actions-overlay">
                                 <a href="${i.link}" target="__blank" class="btn btn-outline-white border-width-2 ms-2">
                                    Detaya Git
                                 </a>
                              </div>
                           </div>

                           <div class="card-footer bg-transparent d-flex justify-content-between border-top-0 pb-0">
                              <span class="text-muted">${i.video_count}</span>

                              <ul class="list-inline list-inline-condensed mb-0">
                                 <li class="list-inline-item">
                                    <a href="#" class="text-muted">
                                       <i class="icon-watch2"></i>
                                           ${i.time}
                                    </a>
                                 </li>
                                 <li class="list-inline-item">
                                    <a href="#" class="text-muted">
                                       <i class="icon-cog"></i>
                                         ${i.quality}
                                    </a>
                                 </li>
                              </ul>
                           </div>

                           <div class="card-body">
                              <h6 class="mb-3">${i.title}</h6>
                           </div>
                        </div>
                     </div>`;

                  })
                     $("#video-list").html(theme)

               }


               if(result.success){
                 getNotif("success",result.message);
               }else {
                 getNotif("error",result.error);
               }
             },
             error:function(e){
                 console.log(e)
             },
             complete:function(){
                  t.html(html);
                 t.prop('disabled',false);
             }
         });
      });
      $(document).ready(function() {
          var totalPages = 100; // Set the total number of pages if known, or dynamically update this during runtime
         var videoCategory            = $("#category").val();

          $('#startAddingButton').click(function() {
             var currentPage = $("#adult-page").val();  // Start from the first page
             console.log(currentPage)
             var t = $(this);
               var html = t.html();
               t.html(loader);
              fetchAndAddVideos(currentPage);
          });

          function fetchAndAddVideos(page) {
               var currentPage = page
              $.ajax({
                  type:"POST",
                  dataType:'JSON',
                  url:origin+"/panel/adult/bot-action",
                  data: { page: page, type:'getCategoriesVideo',videoCategory },
                  success: function(videos) {

                      if (videos.data ) {

                             var theme = "";
                           $.each(videos.data, function(a,i ){
                               theme += `
                                <div class="col-md-2 ">
                                 <div class="card flex-fill bg-light d-flex justify-content-between">
                                    <div class="card-img-actions">
                                       <img class="img-fluid" src="${i.image}" alt="">
                                       <div class="card-img-actions-overlay">
                                          <a href="${i.link}" target="__blank" class="btn btn-outline-white border-width-2 ms-2">
                                             Detaya Git
                                          </a>
                                       </div>
                                    </div>

                                    <div class="card-footer bg-transparent d-flex justify-content-between border-top-0 pb-0">
                                       <span class="text-muted">${i.video_count}</span>

                                       <ul class="list-inline list-inline-condensed mb-0">
                                          <li class="list-inline-item">
                                             <a href="#" class="text-muted">
                                                <i class="icon-watch2"></i>
                                                    ${i.time}
                                             </a>
                                          </li>
                                          <li class="list-inline-item">
                                             <a href="#" class="text-muted">
                                                <i class="icon-cog"></i>
                                                  ${i.quality}
                                             </a>
                                          </li>
                                       </ul>
                                    </div>

                                    <div class="card-body">
                                       <h6 class="mb-3">${i.title}</h6>
                                    </div>
                                 </div>
                              </div>`;

                           })
                              $("#video-list").html(theme)
                        var id = [];
                        $.each(videos.data, function(a,i){
                           var o = {
                              id: i.id,
                              time: i.time
                           }
                           id.push(o);
                        })
                  
                           addVideos(id, function(success) {
                              if (success) {
                                  if (page < totalPages) {
                                      currentPage++;
                                      $("#adult-page").val(currentPage)
                                      fetchAndAddVideos(currentPage);
                                  } else {
                                    getNotif("success",'All pages have been processed!');
                                     $('#startAddingButton').html('Kaydet')
                                  }
                              } else {
                                  getNotif('error','Failed to add videos on page ' + currentPage);
                              }
                           });
                     } else {
                          getNotif('warning','No videos found on page ' + currentPage);
                     }
                  },
                  error: function() {
                      getNotif('error','Error fetching videos from page ' + currentPage);
                  }
              });
          }

          function addVideos(videos, callback) {
              $.ajax({
                  url:origin+"/panel/adult/bot-action",
                  type: 'POST',
                  dataType:'json',
                  data: { videos: videos, type: "saveVideo" },
                  success: function(response) {
                      callback(response.success);
                  },
                  error: function() {
                      callback(false);
                  }
              });
          }
      });

    }

    var MoviesAdd = function(){
        $(".create-movies").click(function(){
          var validator = $( ".series-form" ).validate();
          if(validator.form()){

            var name            = $("#movies-name").val();
            var original_name   = $("#original-name").val();
            var movies_alias    = $("#movies-alias").val();
            var movies_air_date = $(".movies-air-date").val();
            var category_list   = $(".category-list").val();
            var movies_desc     = $("#movies-desc").val();
            var user_access     = $("#user-access").val();
            var fragman         = $("#fragman").val();
            var fragmanJson         = $("#fragman-json").val();
            var status          = $("#status").val();
            var imdb_point      = $("#imdb-point").val();
            var imdb_id         = $("#imdb-id").val();
            var country         = $("#country").val();
            var budget          = $("#budget").val();
            var revenue         = $("#revenue").val();
            var time            = $("#time").val();
            var cast            = $("#cast-obj").val();
            var tmdbId          = $("#tmdbId").val();
            var active          = $("#movies-active").is(":checked") ? 1 : 0;
            var tags            = $(".tags").val();
            var poster          = $("#avatar").attr("src");
            var cover           = $("#avatar-cover").attr("src"); 
            var logo            = $("#logo").attr("src"); 
            var seo_title       = $("#seo_title").val(); 
            var seo_desc        = $("#seo_desc").val(); 
            var videos          = $("#videos-obj").val() ;
            var created_at          = $("#created_at").val() ;
            var noindex        = $("#noindex").is(":checked") ? 1 : 0;
            var vote_count        = $("#vote-count").val()
            var link        = $("#external_link").val()

            /*Extension*/
            var countdown       = $("#countdown:checked").val(); 
            var apk             = $("#apk:checked").val(); 
            var tags            = $("#tags").val(); 
            var collectmovies  = $("#collect-movies").val(); 
            var collectmoviesJson  = $("#collect-moviesJson").val(); 
            var tiers            = $("#tiers").val(); 

            var t = $(this);
            var html = t.html();
            t.html(loader);
            t.prop('disabled',true);
            $.ajax({
                type:"POST",
                url:origin+"/panel/movies/create",
                data:{
                   /*Ex*/
                    countdown,
                    apk,
                    tags,
                    collectmovies,
                    collectmoviesJson,
                   /*Ex*/
                    link,

                    name,
                    original_name,
                    movies_alias,
                    movies_air_date,
                    category_list,
                    tags,
                    active,
                    movies_desc,
                    user_access,
                    fragman,
                    fragmanJson,
                    status,
                    imdb_point,
                    imdb_id,
                    country,
                    budget,
                    revenue,
                    time,
                    tmdbId,
                    poster,
                    cover,
                    logo,
                    cast,
                    tiers,
                    seo_title,
                    seo_desc,
                    videos,
                    vote_count,
                    noindex,
                    created_at
                },
                dataType:'json',
                success:function(result){
                  if(result.success){
                    getNotif("success",result.success);
                  }else {
                    getNotif("error",result.error);
                  }
                },
                error:function(e){
                    console.log(e)
                },
                complete:function(){
                     t.html(html);
                    t.prop('disabled',false);
                }
            });
          }
        });
    }
    var MoviesEdit = function(){
        $(".edit-movies").click(function(){
          var validator = $( ".series-form" ).validate();
          if(validator.form()){

            var id              = $("#movies-id").val();
            var name            = $("#movies-name").val();
            var original_name   = $("#original-name").val();
            var movies_alias    = $("#movies-alias").val();
            var movies_air_date = $(".movies-air-date").val();
            var category_list   = $(".category-list").val();
            var movies_desc     = $("#movies-desc").val();
            var user_access     = $("#user-access").val();
            var fragman         = $("#fragman").val();
            var status          = $("#status").val();
            var imdb_point      = $("#imdb-point").val();
            var imdb_id         = $("#imdb-id").val();
            var country         = $("#country").val();
            var budget          = $("#budget").val();
            var revenue         = $("#revenue").val();
            var time            = $("#time").val();
            var cast            = $("#cast-obj").val();
            var tmdbId          = $("#tmdbId").val();
            var active          = $("#movies-active").is(":checked") ? 1 : 0;
            var tags            = $(".tags").val();
            var poster          = $("#avatar-source").val(); 
            var logo           = $("#logo-source").val(); 
            var cover           = $("#cover-source").val(); 
            var seo_title       = $("#seo_title").val(); 
            var seo_desc        = $("#seo_desc").val(); 
            var noindex        = $("#noindex").is(":checked") ? 1 : 0;
            var created_at          = $("#created_at").val() ;
            var link        = $("#external_link").val()
            
            /*Extension*/
            var countdown       = $("#countdown:checked").val(); 
            var apk             = $("#apk:checked").val(); 
            var tags            = $("#tags").val(); 
            var collectmovies  = $("#collect-movies").val(); 
            var tiers            = $("#tiers").val(); 

            var t = $(this);
            var html = t.html();
            t.html(loader);
            t.prop('disabled',true);
            $.ajax({
                type:"POST",
                url:origin+"/panel/movies/update",
                data:{
                   /*Ex*/
                    countdown,
                    apk,
                    tags,
                    collectmovies,
                   /*Ex*/
                    link,
                    id,
                    name,
                    original_name,
                    movies_alias,
                    movies_air_date,
                    category_list,
                    tags,
                    active,
                    movies_desc,
                    user_access,
                    fragman,
                    status,
                    imdb_point,
                    imdb_id,
                    country,
                    budget,
                    revenue,
                    time,
                    tmdbId,
                    poster,
                    logo,
                    cover,
                    tiers,
                    cast,
                    seo_title,
                    seo_desc,
                    noindex,
                    created_at
                },
                dataType:'json',
                success:function(result){
                  if(result.success){
                    getNotif("success",result.success);
                  }else {
                    getNotif("error",result.error);
                  }
                },
                error:function(e){
                    console.log(e)
                },
                complete:function(){
                     t.html(html);
                    t.prop('disabled',false);
                }
            });
          }
        });
    }
    var AdultEdit = function(){
        $(".edit-adult").click(function(){
          var validator = $( ".series-form" ).validate();
          if(validator.form()){

            var id              = $("#movies-id").val();
            var name            = $("#movies-name").val();
            var movies_alias    = $("#movies-alias").val();
            var category_list   = $(".category-list").val();
            var movies_desc     = $("#movies-desc").val();
            var country         = $("#country").val();
            var time            = $("#time").val();
            var channels            = $("#channel").val();
            var cast            = $("#cast-obj").val();
            var active          = $("#movies-active").is(":checked") ? 1 : 0;
            var tags            = $(".tags").val();
            var poster          = $("#avatar-source").val(); 
            var cover           = $("#cover-source").val(); 
            var seo_title       = $("#seo_title").val(); 
            var seo_desc        = $("#seo_desc").val(); 
            
            /*Extension*/
            var tags            = $("#tags").val(); 

            var t = $(this);
            var html = t.html();
            t.html(loader);
            t.prop('disabled',true);
            $.ajax({
                type:"POST",
                url:origin+"/panel/adult/update",
                data:{
                   /*Ex*/
                    tags,
                   /*Ex*/
                    id,
                    name,
                    movies_alias,
                    category_list,
                    tags,
                    active,
                    channels,
                    movies_desc,
                    country,
                    time,
                    poster,
                    cover,
                    cast,
                    seo_title,
                    seo_desc
                },
                dataType:'json',
                success:function(result){
                  if(result.success){
                    getNotif("success",result.success);
                  }else {
                    getNotif("error",result.error);
                  }
                },
                error:function(e){
                    console.log(e)
                },
                complete:function(){
                     t.html(html);
                    t.prop('disabled',false);
                }
            });
          }
        });
    }
    var MoviesAddVideo = function(){
      var videosList = [];
      $(document).on("click","[data-movies-action]",function(){
        var videos = $("#videos-obj").val() ? JSON.parse($("#videos-obj").val()) : [];
        var type  = $(this).data("movies-action");
        var id    = $(this).data("video-id");
        var parent = $(this).closest("tr");
        if(type == 'VIDEO_DELETE'){
          var check = Object.keys(videos).filter(key => videos[key]["video_id"] === id)[0];
          if(check != undefined){
            delete videos[check];
            videos = videos.filter(Boolean);
            $("#videos-obj").val(JSON.stringify(videos));
            parent.remove()
          }

        }
      });
      $(document).on("click","#add-video-movies",function(){
        var validator   = $( ".video-add-form" ).validate();
        if(validator.form()){
          var video_service   = $("#video_service").val();
          var video_group     = $("#video-group").val();
          var video_link      = $("#video-link").val();
          var video_sort      = $("#video-sort").val();
          var video_download  = $("#video-download").val();
          var video_id        = Math.floor(Math.random() * 9999  + 1);

          var obj = {
            video_service,
            video_group,
            video_link,
            video_sort,
            video_download,
            video_id
          }
          videosList.push(obj);
          var videos_count = parseInt($("#videos-count").html());

          $("#videos-count").html(videos_count += 1);
          $("#add-video-modal").modal('hide');
          var theme = `
            <tr>
                <td>${video_service}</td>
                <td>${video_group}</td>
                <td><a href="${video_link}">Video Link</a></td>
                <td class="text-center">
                   <button type="button" class="btn btn-danger" data-movies-action="VIDEO_DELETE" data-video-id="${video_id}"><i class="icon-trash mr-2"></i> Sil</button>
                </td>
             </tr>
          `;
          $("#video-list-table").append(theme);
          $("#videos-obj").val(JSON.stringify(videosList));
        }
      });
      $(document).on("click","#add-movie-video",function(){
        var movies_id       = $(this).data("id");
        var alias           = $("#movies-alias").val();
        var video_service   = $("#video_service").val();
        var video_group     = $("#video-group").val();
        var video_link      = $("#video-link").val();
        var video_cover     = $("#video-cover").val();
        var video_sort      = $("#video-sort").val();
        var video_tiers      = $("#video_tiers").val();
        var video_download  = $("#video-download").val();
        var validator       = $( ".video-add-form" ).validate();
        if(validator.form()){
          $.ajax({
            type:"POST",
            url:origin+"/panel/movies/video/add",
            data:{
              movies_id,
              alias,
              video_service,
              video_group,
              video_link,
              video_cover,
              video_sort,
              video_tiers,
              video_download,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }else {
          getNotif('error','Lütfen gerekli alanları doldurunuz.');
        }
      });
    }
    var VideoEdit = function(){
      var videoId = 0;
      var type = "";
      $(document).on("click","[data-edit-video]",function(){
        videoId = $(this).data("edit-video");
        type    = $(this).data("type");
        if(videoId){
          $('#videos-list').modal('hide')
          $.ajax({
            type:"POST",
            url:origin+"/panel/"+type+"/video/get",
            data:{
              videoId,
            },
            dataType:'json',
            success:function(result){
              if(result.success){

                getNotif('success',result.message);
                $("#edit_video_service").val(result.data.vs_id).change();
                $("#edit_video-group").val(result.data.vg_id).change();
                $("#edit_video-link").val(result.data.ev_link)
                $("#edit_video-cover").val(result.data.cover)
                $("#edit_video-sort").val(result.data.ev_sort)
                $("#edit_video-download").val(result.data.download)
                var tiers = result.data.tiers
                if(tiers){
                  tiers = JSON.parse(result.data.tiers)
                  $('#edit_video_tiers').val(tiers).trigger('change');
                }
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
      $(document).on("click","#edit-video",function(){
        var video_service   = $("#edit_video_service").val();
        var video_group     = $("#edit_video-group").val();
        var video_link      = $("#edit_video-link").val();
        var video_cover     = $("#edit_video-cover").val();
        var video_sort      = $("#edit_video-sort").val();
        var video_tiers     = $("#edit_video_tiers").val();
        var video_download  = $("#edit_video-download").val();
        var validator       = $( ".video-edit-form" ).validate();
        if(validator.form()){
          $.ajax({
            type:"POST",
            url:origin+"/panel/"+type+"/video/edit",
            data:{
              videoId,
              video_service,
              video_group,
              video_link,
              video_cover,
              video_sort,
              video_tiers,
              video_download,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }else {
          getNotif('error','Lütfen gerekli alanları doldurunuz.');
        }
      });
    }
    var WidgetTable = function(){
      var table = $("#widget-list").DataTable({
        processing: true,
        serverSide: true,
        ajax: {
          url: origin + "/panel/widget/list",
          type: "POST",
          data:{
            page:getUrlParameter('page')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "title" },
          { data: "page" },
          { data: "limit" },
          { data: "sort" },
          { data: "model" },
          { data: "theme" },
          { data: "condition" },
          { data: "status" },
          { data: "action" },
        ],
      });
      window.widgetTable = table;
    }
    var WidgetAdd = function(){
      $(document).on("click","#add-widget",function(){
        var name            = $("#name").val();
        var limit           = $("#limit").val();
        var page            = $("#pageList").val();
        var sort            = $("#sort").val();
        var template        = $("#template").val();
        var type            = $("#condition").val();
        var tags            = $("#tags").val();
        var active          = $("#active").is(":checked") ? 1 : 0;
        var main            = $("#main").is(":checked") ? 1 : 0;
        var content_type    = $("#content_type").val();
        if(type == 10){
          var condition_values = []
          var select_list = $("#condition_values").select2("data");
          $.each(select_list,function(a,i){
            var data = {
              name:i.text,
              id:i.id,
              type:i.type
            }
            condition_values.push(data)
          })
          var checkCountSeries = Object.keys(condition_values).filter(key => condition_values[key].type == 'series').length;
          var checkCountMovies = Object.keys(condition_values).filter(key => condition_values[key].type == 'movie').length;
          if(checkCountSeries != 3 && checkCountMovies != 3){
            getNotif('error','Lütfen 3 adet film 3 adet dizi seçiniz. Eksik veya fazla giremezsiniz.');
            return false;
          }
        }else {
          var condition_values= $("#condition_values").val();
        }

        var validator       = $( ".video-add-form" ).validate();
        if(validator.form()){
          $.ajax({
            type:"POST",
            url:origin+"/panel/widget/add",
            data:{
              name,
              page,
              limit,
              sort,
              template,
              type,
              tags,
              content_type,
              main,
              condition_values,
              active
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
                $('#condition').val(null).trigger('change');
                $('#pageList').val(null).trigger('change');
                $('#template').val(null).trigger('change');
                $('#condition_values').val(null).trigger('change');
                $('#content_type').val(null).trigger('change');
                 window.widgetTable.ajax.reload(null,false);
                 $( ".video-add-form" ).trigger('reset')
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }else {
          getNotif('error','Lütfen gerekli alanları doldurunuz.');
        }
      });
    }
    var CastTable = function(){
      var table = $("#cast-table-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [5] },
        ],
        ajax: {
          url: origin + "/panel/cast/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "alias" },
          { data: "gender" },
          { data: "action" },
   
        ],
      });
    }
    var BlogTable = function(){
      var table = $("#blog-table-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [4] },
        ],
        ajax: {
          url: origin + "/panel/blog/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "title" },
          { data: "alias" },
          { data: "desc" },
          { data: "action" },
   
        ],
      });
    }
    var Proxys = function(){
      var table = $("#proxy-table-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [5] },
        ],
        ajax: {
          url: origin + "/panel/proxy/list",
          type: "POST",
          data:{
            "search":getUrlParameter('search'),
            "v":getUrlParameter('v'),
            "v3":getUrlParameter('v3'),
            "v4":getUrlParameter('v4'),
            "v5":getUrlParameter('v5'),
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            var elems2 = Array.prototype.slice.call(document.querySelectorAll('.enabled'));
            elems2.forEach(function(html) {
             $(html).closest('tr').css('background','red');
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "_c" },
          { data: "id" },
          { data: "username" },
          { data: "password" },
          { data: "proxy_address" },
          { data: "port" },
          { data: "valid" },
          { data: "last_verification" },
          { data: "country_code" },
          { data: "city_name" },
          { data: "asn_name" },
          { data: "asn_number" },
          { data: "high_country_confidence" },
          { data: "created_at" },
   
        ],
        createdRow: function(row, data, dataIndex) {
            if (data.enabled === 1) { // Eğer "enabled" değeri 1 ise
                $(row).addClass('enabled-row'); // Satırı kırmızı yapacak sınıfı ekleyin
            }
        }
      });
    }
    var TierTable = function(){
      var table = $("#tier-table-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [4] },
        ],
        ajax: {
          url: origin + "/panel/tier/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "title" },
          { data: "description" },
          { data: "price" },
          { data: "action" },
   
        ],
      });
    }
    var RequestTable = function(){
      var table = $("#request-table-list").DataTable({
        columnDefs: [
          { orderable: false, targets: [8] },
        ],
        processing: true,
        serverSide: true,
        ajax: {
          url: origin + "/panel/request/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "vote" },
          { data: "type" },
          { data: "status" },
          { data: "user" },
          { data: "date" },
          { data: "action" },
   
        ],
      });
    }
    var ChannelTable = function(){
      var table = $("#channel-table-list").DataTable({
        "order": [[ 0, 'desc' ]],
        columnDefs: [
          { orderable: false, targets: [4] },
        ],
        processing: true,
        serverSide: true,
        ajax: {
          url: origin + "/panel/channel/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "alias" },
          { data: "action" },
        ],
      });
    }
    var CommentTable = function(){
      var table = $("#comment-table-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [6] },
        ],
        ajax: {
          url: origin + "/panel/comments/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "link" },
          { data: "comment" },
          { data: "content" },
          { data: "action" },
   
        ],
      });
      window.CommentTable = table;
    }
    var DiscussionTable = function(){
      var table = $("#discussion-table-list").DataTable({
        columnDefs: [
          { orderable: false, targets: [4] },
        ],
        processing: true,
        serverSide: true,
        ajax: {
          url: origin + "/panel/discussion/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "name" },
          { data: "title" },
          { data: "content" },
          { data: "action" },
   
        ],
      });
      window.CommentTable = table;
    }
    var DiscussionCategoryTable = function(){
      var table = $("#discussion-category-list").DataTable({
        columnDefs: [
          { orderable: false, targets: [4] },
        ],
        processing: true,
        serverSide: true,
        ajax: {
          url: origin + "/panel/discussion/category/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "alias" },
          { data: "status" },
          { data: "action" },
        ],
      });
    }
    var UsersTable = function(){
      var table = $("#users-table-list").DataTable({
        processing: true,
        serverSide: true,
        "order": [[ 0, 'desc' ]],
        columnDefs: [
          { orderable: false, targets: [5] },
        ],
        ajax: {
          url: origin + "/panel/users/list",
          type: "POST",
          data:{
            "type_id":getUrlParameter('type')
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "u_avatar" },
          { data: "u_name" },
          { data: "u_username" },
          { data: "u_email" },
          { data: "action" },
   
        ],
      });
    }
    var ActionTable = function(){
      var table = $("#action-table-list").DataTable({
        columnDefs: [
          { orderable: false, targets: [5] },
        ],
        processing: true,
        serverSide: true,
        ajax: {
          url: origin + "/panel/action/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "title" },
          { data: "sort" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
    }
    var BadgesTable = function(){
      var table = $("#badges-table-list").DataTable({
        processing: true,
        serverSide: true,
        "order": [[ 0, 'desc' ]],
        columnDefs: [
          { orderable: false, targets: [6] },
        ],
        ajax: {
          url: origin + "/panel/badges/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "title" },
          { data: "desc" },
          { data: "sort" },
          { data: "active" },
          { data: "action" },
   
        ],
      });
    }
    var ContactTable = function(){
      var table = $("#contact-table-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [6] },
        ],
        ajax: {
          url: origin + "/panel/contact/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "name" },
          { data: "email" },
          { data: "subject" },
          { data: "message" },
          { data: "created_at" },
          { data: "action" },
   
        ],
      });
      window.ContactTable = table;
    }
    var ReportTable = function(){
      var table = $("#report-table-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [7] },
        ],
        ajax: {
          url: origin + "/panel/reports/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "name" },
          { data: "content" },
          { data: "desc" },
          { data: "report" },
          { data: "category" },
          { data: "answered" },
          { data: "action" },
   
        ],
      });
      window.ReportTable = table;
    }
    var ReportCategoryTable = function(){
      var table = $("#report-category-table-list").DataTable({
        processing: true,
        serverSide: true,
        columnDefs: [
          { orderable: false, targets: [4] },
        ],
        ajax: {
          url: origin + "/panel/reports/category/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "title" },
          { data: "category" },
          { data: "sort" },
          { data: "action" },
   
        ],
      });
      window.ReportCategoryTable = table;
    }
    var ServicesTable = function(){
      var table = $("#services-table-list").DataTable({
        processing: true,
        columnDefs: [
          { orderable: false, targets: [4] },
        ],
        serverSide: true,
        ajax: {
          url: origin + "/panel/services/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "name" },
          { data: "sort" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
      window.ServicesTable = table;
    }
    var videoGroupTable = function(){
      var table = $("#vgroup-table-list").DataTable({

        columnDefs: [
          { orderable: false, targets: [5] },
        ],
        processing: true,
        serverSide: true,
        ajax: {
          url: origin + "/panel/vgroup/list",
          type: "POST",
          data:{
          },
          complete:function(){
            var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
            elems.forEach(function(html) {
                var switchery = new Switchery(html);
            });
            coreInit(table);
          }
        },
        columns: [
          { data: "id" },
          { data: "image" },
          { data: "name" },
          { data: "sort" },
          { data: "status" },
          { data: "action" },
   
        ],
      });
      window.VideoGroup = table;
    }
    var WidgetList = function(){
      $(document).on("change",".content_type",function(){
        var parent = $(this).closest('form');
        var type = $(this).val();
        if(type){
          $.ajax({
            type:"POST",
            url:origin+"/panel/widget/get/template",
            data:{
              type,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                $(parent).find(".template").html(result.theme)
                $(parent).find(".condition").html("")
                $(parent).find(".condition-values-container .form-group").html("")
              }else {
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var WidgetGetData = function(){
      $(document).on("click","[data-get-widget]",function(){
        var widget_id = $(this).data("get-widget");
        if(widget_id){
          $.ajax({
            type:"POST",
            url:origin+"/panel/widget/get/values",
            data:{
              widget_id,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                $("#edit-widget").attr('data-id',result.data.widgets_id);
                $("#edit-widget-modal select[name='page']").val(result.data.page).trigger('change');
                $("#edit-widget-modal input[name=sort]").val(result.data.sort);
                $("#edit-widget-modal input[name=limit]").val(result.data.limit);
                $("#edit-widget-modal input[name=name]").val(result.data.name);
                $("#edit-widget-modal select[name='content_type']").val(result.data.widget_types_id).trigger('change');
                setTimeout(function(){
                  $("#edit-widget-modal select[name='template']").val(result.data.widget_types_template_id).trigger('change');
                },500)
                setTimeout(function(){
                  $("#edit-widget-modal select[name='type']").val(result.data.type).trigger('change');
                },700)
                if(result.data.content_id){
                  console.log(1)
                  setTimeout(function(){
                    var data = {
                      id: result.data.content_id,
                      text: result.data.content_value
                    };
                    var newOption = new Option(data.text, data.id, true, false);
                    $("#edit-widget-modal select[name='condition_values']").append(newOption).trigger('change');
                  },950)
                }else if(result.data.items){
                  setTimeout(function(){
                    $.each(result.data.items,function(a,i){
                      var data = {
                        id: i.id,
                        text: i.name
                      };
                      var newOption = new Option(data.text, data.id, true, true);
                      $("#edit-widget-modal select[name='condition_values']").append(newOption).trigger('change');
                    });
                  },950)
                }
                
                $('.select-search').select2();
                $('#edit-widget-modal').modal('show')
              }else {
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var WidgetEdit = function(){
      $(document).on("click","#edit-widget",function(){
        var widget_id = $(this).data("id");
        var parent = $(this).closest('form');
        if(widget_id){
          var name            = $(parent).find("input[name='name']").val();
          var limit           = $(parent).find("input[name='limit']").val();
          var page            = $(parent).find("select[name='page']").val();

          var sort            = $(parent).find("input[name='sort']").val();
          var template        = $(parent).find(".template").val();
          var type            = $(parent).find(".condition").val();
          var tags            = $(parent).find("#tags").val();
          var active          = $(parent).find("#active").is(":checked") ? 1 : 0;
          var main            = $(parent).find("#main").is(":checked") ? 1 : 0;
          var content_type    = $(parent).find(".content_type").val();
          var condition_values= $(parent).find("#condition_values").val();
          var validator       = $( ".video-edit-form" ).validate();
          if(validator.form()){
            $.ajax({
              type:"POST",
              url:origin+"/panel/widget/edit",
              data:{
                widget_id,
                name,
                page,
                limit,
                sort,
                template,
                type,
                tags,
                content_type,
                main,
                condition_values,
                active
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                   window.widgetTable.ajax.reload(null,false);
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
              }
            });
          }else {
            getNotif('error','Lütfen gerekli alanları doldurunuz.');
          }
        }
      })
    }
    var WidgetConditionList = function(){
      $(document).on("change",".template",function(){
        var template_id = $(this).val();
        var parent = $(this).closest('form');
        if(template_id){
          $.ajax({
            type:"POST",
            url:origin+"/panel/widget/get/condition",
            data:{
              template_id,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                $(parent).find(".condition").html(result.theme)
              }else {
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var WidgetConditionValues = function(){
      $(document).on("change",".condition",function(){
        var parent = $(this).closest('form');
        var idClass = $(parent).closest('.modal').attr('id');
        console.log(idClass)
        var condition_id = $(this).val();
        if(condition_id){
          $.ajax({
            type:"POST",
            url:origin+"/panel/widget/get/condition/values",
            data:{
              condition_id,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                $(parent).find(".condition_values").remove()
                $(parent).find(".condition-values-container").html(result.theme);
                SearchSelect("#"+idClass);
              }else {
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var SearchSelect = function(id = ""){
      console.log(id)
      if(!id){
        id = "#add-widget-modal"
      }
      $(".search-multi").select2({
          dropdownParent: id,
          tags: [],
          ajax: {
              url: "/panel/widget/search/multi",
              dataType: 'json',
              type: "GET",
              data: function (term) {
                  return {
                      search: term.term
                  };
              },
               processResults: function (data) {
               
                  return {
                      results: $.map(data, function (item) {
                          return {
                              text: item.name,
                              type: item.type,
                              id: item.id
                          }
                      })
                  };
              }
          }
        });
      $(".search-wcs").each(function(a,i){
        var type = $(this).data("type");
        if(type){
          $(".search-wcs").select2({
            dropdownParent: id,
            tags: [],
            ajax: {
                url: "/panel/widget/search/"+type,
                dataType: 'json',
                type: "GET",
                data: function (term) {
                    return {
                        search: term.term
                    };
                },
                 processResults: function (data) {
                  console.log(data)
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                slug: item.link,
                                id: item.link
                            }
                        })
                    };
                }
            }
          });
        }
      })
    }
    var replyComment = function(){
      $(document).on("click","[data-reply-comment]",function(){
        var comment_id = $(this).data("reply-comment");
        $("#reply-comment").attr('data-id',comment_id);
      });
      $(document).on("click","#reply-comment",function(){
        var reply       = $("#reply").val();
        var comment_id  = $(this).attr("data-id");
        if(reply){
          $.ajax({
            type:"POST",
            url:origin+"/panel/comment/reply",
            data:{
              comment_id,
              reply,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
                $("#reply-modal").modal('hide')
                $("#reply").html('')
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var editComment = function(){
      var comment_id;
      $(document).on("click","[data-edit-comment]",function(){
        comment_id = $(this).data("edit-comment");
      });
      $(document).on("click","#edit-comment",function(){
        var comment = $("#reply-edit").val()
        if(comment_id && comment){
          $.ajax({
            type:"POST",
            url:origin+"/panel/comment/edit",
            data:{
              comment_id,
              comment,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
                window.CommentTable.ajax.reload(null,false);
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
      $("#edit-modal").on('shown.bs.modal', function () {
         $.ajax({
            type:"POST",
            url:origin+"/panel/comment/get",
            data:{
              comment_id,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                $("#reply-edit").val(result.item.comment);
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
      });

      
    }
    var replyReport = function(){
      $(document).on("click","[data-reply-report]",function(){
        var comment_id = $(this).data("reply-report");
        $("#reply-report").attr('data-id',comment_id);
      });
      $(document).on("click","#reply-report",function(){
        var reply       = $("#reply").val();
        var report_id  = $(this).attr("data-id");
        if(reply){
          $.ajax({
            type:"POST",
            url:origin+"/panel/reports/reply",
            data:{
              report_id,
              reply,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
                $("#reply-modal").modal('hide')
                $("#reply").html('');
                window.ReportTable.ajax.reload(null,false)
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var setMeta = function(){
      $(document).on('click','.set-meta',function(){
        var seo_title = $("#seo_title").val();
        var seo_desc  = $("#seo_desc").val();
        var seo_keyw  = $("#seo_keyw").val();
        var page      = $("#page").val();
        var alias     = $("#alias").val();
        var nofollow  = $("#nofollow").is(":checked") ? 1 : 0;
        var noindex   = $("#noindex").is(":checked") ? 1 : 0;
        var info      = $("#info").val();
        var schema    = $("#schema").val();
        if(seo_title){
          $.ajax({
            type:"POST",
            url:origin+"/panel/set/meta",
            data:{
              seo_title,
              seo_desc,
              seo_keyw,
              page,
              alias,
              nofollow,
              noindex,
              info,
              schema
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
      $(document).on("change","#page",function(){
        var value = $(this).val();
        var alias = $("#alias").val();
        if(value){
           $.ajax({
            type:"POST",
            url:origin+"/panel/get/meta",
            data:{
              value,
              alias,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                $("#seo_title").val(result.item.title);
                $("#seo_desc").val(result.item.description);
                $("#seo_keyw").val(result.item.keyw);
                // $("#page").val();ö
                $("#alias").val(result.item.router_name);
               
                changeSwitchery($("#noindex"),result.item.noindex ? 1 : 0)
                changeSwitchery($("#nofollow"),result.item.nofollow ? 1 : 0)
                $("#info").val(result.item.mask_info);
                $("#schema").val(result.item.snippets);
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var setApi = function(){
      $(document).on('click','.set-api',function(){
        var public    = $("#public").val();
        var private   = $("#private").val();
        var active    = $("#active").is(":checked") ? 1 : 0;
        var id        = $("#api_id").val();

        if(public && private && id){
          $.ajax({
            type:"POST",
            url:origin+"/panel/set/api",
            data:{
              public,
              private,
              active,
              id
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                getNotif('success',result.message);
              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var searchSeries = function(){
      $("#search-series").select2({
        dropdownParent: $('#bot-settings-modal').length ? $('#bot-settings-modal') : null,
        placeholder:"Diziler",
          tags: [],
          ajax: {
              url: "/panel/widget/search/series",
              dataType: 'json',
              type: "GET",
              data: function (term) {
                  return {
                      search: term.term
                  };
              },
               processResults: function (data) {
                  return {
                      results: $.map(data, function (item) {
                          return {
                              text: item.name,
                              slug: item.link,
                              id: item.link
                          }
                      })
                  };
              }
          }
        });
    }
    var searchMovies = function(){
      $("#search-movies").select2({
        dropdownParent: $('#bot-settings-modal').length ? $('#bot-settings-modal') : null,
        placeholder:"Filmler",
         
          tags: [],
          ajax: {
              url: "/panel/widget/search/movies",
              dataType: 'json',
              type: "GET",
              data: function (term) {
                  return {
                      search: term.term
                  };
              },
               processResults: function (data) {
                  return {
                      results: $.map(data, function (item) {
                          return {
                              text: item.name,
                              slug: item.link,
                              id: item.link
                          }
                      })
                  };
              }
          }
        });
    }
    var searchAnimes = function(){
      $("#search-animes").select2({
          tags: [],
        placeholder:"Animeler",

          ajax: {
              url: "/panel/widget/search/animes",
              dataType: 'json',
              type: "GET",
              data: function (term) {
                  return {
                      search: term.term
                  };
              },
               processResults: function (data) {
                  return {
                      results: $.map(data, function (item) {
                          return {
                              text: item.name,
                              slug: item.link,
                              id: item.link
                          }
                      })
                  };
              }
          }
        });
    }
    var badgeInputs = function(){
      $(document).on("change",".badge-type",function(){
        var id = $(this).val();
        if(id){
          $.ajax({
            type:"POST",
            url:origin+"/panel/badge/get/input",
            data:{
              id,
            },
            dataType:'json',
            success:function(result){
              if(result.success){
                $("#input-list").html("")
                $("#input-list").alpaca(result.data)
                setTimeout(function(){
                  $('.search-series select').select2();
                  $('.search-movie select').select2({});
                  $('input[name=start_end]').daterangepicker({ 
                    singleDatePicker: false,
                    timePicker: true,
                     locale: {
                        format: 'YYYY-MM-DD hh:mm',
                        "separator": " - ",
                        "applyLabel": "Uygula",
                        "cancelLabel": "Vazgeç",
                        "fromLabel": "Dan",
                        "toLabel": "a",
                        "customRangeLabel": "Seç",
                        "daysOfWeek": [
                            "Pt",
                            "Sl",
                            "Çr",
                            "Pr",
                            "Cm",
                            "Ct",
                            "Pz"
                        ],
                        "monthNames": [
                            "Ocak",
                            "Şubat",
                            "Mart",
                            "Nisan",
                            "Mayıs",
                            "Haziran",
                            "Temmuz",
                            "Ağustos",
                            "Eylül",
                            "Ekim",
                            "Kasım",
                            "Aralık"
                        ],
                        "firstDay": 1
                    },

                });
                },100)

              }else {
                getNotif('error',result.message);
              }
            },
            error:function(e){
                console.log(e)
            },
            complete:function(){
            }
          });
        }
      });
    }
    var badgeSet = function(){
      $(document).on("click",".set-badges",function(){
        var title   = $("#badge-form input[name=title]").val();
        var exp     = $("#badge-form input[name=exp]").val();
        var sort    = $("#badge-form input[name=sort]").val();
        var type    = $("#badge-form select[name=type]").val();
        var desc    = $("#badge-form textarea[name=desc]").val();
        var task    = $("#badge-form select[name=task]").is(":checked") ? 1 : 0;
        var active  = $("#badge-form input[name=active]").is(":checked") ? 1 : 0;
        var image   = $(".custom-file-input")[0].files[0];
        if(title && type && exp && $(".alpaca-invalid").length <= 0){
          var values = $('#input-list').alpaca().getValue();
          var data    = new FormData();
          data.append('file',image);
          data.append('title',title);
          data.append('exp',exp);
          data.append('sort',sort);
          data.append('type',type);
          data.append('desc',desc);
          data.append('task',task);
          data.append('active',active);
          data.append('values',JSON.stringify(values));
          $.ajax({
            type: "POST",
            url: "/panel/badge/set",
            data: data,
            dataType:'JSON',
            contentType: false,
            processData: false,
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      });
    }
     var translatorUpdate = function(){
      $(document).on("click",".translator-update",function(){
        var desc   = $("#translator-desc").val();
        var users     = $("#translator-users").val();
        var vg_id     = $("#vg_id").val();
        var image    = $("#translator-image")[0].files[0];
        var facebook = $(".translator-social-facebook").val()
        var twitter  = $(".translator-social-twitter").val()
        var discord  = $(".translator-social-discord").val()
        var website  = $(".translator-social-website").val()

        var social = {
          facebook,
          twitter,
          discord,
          website
        }
        if(vg_id ){
          var data    = new FormData();
          data.append('file',image);
          data.append('desc',desc);
          data.append('users',users);
          data.append('social',JSON.stringify(social));
          data.append('vg_id',vg_id);
          $.ajax({
            type: "POST",
            url: "/panel/translator/update",
            data: data,
            dataType:'JSON',
            contentType: false,
            processData: false,
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      });
    }
    var badgeUpdate = function(){
      var id = $("[data-type-id]").data("type-id");
      var datas = $("[data-values]").data("values");
      if(id){
        $("#badge-form select[name=type]").val(id).change();
        setTimeout(function(){
          $.each(datas,function(a,i){
            var type = $(`input[name=${a}]`).attr('type');
            if(type == 'radio' || type == 'checkbox'){
              $(`input[name=${a}]`).each(function(b,c){
                var val = $(this).val();
                if(val == i){
                  $(this).prop('checked',true)
                }
              })
              
            }else {
              $(`input[name=${a}]`).val(i).change();
            }
          });
        },200)
      }
      $(document).on("click",".edit-badges",function(){
        var title   = $("#badge-form input[name=title]").val();
        var exp     = $("#badge-form input[name=exp]").val();
        var sort    = $("#badge-form input[name=sort]").val();
        var type    = $("#badge-form select[name=type]").val();
        var task    = $("#task").is(":checked") ? 1 : 0;
        var desc    = $("#badge-form textarea[name=desc]").val();
        var active  = $("#badge-form input[name=active]").is(":checked") ? 1 : 0;
        var badge_id  = $("#badge-form input[name=badge_id]").val();
        var image   = $(".custom-file-input")[0].files[0];
        if(title && type && exp && $(".alpaca-invalid").length <= 0){
          var values = $('#input-list').alpaca().getValue();
          var data    = new FormData();
          data.append('id',badge_id);
          data.append('file',image);
          data.append('title',title);
          data.append('exp',exp);
          data.append('sort',sort);
          data.append('type',type);
          data.append('task',task);
          data.append('desc',desc);
          data.append('active',active);
          data.append('values',JSON.stringify(values));
          $.ajax({
            type: "POST",
            url: "/panel/badge/update",
            data: data,
            dataType:'JSON',
            contentType: false,
            processData: false,
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      });
    }
    var footerAnchor = function(){
      $(document).on("click",".add-footer-group",function(){
        var lastItem = $(".group-footer:last");
        var count = $(".group-footer").length ;

        var theme = `
          <div class="group-footer">
            <div class="form-group row">
              <div class="col-lg-12">
                <div class="input-group">
                  <input type="text" name="footer[]" class="footer-anch-title form-control" placeholder="Footer Başlık Adı">
                  <div class="input-group-append position-static">
                          <button type="button" class="btn btn-light footer-anc-add btn-icon" ><i class="icon-plus22"></i></button>
                        </div>
                </div>
              </div>
            </div>
            <div class="form-group row anchor-item">
              <div class="col-lg-5">
                  <input type="text" name="anchor[${count}][name][]" class="form-control" placeholder="Bağlantı Adı">
              </div>
              <div class="col-lg-5">
                <input type="text" name="anchor[${count}][link][]" class="form-control" placeholder="Bağlantı Link">
              </div>
              <div class="col-lg-1">
                <button type="button" class="btn btn-danger remove-anchor-item btn-icon"><i class="icon-trash"></i></button>
              </div>
            </div>
          </div>
        `;
        $(theme).insertAfter(lastItem);
      });
        $(document).on("click",".remove-anchor-item",function(){
        $(this).closest(".anchor-item").remove()
      });
      $(document).on("click",".footer-anc-add",function(){
        var count = $(this).closest(".group-footer").index();
        var lastItem = $(this).closest(".group-footer").find(".anchor-item:last");
        var theme = `
          <div class="form-group row anchor-item">
            <div class="col-lg-5">
                <input type="text" name="anchor[${count}][name][]" class="form-control" placeholder="Bağlantı Adı">
            </div>
            <div class="col-lg-5">
              <input type="text" name="anchor[${count}][link][]" class="form-control" placeholder="Bağlantı Link">
            </div>
            <div class="col-lg-1">
              <button type="button" class="btn btn-danger remove-anchor-item btn-icon"><i class="icon-trash"></i></button>
            </div>
          </div>
        `;
        $(theme).insertAfter(lastItem);
      });
      $(document).on("click",".front-video-add",function(){
        var count = $(this).closest(".group-footer").index();
        var lastItem = $(this).closest(".group-footer").find(".anchor-item:last");
        var theme = `
          <div class="form-group row anchor-item">
            <div class="col-lg-3">
                <input type="text" name="body[link][]" class="form-control" placeholder="Reklam Link">
            </div>
            <div class="col-lg-3">
                      <input type="text" name="body[image][]" class="form-control" placeholder="Reklam Görsel">
                  </div>
            <div class="col-lg-4">
                      <input type="text" name="body[video][]" class="form-control" placeholder="Reklam Video">
                  </div>
            <div class="col-lg-1">
              <input type="text" name="body[time][]" class="form-control" placeholder="Süre">
            </div>
            <div class="col-lg-1">
              <button type="button" class="btn btn-danger remove-anchor-item btn-icon"><i class="icon-trash"></i></button>
            </div>
          </div>
        `;
        $(theme).insertAfter(lastItem);
      });
      $(document).on("click",".footer-anc-add-redirect",function(){
        var redirect = $(this).data("redirect");
        var count = $(".anchor-item").length + 1 - 1
        var title = "Eski URL"
        var title2 = "Yeni URL"
      
        var lastItem = $(this).closest(".group-footer").find(".anchor-item:last");
        var theme = `
          <div class="form-group row anchor-item">
            <div class="col-lg-5">
                <input type="text" name="anchor[${count}][old]" class="form-control" placeholder="${title}">
            </div>
            <div class="col-lg-5">
              <input type="text" name="anchor[${count}][new]" class="form-control" placeholder="${title2}">
            </div>
            <div class="col-lg-1">
              <button type="button" class="btn btn-danger remove-anchor-item btn-icon"><i class="icon-trash"></i></button>
            </div>
          </div>
        `;
        $(theme).insertAfter(lastItem);
      });
      $(document).on("click",".save-footers",function(){
        var data = $("#footer-form").serialize();
        if(data){
          $.ajax({
            type: "POST",
            url: "/panel/footer/set",
            data: data,
            dataType:'JSON',
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      });
      $(document).on("click",".save-redirect",function(){
        var data = $("#footer-form").serialize();
        if(data){
          $.ajax({
            type: "POST",
            url: "/panel/redirect/set",
            data: data,
            dataType:'JSON',
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      });
      $(document).on("click",".save-batch-redirect",function(){
        var data = $("#footer-form").serialize();
        if(data){
          setLoading("body");
          $.ajax({
            type: "POST",
            url: "/panel/redirect/batch",
            data: data,
            dataType:'JSON',
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
              unLoading("body")
            }
          });
        }
      });
      $(document).on("click",".save-social-footers",function(){
        var data = $("#footer-social-form").serialize();
        if(data){
          $.ajax({
            type: "POST",
            url: "/panel/footer/social/set",
            data: data,
            dataType:'JSON',
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      });
    }
    var getTabContent = function(){
      $(document).on("click","[data-get-content]",function(){
        var user_id = $("[data-user-id]").data("user-id");
        console.log(user_id)
        var uri     = $(this).data("get-content");
        var content = $(this).attr("href");
        if(user_id && uri){
          $.ajax({
            type: "POST",
            url: "/panel/"+uri,
            data: {
              "user_id":user_id
            },
            dataType:'JSON',
            success: function(result) {
              if(result.success) {
                $(content).find(".card-body").html(result.data);
              }else {
              }
            },
            complete: function() {
            }
          });
        }
      })
    }
    var saveUser = function(){
      $(document).on("click","#save-profile",function(){
        var data = $("#profile-settings").serialize();
        var resultData = $("#profile-settings").find(".message");
        if(data){
          $.ajax({
            type: "POST",
            url: "/panel/users/info/setting",
            data: data,
            dataType:'JSON',
            success: function(result) {
                $(resultData).html(result.message)
            },
            complete: function() {
            }
          });
        }
      });
      $(document).on("click","#save-settings",function(){
        var data = $("#general-settings").serialize();
        var resultData = $("#general-settings").find(".message");
        if(data){
          $.ajax({
            type: "POST",
            url: "/panel/users/general/setting",
            data: data,
            dataType:'JSON',
            success: function(result) {
              if(result.success){
                getNotif('success', result.message);
              }else {
                getNotif('danger', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      });
    }
    var getAutoVideo = function(){
      $(document).on("click","[data-get-video]",function(){
        var id = $(this).data("get-video");
        var imdb_id = $(this).data("imdb");
        var link = $(this).data("link");
        if(imdb_id && id){
          $.ajax({
            type: "POST",
            url: "/api/single/add",
            data: {
              imdb_id,
              link,
              id
            },
            dataType:'JSON',
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      })
      $(document).on("click","[data-get-video-series]",function(){
        var id = $(this).data("get-video-series");
        var imdb_id = $(this).data("imdb");
        var link = $(this).data("link");
        if(imdb_id && id){
          $.ajax({
            type: "POST",
            url: "/api/single/add/series",
            data: {
              imdb_id,
              link,
              id
            },
            dataType:'JSON',
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      })
      $(document).on("click","[data-get-video-episode]",function(){
        var id = $(this).data("get-video-episode");
        var imdb_id = $(this).data("imdb");
        var episode = $(this).data("episode");
        var season = $(this).data("season");
        if(imdb_id && id){
          $.ajax({
            type: "POST",
            url: "/api/single/add/series/episode",
            data: {
              imdb_id,
              episode,
              season,
              id
            },
            dataType:'JSON',
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      })
    }
    var refreshSeason = function(){
      $(document).on("click",".reload-season",function(){
        var tmdbId    = $(this).data("id");
        var language  = $(this).data("lang");
        var series_id  = $(this).data("series");
        if(tmdbId){
          $.ajax({
            type: "POST",
            url: "/panel/tmdb/update/seasons",
            data: {tmdbId,language,series_id},
            dataType:"json",
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
                setTimeout(function(){
                  window.location.reload();
                },1000)
              }else {
                t.prop('disabled',false);
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      });
    }

  
    var anilistUpdateAnime = function(){
      $(document).on("click","[data-anilist]",function(){
        var id    = $(this).data("anilist");
        if(id){
          setLoading("body");
          $.ajax({
            type: "POST",
            url: "/panel/anilist/update",
            data: {id},
            dataType:"json",
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
                setTimeout(function(){
                  window.location.reload();
                },1000)
              }else {
                t.prop('disabled',false);
                getNotif('error', result.message);
              }
            },
            complete: function() {
              unLoading("body")

            }
          });
        }else {
             swalInit.fire({
              title: 'Uyarı!',
              text: 'Anilist ID Bulunamadı',
              type: 'warning',
              showCancelButton: false,
              confirmButtonText: 'Tamam',
            })
        }
      });
      $(document).on("click","[data-mal]",function(){
        var id    = $(this).data("mal");
        if(id){
          setLoading("body");
          
          $.ajax({
            type: "POST",
            url: "/panel/mal/update",
            data: {id},
            dataType:"json",
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
                setTimeout(function(){
                  window.location.reload();
                },1000)
              }else {
                t.prop('disabled',false);
                getNotif('error', result.message);
              }
            },
            complete: function() {
              unLoading("body")

            }
          });
        }else {
             swalInit.fire({
              title: 'Uyarı!',
              text: 'Anilist ID Bulunamadı',
              type: 'warning',
              showCancelButton: false,
              confirmButtonText: 'Tamam',
            })
        }
      });
    }
    var countDownAdd = function(){
      var countdownId = 0;
      $(document).on("click","[data-countdown]",function(){
        countdownId = $(this).data("countdown");
      })
      $(document).on("click","#add-countdown",function(){
        var title = $("#countdown-title").val();
        var sort  = $("#countdown-sort").val();
        var theme = $("#countdown-theme").val();
        var date  = $("#countdown-date").val();
        var content_type  = $("#countdown-type").val();
        if(countdownId){
          $.ajax({
            type: "POST",
            url: "/panel/countdown/add",
            data: {countdownId,title,sort,theme,date,content_type},
            dataType:"json",
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
                setTimeout(function(){
                  window.location.reload();
                },1000)
              }else {
                t.prop('disabled',false);
                getNotif('error', result.message);
              }
            },
            complete: function() {
            }
          });
        }
      });
    }
    var setRequestStatus = function(){
      $(document).on("click","[data-set-status]",function(){
        var id    = $(this).data("set-status");
        var type  = $(this).data("status");
        bootbox.prompt({
              title: 'Lütfen duruma ait bilgi giriniz.',
              buttons: {
                  confirm: {
                      label: 'Evet',
                      className: 'btn-primary'
                  },
                  cancel: {
                      label: 'İptal',
                      className: 'btn-link'
                  }
              },
              callback: function (result) {
                  if (result === null) {                                             
                                                
                  } else {
                    setLoading("body");
                    $.ajax({
                      type: "POST",
                      url: "/panel/request/set/status",
                      data: {
                        id,
                        type,
                        info:result
                      },
                      dataType:"json",
                      success: function(result) {
                        if(result.success) {
                          getNotif('success', result.message);
                          setTimeout(function(){
                            window.location.reload();
                          },1000)
                        }else {
                          getNotif('error', result.message);
                        }
                      },
                      complete: function() {
                        unLoading("body");
                      }
                    });           
                  }
              }
          });
      });
    }
   
    var getTiers = function(){
      $(document).on("click","[data-get-tiers]",function(){
        setLoading("body");
        $.ajax({
            type: "POST",
            url: "/panel/patreon/get/tiers",
            data: {
            },
            dataType:"json",
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
                setTimeout(function(){
                  window.location.reload();
                },1000)
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
              unLoading("body");
            }
        }); 
      });
    }
    var marketPlace = function(){
      $(document).on("click","[data-module]",function(){
        var module = $(this).data("module");
        if(module == 'not_buy'){
          $(".module-item").hide().filter(':contains("Satın Al")').show();

        }else if(module == 'bought'){
          $(".module-item").hide().filter(':contains("Pasif / Aktif")').show();

        }else if(module == 'all'){
          $(".module-item").show();
        }
      });
      $(document).on("click",".module-active",function(){
        var slug    = $(this).data("slug");
        var checked = $(this).is(":checked") ? 1 : 0;
        $.ajax({
            type: "POST",
            url: "/panel/module/status",
            data: {
              slug,
              checked
            },
            dataType:"json",
            success: function(result) {
             
            },
            complete: function() {
            }
        }); 
      })
    }

    var getEpisodeList = function(){
      $(document).on("change",".get-season-episode",function(){
        var id = $(this).val();
        var episodeList = $("[data-episode-list]").data("episode-list");
        if(episodeList[id]){
          $('.video-episode-list').html('');
          $.each(episodeList[id],function(a,i){
             var newOption = new Option(i.episode, i.id, false, false);
             $('.video-episode-list').append(newOption).trigger('change');
          })
        }
      })
    }
    var deleteAllVideo = function(){
      $(document).on("click","[data-video-delete]",function(){
        var id = $(this).data("video-delete");
        var type = $(this).data("type");
        if(id){
          swalInit.fire({
          title: 'Uyarı!',
          text: 'Bu silme işlemini yapmak istediğinize emin misiniz!',
          type: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Evet, sil!',
          cancelButtonText: 'Hayır'
        }).then(function(result) {
            if(result.value) {
               setLoading("body");
               $.ajax({
                  type: "POST",
                  url: "/panel/"+type+"/video/all/delete",
                  data: {
                    id
                  },
                  dataType:"json",
                  success: function(result) {
                    if(result.success) {
                      getNotif('success', result.message);
                    }else {
                      getNotif('error', result.message);
                    }
                  },
                  complete: function() {
                    unLoading("body");
                  }
              }); 
            }
        });
         
        }
      })
    }
    var replaceLink = function(){
      $(document).on("click","#replace-link",function(){
        event.preventDefault();

        var find = $("#find").val();
        var replace = $("#replace").val();
        var type = $("#replace-type").val();
        if(find){
          $.ajax({
            type: "POST",
            url: "/panel/video/replaces",
            data: {
              find,
              replace,
              type
            },
            dataType:"json",
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
              unLoading("body");
            }
        }); 
        }
      })
    }
    var replaceLinkCheck = function(){
      $(document).on("click","#check-replace",function(){
        event.preventDefault();

        var find = $("#find").val();
        var replace = $("#replace").val();
        var type = $("#replace-type").val();
        if(find){
          $.ajax({
            type: "POST",
            url: "/panel/video/replaces-check",
            data: {
              find,
              replace,
              type
            },
            dataType:"json",
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
              unLoading("body");
            }
        }); 
        }
      })
    }
    var bannedUser = function(){
      $(document).on("click","[data-banned]",function(){
        event.preventDefault();
        var user = $(this).data("banned");
        var time = $("#banned_time").val();
        var desc = $("#banned_desc").val();
        if(user){
                         setLoading("body");

          $.ajax({
            type: "POST",
            url: "/panel/user/banned",
            data: {
              user,
              time,
              desc
            },
            dataType:"json",
            success: function(result) {
              if(result.success) {
                getNotif('success', result.message);
              }else {
                getNotif('error', result.message);
              }
            },
            complete: function() {
              unLoading("body");
            }
        }); 
        }
      })
    }
    var allGroupUpdate = function(){
      $(document).on("click","[data-update-all-group]",function(){
        event.preventDefault();
        var series_id = $(this).data("update-all-group");
        var group_id = $("#all-video-group").val();
        if(group_id && series_id ){

           swalInit.fire({
            title: 'Uyarı!',
            text: 'Bu işlemi yapmak istediğine emin misin!',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Evet, kaldır!',
            cancelButtonText: 'Hayır'
          }).then(function(result) {
              if(result.value) {
                   setLoading("body");
                    $.ajax({
                      type: "POST",
                      url: "/panel/series/all/group/update",
                      data: {
                        series_id,
                        group_id,
                      },
                      dataType:"json",
                      success: function(result) {
                        if(result.success) {
                          getNotif('success', result.message);
                        }else {
                          getNotif('error', result.message);
                        }
                      },
                      complete: function() {
                        unLoading("body");
                      }
                  }); 
              }
          });;
          
        }
      })
    }
    var bannedUserDelete = function(){
      $(document).on("click","[data-banned-delete]",function(){
        event.preventDefault();
        var id = $(this).data("banned-delete");
        if(id){
          swalInit.fire({
            title: 'Uyarı!',
            text: 'Bu kullanıcının cezasını kaldırmak istediğinize emin misiniz!',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Evet, kaldır!',
            cancelButtonText: 'Hayır'
          }).then(function(result) {
              if(result.value) {
                  $.ajax({
                    type:"POST",
                    url:origin+"/panel/user/delete/banned",
                    data:{id},
                    dataType:'json',
                    success:function(result){
                      if(result.success){
                        swalInit.fire(
                            'Başarılı!',
                            result.message,
                            'success'
                        );
                      }
                    },
                    error:function(e){
                        console.log(e)
                    },
                    complete:function(){
                    }
                  });
              }
          });;
        }
      })
    }
    var moveEpisode = function(){
      $(document).on("click","#movie-episode",function(){
        event.preventDefault();
        var anime = $("#move-anime").val();
        var old_anime = $("[data-anime-id]").data("anime-id");
        var episode_id = $("#move-episode-id").val();
        var episode = $("#movie-episode-number").val();
        if(anime && episode_id ){
          swalInit.fire({
            title: 'Uyarı!',
            text: 'Bu işlemi yapmak istediğine emin misin?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Evet, taşı!',
            cancelButtonText: 'Hayır'
          }).then(function(result) {
              if(result.value) {

                  $.ajax({
                    type:"POST",
                    url:origin+"/panel/anime/move/episode",
                    data:{episode_id, episode, anime, old_anime},
                    dataType:'json',
                    success:function(result){
                      if(result.success){
                        $("[data-get-anime-episode="+episode_id+"]").closest("tr").remove()
                        swalInit.fire(
                            'Başarılı!',
                            result.message,
                            'success'
                        );
                      }
                    },
                    error:function(e){
                        console.log(e)
                    },
                    complete:function(){
                    }
                  });
              }
          });;
        }
      })
    }
    var getYoutubePlaylist = function(){
      $(document).on("click","[data-get-playlist]",function(){
        var playlist = $("#playlist").val();
        var title = $("#title").val();
        var whereis = $("#whereis").val();
        var status = $("#status").val();
        var series = $("#search-series").val();

        if(playlist && title && whereis ){
          setLoading("body");

          $.ajax({
              type: "POST",
              url: "/panel/youtube/add",
              data: {
                playlist,
                title,
                whereis,
                status,
                series
              },
              dataType:"json",
              success: function(result) {
                if(result.success) {
                  getNotif('success', result.message);
                }else {
                  getNotif('error', result.message);
                }
              },
              complete: function() {
                unLoading("body");
              }
          }); 
        }else {
          alert("Gerekli alanları doldurunuz.")
        }
        
      });
    }
    var customAccess = function(){
      var id = 0;
      var type = 0;

      var elem_dmca          = $('.custom-dmca');
      var elem_not_member    = $('.custom-not_member');
      var elem_only_mobile   = $('.custom-only_mobile');
      var elem_only_yandex   = $('.custom-only_yandex');
      var elem_abroad        = $('.custom-abroad');
      $(document).on("click","[data-custom-access]",function(){
        id   = $(this).data("custom-access")
        type = $(this).data("type");
        var json  = $(this).data("cs");
        json = json ? json : '';

        if(json){
          $('#customAccess-modal').on('shown.bs.modal', function () {

            json.not_member  == 1? elem_not_member.prop('checked',true)  : elem_not_member.prop('checked',false)
            json.only_mobile  == 1? elem_only_mobile.prop('checked',true)  : elem_only_mobile.prop('checked',false)
            json.only_yandex  == 1? elem_only_yandex.prop('checked',true)  : elem_only_yandex.prop('checked',false)
            json.abroad  == 1? elem_abroad.prop('checked',true)  : elem_abroad.prop('checked',false)
            json.dmca  == 1? elem_dmca.prop('checked',true)  : elem_dmca.prop('checked',false)
            
          }.bind(this));
           

              // json.dmca == 1? $('.dmca').trigger('click') : ''
              // json.not_member== 1 ? $('.custom-not_member').trigger('click') : ''
              // json.only_mobile == 1? $('.custom-only_mobile').trigger('click') : ''
              // json.only_yandex == 1? $('.custom-only_yandex').trigger('click') : ''
              // json.abroad == 1? $('.custom-abroad').trigger('click') : ''
        }else {
             $('#customAccess-modal').on('shown.bs.modal', function () {
                elem_not_member.prop('checked',false)
                elem_only_mobile.prop('checked',false)
                elem_only_yandex.prop('checked',false)
                elem_abroad.prop('checked',false)
                elem_dmca.prop('checked',false)
             }.bind(this));
        }
      });

        $(document).on("click","#custom-access-update",function(){
            if(id){
                var t = $(this);
                var html = t.html();
                t.html(loader);
                t.prop('disabled',true);

              var dmca          = $('.custom-dmca').is(":checked") ? 1 : 0;
              var not_member    = $('.custom-not_member').is(":checked") ? 1 : 0;
              var only_mobile   = $('.custom-only_mobile').is(":checked") ? 1 : 0;
              var only_yandex   = $('.custom-only_yandex').is(":checked") ? 1 : 0;
              var abroad        = $('.custom-abroad').is(":checked") ? 1 : 0;

              var custom = {
                dmca,
                not_member,
                only_mobile,
                only_yandex,
                abroad     
              }

            $.ajax({
              type: "POST",
              url: "/panel/"+type+"/custom-access",
              data: {
                id,
                custom
              },
              dataType:"json",
              success: function(result) {
                if(result.success) {
                  getNotif('success', result.message);
                }else {
                  getNotif('error', result.message);
                }
              },
              complete: function() {
                   t.html(html);
                        t.prop('disabled',false);
              }
            });
            }
        })
    }
     var episodeClone = function(){
        $(document).on("click","#add-clone",function(){
          var type = $(this).data("type");
          var season      = $("#clone-season").val();
          var episode     = $("#clone-episode").val();
          var episode_id  = $("#clone-episode-modal").attr("data-id");
          if ( episode && episode_id){
          setLoading("body");
            
            $.ajax({
              type:"POST",
              url:origin+"/panel/"+type+"/clone/add",
              data:{
                episode_id,
                season,
                episode,
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
                unLoading("body");
              }
            });
          }
        })
    }
    var updateRedirect = function(){
      $(document).on("click","[data-redirect-update]",function(){
        var id = $(this).data("redirect-update");
        var oldUrl = $("#item-"+id).find(".old-url").val()
        var newUrl = $("#item-"+id).find(".new-url").val()
        if(id && oldUrl && newUrl){
             setLoading("body");
            $.ajax({
              type:"POST",
              url:origin+"/panel/redirect/update",
              data:{
                id,
                oldUrl,
                newUrl,
              },
              dataType:'json',
              success:function(result){
                if(result.success){
                  getNotif('success',result.message);
                }else {
                  getNotif('error',result.message);
                }
              },
              error:function(e){
                  console.log(e)
              },
              complete:function(){
                unLoading("body");
              }
            });
        }
      })
    }

    var botAction = function(){

         $(document).on("click",".get-episode-list",function(){
             var content_id = $("#search-series").val();

              var isProcessing = false;
              var lastProcessedIndex = 0; // En son işlenen satırın indeksini saklayan değişken
              var noMoreRecords = false; // Kayıt kalmadığında uyarı vermek için bayrak
              var recordsTotal = 0; // Toplam kayıt
              var requestCount = 0; // İstek sayısı toplam
              if (!$.fn.dataTable.isDataTable("#without-episode-list")) {
                   var table = $("#without-episode-list").DataTable({
                      processing: true,
                      serverSide: true,
                      searching:false,
                      order: [[0, "desc"]],
                      columnDefs: [
                          { orderable: false, targets: [4] },
                      ],
                      ajax: {
                          url: origin + "/api/v2/episodes/without-videos",
                          type: "GET",
                          data: function(d) {
                           
                              return {
                                  page: (d.start / d.length) + 1,
                                  limit: d.length,
                                  custom_access: getUrlParameter('access'),
                                  include_series_info: 1,
                                  check_air_date: 1,
                                  content_id
                              };
                          },
                          dataSrc: function(json) {
                          
                              json.recordsTotal = json.total;
                              json.recordsFiltered = json.total;
                                recordsTotal = json.total
                                requestCount = 0

                              return json.data.map(function(episode) {
                                  return {
                                      e_id: episode.e_id,
                                      s_name: episode.s_name,
                                      name: episode.s_name,
                                      series_id: episode.s_id,
                                      s_link: episode.s_link,
                                      original_name: episode.s_original_name,
                                      s_imdb_id: episode.s_imdb_id,
                                      season: episode.season_number,
                                      episode: episode.e_num,
                                      season_number: episode.season_number+ ". Sezon - " +  episode.e_num + ". Bölüm",
                                      air_date: episode.e_air_date,

                                  };
                              });
                          },
                          complete: function() {
                              var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
                              elems.forEach(function(html) {
                                  var switchery = new Switchery(html);
                              });
                              coreInit(table);
                            
                          }
                      },
                      columns: [
                          { data: "e_id", title: "Bölüm No" },
                          { data: "s_name", title: "Dizi Adı" },
                          { data: "s_link", title: "Dizi Link" },
                          { data: "s_imdb_id", title: "IMDB ID" },
                          { data: "season_number", title: "Sezon & Bölüm" },
                          { data: "air_date", title: "Yayın Tarihi" },

                      ],
                      pageLength: 10,
                      lengthMenu: [[10, 25, 50], [10, 25, 50]],
                      paging: true,
                      lengthChange: true,
                      info: true,
                      autoWidth: false,
                  });

               }

             $("#get-episode-list .start-button").on("click", function() {
               var driver = $(".bot-provider").val();
               var proxy = $("#proxy").val();
                
               if(driver.length){

                   $(this).prop("disabled", true);
                    $("#get-episode-list .stop-button").prop("disabled", false);
                    isProcessing = true;
                    processData(lastProcessedIndex);
               }else {
                    swalInit.fire(
                        'Uyarı!',
                        'Lütfen bot ayarlarından hedef site belirtin.',
                        'info'
                    );
               }
             });

             $("#get-episode-list .stop-button").on("click", function() {
                 $(this).prop("disabled", true);
                 $("#get-episode-list .start-button").prop("disabled", false);
                 isProcessing = false;
             });


           
           // Sayfa değiştirerek giden kod
            function processData(startIndex) {
         
             var search_type = $("#search_type").val();

              var currentPage = table.page();
              var pageInfo = table.page.info();
              var rows = table.rows({ page: 'current' }).data();

              var processRow = function(index) {
                  if (!isProcessing || index >= rows.length) {
                      if (isProcessing && index >= rows.length && currentPage < pageInfo.pages - 1) {
                          table.ajax.reload(null, false); // Tabloyu günceller ve aynı sayfada kalır

                          // table.page(currentPage + 1).draw('page'); // Sayfa değiştirerek ilerler
                          lastProcessedIndex = 0; // Yeni sayfa başladığında indeks sıfırlanır
                          setTimeout(function() {
                              processData(0);
                          }, 1000); // Sayfa değişiklikleri arasında bir bekleme süresi
                      }
                      return;
                  }

                  var row = rows[index];
                var driver = $(".bot-provider").val();
               var proxy = $("#proxy").val();
                  $.ajax({
                      url: "/panel/bot/single-add",
                      type: "POST",
                      dataType:'json',
                      data: {
                          episode_id: row.e_id,
                          episode: row.episode,
                          season: row.season,
                          alias: row.s_link,
                          name: row.s_name,
                          series_id: row.series_id,
                          imdb_id: row.s_imdb_id,
                         original_name: row.original_name,

                           driver,
                          search_type,
                          proxy,
                          type:'series',
                          
                      },
                      success: function(response) {

                          if (response.success) {
                              $(table.row(index).node()).addClass("bg-success");
                                var wc = parseInt($("#without-series-count").text())
                           $("#without-series-count").text(wc - 1)
                          } else {
                              $(table.row(index).node()).addClass("bg-danger");
                          }
                          lastProcessedIndex = index + 1; // Başarılı istek sonrası indeksi günceller
                          processRow(index + 1);
                      },
                      error: function() {
                          $(table.row(index).node()).addClass("bg-danger");
                          lastProcessedIndex = index + 1; // Hatalı istek sonrası indeksi günceller
                          processRow(index + 1);
                      },
                      complete: function(){
                           requestCount++;
                           console.log(requestCount, recordsTotal)
                           if (requestCount == recordsTotal) {
                                noMoreRecords = true; // Kayıt kalmadığında bayrağı set et
                            }
                           if (noMoreRecords) {
                                  swalInit.fire(
                                    'Başarılı!',
                                    'Tüm bölümlerin kontrolu tamamlandı.',
                                    'info'
                                );
                                 $("#get-episode-list .stop-button").prop("disabled", true);
                                 $("#get-episode-list .start-button").prop("disabled", false);
                                 isProcessing = false;
                                 noMoreRecords = false; // Bayrağı sıfırla
                            }
                      }
                  });
              };

              processRow(startIndex);
            }
         });

         
          $(document).on("click",".get-movies",function(){
            var content_id = $("#search-movies").val();

              var isProcessing = false;
              var lastProcessedIndex = 0; // En son işlenen satırın indeksini saklayan değişken
              var noMoreRecords = false; // Kayıt kalmadığında uyarı vermek için bayrak
              var recordsTotal = 0; // Toplam kayıt
              var requestCount = 0; // İstek sayısı toplam
              if (!$.fn.dataTable.isDataTable("#without-movies-list")) {
                   var table = $("#without-movies-list").DataTable({
                      processing: true,
                      serverSide: true,
                      searching:false,
                      order: [[0, "desc"]],
                      columnDefs: [
                          { orderable: false, targets: [3] },
                      ],
                      ajax: {
                          url: origin + "/api/v2/movies/without-videos",
                          type: "GET",
                          data: function(d) {
                              return {
                                  page: (d.start / d.length) + 1,
                                  limit: d.length,
                                  custom_access: getUrlParameter('access'),
                                  include_movie_info: 1,
                                  content_id,
                          
                              };
                          },
                          dataSrc: function(json) {
                          
                              json.recordsTotal = json.total;
                              json.recordsFiltered = json.total;

                                 recordsTotal = json.total
                                 requestCount = 0
                              return json.data.map(function(movie) {
                                  return {
                                      movies_id: movie.movies_id,
                                      name: movie.name,
                                      original_name: movie.original_name,
                                      alias: movie.alias,
                                      imdb_id: movie.imdb_id
                                  };
                              });
                          },
                          complete: function() {
                              var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
                              elems.forEach(function(html) {
                                  var switchery = new Switchery(html);
                              });
                              coreInit(table);
                          }
                      },
                      columns: [
                          { data: "movies_id", title: "Film No" },
                          { data: "name", title: "Film Adı" },
                          { data: "alias", title: "Film Link" },
                          { data: "imdb_id", title: "IMDB ID" },

                      ],
                      pageLength: 10,
                      lengthMenu: [[10, 25, 50], [10, 25, 50]],
                      paging: true,
                      lengthChange: true,
                      info: true,
                      autoWidth: false,
                  });

               }

             $("#get-movies .start-button").on("click", function() {
                var driver = $(".bot-provider").val();
                  var proxy = $("#proxy").val();

                if(driver.length){
                       $(this).prop("disabled", true);
                       $("#get-movies .stop-button").prop("disabled", false);
                       isProcessing = true;
                       processData(lastProcessedIndex);
                    }else {
                      swalInit.fire(
                           'Uyarı!',
                           'Lütfen bot ayarlarından hedef site belirtin.',
                           'info'
                       );
                    }
               
             });

             $("#get-movies .stop-button").on("click", function() {
                 $(this).prop("disabled", true);
                 $("#get-movies .start-button").prop("disabled", false);
                 isProcessing = false;
             });


           
           // Sayfa değiştirerek giden kod
            function processData(startIndex) {
               var search_type = $("#search_type").val();
               
              var currentPage = table.page();
              var pageInfo = table.page.info();
              var rows = table.rows({ page: 'current' }).data();

              var processRow = function(index) {
                  if (!isProcessing || index >= rows.length) {
                      if (isProcessing && index >= rows.length && currentPage < pageInfo.pages - 1) {
                          table.ajax.reload(null, false); // Tabloyu günceller ve aynı sayfada kalır

                          // table.page(currentPage + 1).draw('page'); // Sayfa değiştirerek ilerler
                          lastProcessedIndex = 0; // Yeni sayfa başladığında indeks sıfırlanır
                          setTimeout(function() {
                              processData(0);
                          }, 1000); // Sayfa değişiklikleri arasında bir bekleme süresi
                      }
                      return;
                  }

                  var row = rows[index];
                   var driver = $(".bot-provider").val();
                  var proxy = $("#proxy").val();
                  $.ajax({
                      url: "/panel/bot/single-add",
                      type: "POST",
                      dataType:'json',
                      data: {
                          alias: row.alias,
                          movies_id: row.movies_id,
                          name: row.name,
                          imdb_id: row.imdb_id,
                         original_name: row.original_name,
                          
                          driver,
                          proxy,
                          search_type,
                          type:'movie',
                          
                      },
                      success: function(response) {
                              

                          if (response.success) {
                              $(table.row(index).node()).addClass("bg-success");
                                    var wc = parseInt($("#without-movies-count").text())
                                     $("#without-movies-count").text(wc - 1)
                          } else {
                              $(table.row(index).node()).addClass("bg-danger");
                          }
                          lastProcessedIndex = index + 1; // Başarılı istek sonrası indeksi günceller
                          processRow(index + 1);
                      },
                      error: function() {
                          $(table.row(index).node()).addClass("bg-danger");
                          lastProcessedIndex = index + 1; // Hatalı istek sonrası indeksi günceller
                          processRow(index + 1);
                      },
                      complete: function(){
                           requestCount++;
                           if (requestCount == recordsTotal) {
                                noMoreRecords = true; // Kayıt kalmadığında bayrağı set et
                            }
                           if (noMoreRecords) {
                                  swalInit.fire(
                                    'Başarılı!',
                                    'Tüm bölümlerin kontrolu tamamlandı.',
                                    'info'
                                );
                                 $("#get-movies .stop-button").prop("disabled", true);
                                 $("#get-movies .start-button").prop("disabled", false);
                                 isProcessing = false;
                                 noMoreRecords = false; // Bayrağı sıfırla
                            }
                      }
                  });
              };

              processRow(startIndex);
            }
         });
        $(document).on("click","#updateTable",function(){
             var type = $("#fragman_type").val();
             
            if(type == 1){
                 var content_id = $(  "#search-series").val();
                window.searchMovie = content_id.join(",")
            }else if(type == 2){
               var content_id = $( "#search-movies").val();
                window.searchMovie = content_id.join(",")
            }else if(type == 3){
                var content_id = $( "#search-animes").val();
                window.searchAnime = content_id[0]
            }
          
        });

        $(document).on("click", "#updateAnimeList",function(){
           
            window.animeTable.ajax.url(origin + "/api/v2/animes/without-videos?id=" + window.searchAnime);
            window.animeTable.page(0).draw('page');
            window.animeTable.ajax.reload(null, false);
        });

       $(document).on("change", "#search_type", function() {
            var type = $(this).val();
            var parent = $(this).closest('.row');

            // Remove any previous form group if exists
            parent.find('.dynamic-form-group').remove();

            if (type == 'match') {
                // Create form group dynamically
                var formGroup = `
                    <div class="col-md-6 dynamic-form-group">
                        <div class="form-group">
                            <label for="search-animes">Animeler</label>
                            <select id="search-animes-api" class="form-control"></select>
                        </div>
                    </div>`;

                // Append form group to parent
                parent.append(formGroup);

                // Initialize select2 on dynamically created select box
                $("#search-animes-api").select2({
                    dropdownParent: "#add-video-modal",
                    tags: [],
                    placeholder: "Animeler",
                    templateResult: function(item) {
                        if (!item.id) {
                            return item.text;
                        }
                        var $item = $(
                            `<div class="select2-item">
                                <img src="${item.poster}" style="width: 30px; height: 40px; margin-right: 10px;"/>
                                <span>${item.text}</span>
                            </div>`
                        );
                        return $item;
                    },
                    templateSelection: function(item) {
                        return item.text;
                    },
                    ajax: {
                        url: "https://anim-taupe.vercel.app/api/v2/hianime/search/suggestion",
                        dataType: 'json',
                        type: "GET",
                        data: function(term) {
                            return {
                                q: term.term
                            };
                        },
                        processResults: function(data) {
                            return {
                                results: $.map(data.data.suggestions, function(item) {
                                    return {
                                        id: item.id,
                                        text: item.name,
                                        poster: item.poster
                                    };
                                })
                            };
                        }
                    }
                });
            }
        });


        $(document).on("click",".get-animes",function(){
                var content_id = window.searchAnime;
                var isProcessing = false;
                var lastProcessedIndex = 0; // En son işlenen satırın indeksini saklayan değişken
                var noMoreRecords = false; // Kayıt kalmadığında uyarı vermek için bayrak
                var recordsTotal = 0; // Toplam kayıt
                var requestCount = 0; // İstek sayısı toplam
                if (!$.fn.dataTable.isDataTable("#without-animes-list")) {
                   var table = $("#without-animes-list").DataTable({
                      processing: true,
                      serverSide: true,
                      searching:false,
                      order: [[0, "desc"]],
                      columnDefs: [
                          { orderable: false, targets: [3] },
                      ],
                      ajax: {
                          url: origin + "/api/v2/animes/without-videos",
                          type: "GET",
                          data: function(d) {
                              return {
                                  page: (d.start / d.length) + 1,
                                  limit: d.length,
                                  custom_access: getUrlParameter('access'),
                                  include_movie_info: 1,
                                  id: content_id,
                              };
                          },
                          dataSrc: function(json) {
                          
                              json.recordsTotal = json.total;
                              json.recordsFiltered = json.total;

                                 recordsTotal = json.total
                                 requestCount = 0
                              return json.data.map(function(movie) {
                                  return {
                                      id: movie.id,
                                      title: movie.title,
                                      original_title: movie.original_title,
                                      alias: movie.alias,
                                      episode: movie.episode,
                                      episode_id: movie.episode_id,
                                      animes_id: movie.animes_id,
                                      anilist_id: movie.anilist_id,
                                      mal_id: movie.mal_id
                                  };
                              });
                          },
                          complete: function() {
                              var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
                              elems.forEach(function(html) {
                                  var switchery = new Switchery(html);
                              });
                              coreInit(table);
                          }
                      },
                      columns: [
                          { data: "id", title: "Anime No" },
                          { data: "title", title: "Anime Adı" },
                          { data: "alias", title: "Anime Link" },
                          { data: "episode", title: "Bölüm No" },
                          { data: "episode_id", title: "Bölüm ID" },
                          { data: "animes_id", title: "Anime Id" },
                          { data: "anilist_id", title: "Anilist ID" },
                          { data: "mal_id", title: "MAL ID" },

                      ],
                      pageLength: 10,
                      lengthMenu: [[10, 25, 50], [10, 25, 50]],
                      paging: true,
                      lengthChange: true,
                      info: true,
                      autoWidth: false,
                  });

                   window.animeTable = table;

               }

             $("#get-anime .start-button").on("click", function() {
                var driver = $(".bot-provider").val();
                  var proxy = $("#proxy").val();

                if(driver.length){
                       $(this).prop("disabled", true);
                       $("#get-anime .stop-button").prop("disabled", false);
                       isProcessing = true;
                       processData(lastProcessedIndex);
                    }else {
                      swalInit.fire(
                           'Uyarı!',
                           'Lütfen bot ayarlarından hedef site belirtin.',
                           'info'
                       );
                    }
               
             });

             $("#get-anime .stop-button").on("click", function() {
                 $(this).prop("disabled", true);
                 $("#get-anime .start-button").prop("disabled", false);
                 isProcessing = false;
             });


                // Sayfa değiştirerek giden kod
                function processData(startIndex) {
                   var search_type = $("#search_type").val();
                   
                  var currentPage = table.page();
                  var pageInfo = table.page.info();
                  var rows = table.rows({ page: 'current' }).data();

                  var processRow = function(index) {
                      if (!isProcessing || index >= rows.length) {
                          if (isProcessing && index >= rows.length && currentPage < pageInfo.pages - 1) {
                              table.ajax.reload(null, false); // Tabloyu günceller ve aynı sayfada kalır

                              // table.page(currentPage + 1).draw('page'); // Sayfa değiştirerek ilerler
                              lastProcessedIndex = 0; // Yeni sayfa başladığında indeks sıfırlanır
                              setTimeout(function() {
                                  processData(0);
                              }, 1000); // Sayfa değişiklikleri arasında bir bekleme süresi
                          }
                          return;
                      }

                      var row = rows[index];
                       var driver = $(".bot-provider").val();
                      var proxy = $("#proxy").val();
                      var match = $("#search-animes-api").val();
                      $.ajax({
                          url: "/panel/bot/single-add",
                          type: "POST",
                          dataType:'json',
                          data: {
                              alias: row.alias,
                              id: row.id,
                              name: row.title,
                              episode: row.episode,
                              episode_id: row.episode_id,
                              series_id: row.animes_id,
                              mal_id: row.mal_id,
                              anilist_id: row.anilist_id,
                              original_name: row.original_title,
                              match,
                              driver,
                              proxy,
                              search_type,
                              type:'anime',
                              
                          },
                          success: function(response) {
                                  

                              if (response.success) {
                                  $(table.row(index).node()).addClass("bg-success");
                                        var wc = parseInt($("#without-animes-count").text())
                                         $("#without-animes-count").text(wc - 1)
                              } else {
                                  $(table.row(index).node()).addClass("bg-danger");
                              }
                              lastProcessedIndex = index + 1; // Başarılı istek sonrası indeksi günceller
                              processRow(index + 1);
                          },
                          error: function() {
                              $(table.row(index).node()).addClass("bg-danger");
                              lastProcessedIndex = index + 1; // Hatalı istek sonrası indeksi günceller
                              processRow(index + 1);
                          },
                          complete: function(){
                               requestCount++;
                               if (requestCount == recordsTotal) {
                                    noMoreRecords = true; // Kayıt kalmadığında bayrağı set et
                                }
                               if (noMoreRecords) {
                                      swalInit.fire(
                                        'Başarılı!',
                                        'Tüm bölümlerin kontrolu tamamlandı.',
                                        'info'
                                    );
                                     $("#get-animes .stop-button").prop("disabled", true);
                                     $("#get-animes .start-button").prop("disabled", false);
                                     isProcessing = false;
                                     noMoreRecords = false; // Bayrağı sıfırla
                                }
                          }
                      });
                  };

                  processRow(startIndex);
                }
        });
        
        
    }

    var Discover = function(){
        let isProcessing = false; // İşlem durumu kontrolü



        if (!$.fn.dataTable.isDataTable("#discover-list")) {
            let trendingPeriod = 'day';
            const checkStatus = (id, type) => {
                 return $.ajax({
                     url: origin+'/panel/discover/check',
                     dataType: 'json',
                     method: 'POST',
                     data: {
                         id: id,
                         type: type
                     }
                 });
            };
            const addContent = (id, type, button) => {
                 button.prop('disabled', true).html('Loading <div class="loader"></div>');
                 return $.ajax({
                     url: origin +'/panel/discovery/add',
                     method: 'POST',
                     dataType: 'json',
                     data: {
                         id: id,
                         type: type
                     },
                     success: function(response) {
                         if(response.success) {
                             button.html('Eklendi').prop('disabled', true).removeClass('btn-primary').addClass('btn-success');
                         } else {
                             button.html('Eklenmedi').prop('disabled', false).removeClass('btn-primary').addClass('btn-danger');
                             setTimeout(() => {
                                 button.html('Siteye Ekle').removeClass('btn-danger').addClass('btn-primary');
                             }, 2000);
                         }
                     },
                     error: function() {
                         button.html('Eklenmedi').prop('disabled', true).removeClass('btn-primary').addClass('btn-danger');
                         setTimeout(() => {
                             button.html('Siteye Ekle').removeClass('btn-danger').addClass('btn-primary');
                         }, 2000);
                     }
                 });
            };

            let isProcessing = false; // İşlem durumu kontrolü
            let currentPage = 0; // Mevcut sayfa numarası

            // Start butonuna basıldığında işlemi başlatır
            $('#startButton').on('click', function() {
                isProcessing = true;
                $('#startButton').prop('disabled', true);
                $('#stopButton').prop('disabled', false);
                currentPage = 0; // Sayfayı sıfırdan başlat
                processAddButtons();
            });

            // Stop butonuna basıldığında işlemi durdurur
            $('#stopButton').on('click', function() {
                isProcessing = false;
                $('#startButton').prop('disabled', false);
                $('#stopButton').prop('disabled', true);
            });

            // Tüm .add-button düğmelerini sırayla işlemeye başlar
            function processAddButtons() {
                const buttons = $('.add-button:not(:disabled)');
                
                // Eğer mevcut sayfada işlenecek düğme yoksa bir sonraki sayfaya geç
                if (buttons.length === 0 && isProcessing) {
                    const table = $('#discover-list').DataTable();
                    const pageInfo = window.discoveryTable.page.info();
                    if (currentPage < pageInfo.pages - 1) {
                        window.discoveryTable.page(currentPage).draw('page'); // Bir sonraki sayfaya geç
                        currentPage++;
                        
    //                       window.animeTable.ajax.url(origin + "/api/v2/animes/without-videos?id=" + window.searchAnime);
    // window.animeTable.page(0).draw('page');
    // window.animeTable.ajax.reload(null, false);
                        setTimeout(processAddButtons, 5000); // Bir sonraki sayfayı yüklemek için bekle
                    } else {
                        // İşlem tamamlandı
                        isProcessing = false;
                        $('#startButton').prop('disabled', false);
                        $('#stopButton').prop('disabled', true);
                        alert('Tüm sayfalar işlendi!');
                    }
                    return;
                }

                if (!isProcessing) {
                    $('#startButton').prop('disabled', false);
                    $('#stopButton').prop('disabled', true);
                    return;
                }

                const button = $(buttons[0]); // İlk aktif düğmeyi seçer
                const id = button.data('id');
                const type = button.data('type');

                // addContent fonksiyonu çağrılır ve tamamlandığında sıradaki düğmeye geçilir
                addContent(id, type, button).always(() => {
                    setTimeout(() => processAddButtons(), 500); // Bir sonraki düğme için bekleme süresi
                });
            }

            const fetchMovies = (data, callback, settings) => {
                  const page = data.start / data.length + 1;
                  $.ajax({
                      url: `https://api.themoviedb.org/3/trending/all/${trendingPeriod}`,
                      data: {
                          api_key: 'fb58e466f76f551b6dccea1367744840',
                          language: 'tr-TR',
                          page: page
                      },
                      success: async function(response) {
                          const movies = await Promise.all(response.results.map(async movie => {
                              const id = movie.id;
                              const type = movie.media_type === 'tv' ? 'tv' : 'movie';
                              const statusResponse = await checkStatus(id, type);
                              const status = statusResponse.success ? 'Var' : 'Sitede Yok';
                              const statusBadge = statusResponse.success ? '<span class="btn btn-success">Var</span>' : '<span class="btn btn-danger">Yok</span>';
                              const actionButton =  statusResponse.success ? '' : `<button class="btn btn-primary add-button" data-type="${type}" data-id="${id}">Siteye Ekle</button>`;

                              return {
                                  title: movie.title || movie.name  ,
                                  type:  '<span class="btn btn-primary">'+type+' ID: '+ id+'</span>' ,
                                  overview: movie.overview,
                                  release_date: movie.release_date || movie.first_air_date,
                                  popularity: movie.popularity,
                                  vote_average: movie.vote_average,
                                  poster: `<img src="https://image.tmdb.org/t/p/w92${movie.poster_path}" alt="${movie.title || movie.name}">`,
                                  status: statusBadge,
                                   actions: actionButton

                              };
                          }));
                          callback({
                              draw: data.total_pages,
                              recordsTotal: response.total_results,
                              recordsFiltered: response.total_results,
                              data: movies
                          });
                      }
                  });
            };

            const table = $('#discover-list').DataTable({
                 "processing": true,
                 "serverSide": true,
                searching:false,

                 "ajax": fetchMovies,

                 "columns": [
                     { "data": "poster", title: 'Poster' },
                     { "data": "title" , title: 'Adı'},
                     { "data": "type" , title: 'Tip'},
                     { "data": "overview", title: 'Açıklama' , width: "30%"},
                     { "data": "release_date", title: 'Yayın tarihi' },
                     { "data": "popularity" , title: 'Toplam Oylama'},
                     { "data": "vote_average", title: 'Oy Ortalaması' },
                     { "data": "status", title: 'Durum' },
                    { "data": "actions", "width": "10%", "orderable": false }
                 ]
            });

            window.discoveryTable = table;

            $('#periodSelect').on('change', function() {
                trendingPeriod = this.value;
                table.ajax.reload();
            });

            $(document).on('click', '.add-button', function() {
                  const button = $(this);
                 const id = button.data('id');
                 const type = button.data('type');
                 addContent(id, type, button);
            });

        }

    }

    var DiscoverAnime = function(){
        let isProcessing = false; // İşlem durumu kontrolü

        if (!$.fn.dataTable.isDataTable("#discover-anime-list")) {
            let trendingPeriod = 'all';
            const checkStatus = (id, type) => {
                 return $.ajax({
                     url: origin+'/panel/discover/check',
                     dataType: 'json',
                     method: 'POST',
                     data: {
                         id: id,
                         type: type
                     }
                 });
            };
            const addContent = (id, type, button) => {
                 button.prop('disabled', true).html('Loading <div class="loader"></div>');
                 return $.ajax({
                     url: origin +'/panel/discovery/add',
                     method: 'POST',
                     dataType: 'json',
                     data: {
                         id: id,
                         type: type
                     },
                     success: function(response) {
                         if(response.success) {
                             button.html('Eklendi').prop('disabled', true).removeClass('btn-primary').addClass('btn-success');
                         } else {
                             button.html('Eklenmedi').prop('disabled', true).removeClass('btn-primary').addClass('btn-danger');
                             // setTimeout(() => {
                             //     button.html('Siteye Ekle').removeClass('btn-danger').addClass('btn-primary');
                             // }, 2000);
                         }
                     },
                     error: function() {
                         button.html('Eklenmedi').prop('disabled', true).removeClass('btn-primary').addClass('btn-danger');
                     }
                 });
            };

            let isProcessing = false; // İşlem durumu kontrolü
            let currentPage = 0; // Mevcut sayfa numarası

            // Start butonuna basıldığında işlemi başlatır
            $('#startButton').on('click', function() {
                isProcessing = true;
                $('#startButton').prop('disabled', true);
                $('#stopButton').prop('disabled', false);
                currentPage = 0; // Sayfayı sıfırdan başlat
                processAddButtons();
            });

            // Stop butonuna basıldığında işlemi durdurur
            $('#stopButton').on('click', function() {
                isProcessing = false;
                $('#startButton').prop('disabled', false);
                $('#stopButton').prop('disabled', true);
            });

            // Tüm .add-button düğmelerini sırayla işlemeye başlar
            function processAddButtons() {
                const buttons = $('.add-button:not(:disabled):not(.update-btn)');
                
                // Eğer mevcut sayfada işlenecek düğme yoksa bir sonraki sayfaya geç
                if (buttons.length === 0 && isProcessing) {
                    const table = $('#discover-list').DataTable();
                    const pageInfo = window.discoveryTable.page.info();
                    if (currentPage < 1000) {
                        window.discoveryTable.page(currentPage).draw('page'); // Bir sonraki sayfaya geç
                        currentPage++;
                        
                         // window.animeTable.ajax.url(origin + "/api/v2/animes/without-videos?id=" + window.searchAnime);
                        window.discoveryTable.page(currentPage).draw('page');
                        window.discoveryTable.ajax.reload(null, false);
                        setTimeout(processAddButtons, 5000); // Bir sonraki sayfayı yüklemek için bekle
                    } else {
                        // İşlem tamamlandı
                        isProcessing = false;
                        $('#startButton').prop('disabled', false);
                        $('#stopButton').prop('disabled', true);
                        alert('Tüm sayfalar işlendi!');
                    }
                    return;
                }

                if (!isProcessing) {
                    $('#startButton').prop('disabled', false);
                    $('#stopButton').prop('disabled', true);
                    return;
                }

                const button = $(buttons[0]); // İlk aktif düğmeyi seçer
                const id = button.data('id');
                const type = button.data('type');

                // addContent fonksiyonu çağrılır ve tamamlandığında sıradaki düğmeye geçilir
                addContent(id, type, button).always(() => {
                    setTimeout(() => processAddButtons(), 500); // Bir sonraki düğme için bekleme süresi
                });
            }

            const fetchMovies = (data, callback, settings) => {
                  const page = data.start / data.length + 1;
                  $.ajax({
                      url: `https://anim-taupe.vercel.app/api/v2/hianime/azlist/${trendingPeriod}`,
                      data: {
                          page: page
                      },
                      success: async function(response) {

                          const movies = await Promise.all(response.data.animes.map(async movie => {
                              const id = movie.id;
                              const type = movie.type
                              const statusResponse = await checkStatus(id, 'anime');
                              const status = statusResponse.success ? 'Var' : 'Sitede Yok';
                              const statusBadge = statusResponse.success ? '<span class="btn btn-success">Var</span>' : '<span class="btn btn-danger">Yok</span>';
                              const actionButton =  statusResponse.success ? '<button class="btn btn-dark update-btn add-button" data-type="anime" data-id="'+id+'">Güncelle</button>' : `<button class="btn btn-primary add-button" data-type="anime" data-id="${id}">Siteye Ekle</button>`;

                              return {
                                  id: movie.id  ,
                                  title: `<a target="__blank" href="https://aniwatchtv.to/${movie.id}">${movie.name}</a>`  ,
                                  type:  type ,
                                  episode: "DUB: " + movie.episodes.dub + " | SUB: " + movie.episodes.sub,
                                  release_date: "",
                                  popularity: movie.rating,
                                  vote_average: 0,
                                  poster: `<img src="${movie.poster}" width="90" alt="${movie.name}">`,
                                  status: statusBadge,
                                  actions: actionButton
                              };
                          }));
                          callback({
                              draw: data.totalPages,
                              recordsTotal:response.totalPages * 36,
                              recordsFiltered: response.totalPages * 36,
                              data: movies
                          });
                      }
                  });
            };

            const table = $('#discover-anime-list').DataTable({
                 "processing": true,
                 "serverSide": true,
                searching:false,

                 "ajax": fetchMovies,

                 "columns": [
                     { "data": "poster", title: 'Poster' },
                     { "data": "id", title: 'ID' },
                     { "data": "title" , title: 'Adı'},
                     { "data": "episode" , title: 'Bölümler'},
                     { "data": "type" , title: 'Tip'},
                     { "data": "status", title: 'Durum' },
                    { "data": "actions", "width": "10%", "orderable": false }
                 ]
            });

            window.discoveryTable = table;

            $('#periodSelect').on('change', function() {
                trendingPeriod = this.value;
                table.ajax.reload();
            });

            $(document).on('click', '.add-button', function() {
                  const button = $(this);
                 const id = button.data('id');
                 const type = button.data('type');
                 addContent(id, type, button);
            });

        }

    }

    var DiscoverAnimeDaily = function(){
                let isProcessing = false; // İşlem durumu kontrolü

                if (!$.fn.dataTable.isDataTable("#discover-anime-list")) {
                    let trendingPeriod = getUrlParameter('q') ?? 'latestEpisodeAnimes';
                       const checkStatus = (id, type) => {
                             return $.ajax({
                                 url: origin+'/panel/discover/check',
                                 dataType: 'json',
                                 method: 'POST',
                                 data: {
                                     id: id,
                                     type: type
                                 }
                             });
                        };
                    const addContent = (id, type, button) => {
                         button.prop('disabled', true).html('Loading <div class="loader"></div>');
                         return $.ajax({
                             url: origin +'/panel/discovery/add',
                             method: 'POST',
                             dataType: 'json',
                             data: {
                                 id: id,
                                 type: type
                             },
                             success: function(response) {
                                 if(response.success) {
                                     button.html('Eklendi').prop('disabled', true).removeClass('btn-primary').addClass('btn-success');
                                 } else {
                                     button.html('Eklenmedi').prop('disabled', false).removeClass('btn-primary').addClass('btn-danger');
                                     setTimeout(() => {
                                         button.html('Siteye Ekle').removeClass('btn-danger').addClass('btn-primary');
                                     }, 2000);
                                 }
                             },
                             error: function() {
                                 button.html('Eklenmedi').prop('disabled', true).removeClass('btn-primary').addClass('btn-danger');
                                 setTimeout(() => {
                                     button.html('Siteye Ekle').removeClass('btn-danger').addClass('btn-primary');
                                 }, 2000);
                             }
                         });
                    };

                    let isProcessing = false; // İşlem durumu kontrolü
                    let currentPage = 0; // Mevcut sayfa numarası

                    // Start butonuna basıldığında işlemi başlatır
                    $('#startButton').on('click', function() {
                        isProcessing = true;
                        $('#startButton').prop('disabled', true);
                        $('#stopButton').prop('disabled', false);
                        currentPage = 0; // Sayfayı sıfırdan başlat
                        processAddButtons();
                    });

                    // Stop butonuna basıldığında işlemi durdurur
                    $('#stopButton').on('click', function() {
                        isProcessing = false;
                        $('#startButton').prop('disabled', false);
                        $('#stopButton').prop('disabled', true);
                    });

                    // Tüm .add-button düğmelerini sırayla işlemeye başlar
                    function processAddButtons() {
                        const buttons = $('.add-button:not(:disabled)');
                        
                        // Eğer mevcut sayfada işlenecek düğme yoksa bir sonraki sayfaya geç
                        if (buttons.length === 0 && isProcessing) {
                            const table = $('#discover-list').DataTable();
                            const pageInfo = window.discoveryTable.page.info();
                            if (currentPage < pageInfo.pages - 1) {
                                window.discoveryTable.page(currentPage).draw('page'); // Bir sonraki sayfaya geç
                                currentPage++;
                                
            //                       window.animeTable.ajax.url(origin + "/api/v2/animes/without-videos?id=" + window.searchAnime);
            // window.animeTable.page(0).draw('page');
            // window.animeTable.ajax.reload(null, false);
                                setTimeout(processAddButtons, 5000); // Bir sonraki sayfayı yüklemek için bekle
                            } else {
                                // İşlem tamamlandı
                                isProcessing = false;
                                $('#startButton').prop('disabled', false);
                                $('#stopButton').prop('disabled', true);
                                alert('Tüm sayfalar işlendi!');
                            }
                            return;
                        }

                        if (!isProcessing) {
                            $('#startButton').prop('disabled', false);
                            $('#stopButton').prop('disabled', true);
                            return;
                        }

                        const button = $(buttons[0]); // İlk aktif düğmeyi seçer
                        const id = button.data('id');
                        const type = button.data('type');

                        // addContent fonksiyonu çağrılır ve tamamlandığında sıradaki düğmeye geçilir
                        addContent(id, type, button).always(() => {
                            setTimeout(() => processAddButtons(), 500); // Bir sonraki düğme için bekleme süresi
                        });
                    }

                    const fetchMovies = (data, callback, settings) => {
                          const page = data.start / data.length + 1;
                          $.ajax({
                              url: `https://anim-taupe.vercel.app/api/v2/hianime/home`,
                              data: {
                                  page: page
                              },
                              success: async function(response) {
                                 if(trendingPeriod == 'latestEpisodeAnimes'){
                                    var data = response.data.latestEpisodeAnimes

                                 }else if(trendingPeriod == 'spotlightAnimes'){
                                    var data = response.data.spotlightAnimes

                                 }else if(trendingPeriod == 'trendingAnimes'){
                                    var data = response.data.trendingAnimes
                                    
                                 }else if(trendingPeriod == 'topUpcomingAnimes'){
                                    var data = response.data.topUpcomingAnimes
                                    
                                 }else if(trendingPeriod == 'top10Animes'){
                                    var data = response.data.top10Animes.today
                                    
                                 }else if(trendingPeriod == 'topAiringAnimes'){
                                    var data = response.data.topAiringAnimes
                                    
                                 }else if(trendingPeriod == 'mostPopularAnimes'){
                                    var data = response.data.mostPopularAnimes
                                    
                                 }else if(trendingPeriod == 'mostFavoriteAnimes'){
                                    var data = response.data.mostFavoriteAnimes
                                    
                                 }else if(trendingPeriod == 'latestCompletedAnimes'){
                                    var data = response.data.latestCompletedAnimes
                                 }
                                  const movies = await Promise.all(data.map(async movie => {
                                      const id = movie.id;
                                      const type = 'anime'
                                      const statusResponse = await checkStatus(id, type);;
                                      const status = statusResponse.success ? 'Var' : 'Sitede Yok';
                                      const statusBadge = statusResponse.success ? '<span class="btn btn-success">Var</span>' : '<span class="btn btn-danger">Yok</span>';
                                      const actionButton =   trendingPeriod != 'latestEpisodeAnimes' ? '' : `<button class="btn btn-primary add-button" data-type="anime" data-id="${id}">Siteye Ekle</button>`;

                                      return {
                                          id: movie.id || '',
                                          title: movie.name ? `<a target="__blank" href="https://aniwatchtv.to/${movie.id}">${movie.name}</a>` : '',
                                          type: type || '',
                                          episode: movie.episodes ? ("DUB: " + (movie.episodes.dub || 0) + " | SUB: " + (movie.episodes.sub || 0)) : "",
                                          release_date: "",
                                          popularity: movie.rating || 0,
                                          vote_average: 0,
                                          poster: movie.poster ? `<img src="${movie.poster}" width="90" alt="${movie.name || ''}">` : '',
                                          status: statusBadge || '',
                                          actions: actionButton || ''
                                      };
                                  }));
                                  callback({
                                      draw: 1,
                                      recordsTotal:10,
                                      recordsFiltered: 10,
                                      data: movies
                                  });
                              }
                          });
                    };

                    const table = $('#discover-anime-list').DataTable({
                         "processing": true,
                         "serverSide": true,
                        searching:false,

                         "ajax": fetchMovies,

                         "columns": [
                             { "data": "poster", title: 'Poster' },
                             { "data": "id", title: 'ID' },
                             { "data": "title" , title: 'Adı'},
                             { "data": "episode" , title: 'Bölümler'},
                             { "data": "type" , title: 'Tip'},
                             { "data": "status", title: 'Durum' },
                            { "data": "actions", "width": "10%", "orderable": false }
                         ]
                    });

                    window.discoveryTable = table;

                    $('#periodSelect').on('change', function() {
                        trendingPeriod = this.value;
                    });

                    $(document).on('click', '.add-button', function() {
                          const button = $(this);
                         const id = button.data('id');
                         const type = button.data('type');
                         addContent(id, type, button);
                    });

                }

            }
    return {
        initCore:function(){
            Buttons.init();
           _searchTmdbContent();
           _selectTmdbContent();
           _tmdbGetData();
           _seriesAdd();
           _seriesEdit();

           if(pathname.indexOf("users/detail") != "-1" || pathname == 'series/add'|| pathname == 'anime/add' || pathname == 'adult/add' || pathname == 'adult/edit' || pathname == 'movies/add' || pathname.indexOf("series/edit") != "-1" || pathname.indexOf("anime/edit") != "-1" || pathname.indexOf("movies/edit") != "-1" ){
            imageCropper();
            imageCropperCover();
            logoCropper();
           }
           if(pathname == 'series/add'|| pathname.indexOf("series/edit") != "-1"|| pathname.indexOf("anime/edit") != "-1" ){
            seasonAdd();
            episodeAdd();
            episodeEdit();
            videoAdd();
            addCrew();
            seasonSetActive();
            setEpisodeMain();
            getEpisode();
            editEpisode();
            addSeason();
            addEpisode();
            dayNeed();
           }else if(pathname == 'category'){
            CategoryTable();
           }
           AvatarTable()
           LiveTV()
           CollectionTable()
           TagTable()
           getAnimeEpisode()
            editAnimeEpisode()
           animeAdd();
           animeEdit();
           setAnimeEpisodeMain();
           addAnimeEpisode();
           AnimeAddVideo();
           animeTable();
           GoogleTable()
           pagesTable()
           fragmanTable()
           siteTable()
           fragmanType()
           addCast();
           coreInit();
           seriesTable();
           MoviesTable();
           BoxsetTable();
           CategoryUpdate();
           SetActive();
           MoviesAdd();
           MoviesEdit();
           MoviesAddVideo();
           VideoEdit();
           WidgetAdd();
           WidgetTable();
           CastTable();
           BlogTable();
           Proxys();
           TierTable();
           RequestTable();
           ChannelTable();
           CommentTable();
           UsersTable();
           ActionTable();
           BadgesTable();
           WidgetList();
           WidgetGetData();
           WidgetEdit();
           WidgetConditionList();
           WidgetConditionValues();
           replyComment();
           editComment();
           DiscussionTable();
           DiscussionCategoryTable();
           ContactTable();
           ReportTable();
           ReportCategoryTable();
           ServicesTable();
           videoGroupTable();
           replyReport();
           setMeta();
           setApi();
           searchSeries();
           badgeInputs();
           badgeSet();
           badgeUpdate();
           footerAnchor();
           getTabContent();
           saveUser();
           getAutoVideo();
           refreshSeason();
           anilistUpdateAnime();
           countDownAdd();
           setRequestStatus();
           getTiers();
           marketPlace();
           getEpisodeList();
           deleteAllVideo();
           replaceLink();
           replaceLinkCheck();
           bannedUser();
           bannedUserDelete();
           allGroupUpdate();
           moveEpisode();
           translatorUpdate();
           getYoutubePlaylist();
           customAccess();
          episodeClone();
          EpisodeGroupTable();
          updateRedirect();
          subtitleAdd();
           AdultAdd();
           AdultAction();
           AdultTable();
           AdultEdit();
           botAction();
          
         
              searchMovies();

           if(window.location.pathname == "/panel/ads/ignore" || window.location.pathname == "/panel/ads/ignore_gads" ){
              searchAnimes();
           }
           if(window.location.pathname == "/panel/discover/anime" ){
               DiscoverAnime();
           }
           if(window.location.pathname == "/panel/discover/anime/daily" ){
               DiscoverAnimeDaily();
           }

           if(window.location.pathname == "/panel/discover" ){
                Discover();
           }
        }
    }
}();
var Delete = function(){
  var itemDelete = function(){


    $(document).on("click","[data-delete-item]",function(){
      var id    = $(this).data("delete-item");
      var type  = $(this).data("type");
      if(id){
        if(type == "SEASON_DELETE"){
          var key = Object.keys(window.seasons).filter(key => window.seasons[key].id == id )[0];
          delete window.seasons[key];
          window.seasons = window.seasons.filter(Boolean);
          $("#season-obj").val(JSON.stringify(window.seasons))
          $("[data-season-item="+id+"]").remove()
        }
      }
    });
  }
  return {
    init: function(){
      itemDelete();
    }
  }
}();

// Initialize module
// ------------------------------

// When content is loaded
document.addEventListener('DOMContentLoaded', function() {
    Webicrea.initCore();
    Delete.init();

    $("#images-list-modal").on('shown.bs.modal', function () {
        window.lazy.update()
    })
    $(document).on("click","#rightmenu li",function(){
      $("#top-menu li a").removeClass("active")
    })
    $('.daterange-single').daterangepicker({ 
        singleDatePicker: true,
         timePicker: true,
         locale: {
            format: 'YYYY-MM-DD HH:SS'
        }
    });

    $(document).on("click",".proxy-checker",function(){
    var proxyCheckCount = 0;
      var ips = []
      var count = $("#proxy-user-add").length
      
      $(".proxy-checker").each(function(){
        var check = $(this).find('input').is(":checked") ? 1 : 0;

        if(check){
          var ip = $(this).find('input').data("ip");
          
          if(ips.indexOf(ip) == "-1"){
            ips.push(ip);
          }

          proxyCheckCount += 1;
        }
      })
      $("#iplist").val(JSON.stringify(ips))
      if(!proxyCheckCount){
        $(".proxy-header").remove()
      }
      if(!count){
         $(".datatable-header").append(`
          <div style="margin-left:10px" class="proxy-header"><button type="submit" " data-toggle="modal" data-target="#proxy-add" id="proxy-user-add" class="btn btn-primary">Seçilenleri Ekle <i class="icon-paperplane ml-2"></i></button></div>
        `)
       }
    });
    $(document).on("click","#add-proxy-day",function(){
      var form = $("#proxy-form").serialize();
       $.ajax({
          type:"POST",
          url:origin+"/panel/proxy/add",
          data:form,
          dataType:'json',
          success:function(result){
            if(result.success){
              swalInit.fire(
                  'Başarılı!',
                  'Ekleme işlemi başarıyla gerçekleştirildi.',
                  'success'
              );
            }
          },
          error:function(e){
              console.log(e)
          },
          complete:function(){
          }
        });
    })
    $('#video_service').select2({
        dropdownParent: $('#add-video-modal')
    });

    var pathName = window.location.href;
    $(".nav-sidebar li a[href='"+pathName+"']").addClass("active").closest(".nav-group-sub").show().prev("a").addClass("active");

      $(document).on("change","#episode_group_type", function(){
                var type = $(this).val() ;
                 $(".search-tags").select2({
                  tags: [],
                  ajax: {
                      url: "/panel/widget/search/tags?type="+type,
                      dataType: 'json',
                      type: "GET",
                      data: function (term) {
                          return {
                              search: term.term
                          };
                      },
                       processResults: function (data) {
                        console.log(data)
                          return {
                              results: $.map(data, function (item) {
                                  return {
                                      text: item.name,
                                      slug: item.link,
                                      id: item.link
                                  }
                              })
                          };
                      }
                  }
                });
              })
});

// When page is fully loaded
window.addEventListener('load', function() {

})
