<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<meta name="referrer" content="no-referrer">
<meta name="robots" content="noarchive,nosnippet,noindex,nofollow">
<title>Yayın</title>

<style>
  html, body {
    margin: 0;
    padding: 0;
    background-color: black;
    height: 100%;
    overflow: auto; /* 🔹 scroll etkin */
  }

  body {
    -webkit-user-select: none;
    -moz-user-select: none;
    user-select: none;
  }

  iframe {
    border: none;
    width: 600px;   /* genişlik px */
    height: 450px;  /* yükseklik px */
    display: block;
    margin: 20px auto; /* ortalanmış görünüm */
    overflow: auto; /* 🔹 iframe içinde scroll */
  }

  * {
    -webkit-touch-callout: none;
    -webkit-user-drag: none;
  }
</style>
</head>
<body oncontextmenu="return false" onkeydown="return disableKeys(event)">
  
  <iframe 
    src="https://trvtv9.com/channel?id=yayinzirve"
    allow="autoplay; fullscreen"
    allowfullscreen
    scrolling="yes"> <!-- 🔹 HTML scroll izni -->
  </iframe>

  <script>
    // Sağ tıklamayı engelle
    document.addEventListener('contextmenu', event => event.preventDefault());

    // Belirli kısayolları engelle (F12, Ctrl+U, Ctrl+Shift+I vb.)
    function disableKeys(e) {
      if (
        e.key === "F12" ||
        (e.ctrlKey && e.shiftKey && e.key === "I") ||
        (e.ctrlKey && e.shiftKey && e.key === "J") ||
        (e.ctrlKey && e.key === "U") ||
        (e.ctrlKey && e.shiftKey && e.key === "C")
      ) {
        e.preventDefault();
        return false;
      }
    }

    // Eğer iframe içinde değilse, otomatik yönlendir
    if (window.top === window.self) {
      window.location.href = "https://google.com"; // 🔗 anasayfa yönlendirmesi
    }
  </script>
</body>
</html>
